/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.furniture.activators;

import com.ssomar.score.sobject.sactivator.OptionGlobal;
import com.ssomar.score.sobject.sactivator.SOption;
import com.ssomar.score.utils.obfuscation.KeepMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum Option implements SOption
{
    PLAYER_RIGHT_CLICK_ON("PLAYER_RIGHT_CLICK_ON"),
    PLAYER_LEFT_CLICK_ON("PLAYER_LEFT_CLICK_ON"),
    PLAYER_ALL_CLICK_ON("PLAYER_ALL_CLICK_ON"),
    PLAYER_BREAK("PLAYER_BREAK"),
    PLAYER_PLACE("PLAYER_PLACE"),
    PLAYER_SCROLL_DOWN_BY_TARGETING("PLAYER_SCROLL_DOWN_BY_TARGETING"),
    PLAYER_SCROLL_UP_BY_TARGETING("PLAYER_SCROLL_UP_BY_TARGETING");

    private String[] names;

    private Option(String ... names) {
        this.names = names;
    }

    public List<SOption> getPremiumOption() {
        return Option.getPremiumOptionSt();
    }

    public static List<SOption> getPremiumOptionSt() {
        ArrayList<SOption> result = new ArrayList<SOption>();
        result.add((SOption)OptionGlobal.LOOP);
        return result;
    }

    public static String getPremiumOptionAsString() {
        StringBuilder sb = new StringBuilder("");
        for (SOption option : Option.getPremiumOptionSt()) {
            sb.append(option.toString());
            sb.append(" ");
        }
        sb.substring(0, sb.length() - 1);
        return sb.toString();
    }

    public static List<SOption> getOptionWithoutOwner() {
        ArrayList<SOption> result = new ArrayList<SOption>();
        result.add(PLAYER_PLACE);
        return result;
    }

    @KeepMethod
    public List<SOption> getOptionWithOwner() {
        ArrayList<SOption> result = new ArrayList<SOption>();
        for (Option option : Option.values()) {
            if (Option.getOptionWithoutOwner().contains((Object)option)) continue;
            result.add(option);
        }
        return result;
    }

    public static List<SOption> getOptWithTargetEntity() {
        ArrayList<SOption> result = new ArrayList<SOption>();
        return result;
    }

    @KeepMethod
    public List<SOption> getOptionWithTargetEntity() {
        List result = super.getOptionWithTargetEntity();
        result.addAll(Option.getOptWithTargetEntity());
        return result;
    }

    public static List<SOption> getOptWithPlayer() {
        ArrayList<SOption> result = new ArrayList<SOption>();
        result.add(PLAYER_RIGHT_CLICK_ON);
        result.add(PLAYER_LEFT_CLICK_ON);
        result.add(PLAYER_ALL_CLICK_ON);
        result.add(PLAYER_BREAK);
        result.add(PLAYER_PLACE);
        result.add(PLAYER_SCROLL_DOWN_BY_TARGETING);
        result.add(PLAYER_SCROLL_UP_BY_TARGETING);
        return result;
    }

    public static List<SOption> getOptWithDamageCause() {
        ArrayList<SOption> result = new ArrayList<SOption>();
        return result;
    }

    public static List<SOption> getOptWithCommand() {
        ArrayList<SOption> result = new ArrayList<SOption>();
        return result;
    }

    @KeepMethod
    public List<SOption> getOptionWithPlayer() {
        List result = super.getOptionWithPlayer();
        result.addAll(Option.getOptWithPlayer());
        return result;
    }

    @KeepMethod
    public List<SOption> getOptionWithEntity() {
        List result = super.getOptionWithEntity();
        return result;
    }

    @KeepMethod
    public List<SOption> getOptionWithBlock() {
        List result = super.getOptionWithBlock();
        for (Option option : Option.values()) {
            result.add(option);
        }
        return result;
    }

    @KeepMethod
    public List<SOption> getOptionWithTargetBlock() {
        List result = super.getOptionWithTargetBlock();
        result.addAll(Option.getOptWithTargetBlock());
        return result;
    }

    public static List<SOption> getOptWithTargetBlock() {
        ArrayList<SOption> result = new ArrayList<SOption>();
        return result;
    }

    @KeepMethod
    public List<SOption> getOptionWithTargetPlayer() {
        List result = super.getOptionWithTargetPlayer();
        return result;
    }

    @KeepMethod
    public List<SOption> getOptionWithWorld() {
        List result = super.getOptionWithWorld();
        for (Option option : Option.values()) {
            result.add(option);
        }
        return result;
    }

    public static List<SOption> getOptionWithRequiredThings() {
        ArrayList<SOption> result = new ArrayList<SOption>();
        for (Option option : Option.values()) {
            result.add(option);
        }
        return result;
    }

    @KeepMethod
    public boolean isValidOption(String entry) {
        for (Option option : Option.values()) {
            for (String name : option.getNames()) {
                if (!name.equalsIgnoreCase(entry)) continue;
                return true;
            }
        }
        return super.isValidOption(entry);
    }

    @KeepMethod
    public boolean isLoopOption() {
        return super.isLoopOption();
    }

    @KeepMethod
    public SOption getOption(String entry) {
        for (Option option : Option.values()) {
            for (String name : option.getNames()) {
                if (!name.equalsIgnoreCase(entry)) continue;
                return option;
            }
        }
        return super.getOption(entry);
    }

    @KeepMethod
    public List<SOption> getValues() {
        List result = super.getValues();
        result.addAll(Arrays.asList(Option.values()));
        return result;
    }

    @KeepMethod
    public SOption getDefaultValue() {
        return PLAYER_ALL_CLICK_ON;
    }

    public boolean containsThisName(String entry) {
        for (String name : this.getNames()) {
            if (!name.equalsIgnoreCase(entry)) continue;
            return true;
        }
        return super.containsThisName(entry);
    }

    public String[] getNames() {
        return this.names;
    }

    public void setNames(String[] names) {
        this.names = names;
    }

    @KeepMethod
    public List<SOption> getOptionWithItem() {
        List result = super.getOptionWithItem();
        return result;
    }

    public String getName() {
        return this.name();
    }
}

