/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.furniture.creations;

import com.ssomar.myfurniture.features.display.DisplayFeatures;
import com.ssomar.myfurniture.features.display.boundingboxzones.boundingboxzone.BoundingBoxZoneFeature;
import com.ssomar.myfurniture.furniture.Furniture;
import com.ssomar.myfurniture.furniture.creations.CreationAbstract;
import com.ssomar.myfurniture.furniture.placedfurniture.FurniturePlacedManager;
import com.ssomar.myfurniture.furniture.placedfurniture.LocationConverter;
import com.ssomar.myfurniture.furniture.placedfurniture.TargetResult;
import com.ssomar.myfurniture.utils.NotCartesianParralelBoundingBox;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.features.types.ArrayFeature;
import com.ssomar.score.utils.obfuscation.KeepMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Vector3f;

public class AnimatedDisplay
extends CreationAbstract {
    private List<Long> breakTentatives = new ArrayList<Long>();
    private List<NotCartesianParralelBoundingBox> boundingBoxes = new ArrayList<NotCartesianParralelBoundingBox>();
    private List<UUID> displayUUIDList = new ArrayList<UUID>();

    public AnimatedDisplay(Furniture config) {
        super(config);
    }

    public boolean isWallBlockFace(BlockFace blockFace) {
        return blockFace == BlockFace.NORTH || blockFace == BlockFace.SOUTH || blockFace == BlockFace.EAST || blockFace == BlockFace.WEST;
    }

    @Override
    @KeepMethod
    @Nullable
    public Location getTheCorrectedPlacementLocation(@Nullable Location base, @Nullable Entity placer, @Nullable BlockFace blockface) {
        boolean needToBeAligned = this.getConfig().getDisplayFeatures().getAligned().getValue();
        boolean useSpecialFeature = false;
        if (!needToBeAligned && placer != null && placer instanceof Player && !((Player)placer).isSneaking()) {
            Player player = (Player)placer;
            Vector hitPos = new Vector();
            Optional<TargetResult> eBPOpt = FurniturePlacedManager.getInstance().getFurniturePlacedDisplayTargetByPlayer(player, 10.0, hitPos);
            if (eBPOpt.isPresent()) {
                base = new Location(player.getWorld(), hitPos.getX(), hitPos.getY(), hitPos.getZ()).add(0.0, 0.5, 0.0);
                SsomarDev.testMsg((String)("Hit pos at: " + base), (boolean)true);
                useSpecialFeature = true;
            } else {
                RayTraceResult rayTraceResult = ((Player)placer).rayTraceBlocks(5.0);
                if (rayTraceResult != null) {
                    base = rayTraceResult.getHitPosition().toLocation(base.getWorld());
                    SsomarDev.testMsg((String)("Blockface: " + blockface), (boolean)true);
                    if (blockface == BlockFace.UP) {
                        base = base.add(0.0, 0.0, 0.0);
                    } else {
                        Map<String, BoundingBoxZoneFeature> mp = this.getConfig().getDisplayFeatures().getBoundingBoxZoneGroupFeature().getBoundingBoxZones();
                        double zMin = Double.MAX_VALUE;
                        double zMax = Double.MIN_VALUE;
                        for (String key : mp.keySet()) {
                            BoundingBoxZoneFeature bbzf = mp.get(key);
                            double check = (Double)bbzf.getFrom().getArrayValueAtIndex(2);
                            if (check < zMin) {
                                zMin = check;
                            }
                            if (!((check = ((Double)bbzf.getTo().getArrayValueAtIndex(2)).doubleValue()) > zMax)) continue;
                            zMax = check;
                        }
                        SsomarDev.testMsg((String)("Z min: " + zMin + " Z max: " + zMax), (boolean)true);
                        double size = zMax - zMin;
                        SsomarDev.testMsg((String)("Size: " + size), (boolean)true);
                        if (blockface != null) {
                            switch (blockface) {
                                case NORTH: {
                                    base = base.add(0.0, 0.0, -size / 16.0 + (-zMin + 8.0) / 16.0);
                                    break;
                                }
                                case SOUTH: {
                                    base = base.add(0.0, 0.0, size / 16.0 - (-zMin + 8.0) / 16.0);
                                    break;
                                }
                                case EAST: {
                                    base = base.add(size / 16.0 - (-zMin + 8.0) / 16.0, 0.0, 0.0);
                                    break;
                                }
                                case WEST: {
                                    base = base.add(-size / 16.0 + (-zMin + 8.0) / 16.0, 0.0, 0.0);
                                    break;
                                }
                            }
                        }
                    }
                    useSpecialFeature = true;
                }
            }
        }
        if (base == null) {
            return null;
        }
        if (!useSpecialFeature) {
            base = LocationConverter.convert(base, false, true);
        }
        float yaw = 0.0f;
        if (placer != null) {
            base.setYaw(placer.getLocation().getYaw());
        }
        if (SCore.is1v20v1Plus()) {
            base.setPitch(-90.0f);
            base.setYaw(base.getYaw() + 180.0f);
        }
        base.setPitch(base.getPitch() + this.getConfig().getDisplayFeatures().getCustomPitch().getValue().orElse(0).floatValue());
        if (needToBeAligned || blockface != BlockFace.UP) {
            base.setYaw((float)(Math.round(base.getYaw() / 90.0f) * 90));
        }
        base.setY(base.getY() + this.getConfig().getDisplayFeatures().getCustomY().getValue().orElse(0.0));
        return base;
    }

    @Override
    @KeepMethod
    public boolean canPlace(@NotNull Location location) {
        return true;
    }

    @Override
    @KeepMethod
    public boolean place(@NotNull Location location) {
        String summonCommand = "function animated_java:blueprint/summon/default";
        World world = location.getWorld();
        if (world != null) {
            List entities = world.getEntities();
            if (entities.size() > 0) {
                Entity entity = (Entity)entities.get(0);
                SsomarDev.testMsg((String)("entity: " + entity.getLocation()), (boolean)true);
                summonCommand = "execute at " + entity.getUniqueId() + " run execute positioned " + location.getX() + " " + location.getY() + " " + location.getZ() + " run execute rotated " + location.getYaw() + " " + location.getPitch() + " run " + summonCommand;
            } else {
                SsomarDev.testMsg((String)"No entity in the world", (boolean)true);
            }
        }
        ConsoleCommandSender console = Bukkit.getServer().getConsoleSender();
        Bukkit.dispatchCommand((CommandSender)console, (String)summonCommand);
        this.loadBoundingBoxes(this.getConfig().getDisplayFeatures(), location);
        List entities = location.getWorld().getEntities();
        for (Entity entity : entities) {
            if (!(entity instanceof ItemDisplay) || entity.getLocation().distance(location) != 0.0) continue;
            this.displayUUIDList.add(entity.getUniqueId());
        }
        return true;
    }

    @Override
    @KeepMethod
    public void afterPlacingModification(@NotNull Location location) {
    }

    @Override
    @KeepMethod
    public void remove(Location location) {
        if (!this.displayUUIDList.isEmpty()) {
            for (UUID uuid : this.displayUUIDList) {
                Entity entity = Bukkit.getEntity((UUID)uuid);
                if (entity == null) continue;
                entity.remove();
            }
        }
    }

    public void shake() {
        if (!this.displayUUIDList.isEmpty()) {
            String command = "execute as {UUID} run function animated_java:blueprint/animations/crate_idle/play";
            for (UUID displayUUID : this.displayUUIDList) {
                Entity entity = Bukkit.getEntity((UUID)displayUUID);
                if (entity == null) continue;
                String rCommand = command.replace("{UUID}", entity.getUniqueId().toString());
                ConsoleCommandSender console = Bukkit.getServer().getConsoleSender();
                Bukkit.dispatchCommand((CommandSender)console, (String)rCommand);
            }
        } else {
            SsomarDev.testMsg((String)"CANT SHAKE : Display UUID is null", (boolean)true);
        }
    }

    public void transformationLeft(Display entity, Vector axis, float angle, int duration, int delay) {
        entity.setInterpolationDuration(duration);
        entity.setInterpolationDelay(delay);
        Transformation transformation = entity.getTransformation();
        transformation.getLeftRotation().set(new AxisAngle4f(angle, (float)axis.getX(), (float)axis.getY(), (float)axis.getZ()));
        entity.setTransformation(transformation);
    }

    @Override
    public boolean load(Entity entity) {
        return false;
    }

    public void loadBoundingBoxes(DisplayFeatures displayFeatures, Location location) {
        this.boundingBoxes.clear();
        displayFeatures.getBoundingBoxZoneGroupFeature().getBoundingBoxZones().forEach((key, value) -> {
            double yaw = -location.getYaw() + 180.0f;
            ArrayFeature<Double> from = value.getFrom();
            ArrayFeature<Double> to = value.getTo();
            Vector3f fromLoc = new Vector3f((float)((Double)from.getArrayValueAtIndex(0) / 16.0), (float)((Double)from.getArrayValueAtIndex(1) / 16.0), (float)((Double)from.getArrayValueAtIndex(2) / 16.0));
            Vector3f toLoc = new Vector3f((float)((Double)to.getArrayValueAtIndex(0) / 16.0), (float)((Double)to.getArrayValueAtIndex(1) / 16.0), (float)((Double)to.getArrayValueAtIndex(2) / 16.0));
            NotCartesianParralelBoundingBox notCartesianParralelBoundingBox = new NotCartesianParralelBoundingBox(fromLoc, toLoc, value.getId());
            double correctionX = location.getX() - (double)location.getBlockX();
            double correctionZ = location.getZ() - (double)location.getBlockZ();
            double correctionY = location.getY() - (double)location.getBlockY();
            notCartesianParralelBoundingBox.translate(-0.5f, 0.0f, -0.5f);
            notCartesianParralelBoundingBox.rotateY((float)Math.toRadians(yaw));
            notCartesianParralelBoundingBox.translate((double)location.getBlockX() + correctionX, (double)location.getBlockY() + correctionY, (double)location.getBlockZ() + correctionZ);
            notCartesianParralelBoundingBox.debugAllPoints(location.getWorld());
            this.boundingBoxes.add(notCartesianParralelBoundingBox);
        });
    }

    @Override
    @KeepMethod
    public void save(ConfigurationSection config) {
        ArrayList<String> displayUUIDList = new ArrayList<String>();
        for (UUID displayUUID : this.displayUUIDList) {
            displayUUIDList.add(displayUUID.toString());
        }
        config.set("blockEntityUUID", displayUUIDList);
    }

    @Override
    @KeepMethod
    public String getDisplayName() {
        return "";
    }

    @Override
    public boolean tryBreak() {
        this.shake();
        int clickToBreak = (Integer)this.getConfig().getDisplayFeatures().getClickToBreak().getValue().get();
        if (clickToBreak < 1) {
            clickToBreak = 1;
        }
        if (clickToBreak == 1) {
            return true;
        }
        long time = System.currentTimeMillis();
        int click = 0;
        ArrayList<Long> toRemove = new ArrayList<Long>();
        for (int i = this.breakTentatives.size() - 1; i >= 0; --i) {
            if (time - this.breakTentatives.get(i) < 2000L) {
                ++click;
                continue;
            }
            toRemove.add(this.breakTentatives.get(i));
        }
        this.breakTentatives.removeAll(toRemove);
        if (click + 1 >= clickToBreak) {
            return true;
        }
        this.breakTentatives.add(time);
        return false;
    }

    public List<ItemDisplay> getDisplay() {
        if (!this.displayUUIDList.isEmpty()) {
            ArrayList<ItemDisplay> displays = new ArrayList<ItemDisplay>();
            for (UUID displayUUID : this.displayUUIDList) {
                Entity entity = Bukkit.getEntity((UUID)displayUUID);
                if (entity == null) continue;
                displays.add((ItemDisplay)entity);
            }
            return displays;
        }
        return null;
    }

    public List<Long> getBreakTentatives() {
        return this.breakTentatives;
    }

    @Override
    public List<NotCartesianParralelBoundingBox> getBoundingBoxes() {
        return this.boundingBoxes;
    }

    public List<UUID> getDisplayUUIDList() {
        return this.displayUUIDList;
    }
}

