/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.playersettings;

import com.ssomar.myfurniture.MyFurniture;
import com.ssomar.myfurniture.playersettings.PlayerSettingsLoader;
import com.ssomar.myfurniture.playersettings.PlayerSettingsManager;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.editor.FeatureNoLanguageChange;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.DoubleFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.sobject.SObjectWithFileEditable;
import com.ssomar.score.sobject.SObjectWithFileLoader;
import com.ssomar.score.splugin.SPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PlayerSettings
extends SObjectWithFileEditable<PlayerSettings, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements FeatureNoLanguageChange {
    private IntegerFeature maxFurnitureRendered;
    private DoubleFeature viewDistanceFurniture;
    private DoubleFeature maxDistanceBoundingBoxCalculation;

    public PlayerSettings(String id, String path) {
        super((SPlugin)MyFurniture.plugin, id, (FeatureSettingsInterface)FeatureSettingsSCore.playerSettings, path, (SObjectWithFileLoader)PlayerSettingsLoader.getInstance());
        this.reset();
    }

    public PlayerSettings(String id, FeatureParentInterface parent, String path) {
        super((SPlugin)MyFurniture.plugin, id, parent, (FeatureSettingsInterface)FeatureSettingsSCore.playerSettings, path, (SObjectWithFileLoader)PlayerSettingsLoader.getInstance());
        this.reset();
    }

    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add((FeatureInterface)this.maxFurnitureRendered);
        features.add((FeatureInterface)this.viewDistanceFurniture);
        features.add((FeatureInterface)this.maxDistanceBoundingBoxCalculation);
        return features;
    }

    public String getParentInfo() {
        return "(Player settings: " + this.getId() + ")";
    }

    public void reload() {
        if (this.getParent() instanceof PlayerSettings) {
            PlayerSettings item = (PlayerSettings)this.getParent();
            item.setMaxFurnitureRendered(this.maxFurnitureRendered);
            item.setViewDistanceFurniture(this.viewDistanceFurniture);
            item.setMaxDistanceBoundingBoxCalculation(this.maxDistanceBoundingBoxCalculation);
            PlayerSettingsManager.getInstance().actionOnObjectWhenReloading(item);
        }
    }

    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, (FeatureParentInterface)this);
    }

    public void openBackEditor(@NotNull Player player) {
        player.closeInventory();
    }

    public List<String> load(SPlugin sPlugin, ConfigurationSection configurationSection, boolean premiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        for (FeatureInterface feature : this.getFeatures()) {
            errors.addAll(feature.load(sPlugin, configurationSection, premiumLoading));
        }
        return errors;
    }

    public void save(ConfigurationSection configurationSection) {
        for (FeatureInterface feature : this.getFeatures()) {
            feature.save(configurationSection);
        }
    }

    public PlayerSettings getValue() {
        return this;
    }

    public FeatureInterface initItemParentEditor(GUI gui, int i) {
        return null;
    }

    public void updateItemParentEditor(GUI gui) {
    }

    public void reset() {
        this.maxFurnitureRendered = new IntegerFeature((FeatureParentInterface)this, Optional.of(250), (FeatureSettingsInterface)FeatureSettingsSCore.maxFurnitureRendered);
        this.viewDistanceFurniture = new DoubleFeature((FeatureParentInterface)this, Optional.of(150.0), (FeatureSettingsInterface)FeatureSettingsSCore.viewDistanceFurniture);
        this.maxDistanceBoundingBoxCalculation = new DoubleFeature((FeatureParentInterface)this, Optional.of(5.0), (FeatureSettingsInterface)FeatureSettingsSCore.maxDistanceBoundingBoxCalculation);
    }

    public FeatureInterface clone(FeatureParentInterface featureParentInterface) {
        PlayerSettings clone = new PlayerSettings(this.getId(), (FeatureParentInterface)this, this.getPath());
        clone.setMaxFurnitureRendered(this.maxFurnitureRendered.clone((FeatureParentInterface)clone));
        clone.setViewDistanceFurniture(this.viewDistanceFurniture.clone((FeatureParentInterface)clone));
        clone.setMaxDistanceBoundingBoxCalculation(this.maxDistanceBoundingBoxCalculation.clone((FeatureParentInterface)clone));
        return clone;
    }

    public ItemStack getIconItem() {
        return new ItemStack(Material.BEACON);
    }

    public IntegerFeature getMaxFurnitureRendered() {
        return this.maxFurnitureRendered;
    }

    public DoubleFeature getViewDistanceFurniture() {
        return this.viewDistanceFurniture;
    }

    public DoubleFeature getMaxDistanceBoundingBoxCalculation() {
        return this.maxDistanceBoundingBoxCalculation;
    }

    public void setMaxFurnitureRendered(IntegerFeature maxFurnitureRendered) {
        this.maxFurnitureRendered = maxFurnitureRendered;
    }

    public void setViewDistanceFurniture(DoubleFeature viewDistanceFurniture) {
        this.viewDistanceFurniture = viewDistanceFurniture;
    }

    public void setMaxDistanceBoundingBoxCalculation(DoubleFeature maxDistanceBoundingBoxCalculation) {
        this.maxDistanceBoundingBoxCalculation = maxDistanceBoundingBoxCalculation;
    }
}

