/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.playersettings;

import com.ssomar.myfurniture.MyFurniture;
import com.ssomar.myfurniture.playersettings.PlayerSettings;
import com.ssomar.myfurniture.playersettings.PlayerSettingsManager;
import com.ssomar.score.SCore;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.sobject.SObjectWithFileLoader;
import com.ssomar.score.sobject.SObjectWithFileManager;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Optional;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class PlayerSettingsLoader
extends SObjectWithFileLoader<PlayerSettings> {
    private static PlayerSettingsLoader instance;

    public PlayerSettingsLoader() {
        super((SPlugin)SCore.plugin, "/com/ssomar/score/configs/player_settings/", (SObjectWithFileManager)PlayerSettingsManager.getInstance(), Integer.MAX_VALUE);
    }

    public void load() {
        PlayerSettingsManager.getInstance().setDefaultObjects(new ArrayList());
        PlayerSettingsManager.getInstance().setLoadedObjects(new ArrayList());
        this.resetCpt();
        File itemsDirectory = new File(SCore.plugin.getDataFolder() + "/player_settings");
        if (!itemsDirectory.exists()) {
            itemsDirectory.mkdirs();
        }
    }

    public void configVersionsConverter(File file) {
    }

    public void loadPlayerSettingsOf(String id) {
        String path = SCore.plugin.getDataFolder() + "/player_settings/" + id + ".yml";
        File file = this.searchFileOfObject(id);
        if (file == null) {
            PlayerSettings playerSettings = new PlayerSettings(id, path);
            playerSettings.save();
            PlayerSettingsManager.getInstance().addLoadedObject((SObject)playerSettings);
        } else {
            this.loadObjectByFile(path, true);
        }
    }

    public void loadPlayerSettingsOf(Player player) {
        this.loadPlayerSettingsOf(player.getUniqueId().toString());
    }

    public void loadPlayerSettingsOfOnlinePlayers() {
        for (Player player : MyFurniture.plugin.getServer().getOnlinePlayers()) {
            this.loadPlayerSettingsOf(player);
        }
    }

    public Optional<PlayerSettings> getObject(FileConfiguration itemConfig, String id, boolean showError, boolean isPremiumLoading, String path) {
        ArrayList<String> errors = new ArrayList<String>();
        PlayerSettings item = new PlayerSettings(id, path);
        errors.addAll(item.load((SPlugin)SCore.plugin, (ConfigurationSection)itemConfig, isPremiumLoading));
        if (showError) {
            for (String s : errors) {
                SCore.plugin.getServer().getLogger().severe(s);
            }
        }
        return Optional.ofNullable(item);
    }

    public static PlayerSettingsLoader getInstance() {
        if (instance == null) {
            instance = new PlayerSettingsLoader();
        }
        return instance;
    }
}

