/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.texturesloader;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ssomar.myfurniture.MyFurniture;
import com.ssomar.myfurniture.features.display.DisplayFeatures;
import com.ssomar.myfurniture.features.display.boundingboxzones.group.BoundingBoxZoneGroupFeature;
import com.ssomar.myfurniture.furniture.Furniture;
import com.ssomar.myfurniture.furniture.FurnitureManager;
import com.ssomar.myfurniture.texturesloader.ModelFile;
import com.ssomar.score.SCore;
import com.ssomar.score.api.executableitems.ExecutableItemsAPI;
import com.ssomar.score.api.executableitems.config.ExecutableItemInterface;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.usedapi.Dependency;
import com.ssomar.score.utils.logging.Utils;
import com.ssomar.score.utils.messages.SendMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;

public class TexturesPackLoader {
    public static String texturesFolder = MyFurniture.plugin.getPlugin().getDataFolder().getPath() + File.separator + "__textures__";
    public static String assetsFolder = texturesFolder + File.separator + "MyFurniture_Pack" + File.separator + "assets";
    public static String packFilePath = texturesFolder + File.separator + "MyFurniture_Pack" + File.separator + "pack.mcmeta";
    public static String itemPathOld = assetsFolder + File.separator + "minecraft" + File.separator + "models" + File.separator + "item";
    public static String defaultModelOldPath = itemPathOld + File.separator + MyFurniture.BASE_MATERIAL.toString().toLowerCase() + ".json";
    public static String TPACK_NAME = SCore.is1v21v4Plus() ? "MyFurniture_Pack_1_21_4.zip" : "MyFurniture_Pack.zip";
    public static String DEFAULT_TEXTURES_PACK_PATH = texturesFolder + File.separator + TPACK_NAME;

    public void runPackCommand(String[] args) {
        if (!SCore.is1v21v4Plus()) {
            this.runPackCommandCustomModelData(args);
        } else {
            File[] files;
            File folder;
            File oldPackFile;
            boolean containsImport = true;
            boolean containsTryToFix = true;
            for (String arg : args) {
                if (arg.equalsIgnoreCase("--NotImport")) {
                    containsImport = false;
                    continue;
                }
                if (!arg.equalsIgnoreCase("--NotTryToFix")) continue;
                containsTryToFix = false;
            }
            File oldPath = new File(texturesFolder + File.separator + "assets");
            if (oldPath.exists()) {
                try {
                    File s = new File(assetsFolder);
                    s.getParentFile().mkdirs();
                    Files.move(Paths.get(oldPath.getPath(), new String[0]), Paths.get(assetsFolder, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("The folder " + oldPath.getName() + " has been moved to " + assetsFolder));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if ((oldPackFile = new File(texturesFolder + File.separator + "pack.mcmeta")).exists()) {
                try {
                    File s = new File(packFilePath);
                    s.getParentFile().mkdirs();
                    Files.move(Paths.get(oldPackFile.getPath(), new String[0]), Paths.get(packFilePath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("The file " + oldPackFile.getName() + " has been moved to " + packFilePath));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (!(folder = new File(assetsFolder)).exists()) {
                Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("The folder " + assetsFolder + " doesn't exist"));
                return;
            }
            for (File file : files = folder.listFiles()) {
                if (!file.isDirectory()) continue;
                if (containsImport) {
                    this.generatedItemsModelFileForModelThatDidntHave(file, file.getName(), containsTryToFix);
                }
                this.loadModelsOfNamespace(file, file.getName(), containsTryToFix);
            }
        }
        Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)"&eThe textures have been loaded into MyFurniture successfully!");
    }

    public void runPackCommandCustomModelData(String[] args) {
        boolean containsImport = true;
        boolean containsTryToFix = true;
        for (String string : args) {
            if (string.equalsIgnoreCase("--NotImport")) {
                containsImport = false;
                continue;
            }
            if (!string.equalsIgnoreCase("--NotTryToFix")) continue;
            containsTryToFix = false;
        }
        Map<Material, File> definitionFiles = TexturesPackLoader.getAllModelsFileOfDirectory();
        ArrayList<ModelFile> modelsFiles = new ArrayList<ModelFile>();
        for (Map.Entry<Material, File> entry : definitionFiles.entrySet()) {
            Material material = entry.getKey();
            File definitionFile = entry.getValue();
            modelsFiles.addAll(this.loadModelsOfNamespaceCustomModelData(definitionFile, material, containsTryToFix));
        }
        if (containsImport) {
            ArrayList<File> alreadyLoadedFiles = new ArrayList<File>();
            for (ModelFile modelFile : modelsFiles) {
                alreadyLoadedFiles.add(modelFile.getFile());
            }
            List<File> list = TexturesPackLoader.importNotLoadedFiles(alreadyLoadedFiles);
            for (File notDefinedModelFile : list) {
                Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("Not defined model file detected: " + notDefinedModelFile.getName()));
                TexturesPackLoader.registerNewDefaultModel(notDefinedModelFile);
                if (!containsTryToFix) continue;
                TexturesPackLoader.tryToFixTextures(notDefinedModelFile.getPath());
            }
            this.loadModelsOfNamespaceCustomModelData(new File(defaultModelOldPath), MyFurniture.BASE_MATERIAL, containsTryToFix);
        }
    }

    public static void createZip(String zipFilePath, List<String> filePaths, List<String> folderPaths) throws IOException {
        File check = new File(zipFilePath);
        if (check.exists()) {
            check.delete();
        }
        try (FileOutputStream fos = new FileOutputStream(zipFilePath);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            if (filePaths != null) {
                for (String filePath : filePaths) {
                    File file = new File(filePath);
                    if (!file.exists() || !file.isFile()) continue;
                    TexturesPackLoader.addFileToZip(file, file.getName(), zos);
                }
            }
            if (folderPaths != null) {
                for (String folderPath : folderPaths) {
                    File folder = new File(folderPath);
                    if (!folder.exists() || !folder.isDirectory()) continue;
                    TexturesPackLoader.addFolderToZip(folder, folder.getName(), zos);
                }
            }
        }
    }

    private static void addFileToZip(File file, String entryName, ZipOutputStream zos) throws IOException {
        ZipEntry zipEntry = new ZipEntry(entryName);
        zos.putNextEntry(zipEntry);
        try (FileInputStream fis = new FileInputStream(file);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) > 0) {
                zos.write(buffer, 0, length);
            }
        }
        zos.closeEntry();
    }

    private static void addFolderToZip(File folder, String parentPath, ZipOutputStream zos) throws IOException {
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String entryPath = parentPath + "/" + file.getName();
            if (file.isDirectory()) {
                ZipEntry zipEntry = new ZipEntry(entryPath + "/");
                zos.putNextEntry(zipEntry);
                zos.closeEntry();
                TexturesPackLoader.addFolderToZip(file, entryPath, zos);
                continue;
            }
            TexturesPackLoader.addFileToZip(file, entryPath, zos);
        }
    }

    public void generatedItemsModelFileForModelThatDidntHave(File definitionFile, String namespace, boolean tryToFix) {
        Map<File, String> modelsFilesInFolder = this.getAllModelsFileOfDirectory(new File(definitionFile.getPath() + File.separator + "models"), "");
        for (File modelDefFile : modelsFilesInFolder.keySet()) {
            File newItemModelFile = new File(definitionFile.getPath() + File.separator + "items" + File.separator + modelDefFile.getName());
            if (newItemModelFile.exists()) continue;
            try {
                newItemModelFile.getParentFile().mkdirs();
                newItemModelFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try (FileWriter writer = new FileWriter(newItemModelFile);){
                ObjectMapper mapper = new ObjectMapper();
                DefaultPrettyPrinter printer = new DefaultPrettyPrinter();
                mapper.setDefaultPrettyPrinter((PrettyPrinter)printer);
                mapper.enable(SerializationFeature.INDENT_OUTPUT);
                ObjectNode objectNode = mapper.createObjectNode();
                objectNode.put("type", "minecraft:model");
                objectNode.put("model", namespace + ":" + modelsFilesInFolder.get(modelDefFile).replaceAll("\\\\", "/"));
                ObjectNode mainModel = mapper.createObjectNode();
                mainModel.set("model", (JsonNode)objectNode);
                mapper.writeValue((Writer)writer, (Object)mainModel);
                Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("The file has been auto imported in ItemModel: " + newItemModelFile.getName()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Map<File, String> getAllModelsFileOfDirectory(File directory, String path) {
        HashMap<File, String> modelsFiles = new HashMap<File, String>();
        File[] files = directory.listFiles();
        if (files == null) {
            return modelsFiles;
        }
        for (File file : files) {
            String newPath = path;
            if (file.isDirectory()) {
                newPath = newPath.isEmpty() ? file.getName() : newPath + File.separator + file.getName();
                modelsFiles.putAll(this.getAllModelsFileOfDirectory(file, newPath));
                continue;
            }
            if (!file.getName().endsWith(".json")) continue;
            String fileName = file.getName().replaceAll(".json", "");
            newPath = newPath.isEmpty() ? newPath + fileName : newPath + File.separator + fileName;
            modelsFiles.put(file, newPath);
        }
        return modelsFiles;
    }

    public static Map<Material, File> getAllModelsFileOfDirectory() {
        HashMap<Material, File> definitionFiles = new HashMap<Material, File>();
        File folder = new File(itemPathOld);
        if (!folder.exists()) {
            Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("The folder " + itemPathOld + " doesn't exist"));
            return definitionFiles;
        }
        for (File definitionFile : folder.listFiles(File::isFile)) {
            String definitionId = definitionFile.getName().replace(".json", "");
            Material materialRegistration = Material.getMaterial((String)definitionId.toUpperCase());
            if (materialRegistration == null) {
                Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("Definition file > Material " + definitionId + " doesn't exist"));
                continue;
            }
            Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("Definition file detected: " + definitionFile.getName() + " for material " + materialRegistration));
            definitionFiles.put(materialRegistration, definitionFile);
        }
        return definitionFiles;
    }

    public List<ModelFile> loadModelsOfNamespace(File definitionFile, String namespace, boolean tryToFix) {
        ArrayList<ModelFile> modelsFiles = new ArrayList<ModelFile>();
        Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("Loading the model files of the namespace: " + definitionFile.getName()));
        Map<File, String> modelsFilesInFolder = this.getAllModelsFileOfDirectory(new File(definitionFile.getPath() + File.separator + "items"), "");
        for (File modelDefFile : modelsFilesInFolder.keySet()) {
            String itemModelPath = namespace + ":" + modelsFilesInFolder.get(modelDefFile);
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                ModelFile modelFile;
                JsonNode submodel;
                FileReader reader;
                block18: {
                    JsonNode model;
                    block17: {
                        reader = new FileReader(modelDefFile);
                        JsonNode jsonNode = objectMapper.readTree((Reader)reader);
                        model = jsonNode.get("model");
                        if (model != null) break block17;
                        Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("The file " + modelDefFile.getName() + " doesn't contain a model definition"));
                        ((Reader)reader).close();
                        continue;
                    }
                    submodel = model.get("model");
                    if (submodel != null) break block18;
                    Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("The file " + modelDefFile.getName() + " contains a model definition not supported"));
                    ((Reader)reader).close();
                    continue;
                }
                String modelDefinition = submodel.asText();
                String parent = "minecraft";
                if (modelDefinition.contains(":")) {
                    String[] split = modelDefinition.split(":");
                    parent = split[0];
                    modelDefinition = split[1];
                }
                String basePath = assetsFolder + File.separator + parent;
                String completeModelPath = basePath + File.separator + "models" + File.separator + modelDefinition + ".json";
                File textureFile = new File(completeModelPath);
                if (tryToFix) {
                    TexturesPackLoader.tryToFixTextures(textureFile.getPath());
                }
                try {
                    modelFile = new ModelFile(textureFile);
                }
                catch (Exception e) {
                    Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("Error while loading the model: " + textureFile));
                    ((Reader)reader).close();
                    continue;
                }
                try {
                    if (tryToFix) {
                        modelFile.getBoundingBoxFile();
                    }
                    if (!this.registerModelFile(modelFile, itemModelPath)) continue;
                    modelsFiles.add(modelFile);
                }
                finally {
                    ((Reader)reader).close();
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)(MyFurniture.plugin.getNameDesign() + " &7End of the definition file: &e" + definitionFile.getName() + " &7>> &e" + modelsFiles.size() + " textures loaded"));
        return modelsFiles;
    }

    public List<ModelFile> loadModelsOfNamespaceCustomModelData(File definitionFile, Material material, boolean tryToFix) {
        ArrayList<ModelFile> modelsFiles = new ArrayList<ModelFile>();
        Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("Loading the definition file: " + definitionFile.getName()));
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            if (!definitionFile.exists()) {
                Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("The definition file: " + definitionFile.getName() + " doesn't exist"));
                return modelsFiles;
            }
            try (FileReader reader = new FileReader(definitionFile);){
                JsonNode jsonNode = objectMapper.readTree((Reader)reader);
                ArrayNode msg = (ArrayNode)jsonNode.get("overrides");
                for (JsonNode definition : msg) {
                    ModelFile modelFile;
                    JsonNode predicate = definition.get("predicate");
                    if (predicate.get("custom_model_data") == null) {
                        Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("The definition file: " + definitionFile.getName() + " contains a definition without custom_model_data so ignored"));
                        continue;
                    }
                    if (!predicate.get("custom_model_data").isInt()) {
                        Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("The definition file: " + definitionFile.getName() + " contains a custom_model_data that is not an integer"));
                        continue;
                    }
                    int customModelData = predicate.get("custom_model_data").asInt();
                    String modelDefinition = definition.get("model").asText();
                    String parent = "minecraft";
                    if (modelDefinition.contains(":")) {
                        String[] split = modelDefinition.split(":");
                        parent = split[0];
                        modelDefinition = split[1];
                    }
                    String basePath = assetsFolder + File.separator + parent;
                    String completeModelPath = basePath + File.separator + "models" + File.separator + modelDefinition + ".json";
                    File textureFile = new File(completeModelPath);
                    try {
                        modelFile = new ModelFile(textureFile);
                    }
                    catch (Exception e) {
                        Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("Error while loading the model: " + textureFile));
                        continue;
                    }
                    if (tryToFix) {
                        modelFile.getBoundingBoxFile();
                    }
                    if (!this.registerModelFile(modelFile, material, customModelData)) continue;
                    modelsFiles.add(modelFile);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("End of the definition file: " + definitionFile.getName() + " >> " + modelsFiles.size() + " textures loaded"));
        return modelsFiles;
    }

    public static List<File> importNotLoadedFiles(List<File> alreadyLoadedFiles) {
        File folder = new File(assetsFolder);
        if (!folder.exists()) {
            Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("The folder " + assetsFolder + " doesn't exist"));
            return new ArrayList<File>();
        }
        return TexturesPackLoader.a(new ArrayList<File>(), folder, alreadyLoadedFiles);
    }

    private static List<File> a(List<File> notImportedFiles, File folder, List<File> alreadyLoadedFiles) {
        File[] files = folder.listFiles();
        int fileNotImportFound = 0;
        for (File file : files) {
            if (file.isDirectory()) {
                TexturesPackLoader.a(notImportedFiles, file, alreadyLoadedFiles);
                continue;
            }
            if (!file.getName().endsWith(".json")) continue;
            String fileAbsolutePath = file.getAbsolutePath();
            fileAbsolutePath = fileAbsolutePath.replace(itemPathOld + File.separator, "");
            if (alreadyLoadedFiles.contains(file) || !fileAbsolutePath.contains(File.separator)) continue;
            notImportedFiles.add(file);
            ++fileNotImportFound;
        }
        Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("Not imported files found in the folder " + folder.getAbsolutePath() + " Amount: " + fileNotImportFound));
        return notImportedFiles;
    }

    public static ObjectMapper getMapper() {
        ObjectMapper mapper = new ObjectMapper();
        DefaultPrettyPrinter printer = new DefaultPrettyPrinter();
        mapper.setDefaultPrettyPrinter((PrettyPrinter)printer);
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        return mapper;
    }

    public boolean registerModelFile(ModelFile model, String itemModelPath) {
        File file;
        Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)(MyFurniture.plugin.getNameDesign() + " &7Registering model: &e" + model.getModelId() + "(Path: " + model.getModelParentPath() + ")"));
        String eBPath = "plugins" + File.separator + "MyFurniture" + File.separator + "furniture" + File.separator + "__furniture_from_textures__" + File.separator + model.getModelParentPath() + model.getModelId() + ".yml";
        String folderPath = "plugins" + File.separator + "MyFurniture" + File.separator + "furniture" + File.separator + "__furniture_from_textures__";
        if (!model.getModelParentPath().isEmpty()) {
            folderPath = folderPath + File.separator + model.getModelParentPath();
        }
        if (!(file = new File(folderPath)).exists()) {
            file.mkdirs();
        }
        Optional<Furniture> furnitureOptional = FurnitureManager.getInstance().getFurniture(model.getModelId());
        Furniture furniture = furnitureOptional.orElseGet(() -> new Furniture(model.getModelId(), eBPath));
        DisplayFeatures displayFeatures = furniture.getDisplayFeatures();
        if (!furnitureOptional.isPresent()) {
            displayFeatures.getClickToBreak().setValue(Optional.of(3));
        }
        displayFeatures.getItemModel().setValue(Optional.of(itemModelPath));
        BoundingBoxZoneGroupFeature boundingBoxZoneGroupFeature = displayFeatures.getBoundingBoxZoneGroupFeature();
        model.fillBoundingBoxZoneGroupFeature(boundingBoxZoneGroupFeature);
        if (Dependency.EXECUTABLE_ITEMS.isEnabled()) {
            ExecutableItemInterface ei = ExecutableItemsAPI.registerNewExecutableItemObject((ItemStack)furniture.buildItem(1, Optional.empty(), true), (String)model.getModelId(), (String)"MyFurniture/");
            ei.setUsage(-1);
            furniture.getEi().setValue(Optional.of(model.getModelId()));
        }
        try {
            furniture.save();
        }
        catch (Exception e) {
            e.printStackTrace();
            Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("Error while saving the furniture: " + model.getModelId() + " (path: " + eBPath + ")"));
            return false;
        }
        FurnitureManager.getInstance().addLoadedObject((SObject)furniture);
        return true;
    }

    public boolean registerModelFile(ModelFile model, Material material, int customModelData) {
        File file;
        Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("Registering model: " + model.getModelId() + "(Path: " + model.getModelParentPath() + ")"));
        String eBPath = "plugins" + File.separator + "MyFurniture" + File.separator + "furniture" + File.separator + "__furniture_from_textures__" + File.separator + model.getModelParentPath() + model.getModelId() + ".yml";
        String folderPath = "plugins" + File.separator + "MyFurniture" + File.separator + "furniture" + File.separator + "__furniture_from_textures__";
        if (!model.getModelParentPath().isEmpty()) {
            folderPath = folderPath + File.separator + model.getModelParentPath();
        }
        if (!(file = new File(folderPath)).exists()) {
            file.mkdirs();
        }
        Optional<Furniture> furnitureOptional = FurnitureManager.getInstance().getFurniture(model.getModelId());
        Furniture furniture = furnitureOptional.orElseGet(() -> new Furniture(model.getModelId(), eBPath));
        DisplayFeatures displayFeatures = furniture.getDisplayFeatures();
        if (!furnitureOptional.isPresent()) {
            displayFeatures.getClickToBreak().setValue(Optional.of(3));
        }
        displayFeatures.getMaterial().setValue(Optional.of(material));
        displayFeatures.getCustomModelData().setValue(Optional.of(customModelData));
        BoundingBoxZoneGroupFeature boundingBoxZoneGroupFeature = displayFeatures.getBoundingBoxZoneGroupFeature();
        model.fillBoundingBoxZoneGroupFeature(boundingBoxZoneGroupFeature);
        if (Dependency.EXECUTABLE_ITEMS.isEnabled()) {
            ExecutableItemInterface ei = ExecutableItemsAPI.registerNewExecutableItemObject((ItemStack)furniture.buildItem(1, Optional.empty(), true), (String)model.getModelId(), (String)"MyFurniture/");
            ei.setUsage(-1);
            furniture.getEi().setValue(Optional.of(model.getModelId()));
        }
        try {
            furniture.save();
        }
        catch (Exception e) {
            e.printStackTrace();
            Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("Error while saving the furniture: " + model.getModelParentPath() + " (path: " + eBPath + ")"));
            return false;
        }
        FurnitureManager.getInstance().addLoadedObject((SObject)furniture);
        return true;
    }

    public static void registerNewDefaultModel(File modelFile) {
        File defaultDefinitionfile = new File(defaultModelOldPath);
        if (!defaultDefinitionfile.exists()) {
            Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("The default definition file " + defaultDefinitionfile.getName() + " doesn't exist"));
            return;
        }
        int maxCustomModelData = 0;
        ObjectMapper mapper = new ObjectMapper();
        try (FileReader reader = new FileReader(defaultDefinitionfile);){
            JsonNode jsonObject = mapper.readTree((Reader)reader);
            ArrayNode msg = (ArrayNode)jsonObject.get("overrides");
            for (JsonNode definition : msg) {
                JsonNode predicate = definition.get("predicate");
                int customModelData = predicate.get("custom_model_data").asInt();
                if (customModelData <= maxCustomModelData) continue;
                maxCustomModelData = customModelData;
            }
            ObjectNode objectNode = mapper.createObjectNode();
            objectNode.put("predicate", (JsonNode)mapper.createObjectNode().put("custom_model_data", maxCustomModelData + 1));
            String reducedModelPath = modelFile.getPath().replace(assetsFolder + File.separator, "").replace(".json", "");
            if (reducedModelPath.startsWith(File.separator)) {
                reducedModelPath = reducedModelPath.substring(1);
            }
            String[] split = reducedModelPath.split(File.separator + "models" + File.separator);
            String parent = split[0];
            String model = split[1];
            objectNode.put("model", parent + ":" + model);
            msg.add((JsonNode)objectNode);
            try (FileWriter writer = new FileWriter(defaultDefinitionfile);){
                DefaultPrettyPrinter printer = new DefaultPrettyPrinter();
                mapper.setDefaultPrettyPrinter((PrettyPrinter)printer);
                mapper.enable(SerializationFeature.INDENT_OUTPUT);
                mapper.writeValue((Writer)writer, (Object)jsonObject);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void tryToFixTextures(String modelPath) {
        ObjectMapper mapper = new ObjectMapper();
        try (FileReader reader = new FileReader(new File(modelPath));){
            JsonNode jsonObject = mapper.readTree((Reader)reader);
            JsonNode textures = jsonObject.get("textures");
            if (textures == null) {
                Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("The file " + modelPath + " doesn't contain textures"));
                return;
            }
            textures.fields().forEachRemaining(entry -> {
                String texturePath = ((JsonNode)entry.getValue()).asText();
                if (texturePath.contains("./")) {
                    String value = texturePath.replace("./", "");
                    String reducedModelPath = modelPath.replace(assetsFolder, "").replaceAll("\\\\", "/").replace(".json", "");
                    if (reducedModelPath.startsWith("/")) {
                        reducedModelPath = reducedModelPath.substring(1);
                    }
                    String[] split = reducedModelPath.split("/models/");
                    String parent = split[0];
                    String model = split[1];
                    if (model.contains("/")) {
                        model = model.substring(0, model.lastIndexOf("/") + 1);
                    }
                    ((ObjectNode)textures).put((String)entry.getKey(), parent + ":" + model + value);
                    Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)(MyFurniture.plugin.getNameDesign() + " &7Fix the file " + modelPath + " a texture definition contained ./ so fixed it to " + parent + ":" + model + value));
                }
                if (texturePath.contains(":")) {
                    String oldTexturePath = assetsFolder + File.separator + texturePath.replace(":", File.separator + "textures" + File.separator) + ".png";
                    String[] split = texturePath.split(":");
                    String parent = split[0];
                    String model = split[1];
                    if (!model.startsWith("item/")) {
                        String newTexturePath = assetsFolder + File.separator + parent + File.separator + "textures" + File.separator + "item" + File.separator + model + ".png";
                        File oldFile = new File(oldTexturePath);
                        File newFile = new File(newTexturePath);
                        ((ObjectNode)textures).put((String)entry.getKey(), parent + ":item/" + model);
                        Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)(MyFurniture.plugin.getNameDesign() + " &7Fix the file " + modelPath + " a texture definition didnt use /item so fixed it to " + parent + ":item/" + model));
                        if (oldFile.exists() && !newFile.exists()) {
                            try {
                                Files.createDirectories(newFile.getParentFile().toPath(), new FileAttribute[0]);
                                Files.move(oldFile.toPath(), newFile.toPath(), new CopyOption[0]);
                                Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)(MyFurniture.plugin.getNameDesign() + " &7Fix the file " + modelPath + " moved the texture file from " + oldTexturePath + " to " + newTexturePath));
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            });
            try (FileWriter writer = new FileWriter(new File(modelPath));){
                DefaultPrettyPrinter printer = new DefaultPrettyPrinter();
                mapper.setDefaultPrettyPrinter((PrettyPrinter)printer);
                mapper.enable(SerializationFeature.INDENT_OUTPUT);
                mapper.writeValue((Writer)writer, (Object)jsonObject);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isPackFolderExists() {
        File file = new File(texturesFolder);
        return file.exists();
    }

    public static void downloadPack(CommandSender commandSender, boolean deleteIfExists) {
        File file = new File(texturesFolder);
        if (!file.exists()) {
            file.mkdirs();
        } else {
            File defaultack = new File(DEFAULT_TEXTURES_PACK_PATH);
            if (defaultack.exists()) {
                if (deleteIfExists) {
                    defaultack.delete();
                } else {
                    SendMessage.sendMessageNoPlch((CommandSender)commandSender, (String)(MyFurniture.plugin.getNameDesign() + " &7The default pack is already downloaded, Delete it first if you want to refresh it."));
                    return;
                }
            }
        }
        TexturesPackLoader.downloadPackGithub(commandSender);
    }

    protected static void downloadPackGithub(CommandSender commandSender) {
        String DOWNLOAD_URL = "https://github.com/Ssomar-Developement/MyFurniture-pack/raw/main/" + TPACK_NAME;
        InputStream in = null;
        try {
            in = new URL(DOWNLOAD_URL).openStream();
            Files.copy(in, Paths.get(DEFAULT_TEXTURES_PACK_PATH, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            SendMessage.sendMessageNoPlch((CommandSender)commandSender, (String)(MyFurniture.plugin.getNameDesign() + " &7Download of the default pack succeeded (from Github) !"));
        }
        catch (IOException e) {
            SendMessage.sendMessageNoPlch((CommandSender)commandSender, (String)(MyFurniture.plugin.getNameDesign() + " &7The plugin can't download the github pack, it will use a small default pack in the jar instead."));
            TexturesPackLoader.extractFromTheJar(commandSender);
        }
    }

    protected static void extractFromTheJar(CommandSender commandSender) {
        String FILE_NAME = texturesFolder + File.separator + TPACK_NAME;
        String EXTRACT_URL = "/com/ssomar/myfurniture/configs/pack/" + TPACK_NAME;
        try {
            File pdfile = new File(FILE_NAME);
            InputStream in = ((Object)((Object)MyFurniture.plugin)).getClass().getResourceAsStream(EXTRACT_URL);
            if (pdfile.exists()) {
                return;
            }
            MyFurniture.plugin.getDataFolder().mkdirs();
            pdfile.getParentFile().mkdirs();
            pdfile.createNewFile();
            FileOutputStream out = new FileOutputStream(pdfile);
            byte[] buffer = new byte[1024];
            int current = 0;
            while ((current = in.read(buffer)) > -1) {
                ((OutputStream)out).write(buffer, 0, current);
            }
            SendMessage.sendMessageNoPlch((CommandSender)commandSender, (String)(MyFurniture.plugin.getNameDesign() + " &7Download of the default pack succeeded (from jar) !"));
            ((OutputStream)out).close();
            in.close();
        }
        catch (IOException e) {
            SendMessage.sendMessageNoPlch((CommandSender)commandSender, (String)(MyFurniture.plugin.getNameDesign() + " &7The plugin can't extract the default pack from the jar, contact the support !"));
            e.printStackTrace();
        }
    }

    public static void unzipPack() {
        String ZIP_FILE = texturesFolder + File.separator + TPACK_NAME;
        File DESTINATION_FOLDER = new File(texturesFolder + File.separator + "MyFurniture_Pack");
        byte[] buffer = new byte[1024];
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(new FileInputStream(ZIP_FILE));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        ZipEntry zipEntry = null;
        try {
            zipEntry = zis.getNextEntry();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        while (zipEntry != null) {
            try {
                File newFile = TexturesPackLoader.newFile(DESTINATION_FOLDER, zipEntry);
                if (zipEntry.isDirectory()) {
                    if (!newFile.isDirectory() && !newFile.mkdirs()) {
                        throw new IOException("Failed to create directory " + newFile);
                    }
                } else {
                    int len;
                    File parent = newFile.getParentFile();
                    if (!parent.isDirectory() && !parent.mkdirs()) {
                        throw new IOException("Failed to create directory " + parent);
                    }
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                zipEntry = zis.getNextEntry();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            zis.closeEntry();
            zis.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }
}

