/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.utils;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.world.chunk.LightData;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateLight;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import java.util.Arrays;
import java.util.BitSet;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class LightPacketUtilPacketEvent {
    public static void sendLightUpdate(Player player, int chunkX, int chunkZ) {
        BitSet blockLightMask = new BitSet();
        BitSet skyLightMask = new BitSet();
        BitSet emptyBlockLightMask = new BitSet();
        BitSet emptySkyLightMask = new BitSet();
        for (int i = 0; i < 18; ++i) {
            blockLightMask.set(i);
            skyLightMask.set(i);
        }
        byte[][] skyLightArray = new byte[18][];
        byte[][] blockLightArray = new byte[18][];
        byte fullBright = -1;
        for (int i = 0; i < 18; ++i) {
            skyLightArray[i] = new byte[2048];
            blockLightArray[i] = new byte[2048];
            Arrays.fill(skyLightArray[i], fullBright);
            Arrays.fill(blockLightArray[i], fullBright);
        }
        LightData lightData = new LightData(true, blockLightMask, skyLightMask, emptyBlockLightMask, emptySkyLightMask, 18, 18, (byte[][])skyLightArray, (byte[][])blockLightArray);
        WrapperPlayServerUpdateLight lightPacket = new WrapperPlayServerUpdateLight(chunkX, chunkZ, lightData);
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)lightPacket);
    }

    public static void createLightSource(Player player, Location location) {
        int chunkX = location.getChunk().getX();
        int chunkZ = location.getChunk().getZ();
        SsomarDev.testMsg((String)("Chunk X: " + chunkX + ", Chunk Z: " + chunkZ), (boolean)true);
        LightPacketUtilPacketEvent.sendLightUpdate(player, chunkX, chunkZ);
    }

    public static void updateBlockLight(Player player, int x, int y, int z, int lightLevel) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        int relativeX = x & 0xF;
        int relativeZ = z & 0xF;
        int sectionY = y >> 5;
        int relativeY = y & 0x1F;
        BitSet blockLightMask = new BitSet();
        BitSet skyLightMask = new BitSet();
        BitSet emptyBlockLightMask = new BitSet();
        BitSet emptySkyLightMask = new BitSet();
        blockLightMask.set(sectionY);
        skyLightMask.set(sectionY);
        byte[][] skyLightArray = new byte[18][];
        byte[][] blockLightArray = new byte[18][];
        for (int i = 0; i < 18; ++i) {
            skyLightArray[i] = new byte[4096];
            blockLightArray[i] = new byte[4096];
        }
        int index = (relativeY * 16 * 16 + relativeZ * 16 + relativeX) / 2;
        byte existingByte = blockLightArray[sectionY][index];
        existingByte = relativeX % 2 == 0 ? (byte)(existingByte & 0xF0 | lightLevel & 0xF) : (byte)(existingByte & 0xF | (lightLevel & 0xF) << 4);
        blockLightArray[sectionY][index] = existingByte;
        skyLightArray[sectionY][index] = existingByte;
        LightData lightData = new LightData(true, blockLightMask, skyLightMask, emptyBlockLightMask, emptySkyLightMask, 18, 18, (byte[][])skyLightArray, (byte[][])blockLightArray);
        WrapperPlayServerUpdateLight lightPacket = new WrapperPlayServerUpdateLight(chunkX, chunkZ, lightData);
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)lightPacket);
    }

    public static void sendLightUpdate(Player player, Location location, int lightLevel) {
        int localZ;
        int chunkX = location.getBlockX() >> 4;
        int chunkZ = location.getBlockZ() >> 4;
        int sectionY = location.getBlockY() + 64 >> 4;
        LightData lightData = new LightData();
        BitSet blockLightMask = new BitSet();
        BitSet skyLightMask = new BitSet();
        BitSet emptyBlockLightMask = new BitSet();
        BitSet emptySkyLightMask = new BitSet();
        int adjustedSectionY = Math.max(0, sectionY);
        blockLightMask.set(adjustedSectionY);
        int totalSections = 24;
        byte[][] blockLightArray = new byte[totalSections][];
        byte[][] skyLightArray = new byte[totalSections][];
        byte[] emptyLightData = new byte[2048];
        for (int i = 0; i < totalSections; ++i) {
            blockLightArray[i] = (byte[])emptyLightData.clone();
            skyLightArray[i] = (byte[])emptyLightData.clone();
        }
        byte[] sectionLightData = (byte[])blockLightArray[adjustedSectionY].clone();
        int localX = location.getBlockX() & 0xF;
        int localY = location.getBlockY() & 0xF;
        int index = localY << 8 | (localZ = location.getBlockZ() & 0xF) << 4 | localX;
        sectionLightData[index / 2] = index % 2 == 0 ? (byte)(sectionLightData[index / 2] & 0xF0 | lightLevel & 0xF) : (byte)(sectionLightData[index / 2] & 0xF | (lightLevel & 0xF) << 4);
        blockLightArray[adjustedSectionY] = sectionLightData;
        lightData.setBlockLightMask(blockLightMask);
        lightData.setSkyLightMask(skyLightMask);
        lightData.setEmptyBlockLightMask(emptyBlockLightMask);
        lightData.setEmptySkyLightMask(emptySkyLightMask);
        lightData.setBlockLightArray((byte[][])blockLightArray);
        lightData.setSkyLightArray((byte[][])skyLightArray);
        lightData.setBlockLightCount(totalSections);
        lightData.setSkyLightCount(totalSections);
        WrapperPlayServerUpdateLight packet = new WrapperPlayServerUpdateLight(chunkX, chunkZ, lightData);
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)packet);
    }

    public static void sendLightUpdate(Player player, int x, int y, int z, int lightLevel) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        LightData lightData = new LightData();
        int currentSection = (y + 80) / 16;
        SsomarDev.testMsg((String)("currentSection: " + currentSection), (boolean)true);
        BitSet blockLightMask = new BitSet();
        BitSet skyLightMask = new BitSet();
        BitSet emptyBlockLightMask = new BitSet();
        BitSet emptySkyLightMask = new BitSet();
        int totalSections = 24;
        for (int section = 0; section < totalSections; ++section) {
            blockLightMask.set(section);
            emptySkyLightMask.set(section);
        }
        byte[][] blockLightArray = new byte[totalSections][];
        byte[][] skyLightArray = new byte[totalSections][];
        for (int section = 0; section < totalSections; ++section) {
            if (section != currentSection) {
                blockLightArray[section] = new byte[2048];
                skyLightArray[section] = new byte[2048];
                continue;
            }
            byte[] sectionLightData = new byte[2048];
            int index = (y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF;
            sectionLightData[index / 2] = index % 2 == 0 ? (byte)(sectionLightData[index / 2] & 0xF0 | lightLevel & 0xF) : (byte)(sectionLightData[index / 2] & 0xF | (lightLevel & 0xF) << 4);
            blockLightArray[section] = sectionLightData;
            skyLightArray[section] = new byte[2048];
        }
        lightData.setBlockLightMask(blockLightMask);
        lightData.setSkyLightMask(skyLightMask);
        lightData.setEmptyBlockLightMask(emptyBlockLightMask);
        lightData.setEmptySkyLightMask(emptySkyLightMask);
        lightData.setBlockLightArray((byte[][])blockLightArray);
        lightData.setSkyLightArray((byte[][])skyLightArray);
        lightData.setBlockLightCount(totalSections);
        lightData.setSkyLightCount(totalSections);
        WrapperPlayServerUpdateLight packet = new WrapperPlayServerUpdateLight(chunkX, chunkZ, lightData);
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)packet);
        Block block = player.getLocation().getBlock();
        if (block.getType().isAir()) {
            Runnable runnable = () -> {
                block.getState().update(true, true);
                block.getWorld().refreshChunk(chunkX, chunkZ);
            };
            SCore.schedulerHook.runTask(runnable, 5L);
        }
    }
}

