/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.pack;

import com.ssomar.myfurniture.MyFurniture;
import com.ssomar.score.pack.custom.PackManager;
import com.ssomar.score.pack.custom.PackSettings;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class MyFurniturePack {
    static final UUID packUUID = UUID.fromString("3cf9a3c2-064d-4706-ba7a-ed3f7be30a4b");

    public static void unregisterPack() {
        PackManager.getInstance().removePack(packUUID);
    }

    public static void registerPack() {
        String folderPath = MyFurniture.plugin.getDataFolder() + File.separator + "__textures__";
        File folder = new File(folderPath);
        File[] files = folder.listFiles();
        File packFile = null;
        File createdZipFile = null;
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                ArrayList<String> filesInFolder = new ArrayList<String>();
                ArrayList<String> foldersInFolder = new ArrayList<String>();
                for (File fileInFolder : file.listFiles()) {
                    if (fileInFolder.isFile()) {
                        filesInFolder.add(fileInFolder.getAbsolutePath());
                        continue;
                    }
                    if (!fileInFolder.isDirectory()) continue;
                    foldersInFolder.add(fileInFolder.getAbsolutePath());
                }
                createdZipFile = new File(folderPath + File.separator + file.getName() + ".zip");
                if (createdZipFile.exists()) {
                    createdZipFile.delete();
                }
                try {
                    MyFurniturePack.createZip(folderPath + File.separator + file.getName() + ".zip", filesInFolder, foldersInFolder);
                }
                catch (IOException e) {
                    MyFurniture.plugin.getLogger().warning("Error creating zip file: " + e.getMessage());
                }
                packFile = createdZipFile;
                break;
            }
            for (File file : files) {
                if (!file.getName().equals("MyFurniturePack.zip")) continue;
                packFile = file;
                break;
            }
            if (packFile == null) {
                for (File file : files) {
                    if (!file.getName().endsWith(".zip")) continue;
                    packFile = file;
                    break;
                }
            }
        }
        if (packFile == null) {
            MyFurniture.plugin.getLogger().warning("No pack found in the folder __textures__");
            return;
        }
        String filePath = packFile.getAbsolutePath();
        PackSettings packSettings = new PackSettings((SPlugin)MyFurniture.plugin, packUUID, filePath, "", true, createdZipFile != null);
        PackManager.getInstance().addPack(packSettings);
    }

    public static void createZip(String zipFilePath, List<String> filePaths, List<String> folderPaths) throws IOException {
        File check = new File(zipFilePath);
        if (check.exists()) {
            check.delete();
        }
        try (FileOutputStream fos = new FileOutputStream(zipFilePath);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            if (filePaths != null) {
                for (String filePath : filePaths) {
                    File file = new File(filePath);
                    if (!file.exists() || !file.isFile()) continue;
                    MyFurniturePack.addFileToZip(file, file.getName(), zos);
                }
            }
            if (folderPaths != null) {
                for (String folderPath : folderPaths) {
                    File folder = new File(folderPath);
                    if (!folder.exists() || !folder.isDirectory()) continue;
                    MyFurniturePack.addFolderToZip(folder, folder.getName(), zos);
                }
            }
        }
    }

    private static void addFileToZip(File file, String entryName, ZipOutputStream zos) throws IOException {
        ZipEntry zipEntry = new ZipEntry(entryName);
        zos.putNextEntry(zipEntry);
        try (FileInputStream fis = new FileInputStream(file);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) > 0) {
                zos.write(buffer, 0, length);
            }
        }
        zos.closeEntry();
    }

    private static void addFolderToZip(File folder, String parentPath, ZipOutputStream zos) throws IOException {
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String entryPath = parentPath + "/" + file.getName();
            if (file.isDirectory()) {
                ZipEntry zipEntry = new ZipEntry(entryPath + "/");
                zos.putNextEntry(zipEntry);
                zos.closeEntry();
                MyFurniturePack.addFolderToZip(file, entryPath, zos);
                continue;
            }
            MyFurniturePack.addFileToZip(file, entryPath, zos);
        }
    }
}

