/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.furniture;

import com.ssomar.myfurniture.MyFurniture;
import com.ssomar.myfurniture.furniture.Furniture;
import com.ssomar.myfurniture.furniture.FurnitureLoader;
import com.ssomar.myfurniture.furniture.activators.ActivatorMFFeature;
import com.ssomar.myfurniture.listeners.optimize.OptimizedEventsHandler;
import com.ssomar.score.SCore;
import com.ssomar.score.features.custom.activators.activator.SActivator;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.sobject.SObjectWithFileManager;
import com.ssomar.score.sobject.manager.ManagerWithBuildable;
import com.ssomar.score.sobject.sactivator.SOption;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.obfuscation.KeepClass;
import com.ssomar.score.utils.obfuscation.KeepMethod;
import de.tr7zw.nbtapi.NBTItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

@KeepClass
public class FurnitureManager
extends SObjectWithFileManager<Furniture>
implements ManagerWithBuildable<Furniture> {
    private static FurnitureManager instance;
    private NamespacedKey key;

    public FurnitureManager() {
        super((SPlugin)MyFurniture.plugin, "Furniture");
        if (!SCore.is1v13Less()) {
            this.key = new NamespacedKey((Plugin)MyFurniture.getPluginSt(), "MF-ID");
        }
    }

    @KeepMethod
    public void actionOnObjectWhenLoading(Furniture newFurniture) {
        for (SActivator activator : newFurniture.getActivators().getActivators().values()) {
            SOption option = activator.getOption();
            if (!(activator instanceof ActivatorMFFeature)) continue;
            OptimizedEventsHandler.getInstance().read(option);
        }
    }

    @KeepMethod
    public void actionOnObjectWhenReloading(Furniture furniture) {
    }

    @KeepMethod
    public Optional<Furniture> methodObjectLoading(String id) {
        return FurnitureLoader.getInstance().getObjectById(id, false);
    }

    @KeepMethod
    public static FurnitureManager getInstance() {
        if (instance == null) {
            instance = new FurnitureManager();
        }
        return instance;
    }

    @KeepMethod
    public boolean isValidID(String id) {
        for (Furniture item : this.getLoadedObjects()) {
            if (!item.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    @KeepMethod
    public Optional<Furniture> getFurniture(String id) {
        for (Furniture item : this.getLoadedObjects()) {
            if (!item.getId().equals(id)) continue;
            return Optional.of(item);
        }
        return Optional.empty();
    }

    @KeepMethod
    public Optional<Furniture> getFurniture(ItemStack itemStack) {
        return Optional.ofNullable(this.getFurniture(itemStack, new ArrayList<String>()));
    }

    @KeepMethod
    public Furniture getFurniture(ItemStack item, List<String> whiteListedID) {
        boolean hasItemMeta;
        ItemMeta itemMeta = null;
        try {
            itemMeta = item.getItemMeta();
            hasItemMeta = itemMeta != null;
        }
        catch (NullPointerException error) {
            return null;
        }
        String id = "";
        if (SCore.is1v13Less()) {
            NBTItem nbti;
            if (item == null || item.getType() == Material.AIR) {
                return null;
            }
            boolean idFound = false;
            if (SCore.hasNBTAPI && (nbti = new NBTItem(item)).hasKey("EB-ID").booleanValue()) {
                id = nbti.getString("EB-ID");
                idFound = true;
            }
        } else if (hasItemMeta && (id = (String)itemMeta.getPersistentDataContainer().get(this.key, PersistentDataType.STRING)) == null) {
            id = "";
        }
        if (!id.isEmpty()) {
            for (Furniture infoItem : this.getAllObjects()) {
                if (!infoItem.getId().equals(id)) continue;
                return infoItem;
            }
        }
        return null;
    }

    @KeepMethod
    public Optional<SObject> getObject(ItemStack itemStack) {
        return this.getFurniture(itemStack).map(eb -> eb);
    }
}

