/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.furniture.activators;

import com.ssomar.myfurniture.MyFurniture;
import com.ssomar.myfurniture.configs.GeneralConfig;
import com.ssomar.myfurniture.furniture.Furniture;
import com.ssomar.myfurniture.furniture.activators.Option;
import com.ssomar.myfurniture.furniture.activators.editor.ActivatorMFFeatureEditor;
import com.ssomar.myfurniture.furniture.activators.editor.ActivatorMFFeatureEditorManager;
import com.ssomar.myfurniture.furniture.creations.Display;
import com.ssomar.myfurniture.furniture.placedfurniture.FurniturePlaced;
import com.ssomar.myfurniture.listeners.EventsManager;
import com.ssomar.myfurniture.listeners.optimize.OptimizedEventsHandler;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.events.loop.LoopManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.activators.activator.SActivator;
import com.ssomar.score.features.custom.activators.activator.SActivatorWithLoopFeature;
import com.ssomar.score.features.custom.commands.entity.DisplayCommandsFeature;
import com.ssomar.score.features.custom.commands.player.PlayerCommandsFeature;
import com.ssomar.score.features.custom.conditions.custom.parent.CustomConditionsFeature;
import com.ssomar.score.features.custom.conditions.entity.parent.EntityConditionsFeature;
import com.ssomar.score.features.custom.conditions.placeholders.group.PlaceholderConditionGroupFeature;
import com.ssomar.score.features.custom.conditions.player.parent.PlayerConditionsFeature;
import com.ssomar.score.features.custom.conditions.world.parent.WorldConditionsFeature;
import com.ssomar.score.features.custom.cooldowns.CooldownFeature;
import com.ssomar.score.features.custom.loop.LoopFeatures;
import com.ssomar.score.features.custom.required.parent.RequiredGroup;
import com.ssomar.score.features.custom.variables.update.group.VariableUpdateGroupFeature;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.ColoredStringFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.features.types.SOptionFeature;
import com.ssomar.score.features.types.list.ListDamageCauseFeature;
import com.ssomar.score.features.types.list.ListUncoloredStringFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.scheduler.ScheduleFeatures;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.sobject.sactivator.EventInfo;
import com.ssomar.score.sobject.sactivator.SOption;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.obfuscation.KeepMethod;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.sevents.events.projectile.hitentity.ProjectileHitEntityEvent;
import com.ssomar.sevents.events.projectile.hitplayer.ProjectileHitPlayerEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class ActivatorMFFeature
extends SActivator<ActivatorMFFeature, ActivatorMFFeatureEditor, ActivatorMFFeatureEditorManager>
implements SActivatorWithLoopFeature {
    private ColoredStringFeature displayName;
    private SOptionFeature optionFeature;
    private RequiredGroup requiredGroup;
    private IntegerFeature usageModification;
    private DisplayCommandsFeature displayCommands;
    private PlayerCommandsFeature ownerCommands;
    private PlayerCommandsFeature playerCommands;
    private BooleanFeature silenceOutput;
    private BooleanFeature cancelEvent;
    private ListDamageCauseFeature detailedDamageCauses;
    private ListUncoloredStringFeature detailedCommands;
    private PlayerConditionsFeature playerConditions;
    private PlayerConditionsFeature ownerConditions;
    private EntityConditionsFeature displayConditions;
    private WorldConditionsFeature worldConditions;
    private PlaceholderConditionGroupFeature placeholderConditions;
    private CustomConditionsFeature customConditions;
    private CooldownFeature playerCooldown;
    private CooldownFeature globalCooldown;
    private LoopFeatures loopFeatures;
    private VariableUpdateGroupFeature variableUpdates;
    private static final boolean DEBUG = true;

    public ActivatorMFFeature(FeatureParentInterface parent, String id) {
        super((SPlugin)MyFurniture.plugin, parent, id);
        this.reset();
    }

    @KeepMethod
    public String getParentObjectId() {
        String id = "";
        if (this.getParent() instanceof FeatureAbstract) {
            FeatureAbstract parent = (FeatureAbstract)this.getParent();
            for (int i = 0; parent instanceof FeatureAbstract && i != 5; ++i) {
                if (parent instanceof Furniture) {
                    id = ((Furniture)parent).getId();
                    break;
                }
                parent = (FeatureAbstract)parent.getParent();
            }
        }
        return id;
    }

    @KeepMethod
    public SOption getOption() {
        return this.optionFeature.getValue();
    }

    @KeepMethod
    public void run(Object sObject, final EventInfo eInfo) {
        final FurniturePlaced furniturePlaced = (FurniturePlaced)((Object)sObject);
        final Block block = furniturePlaced.getLocation().getBlock();
        Location bLoc = block.getLocation();
        BukkitRunnable runnable = new BukkitRunnable(this){
            final /* synthetic */ ActivatorMFFeature this$0;
            {
                this.this$0 = this$0;
            }

            @KeepMethod
            public void run() {
                Optional ownerOpt;
                Optional projOpt;
                SsomarDev.testMsg((String)"Activator 0", (boolean)true);
                Event eSrc = eInfo.getEventSource();
                Player owner = null;
                ItemDisplay display = null;
                Player player = null;
                Optional optionalPlayer = Optional.empty();
                eSrc = eInfo.getEventSource();
                StringPlaceholder sp = furniturePlaced.getPlaceholders();
                sp.setId(furniturePlaced.getFurniture().getId());
                sp.setName(furniturePlaced.getFurniture().getDisplayName());
                sp.setItem(furniturePlaced.getFurniture().getDisplayName());
                sp.setActivator_id(this.this$0.getId());
                sp.setActivator_name(this.this$0.getName());
                sp.setActivator(this.this$0.getName());
                if (eInfo.getBlockface().isPresent()) {
                    sp.setBlockface((String)eInfo.getBlockface().get());
                }
                if ((projOpt = eInfo.getProjectile()).isPresent()) {
                    SsomarDev.testMsg((String)" has projectile", (boolean)true);
                    if (eInfo.getBlockface().isPresent()) {
                        sp.setProjectilePlcHldr((Projectile)projOpt.get(), (String)eInfo.getBlockface().get());
                    } else {
                        sp.setProjectilePlcHldr((Projectile)projOpt.get(), "");
                    }
                }
                sp.setBlockPlcHldr(block, MyFurniture.BASE_MATERIAL);
                Map extra = sp.getExtraPlaceholders();
                extra.put("%furniture_id%", furniturePlaced.getId());
                extra.put("%furniture_config_id%", furniturePlaced.getFurnitureID());
                ActionInfo actionInfo = new ActionInfo(furniturePlaced.getFurniture().getDisplayName(), sp);
                actionInfo.setSlot(Integer.valueOf(0));
                actionInfo.setEventFromCustomBreakCommand(eInfo.isFromCustomBreakCommand());
                actionInfo.setSilenceOutput(this.this$0.silenceOutput.getValue().booleanValue());
                actionInfo.setLauncherUUID(furniturePlaced.getInternalData().getOwnerUUID());
                actionInfo.setReceiverUUID(furniturePlaced.getInternalData().getOwnerUUID());
                actionInfo.setVelocity(eInfo.getVelocity());
                actionInfo.setBlock(block);
                actionInfo.initActionRelatedToDamageEvent(eSrc);
                SsomarDev.testMsg((String)"Activator 1", (boolean)true);
                if (eInfo.getDamageCause().isPresent()) {
                    SsomarDev.testMsg((String)("Activator 3 >> &e" + ((EntityDamageEvent.DamageCause)eInfo.getDamageCause().get()).name()), (boolean)true);
                } else {
                    SsomarDev.testMsg((String)"Activator 3 >> &cNO CAUSE", (boolean)true);
                }
                if (Option.getOptWithDamageCause().contains(this.this$0.optionFeature.getValue()) && !this.this$0.detailedDamageCauses.verifCause((EntityDamageEvent.DamageCause)eInfo.getDamageCause().get())) {
                    return;
                }
                if (Option.getOptWithCommand().contains(this.this$0.optionFeature.getValue())) {
                    SsomarDev.testMsg((String)("Command activator " + eInfo.getCommand()), (boolean)true);
                    String[] split = ((String)eInfo.getCommand().get()).split(" ");
                    int i = 0;
                    Map map = sp.getExtraPlaceholders();
                    for (String arg : split) {
                        map.put("%arg" + i + "%", arg);
                        ++i;
                    }
                    if (!this.this$0.detailedCommands.getValue().isEmpty()) {
                        boolean invalid = true;
                        for (String s : this.this$0.detailedCommands.getValue()) {
                            if (!((String)eInfo.getCommand().get()).contains(s)) continue;
                            invalid = false;
                            break;
                        }
                        if (invalid) {
                            return;
                        }
                    }
                }
                if ((ownerOpt = furniturePlaced.getInternalData().getOwnerOptional()).isPresent()) {
                    owner = (Player)ownerOpt.get();
                }
                SsomarDev.testMsg((String)"Activator 4", (boolean)true);
                display = ((Display)furniturePlaced.getCreation()).getDisplay();
                if (display == null) {
                    return;
                }
                sp.setEntityPlcHldr(display.getUniqueId());
                actionInfo.setEntityUUID(display.getUniqueId());
                Optional playerOpt = eInfo.getPlayer();
                if (playerOpt.isPresent()) {
                    optionalPlayer = playerOpt;
                    player = (Player)playerOpt.get();
                    sp.setPlayerPlcHldr(player.getUniqueId());
                }
                SsomarDev.testMsg((String)"Activator 5", (boolean)true);
                SendMessage sm = new SendMessage();
                sm.setSp(sp);
                if (!this.this$0.worldConditions.verifConditions(block.getWorld(), optionalPlayer, sm, eSrc)) {
                    return;
                }
                if (owner != null && !this.this$0.ownerConditions.verifConditions(owner, optionalPlayer, sm, eSrc)) {
                    return;
                }
                if (Option.getOptWithPlayer().contains(this.this$0.optionFeature.getValue()) && player != null && !this.this$0.playerConditions.verifConditions(player, optionalPlayer, sm, eSrc)) {
                    return;
                }
                if (display != null && !this.this$0.displayConditions.verifConditions((Entity)display, optionalPlayer, sm, eSrc)) {
                    return;
                }
                if (!this.this$0.customConditions.verifConditions(player, null, sm, eSrc)) {
                    return;
                }
                SsomarDev.testMsg((String)"Activator 7", (boolean)true);
                if (!this.this$0.placeholderConditions.verify(owner, player, sp, eSrc)) {
                    return;
                }
                SsomarDev.testMsg((String)"Activator 7.9", (boolean)true);
                if (player != null ? !this.this$0.requiredGroup.verify(player, eSrc, sp) : owner != null && !this.this$0.requiredGroup.verify(owner, eSrc, sp)) {
                    return;
                }
                SsomarDev.testMsg((String)"Activator 8-9", (boolean)true);
                if (player != null) {
                    if (!this.this$0.globalCooldown.checkCooldown((Entity)player, eSrc, sp, (SObject)furniturePlaced.getFurniture())) {
                        return;
                    }
                    if (!this.this$0.playerCooldown.checkCooldown((Entity)player, eSrc, sp, (SObject)furniturePlaced.getFurniture())) {
                        return;
                    }
                }
                if (eInfo.isMustDoNothing()) {
                    ActivatorMFFeature.cancelEvent(eSrc, this.this$0.cancelEvent.getValue(null, sp));
                    return;
                }
                SsomarDev.testMsg((String)"Activator 10", (boolean)true);
                if (player != null) {
                    this.this$0.requiredGroup.take(player, sp);
                } else if (owner != null) {
                    this.this$0.requiredGroup.take(owner, sp);
                }
                ActivatorMFFeature.cancelEvent(eSrc, this.this$0.cancelEvent.getValue(null, sp));
                ActionInfo aCloned = actionInfo.clone();
                if (!Option.getOptWithPlayer().contains(this.this$0.optionFeature.getValue()) || player == null) {
                    aCloned.setNoPlayerTriggeredTheAction(true);
                }
                this.this$0.displayCommands.runCommands(aCloned, furniturePlaced.getFurniture().getDisplayName());
                if (owner != null) {
                    this.this$0.ownerCommands.runCommands(actionInfo, furniturePlaced.getFurniture().getDisplayName());
                }
                if (player != null) {
                    this.this$0.playerCooldown.addCooldown((Entity)player, (SObject)furniturePlaced.getFurniture(), sp);
                    this.this$0.globalCooldown.addGlobalCooldown((SObject)furniturePlaced.getFurniture());
                    ActionInfo aInfo2 = actionInfo.clone();
                    aInfo2.setReceiverUUID(player.getUniqueId());
                    this.this$0.playerCommands.runCommands(aInfo2, furniturePlaced.getFurniture().getDisplayName());
                }
                SsomarDev.testMsg((String)"Activator 11", (boolean)true);
                if (furniturePlaced.isRemoved()) {
                    return;
                }
                SsomarDev.testMsg((String)"Activator 12", (boolean)true);
                furniturePlaced.updateVariables(this.this$0.variableUpdates, optionalPlayer.orElse(null), sp);
                furniturePlaced.changeUsage((Integer)this.this$0.usageModification.getValue().get());
                furniturePlaced.updateTitle();
                SsomarDev.testMsg((String)"Activator 15", (boolean)true);
            }
        };
        SCore.schedulerHook.runLocationTaskAsap((Runnable)runnable, bLoc);
    }

    @KeepMethod
    public List<String> getMenuDescription() {
        return null;
    }

    @KeepMethod
    public SActivator getBuilderInstance(FeatureParentInterface featureParentInterface, String s) {
        return new ActivatorMFFeature(featureParentInterface, s);
    }

    @KeepMethod
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureAbstract> features = new ArrayList<FeatureAbstract>(Arrays.asList(this.displayName, this.optionFeature));
        features.addAll(Arrays.asList(this.usageModification, this.cancelEvent, this.silenceOutput, this.requiredGroup, this.displayConditions, this.displayCommands, this.worldConditions, this.placeholderConditions, this.variableUpdates));
        if (this.optionFeature.getValue().isLoopOption()) {
            features.add((FeatureAbstract)this.loopFeatures);
        }
        if (!Option.getOptionWithoutOwner().contains(this.optionFeature.getValue())) {
            features.add((FeatureAbstract)this.ownerCommands);
            features.add((FeatureAbstract)this.ownerConditions);
        }
        if (Option.getOptWithDamageCause().contains(this.optionFeature.getValue())) {
            features.add((FeatureAbstract)this.detailedDamageCauses);
        }
        if (Option.getOptWithCommand().contains(this.optionFeature.getValue())) {
            features.add((FeatureAbstract)this.detailedCommands);
        }
        if (Option.getOptWithPlayer().contains(this.optionFeature.getValue())) {
            features.add((FeatureAbstract)this.playerCommands);
            features.add((FeatureAbstract)this.playerConditions);
            features.add((FeatureAbstract)this.playerCooldown);
            features.add((FeatureAbstract)this.globalCooldown);
            features.add((FeatureAbstract)this.customConditions);
        }
        return features;
    }

    public ScheduleFeatures getScheduleFeatures() {
        return null;
    }

    public Runnable getRunnableForAll() {
        return null;
    }

    @KeepMethod
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @KeepMethod
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection parentSection = this.getParent().getConfigurationSection();
        if (parentSection.isConfigurationSection(this.getId())) {
            return parentSection.getConfigurationSection(this.getId());
        }
        return parentSection.createSection(this.getId());
    }

    @KeepMethod
    public File getFile() {
        return this.getParent().getFile();
    }

    @KeepMethod
    public void reload() {
        SsomarDev.testMsg((String)("Reloading activator " + this.getId()), (boolean)true);
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            ActivatorMFFeature a;
            if (!(feature instanceof ActivatorMFFeature) || !(a = (ActivatorMFFeature)feature).getId().equals(this.getId())) continue;
            a.setDisplayName(this.displayName);
            SsomarDev.testMsg((String)("Reloading activator " + this.getId() + " option: " + this.optionFeature.getValue().toString()), (boolean)true);
            a.setOptionFeature(this.optionFeature);
            a.setUsageModification(this.usageModification);
            a.setCancelEvent(this.cancelEvent);
            a.setSilenceOutput(this.silenceOutput);
            a.setRequiredGroup(this.requiredGroup);
            a.setLoopFeatures(this.loopFeatures);
            a.setDetailedDamageCauses(this.detailedDamageCauses);
            a.setDetailedCommands(this.detailedCommands);
            a.setDisplayCommands(this.displayCommands);
            a.setOwnerCommands(this.ownerCommands);
            a.setPlayerCommands(this.playerCommands);
            a.setPlayerConditions(this.playerConditions);
            a.setOwnerConditions(this.ownerConditions);
            a.setDisplayConditions(this.displayConditions);
            a.setWorldConditions(this.worldConditions);
            a.setPlaceholderConditions(this.placeholderConditions);
            a.setCustomConditions(this.customConditions);
            a.setPlayerCooldown(this.playerCooldown);
            a.setGlobalCooldown(this.globalCooldown);
            a.setVariableUpdates(this.variableUpdates);
            break;
        }
    }

    @KeepMethod
    public ActivatorMFFeature clone(FeatureParentInterface newParent) {
        ActivatorMFFeature clone = new ActivatorMFFeature(newParent, this.getId());
        clone.setDisplayName(this.displayName.clone((FeatureParentInterface)clone));
        clone.setOptionFeature(this.optionFeature.clone((FeatureParentInterface)clone));
        clone.setUsageModification(this.usageModification.clone((FeatureParentInterface)clone));
        clone.setCancelEvent(this.cancelEvent.clone((FeatureParentInterface)clone));
        clone.setSilenceOutput(this.silenceOutput.clone((FeatureParentInterface)clone));
        clone.setRequiredGroup(this.requiredGroup.clone((FeatureParentInterface)clone));
        clone.setLoopFeatures(this.loopFeatures.clone((FeatureParentInterface)clone));
        clone.setDetailedDamageCauses(this.detailedDamageCauses.clone((FeatureParentInterface)clone));
        clone.setDetailedCommands(this.detailedCommands.clone((FeatureParentInterface)clone));
        clone.setDisplayCommands(this.displayCommands.clone((FeatureParentInterface)clone));
        clone.setOwnerCommands(this.ownerCommands.clone((FeatureParentInterface)clone));
        clone.setPlayerCommands(this.playerCommands.clone((FeatureParentInterface)clone));
        clone.setOwnerConditions(this.ownerConditions.clone((FeatureParentInterface)clone));
        clone.setPlayerConditions(this.playerConditions.clone((FeatureParentInterface)clone));
        clone.setDisplayConditions(this.displayConditions.clone((FeatureParentInterface)clone));
        clone.setWorldConditions(this.worldConditions.clone((FeatureParentInterface)clone));
        clone.setPlaceholderConditions(this.placeholderConditions.clone((FeatureParentInterface)clone));
        clone.setCustomConditions(this.customConditions.clone((FeatureParentInterface)clone));
        clone.setPlayerCooldown(this.playerCooldown.clone((FeatureParentInterface)clone));
        clone.setGlobalCooldown(this.globalCooldown.clone((FeatureParentInterface)clone));
        clone.setVariableUpdates(this.variableUpdates.clone((FeatureParentInterface)clone));
        return clone;
    }

    @KeepMethod
    public void openEditor(@NotNull Player player) {
        ActivatorMFFeatureEditorManager.getInstance().startEditing(player, (FeatureParentInterface)this);
    }

    @KeepMethod
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @KeepMethod
    public List<String> load(SPlugin sPlugin, ConfigurationSection config, boolean b) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.getId())) {
            ConfigurationSection section = config.getConfigurationSection(this.getId());
            for (FeatureInterface f : this.getFeatures()) {
                errors.addAll(f.load(sPlugin, section, b));
            }
            if (this.optionFeature.getValue().isLoopOption()) {
                errors.addAll(this.loopFeatures.load(sPlugin, section, b));
            }
            if (!Option.getOptionWithoutOwner().contains(this.optionFeature.getValue())) {
                errors.addAll(this.ownerCommands.load(sPlugin, section, b));
                errors.addAll(this.ownerConditions.load(sPlugin, section, b));
            }
            if (Option.getOptWithDamageCause().contains(this.optionFeature.getValue())) {
                errors.addAll(this.detailedDamageCauses.load(sPlugin, section, b));
            }
            if (Option.getOptWithCommand().contains(this.optionFeature.getValue())) {
                errors.addAll(this.detailedCommands.load(sPlugin, section, b));
            }
            if (Option.getOptWithPlayer().contains(this.optionFeature.getValue())) {
                errors.addAll(this.playerCommands.load(sPlugin, section, b));
                errors.addAll(this.playerConditions.load(sPlugin, section, b));
                errors.addAll(this.playerCooldown.load(sPlugin, section, b));
                errors.addAll(this.globalCooldown.load(sPlugin, section, b));
                errors.addAll(this.customConditions.load(sPlugin, section, b));
            }
            if (Option.getOptWithTargetEntity().contains(this.optionFeature.getValue())) {
                errors.addAll(this.displayConditions.load(sPlugin, section, b));
                errors.addAll(this.globalCooldown.load(sPlugin, section, b));
            }
        }
        return errors;
    }

    @KeepMethod
    public void save(ConfigurationSection config) {
        ConfigurationSection attributeConfig = config.createSection(this.getId());
        if (this.optionFeature.getValue().isLoopOption()) {
            LoopManager.getInstance().addLoopActivator((SActivator)this);
        } else {
            LoopManager.getInstance().removeLoopActivator((SActivator)this);
        }
        OptimizedEventsHandler.getInstance().read(this.optionFeature.getValue());
        for (FeatureInterface feature : this.getFeatures()) {
            feature.save(attributeConfig);
        }
    }

    @KeepMethod
    public ActivatorMFFeature getValue() {
        return this;
    }

    @KeepMethod
    public ActivatorMFFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 3];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 3] = this.displayName.getValue().isPresent() ? "\u00a77Name: \u00a7e" + (String)this.displayName.getValue().get() : "\u00a77Name: \u00a7cNot set";
        finalDescription[finalDescription.length - 2] = "&7Option: &e" + this.optionFeature.getValue();
        finalDescription[finalDescription.length - 1] = GUI.CLICK_HERE_TO_CHANGE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName() + " - (" + this.getId() + ")", false, false, finalDescription);
        return this;
    }

    @KeepMethod
    public void updateItemParentEditor(GUI gui) {
    }

    @KeepMethod
    public boolean isTheFeatureClickedParentEditor(String featureClicked) {
        return featureClicked.contains(this.getEditorName()) && featureClicked.contains("(" + this.getId() + ")");
    }

    @KeepMethod
    public void reset() {
        this.displayName = new ColoredStringFeature((FeatureParentInterface)this, Optional.of("&eActivator"), (FeatureSettingsInterface)FeatureSettingsSCore.name);
        this.optionFeature = new SOptionFeature((SPlugin)MyFurniture.plugin, (SOption)Option.PLAYER_ALL_CLICK_ON, (FeatureParentInterface)this, (FeatureSettingsInterface)FeatureSettingsSCore.option);
        this.usageModification = MyFurniture.plugin.isLotOfWork() ? new IntegerFeature((FeatureParentInterface)this, Optional.of(-1), (FeatureSettingsInterface)FeatureSettingsSCore.usageModification) : new IntegerFeature((FeatureParentInterface)this, Optional.of(0), (FeatureSettingsInterface)FeatureSettingsSCore.usageModification);
        this.cancelEvent = new BooleanFeature((FeatureParentInterface)this, Boolean.valueOf(false), (FeatureSettingsInterface)FeatureSettingsSCore.cancelEvent);
        this.silenceOutput = new BooleanFeature((FeatureParentInterface)this, Boolean.valueOf(false), (FeatureSettingsInterface)FeatureSettingsSCore.silenceOutput);
        this.requiredGroup = new RequiredGroup((FeatureParentInterface)this);
        this.loopFeatures = new LoopFeatures((FeatureParentInterface)this);
        this.detailedDamageCauses = new ListDamageCauseFeature((FeatureParentInterface)this, new ArrayList(), (FeatureSettingsInterface)FeatureSettingsSCore.detailedDamageCauses);
        this.detailedCommands = new ListUncoloredStringFeature((FeatureParentInterface)this, new ArrayList(), (FeatureSettingsInterface)FeatureSettingsSCore.detailedCommands, Optional.empty());
        this.displayCommands = new DisplayCommandsFeature((FeatureParentInterface)this, (FeatureSettingsInterface)FeatureSettingsSCore.displayCommands);
        this.ownerCommands = new PlayerCommandsFeature((FeatureParentInterface)this, (FeatureSettingsInterface)FeatureSettingsSCore.ownerCommands);
        this.playerCommands = new PlayerCommandsFeature((FeatureParentInterface)this, (FeatureSettingsInterface)FeatureSettingsSCore.playerCommands);
        this.playerConditions = new PlayerConditionsFeature((FeatureParentInterface)this, (FeatureSettingsInterface)FeatureSettingsSCore.playerConditions);
        this.ownerConditions = new PlayerConditionsFeature((FeatureParentInterface)this, (FeatureSettingsInterface)FeatureSettingsSCore.ownerConditions);
        this.displayConditions = new EntityConditionsFeature((FeatureParentInterface)this, (FeatureSettingsInterface)FeatureSettingsSCore.displayConditions_conditions);
        this.worldConditions = new WorldConditionsFeature((FeatureParentInterface)this, (FeatureSettingsInterface)FeatureSettingsSCore.worldConditions);
        this.customConditions = new CustomConditionsFeature((FeatureParentInterface)this, (FeatureSettingsInterface)FeatureSettingsSCore.customConditions, (SPlugin)MyFurniture.plugin);
        this.placeholderConditions = new PlaceholderConditionGroupFeature((FeatureParentInterface)this);
        this.playerCooldown = new CooldownFeature((FeatureParentInterface)this, (FeatureSettingsInterface)FeatureSettingsSCore.playerCooldownFeatures, (SPlugin)MyFurniture.plugin, GeneralConfig.getInstance().getBooleanSetting(GeneralConfig.Setting.premiumEnableCooldownForOp.name()));
        this.globalCooldown = new CooldownFeature((FeatureParentInterface)this, (FeatureSettingsInterface)FeatureSettingsSCore.globalCooldownFeatures, (SPlugin)MyFurniture.plugin, GeneralConfig.getInstance().getBooleanSetting(GeneralConfig.Setting.premiumEnableCooldownForOp.name()), true);
        this.variableUpdates = new VariableUpdateGroupFeature((FeatureParentInterface)this);
    }

    static void cancelEvent(Event e, boolean condition) {
        if (e != null && condition && e instanceof Cancellable) {
            if (e instanceof ProjectileHitEntityEvent) {
                ((ProjectileHitEntityEvent)e).getEntity().remove();
            } else if (e instanceof ProjectileHitPlayerEvent) {
                ((ProjectileHitPlayerEvent)e).getEntity().remove();
            }
            ((Cancellable)e).setCancelled(true);
        }
    }

    @KeepMethod
    public void activateOptionGlobal(EventInfo eventInfo) {
        ArrayList<ActivatorMFFeature> activators = new ArrayList<ActivatorMFFeature>();
        for (SActivator activator : eventInfo.getWhitelistActivators()) {
            if (!(activator instanceof ActivatorMFFeature)) continue;
            activators.add((ActivatorMFFeature)activator);
        }
        EventsManager.getInstance().activeOptionAllFP(eventInfo);
    }

    @KeepMethod
    public List<ActivatorMFFeature> extractActivatorsSameClass(List<SActivator> list) {
        ArrayList<ActivatorMFFeature> activators = new ArrayList<ActivatorMFFeature>();
        for (SActivator activator : list) {
            if (!(activator instanceof ActivatorMFFeature)) continue;
            activators.add((ActivatorMFFeature)activator);
        }
        list.removeAll(activators);
        return activators;
    }

    public ColoredStringFeature getDisplayName() {
        return this.displayName;
    }

    public SOptionFeature getOptionFeature() {
        return this.optionFeature;
    }

    public RequiredGroup getRequiredGroup() {
        return this.requiredGroup;
    }

    public IntegerFeature getUsageModification() {
        return this.usageModification;
    }

    public DisplayCommandsFeature getDisplayCommands() {
        return this.displayCommands;
    }

    public PlayerCommandsFeature getOwnerCommands() {
        return this.ownerCommands;
    }

    public PlayerCommandsFeature getPlayerCommands() {
        return this.playerCommands;
    }

    public BooleanFeature getSilenceOutput() {
        return this.silenceOutput;
    }

    public BooleanFeature getCancelEvent() {
        return this.cancelEvent;
    }

    public ListDamageCauseFeature getDetailedDamageCauses() {
        return this.detailedDamageCauses;
    }

    public ListUncoloredStringFeature getDetailedCommands() {
        return this.detailedCommands;
    }

    public PlayerConditionsFeature getPlayerConditions() {
        return this.playerConditions;
    }

    public PlayerConditionsFeature getOwnerConditions() {
        return this.ownerConditions;
    }

    public EntityConditionsFeature getDisplayConditions() {
        return this.displayConditions;
    }

    public WorldConditionsFeature getWorldConditions() {
        return this.worldConditions;
    }

    public PlaceholderConditionGroupFeature getPlaceholderConditions() {
        return this.placeholderConditions;
    }

    public CustomConditionsFeature getCustomConditions() {
        return this.customConditions;
    }

    public CooldownFeature getPlayerCooldown() {
        return this.playerCooldown;
    }

    public CooldownFeature getGlobalCooldown() {
        return this.globalCooldown;
    }

    public LoopFeatures getLoopFeatures() {
        return this.loopFeatures;
    }

    public VariableUpdateGroupFeature getVariableUpdates() {
        return this.variableUpdates;
    }

    public void setDisplayName(ColoredStringFeature displayName) {
        this.displayName = displayName;
    }

    public void setOptionFeature(SOptionFeature optionFeature) {
        this.optionFeature = optionFeature;
    }

    public void setRequiredGroup(RequiredGroup requiredGroup) {
        this.requiredGroup = requiredGroup;
    }

    public void setUsageModification(IntegerFeature usageModification) {
        this.usageModification = usageModification;
    }

    public void setDisplayCommands(DisplayCommandsFeature displayCommands) {
        this.displayCommands = displayCommands;
    }

    public void setOwnerCommands(PlayerCommandsFeature ownerCommands) {
        this.ownerCommands = ownerCommands;
    }

    public void setPlayerCommands(PlayerCommandsFeature playerCommands) {
        this.playerCommands = playerCommands;
    }

    public void setSilenceOutput(BooleanFeature silenceOutput) {
        this.silenceOutput = silenceOutput;
    }

    public void setCancelEvent(BooleanFeature cancelEvent) {
        this.cancelEvent = cancelEvent;
    }

    public void setDetailedDamageCauses(ListDamageCauseFeature detailedDamageCauses) {
        this.detailedDamageCauses = detailedDamageCauses;
    }

    public void setDetailedCommands(ListUncoloredStringFeature detailedCommands) {
        this.detailedCommands = detailedCommands;
    }

    public void setPlayerConditions(PlayerConditionsFeature playerConditions) {
        this.playerConditions = playerConditions;
    }

    public void setOwnerConditions(PlayerConditionsFeature ownerConditions) {
        this.ownerConditions = ownerConditions;
    }

    public void setDisplayConditions(EntityConditionsFeature displayConditions) {
        this.displayConditions = displayConditions;
    }

    public void setWorldConditions(WorldConditionsFeature worldConditions) {
        this.worldConditions = worldConditions;
    }

    public void setPlaceholderConditions(PlaceholderConditionGroupFeature placeholderConditions) {
        this.placeholderConditions = placeholderConditions;
    }

    public void setCustomConditions(CustomConditionsFeature customConditions) {
        this.customConditions = customConditions;
    }

    public void setPlayerCooldown(CooldownFeature playerCooldown) {
        this.playerCooldown = playerCooldown;
    }

    public void setGlobalCooldown(CooldownFeature globalCooldown) {
        this.globalCooldown = globalCooldown;
    }

    public void setLoopFeatures(LoopFeatures loopFeatures) {
        this.loopFeatures = loopFeatures;
    }

    public void setVariableUpdates(VariableUpdateGroupFeature variableUpdates) {
        this.variableUpdates = variableUpdates;
    }
}

