/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.features.display;

import com.ssomar.myfurniture.features.display.DisplayFeaturesEditor;
import com.ssomar.myfurniture.features.display.DisplayFeaturesEditorManager;
import com.ssomar.myfurniture.features.display.boundingboxzones.group.BoundingBoxZoneGroupFeature;
import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.ColorIntegerFeature;
import com.ssomar.score.features.types.DoubleFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.features.types.MaterialFeature;
import com.ssomar.score.features.types.UncoloredStringFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.obfuscation.KeepMethod;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class DisplayFeatures
extends FeatureWithHisOwnEditor<DisplayFeatures, DisplayFeatures, DisplayFeaturesEditor, DisplayFeaturesEditorManager> {
    private UncoloredStringFeature itemModel;
    private IntegerFeature customModelData;
    private MaterialFeature material;
    private DoubleFeature scale;
    private BooleanFeature aligned;
    private IntegerFeature customPitch;
    private DoubleFeature customY;
    private BooleanFeature glow;
    private IntegerFeature clickToBreak;
    private IntegerFeature blockLight;
    private IntegerFeature skyLight;
    private ColorIntegerFeature glowColor;
    private DoubleFeature viewRange;
    private BoundingBoxZoneGroupFeature boundingBoxZoneGroupFeature;

    public DisplayFeatures(FeatureParentInterface parent) {
        super(parent, (FeatureSettingsInterface)FeatureSettingsSCore.displayFeatures);
        this.reset();
    }

    @KeepMethod
    public void reset() {
        this.itemModel = new UncoloredStringFeature((FeatureParentInterface)this, Optional.empty(), (FeatureSettingsInterface)FeatureSettingsSCore.itemModel, false);
        this.customModelData = new IntegerFeature((FeatureParentInterface)this, Optional.empty(), (FeatureSettingsInterface)FeatureSettingsSCore.customModelData);
        this.material = new MaterialFeature((FeatureParentInterface)this, Optional.empty(), (FeatureSettingsInterface)FeatureSettingsSCore.material);
        this.scale = new DoubleFeature((FeatureParentInterface)this, Optional.of(1.0), (FeatureSettingsInterface)FeatureSettingsSCore.scale);
        this.aligned = new BooleanFeature((FeatureParentInterface)this, Boolean.valueOf(false), (FeatureSettingsInterface)FeatureSettingsSCore.aligned);
        this.customPitch = new IntegerFeature((FeatureParentInterface)this, Optional.of(90), (FeatureSettingsInterface)FeatureSettingsSCore.customPitch);
        this.customY = new DoubleFeature((FeatureParentInterface)this, Optional.empty(), (FeatureSettingsInterface)FeatureSettingsSCore.customY);
        this.glow = new BooleanFeature((FeatureParentInterface)this, Boolean.valueOf(false), (FeatureSettingsInterface)FeatureSettingsSCore.glow);
        this.clickToBreak = new IntegerFeature((FeatureParentInterface)this, Optional.of(1), (FeatureSettingsInterface)FeatureSettingsSCore.clickToBreak);
        this.boundingBoxZoneGroupFeature = new BoundingBoxZoneGroupFeature((FeatureParentInterface)this, true);
        this.blockLight = new IntegerFeature((FeatureParentInterface)this, Optional.empty(), (FeatureSettingsInterface)FeatureSettingsSCore.blockLight);
        this.skyLight = new IntegerFeature((FeatureParentInterface)this, Optional.empty(), (FeatureSettingsInterface)FeatureSettingsSCore.skyLight);
        this.glowColor = new ColorIntegerFeature((FeatureParentInterface)this, Optional.empty(), (FeatureSettingsInterface)FeatureSettingsSCore.glowColor);
        this.viewRange = new DoubleFeature((FeatureParentInterface)this, Optional.of(20.0), (FeatureSettingsInterface)FeatureSettingsSCore.viewRange);
    }

    @KeepMethod
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection containerFeaturesSection = config.getConfigurationSection(this.getName());
            error.addAll(this.itemModel.load(plugin, containerFeaturesSection, isPremiumLoading));
            error.addAll(this.customModelData.load(plugin, containerFeaturesSection, isPremiumLoading));
            error.addAll(this.material.load(plugin, containerFeaturesSection, isPremiumLoading));
            error.addAll(this.scale.load(plugin, containerFeaturesSection, isPremiumLoading));
            error.addAll(this.aligned.load(plugin, containerFeaturesSection, isPremiumLoading));
            error.addAll(this.customPitch.load(plugin, containerFeaturesSection, isPremiumLoading));
            error.addAll(this.customY.load(plugin, containerFeaturesSection, isPremiumLoading));
            error.addAll(this.glow.load(plugin, containerFeaturesSection, isPremiumLoading));
            error.addAll(this.clickToBreak.load(plugin, containerFeaturesSection, isPremiumLoading));
            error.addAll(this.boundingBoxZoneGroupFeature.load(plugin, containerFeaturesSection, isPremiumLoading));
            error.addAll(this.blockLight.load(plugin, containerFeaturesSection, isPremiumLoading));
            error.addAll(this.skyLight.load(plugin, containerFeaturesSection, isPremiumLoading));
            error.addAll(this.glowColor.load(plugin, containerFeaturesSection, isPremiumLoading));
            error.addAll(this.viewRange.load(plugin, containerFeaturesSection, isPremiumLoading));
        }
        return error;
    }

    @KeepMethod
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection containerFeaturesSection = config.createSection(this.getName());
        if (SCore.is1v21v4Plus()) {
            this.itemModel.save(containerFeaturesSection);
        } else {
            this.customModelData.save(containerFeaturesSection);
            this.material.save(containerFeaturesSection);
        }
        this.scale.save(containerFeaturesSection);
        this.aligned.save(containerFeaturesSection);
        this.customPitch.save(containerFeaturesSection);
        this.customY.save(containerFeaturesSection);
        this.glow.save(containerFeaturesSection);
        this.clickToBreak.save(containerFeaturesSection);
        this.boundingBoxZoneGroupFeature.save(containerFeaturesSection);
        this.blockLight.save(containerFeaturesSection);
        this.skyLight.save(containerFeaturesSection);
        this.glowColor.save(containerFeaturesSection);
        this.viewRange.save(containerFeaturesSection);
    }

    @KeepMethod
    public DisplayFeatures getValue() {
        return this;
    }

    @KeepMethod
    public DisplayFeatures initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 8];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 8] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 7] = "&7Item Model: &e" + this.itemModel.getValue().orElse("None");
        finalDescription[finalDescription.length - 6] = "&7Scale: &e" + this.scale.getValue().orElse(1.0);
        finalDescription[finalDescription.length - 5] = "&7Aligned: &e" + this.aligned.getValue();
        finalDescription[finalDescription.length - 4] = "&7Custom Pitch: &e" + this.customPitch.getValue().orElse(0);
        finalDescription[finalDescription.length - 3] = "&7Custom Y: &e" + this.customY.getValue().orElse(0.0);
        finalDescription[finalDescription.length - 2] = "&7Glow: &e" + this.glow.getValue();
        finalDescription[finalDescription.length - 1] = "&7View Range: &e" + this.viewRange.getValue().orElse(20.0);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @KeepMethod
    public void updateItemParentEditor(GUI gui) {
    }

    @KeepMethod
    public DisplayFeatures clone(FeatureParentInterface newParent) {
        DisplayFeatures eF = new DisplayFeatures(newParent);
        eF.itemModel = this.itemModel.clone((FeatureParentInterface)eF);
        eF.customModelData = this.customModelData.clone((FeatureParentInterface)eF);
        eF.material = this.material.clone((FeatureParentInterface)eF);
        eF.scale = this.scale.clone((FeatureParentInterface)eF);
        eF.aligned = this.aligned.clone((FeatureParentInterface)eF);
        eF.customPitch = this.customPitch.clone((FeatureParentInterface)eF);
        eF.customY = this.customY.clone((FeatureParentInterface)eF);
        eF.glow = this.glow.clone((FeatureParentInterface)eF);
        eF.clickToBreak = this.clickToBreak.clone((FeatureParentInterface)eF);
        eF.boundingBoxZoneGroupFeature = this.boundingBoxZoneGroupFeature.clone((FeatureParentInterface)eF);
        eF.blockLight = this.blockLight.clone((FeatureParentInterface)eF);
        eF.skyLight = this.skyLight.clone((FeatureParentInterface)eF);
        eF.glowColor = this.glowColor.clone((FeatureParentInterface)eF);
        eF.viewRange = this.viewRange.clone((FeatureParentInterface)eF);
        return eF;
    }

    @KeepMethod
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        if (SCore.is1v21v4Plus()) {
            features.add((FeatureInterface)this.itemModel);
        } else {
            features.add((FeatureInterface)this.customModelData);
            features.add((FeatureInterface)this.material);
        }
        features.add((FeatureInterface)this.scale);
        features.add((FeatureInterface)this.aligned);
        features.add((FeatureInterface)this.customPitch);
        features.add((FeatureInterface)this.customY);
        features.add((FeatureInterface)this.glow);
        features.add((FeatureInterface)this.clickToBreak);
        features.add((FeatureInterface)this.boundingBoxZoneGroupFeature);
        features.add((FeatureInterface)this.blockLight);
        features.add((FeatureInterface)this.skyLight);
        features.add((FeatureInterface)this.glowColor);
        features.add((FeatureInterface)this.viewRange);
        return features;
    }

    @KeepMethod
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @KeepMethod
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @KeepMethod
    public File getFile() {
        return this.getParent().getFile();
    }

    @KeepMethod
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof DisplayFeatures)) continue;
            DisplayFeatures eF = (DisplayFeatures)feature;
            eF.setItemModel(this.itemModel);
            eF.setCustomModelData(this.customModelData);
            eF.setMaterial(this.material);
            eF.setScale(this.scale);
            eF.setAligned(this.aligned);
            eF.setCustomPitch(this.customPitch);
            eF.setCustomY(this.customY);
            eF.setGlow(this.glow);
            eF.setClickToBreak(this.clickToBreak);
            eF.setBoundingBoxZoneGroupFeature(this.boundingBoxZoneGroupFeature);
            eF.setBlockLight(this.blockLight);
            eF.setSkyLight(this.skyLight);
            eF.setGlowColor(this.glowColor);
            eF.setViewRange(this.viewRange);
            break;
        }
    }

    @KeepMethod
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @KeepMethod
    public void openEditor(@NotNull Player player) {
        DisplayFeaturesEditorManager.getInstance().startEditing(player, (FeatureParentInterface)this);
    }

    public UncoloredStringFeature getItemModel() {
        return this.itemModel;
    }

    public IntegerFeature getCustomModelData() {
        return this.customModelData;
    }

    public MaterialFeature getMaterial() {
        return this.material;
    }

    public DoubleFeature getScale() {
        return this.scale;
    }

    public BooleanFeature getAligned() {
        return this.aligned;
    }

    public IntegerFeature getCustomPitch() {
        return this.customPitch;
    }

    public DoubleFeature getCustomY() {
        return this.customY;
    }

    public BooleanFeature getGlow() {
        return this.glow;
    }

    public IntegerFeature getClickToBreak() {
        return this.clickToBreak;
    }

    public IntegerFeature getBlockLight() {
        return this.blockLight;
    }

    public IntegerFeature getSkyLight() {
        return this.skyLight;
    }

    public ColorIntegerFeature getGlowColor() {
        return this.glowColor;
    }

    public DoubleFeature getViewRange() {
        return this.viewRange;
    }

    public BoundingBoxZoneGroupFeature getBoundingBoxZoneGroupFeature() {
        return this.boundingBoxZoneGroupFeature;
    }

    public void setItemModel(UncoloredStringFeature itemModel) {
        this.itemModel = itemModel;
    }

    public void setCustomModelData(IntegerFeature customModelData) {
        this.customModelData = customModelData;
    }

    public void setMaterial(MaterialFeature material) {
        this.material = material;
    }

    public void setScale(DoubleFeature scale) {
        this.scale = scale;
    }

    public void setAligned(BooleanFeature aligned) {
        this.aligned = aligned;
    }

    public void setCustomPitch(IntegerFeature customPitch) {
        this.customPitch = customPitch;
    }

    public void setCustomY(DoubleFeature customY) {
        this.customY = customY;
    }

    public void setGlow(BooleanFeature glow) {
        this.glow = glow;
    }

    public void setClickToBreak(IntegerFeature clickToBreak) {
        this.clickToBreak = clickToBreak;
    }

    public void setBlockLight(IntegerFeature blockLight) {
        this.blockLight = blockLight;
    }

    public void setSkyLight(IntegerFeature skyLight) {
        this.skyLight = skyLight;
    }

    public void setGlowColor(ColorIntegerFeature glowColor) {
        this.glowColor = glowColor;
    }

    public void setViewRange(DoubleFeature viewRange) {
        this.viewRange = viewRange;
    }

    public void setBoundingBoxZoneGroupFeature(BoundingBoxZoneGroupFeature boundingBoxZoneGroupFeature) {
        this.boundingBoxZoneGroupFeature = boundingBoxZoneGroupFeature;
    }
}

