/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.furniture.placedfurniture;

import com.ssomar.myfurniture.MyFurniture;
import com.ssomar.myfurniture.api.events.FurnitureBreakEvent;
import com.ssomar.myfurniture.editor.FurnituresPlacedEditor;
import com.ssomar.myfurniture.features.display.DisplayFeatures;
import com.ssomar.myfurniture.furniture.Furniture;
import com.ssomar.myfurniture.furniture.FurnitureManager;
import com.ssomar.myfurniture.furniture.FurnitureObject;
import com.ssomar.myfurniture.furniture.creations.CreationAbstract;
import com.ssomar.myfurniture.furniture.creations.Creations;
import com.ssomar.myfurniture.furniture.creations.Display;
import com.ssomar.myfurniture.furniture.placedfurniture.FurniturePlacedManager;
import com.ssomar.myfurniture.furniture.placedfurniture.editor.FurniturePlacedEditorManager;
import com.ssomar.myfurniture.playersettings.PlayerSettings;
import com.ssomar.myfurniture.playersettings.PlayerSettingsManager;
import com.ssomar.myfurniture.utils.ShulkerPacketUtilPacketEvent;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.activators.activator.SActivator;
import com.ssomar.score.features.custom.variables.real.VariableReal;
import com.ssomar.score.features.custom.variables.update.group.VariableUpdateGroupFeature;
import com.ssomar.score.features.custom.variables.update.variable.VariableUpdateFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.sobject.InternalData;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.sobject.SObjectEditable;
import com.ssomar.score.sobject.SObjectWithVariables;
import com.ssomar.score.sobject.menu.NewSObjectsManagerEditor;
import com.ssomar.score.sobject.menu.SObjectsEditorAbstract;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.DropType;
import com.ssomar.score.utils.emums.VariableUpdateType;
import com.ssomar.score.utils.numbers.NTools;
import com.ssomar.score.utils.obfuscation.KeepMethod;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.writer.NameSpaceKeyWriterReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FurniturePlaced
extends SObject<FurniturePlaced, GUI, NewGUIManager<GUI>>
implements SObjectEditable {
    private static final Boolean DEBUG = true;
    private Entity mainEntity;
    private Location location;
    private Location holoLocation;
    private CreationAbstract creation;
    private String MF_ID;
    private InternalData internalData;
    private boolean isRemoved;
    private boolean isMyFurniture;
    private FileConfiguration fileConfiguration;
    private Map<Player, List<Integer>> packetsEntities;
    private boolean saveLaunched;

    public FurniturePlaced(@NotNull Entity mainEntity, @NotNull Location location, @NotNull CreationAbstract creation, @NotNull String MF_ID, @NotNull InternalData internalData) {
        super((SPlugin)MyFurniture.plugin, UUID.randomUUID().toString(), (FeatureSettingsInterface)FeatureSettingsSCore.FURNITUREPLACED);
        this.mainEntity = mainEntity;
        this.isRemoved = false;
        this.isMyFurniture = false;
        this.location = location;
        this.MF_ID = MF_ID;
        this.creation = creation;
        this.internalData = internalData;
        this.packetsEntities = new HashMap<Player, List<Integer>>();
    }

    public FurniturePlaced(@NotNull Entity entity) {
        super((SPlugin)MyFurniture.plugin, UUID.randomUUID().toString(), (FeatureSettingsInterface)FeatureSettingsSCore.FURNITUREPLACED);
        this.mainEntity = entity;
        this.isRemoved = false;
        this.isMyFurniture = false;
        this.packetsEntities = new HashMap<Player, List<Integer>>();
        this.location = entity.getLocation();
        PersistentDataContainer persistentDataContainer = this.mainEntity.getPersistentDataContainer();
        Optional MFIDOpt = NameSpaceKeyWriterReader.readString((Plugin)SCore.plugin, (PersistentDataContainer)persistentDataContainer, (String)"MF-ID");
        if (!MFIDOpt.isPresent()) {
            return;
        }
        this.MF_ID = (String)MFIDOpt.get();
        Optional furnitureOptional = FurnitureManager.getInstance().getLoadedObjectWithID(this.MF_ID);
        if (furnitureOptional.isPresent()) {
            this.isMyFurniture = true;
            Furniture furniture = (Furniture)((Object)furnitureOptional.get());
            this.creation = Creations.getCreation(furniture);
            this.creation.load(entity);
            this.internalData = new InternalData();
            this.internalData.loadFromEntity(entity, (SObjectWithVariables)furniture);
        }
    }

    public void changeUsage(int usageModification) {
        SsomarDev.testMsg((String)("MF changeUsage: " + usageModification), (boolean)true);
        if (this.internalData.getUsage() == -1) {
            return;
        }
        if (this.internalData.getUsage() + usageModification <= 0 && usageModification != 0) {
            this.breakFurniture(null, false, null, BreakMethod.CUSTOM);
        } else if (usageModification != 0) {
            this.internalData.setUsage(this.internalData.getUsage() + usageModification);
            this.setUsage(this.internalData.getUsage());
        }
    }

    public void setUsage(int usage) {
        SsomarDev.testMsg((String)("MF setUsage: " + usage), (boolean)true);
        this.internalData.setUsage(usage);
        this.internalData.saveInEntity(this.getMainEntity());
    }

    public void updateUsage(int i) {
        this.setUsage(i);
    }

    public StringPlaceholder getPlaceholders() {
        StringPlaceholder placeholder = new StringPlaceholder();
        placeholder.setOwnerPlcHldr(this.internalData.getOwnerUUID());
        placeholder.setUsage(this.internalData.getUsage() + "");
        placeholder.setVariables((List)this.internalData.getVariableRealsList());
        return placeholder;
    }

    public String getFurnitureID() {
        return this.MF_ID;
    }

    public Location getTitleLocation() {
        return this.holoLocation;
    }

    @KeepMethod
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>();
    }

    @KeepMethod
    public String getParentInfo() {
        return null;
    }

    public ConfigurationSection getConfigurationSection() {
        return null;
    }

    public File getFile() {
        return null;
    }

    @KeepMethod
    public void reload() {
    }

    @KeepMethod
    public void openEditor(@NotNull Player player) {
        FurniturePlacedEditorManager.getInstance().startEditing(player, (FeatureParentInterface)this);
    }

    @KeepMethod
    public void openBackEditor(@NotNull Player player) {
        NewSObjectsManagerEditor.getInstance().startEditing(player, (SObjectsEditorAbstract)new FurnituresPlacedEditor());
    }

    @KeepMethod
    public List<String> load(SPlugin sPlugin, ConfigurationSection configurationSection, boolean b) {
        return null;
    }

    @KeepMethod
    public void save(ConfigurationSection configurationSection) {
    }

    @KeepMethod
    public FurniturePlaced getValue() {
        return null;
    }

    @KeepMethod
    public FurniturePlaced initItemParentEditor(GUI gui, int i) {
        return null;
    }

    @KeepMethod
    public void updateItemParentEditor(GUI gui) {
    }

    @KeepMethod
    public void reset() {
    }

    @KeepMethod
    public FurniturePlaced clone(FeatureParentInterface featureParentInterface) {
        FurniturePlaced executableBlockPlaced = new FurniturePlaced(this.mainEntity, this.location, this.creation, this.MF_ID, this.internalData);
        return executableBlockPlaced;
    }

    public boolean delete() {
        return false;
    }

    public void update(Player player, double distance, @Nullable PlayerSettings playerSettings) {
        if (playerSettings == null) {
            playerSettings = PlayerSettingsManager.getInstance().getLoadedObjectWithID(player.getUniqueId().toString()).get();
        }
        if (distance < (Double)playerSettings.getViewDistanceFurniture().getValue().get()) {
            if (!player.canSee(this.getMainEntity())) {
                this.showFurniture(player);
            }
        } else if (player.canSee(this.getMainEntity())) {
            this.hideFurniture(player);
        }
        if (distance < (Double)playerSettings.getMaxDistanceBoundingBoxCalculation().getValue().get()) {
            if (!this.packetsEntities.containsKey(player)) {
                this.addBoundingBoxes(player);
            }
        } else if (this.packetsEntities.containsKey(player)) {
            this.removeBoundingBoxes(player);
        }
    }

    public void addBoundingBoxes(Player player) {
        if (this.isRemoved) {
            return;
        }
        if (!this.packetsEntities.containsKey(player)) {
            Display display = (Display)this.creation;
            this.packetsEntities.put(player, display.spawnBoundingBoxFor(player));
        }
    }

    public void removeBoundingBoxesForEveryone() {
        for (Player player : this.packetsEntities.keySet()) {
            if (!player.isOnline()) continue;
            List<Integer> packets = this.packetsEntities.get(player);
            int[] packetsArray = new int[packets.size()];
            for (int i = 0; i < packets.size(); ++i) {
                packetsArray[i] = packets.get(i);
            }
            new ShulkerPacketUtilPacketEvent().removeClientEntity(player, packetsArray);
        }
        this.packetsEntities.clear();
    }

    public void removeBoundingBoxes(Player player) {
        if (this.packetsEntities.containsKey(player)) {
            if (player.isOnline()) {
                List<Integer> packets = this.packetsEntities.get(player);
                int[] packetsArray = new int[packets.size()];
                for (int i = 0; i < packets.size(); ++i) {
                    packetsArray[i] = packets.get(i);
                }
                new ShulkerPacketUtilPacketEvent().removeClientEntity(player, packetsArray);
            }
            this.packetsEntities.remove(player);
        }
    }

    public void hideFurniture(final @NotNull Player player) {
        if (player.canSee(this.getMainEntity())) {
            BukkitRunnable runnable = new BukkitRunnable(){

                public void run() {
                    player.hideEntity((Plugin)MyFurniture.plugin, FurniturePlaced.this.getMainEntity());
                    SsomarDev.testMsg((String)("FurniturePlaced hideFurniture >> " + FurniturePlaced.this.getFurnitureID()), (boolean)false);
                }
            };
            SCore.schedulerHook.runEntityTaskAsap((Runnable)runnable, null, (Entity)player);
        }
    }

    public void showFurniture(final @NotNull Player player) {
        if (this.isRemoved) {
            return;
        }
        if (!player.canSee(this.getMainEntity())) {
            BukkitRunnable runnable = new BukkitRunnable(){

                public void run() {
                    player.showEntity((Plugin)MyFurniture.plugin, FurniturePlaced.this.getMainEntity());
                    SsomarDev.testMsg((String)("FurniturePlaced showFurniture >> " + FurniturePlaced.this.getFurnitureID()), (boolean)false);
                }
            };
            SCore.schedulerHook.runEntityTaskAsap((Runnable)runnable, null, (Entity)player);
        }
    }

    public void breakFurniture(@Nullable Player player, boolean drop, @Nullable Event sourceEvent, BreakMethod breakMethod) {
        if (this.getFurniture() == null) {
            this.remove();
            return;
        }
        if (player != null && !this.getFurniture().checkIfPlayerCanBreakAt(player, this.location, true)) {
            return;
        }
        FurnitureBreakEvent event = new FurnitureBreakEvent(player, this, sourceEvent, breakMethod);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.dropBlock(player, drop);
        this.remove();
    }

    public void dropBlock(@Nullable Player player, boolean drop) {
        SsomarDev.testMsg((String)("drop: passe 0 >> " + drop), (boolean)true);
        if (this.getFurniture().getResetInternalDatasWhenBroken().getValue().booleanValue()) {
            // empty if block
        }
        if (drop && this.getFurniture().getDropBlockIfItIsBroken().getValue().booleanValue()) {
            SsomarDev.testMsg((String)("drop: passe 2 >> " + this.getFurniture().getDropType().getValue().get()), (boolean)true);
            if (((DropType)this.getFurniture().getDropType().getValue().get()).equals((Object)DropType.ON_THE_GROUND) || player == null || player != null && !player.getInventory().addItem(new ItemStack[]{this.toObject(player.getUniqueId()).getItem()}).isEmpty()) {
                this.dropAtLocation(this.location);
            }
        }
    }

    public void dropAtLocation(Location location) {
        ItemStack is = this.toObject(this.internalData.getOwnerUUID()).getItem();
        location.getWorld().dropItem(location, is);
    }

    public FurnitureObject toObject(@Nullable UUID creator) {
        int amount = 1;
        if (creator != null) {
            this.internalData.setOwnerUUID(creator);
        }
        ItemStack is = this.getFurniture().buildItem(amount, this.internalData);
        return new FurnitureObject(is);
    }

    public FurnitureObject toObject() {
        return this.toObject(null);
    }

    public void moveFurniture(Location location) {
        this.getMainEntity().teleport(location);
    }

    public void remove() {
        this.isRemoved = true;
        this.removeBoundingBoxesForEveryone();
        this.creation.remove(this.location);
        if (this.holoLocation != null) {
            this.getFurniture().getTitle().remove(this.holoLocation);
        }
        AtomicReference<StorageMinecart> chestBoat = new AtomicReference<StorageMinecart>();
        Collection entities = this.getMainEntity().getLocation().getWorld().getNearbyEntities(this.getMainEntity().getLocation(), 0.05, 0.05, 0.05);
        for (Entity entity : entities) {
            Optional mainId;
            if (!(entity instanceof StorageMinecart) || !(mainId = NameSpaceKeyWriterReader.readString((Plugin)SCore.plugin, (PersistentDataContainer)entity.getPersistentDataContainer(), (String)"MF-CHEST")).isPresent() || !((String)mainId.get()).equals(this.getMainEntity().getUniqueId().toString())) continue;
            chestBoat.set((StorageMinecart)entity);
            break;
        }
        if (chestBoat.get() != null) {
            ((StorageMinecart)chestBoat.get()).remove();
        }
        FurniturePlacedManager.getInstance().removeFurniturePlaced(this);
    }

    public int getUsage() {
        return this.internalData.getUsage();
    }

    @Nullable
    public Furniture getFurniture() {
        Optional oOpt = FurnitureManager.getInstance().getLoadedObjectWithID(this.MF_ID);
        if (oOpt.isPresent()) {
            return (Furniture)((Object)oOpt.get());
        }
        return null;
    }

    public boolean hasLoop() {
        Furniture eB = this.getFurniture();
        if (eB == null) {
            return false;
        }
        for (SActivator act : eB.getActivators().getActivators().values()) {
            if (!act.getOption().isLoopOption()) continue;
            return true;
        }
        return false;
    }

    public String updateVariable(String variableName, String value, VariableUpdateType type) {
        variableName = variableName.toUpperCase();
        Map variables = this.internalData.getVariables();
        if (type.equals((Object)VariableUpdateType.MODIFICATION)) {
            if (NTools.isNumber((String)value) && variables.containsKey(variableName) && NTools.isNumber((String)((String)variables.get(variableName)))) {
                double newValue = Double.parseDouble(value);
                double oldValue = Double.parseDouble((String)variables.get(variableName));
                double addition = newValue + oldValue;
                variables.put(variableName, addition + "");
            } else {
                variables.put(variableName, (String)variables.get(variableName) + "" + value);
            }
        } else {
            variables.put(variableName, value);
        }
        FileConfiguration config = this.getFileConfiguration();
        if (!config.isConfigurationSection("variables")) {
            config.createSection("variables");
        }
        this.internalData.getVariableRealsList().buildWithCustomValues(variables, config.getConfigurationSection("variables"), this.internalData.getOwnerUUID());
        return (String)variables.get(variableName);
    }

    public void updateVariables(VariableUpdateGroupFeature updates, @Nullable Player p, @Nullable StringPlaceholder sp) {
        SsomarDev.testMsg((String)"updateVariables 1", (boolean)DEBUG);
        for (VariableUpdateFeature update : updates.getVariablesUpdates().values()) {
            SsomarDev.testMsg((String)("updateVariables 1 launch " + update.getId()), (boolean)DEBUG);
            this.updateVariable(update, p, sp);
        }
        this.internalData.saveInEntity(this.getMainEntity());
    }

    public void updateVariable(VariableUpdateFeature update, @Nullable Player p, @Nullable StringPlaceholder sp) {
        for (VariableReal var : this.internalData.getVariableRealsList()) {
            SsomarDev.testMsg((String)("VariableReal found " + (String)var.getConfig().getVariableName().getValue().get() + " and we search for " + (String)update.getVariableName().getValue().get()), (boolean)DEBUG);
            if (!((String)var.getConfig().getVariableName().getValue().get()).equals(update.getVariableName().getValue().get())) continue;
            SsomarDev.testMsg((String)("VariableReal OKAY " + (String)var.getConfig().getVariableName().getValue().get()), (boolean)DEBUG);
            var.modifVariable(this.getMainEntity().getPersistentDataContainer(), update, p, sp);
        }
    }

    public void updateTitle() {
        Location holoLoc;
        if (!this.isRemoved() && (holoLoc = this.getFurniture().getTitle().update(this.getHoloLocation(), this.getLocation(), this.getPlaceholders())) != null) {
            this.setHoloLocation(holoLoc);
        }
    }

    @KeepMethod
    public ItemStack getIconItem() {
        return this.getFurniture().getIconItem();
    }

    @KeepMethod
    public List<String> getDescription() {
        ArrayList<String> description = new ArrayList<String>();
        description.add("\u00a77ID: \u00a7f" + this.getMF_ID());
        description.add("\u00a77Location: \u00a7f" + this.getLocation().getWorld().getName() + " " + this.getLocation().getBlockX() + " " + this.getLocation().getBlockY() + " " + this.getLocation().getBlockZ());
        if (this.internalData.getOwnerOptional().isPresent()) {
            description.add("\u00a77Owner: \u00a7f" + ((Player)this.internalData.getOwnerOptional().get()).getName());
        } else {
            description.add("\u00a77Owner: \u00a7cNo Owner");
        }
        description.add("\u00a77Usage: \u00a7f" + this.getUsage());
        description.add("\u00a77Variables: \u00a7f" + this.internalData.getVariables());
        return description;
    }

    public void replaceFurnitureConfig(@NotNull Furniture furniture) {
        CreationAbstract creation = this.getCreation();
        if (creation instanceof Display) {
            Optional intOpt;
            Display display = (Display)creation;
            DisplayFeatures displayFeatures = furniture.getDisplayFeatures();
            ItemDisplay displayEntity = display.getDisplay();
            ItemStack visualItem = new ItemStack(MyFurniture.BASE_MATERIAL);
            if (!SCore.is1v21v4Plus()) {
                visualItem = new ItemStack(displayFeatures.getMaterial().getValue().orElse(MyFurniture.BASE_MATERIAL));
            }
            ItemMeta meta = visualItem.getItemMeta();
            if (SCore.is1v21v4Plus()) {
                intOpt = displayFeatures.getItemModel().getValue();
                intOpt.ifPresent(s -> meta.setItemModel(NamespacedKey.fromString((String)s)));
            } else {
                intOpt = displayFeatures.getCustomModelData().getValue();
                intOpt.ifPresent(arg_0 -> ((ItemMeta)meta).setCustomModelData(arg_0));
            }
            visualItem.setItemMeta(meta);
            displayEntity.setItemStack(visualItem);
            display.loadBoundingBoxes(displayFeatures, this.getLocation());
            if (displayFeatures.getSkyLight().getValue().isPresent() || displayFeatures.getBlockLight().getValue().isPresent()) {
                Display.Brightness brightness = new Display.Brightness(displayFeatures.getBlockLight().getValue().orElse(7).intValue(), displayFeatures.getSkyLight().getValue().orElse(7).intValue());
                displayEntity.setBrightness(brightness);
            }
            if (displayFeatures.getGlow().getValue().booleanValue()) {
                displayEntity.setGlowing(true);
                if (displayFeatures.getGlowColor().getValue().isPresent()) {
                    displayEntity.setGlowColorOverride(Color.fromRGB((int)((Integer)displayFeatures.getGlowColor().getValue().get())));
                } else {
                    displayEntity.setGlowColorOverride(null);
                }
            } else {
                displayEntity.setGlowing(false);
            }
            this.MF_ID = furniture.getId();
        }
    }

    public Entity getMainEntity() {
        return this.mainEntity;
    }

    public Location getLocation() {
        return this.location;
    }

    public Location getHoloLocation() {
        return this.holoLocation;
    }

    public CreationAbstract getCreation() {
        return this.creation;
    }

    public String getMF_ID() {
        return this.MF_ID;
    }

    public InternalData getInternalData() {
        return this.internalData;
    }

    public boolean isRemoved() {
        return this.isRemoved;
    }

    public boolean isMyFurniture() {
        return this.isMyFurniture;
    }

    public FileConfiguration getFileConfiguration() {
        return this.fileConfiguration;
    }

    public Map<Player, List<Integer>> getPacketsEntities() {
        return this.packetsEntities;
    }

    public boolean isSaveLaunched() {
        return this.saveLaunched;
    }

    public void setMainEntity(Entity mainEntity) {
        this.mainEntity = mainEntity;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void setHoloLocation(Location holoLocation) {
        this.holoLocation = holoLocation;
    }

    public void setCreation(CreationAbstract creation) {
        this.creation = creation;
    }

    public void setMF_ID(String MF_ID) {
        this.MF_ID = MF_ID;
    }

    public void setInternalData(InternalData internalData) {
        this.internalData = internalData;
    }

    public void setRemoved(boolean isRemoved) {
        this.isRemoved = isRemoved;
    }

    public void setMyFurniture(boolean isMyFurniture) {
        this.isMyFurniture = isMyFurniture;
    }

    public void setFileConfiguration(FileConfiguration fileConfiguration) {
        this.fileConfiguration = fileConfiguration;
    }

    public void setPacketsEntities(Map<Player, List<Integer>> packetsEntities) {
        this.packetsEntities = packetsEntities;
    }

    public void setSaveLaunched(boolean saveLaunched) {
        this.saveLaunched = saveLaunched;
    }

    public static enum BreakMethod {
        NATURAL,
        CUSTOM;

    }
}

