/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.furniture.placedfurniture.storage;

import com.ssomar.myfurniture.MyFurniture;
import com.ssomar.score.SCore;
import com.ssomar.score.usedapi.AllWorldManager;
import com.ssomar.score.utils.writer.NameSpaceKeyWriterReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;

public class StorageEntityManager {
    private List<Entity> entities = new ArrayList<Entity>();
    private static StorageEntityManager instance;

    public void addEntity(Entity entity) {
        Optional mainId = NameSpaceKeyWriterReader.readString((Plugin)SCore.plugin, (PersistentDataContainer)entity.getPersistentDataContainer(), (String)"MF-CHEST");
        if (!mainId.isPresent()) {
            return;
        }
        this.entities.add(entity);
        Collection players = Bukkit.getServer().getOnlinePlayers();
        for (Player player : players) {
            player.hideEntity((Plugin)MyFurniture.plugin, entity);
        }
    }

    public void removeEntity(Entity entity) {
        this.entities.remove(entity);
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public void addAllEntities() {
        for (String worldStr : AllWorldManager.getWorlds()) {
            Optional worldOpt = AllWorldManager.getWorld((String)worldStr);
            if (!worldOpt.isPresent()) continue;
            World world = (World)worldOpt.get();
            world.getEntities().forEach(this::addEntity);
        }
    }

    public void addEntities(List<Entity> entities) {
        for (Entity entity : entities) {
            this.addEntity(entity);
        }
    }

    public void removeEntities(List<Entity> entities) {
        this.entities.removeAll(entities);
    }

    public void hideAllEntitiesForPlayer(Player player) {
        for (Entity entity : this.entities) {
            player.hideEntity((Plugin)MyFurniture.plugin, entity);
        }
    }

    public static StorageEntityManager getInstance() {
        if (instance == null) {
            instance = new StorageEntityManager();
        }
        return instance;
    }
}

