/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.features.display.boundingboxzones.boundingboxzone;

import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.types.ArrayFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.obfuscation.KeepMethod;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class BoundingBoxZoneFeature
extends FeatureAbstract<BoundingBoxZoneFeature, BoundingBoxZoneFeature>
implements FeatureParentInterface<BoundingBoxZoneFeature, BoundingBoxZoneFeature> {
    private ArrayFeature<Double> from;
    private ArrayFeature<Double> to;
    private String id;

    public BoundingBoxZoneFeature(FeatureParentInterface parent, String id) {
        super(parent, (FeatureSettingsInterface)FeatureSettingsSCore.boundingBoxZone);
        this.id = id;
        this.reset();
    }

    @KeepMethod
    public void reset() {
        this.from = new ArrayFeature((FeatureParentInterface)this, (FeatureSettingsInterface)FeatureSettingsSCore.from, 3);
        this.to = new ArrayFeature((FeatureParentInterface)this, (FeatureSettingsInterface)FeatureSettingsSCore.to, 3);
    }

    @KeepMethod
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.id)) {
            ConfigurationSection enchantmentConfig = config.getConfigurationSection(this.id);
            errors.addAll(this.from.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.to.load(plugin, enchantmentConfig, isPremiumLoading));
        } else {
            errors.add("&cERROR, Couldn't load the bounding box zone value because there is not section with the good ID: " + this.id + " &7&o" + this.getParent().getParentInfo());
        }
        return errors;
    }

    @KeepMethod
    public boolean isTheFeatureClickedParentEditor(String featureClicked) {
        return featureClicked.contains(this.getEditorName()) && featureClicked.contains("(" + this.id + ")");
    }

    @KeepMethod
    public void save(ConfigurationSection config) {
        config.set(this.id, null);
        ConfigurationSection enchantmentConfig = config.createSection(this.id);
        this.from.save(enchantmentConfig);
        this.to.save(enchantmentConfig);
    }

    @KeepMethod
    public BoundingBoxZoneFeature getValue() {
        return this;
    }

    @KeepMethod
    public BoundingBoxZoneFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = GUI.SHIFT_CLICK_TO_REMOVE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName() + " - (" + this.id + ")", false, false, finalDescription);
        return this;
    }

    @KeepMethod
    public void updateItemParentEditor(GUI gui) {
    }

    @KeepMethod
    public BoundingBoxZoneFeature clone(FeatureParentInterface newParent) {
        BoundingBoxZoneFeature eF = new BoundingBoxZoneFeature(newParent, this.id);
        eF.setFrom((ArrayFeature<Double>)this.from.clone((FeatureParentInterface)eF));
        eF.setTo((ArrayFeature<Double>)this.to.clone((FeatureParentInterface)eF));
        return eF;
    }

    @KeepMethod
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<ArrayFeature>(Arrays.asList(this.from, this.to));
    }

    public FeatureInterface getFeature(FeatureSettingsInterface featureSettingsInterface) {
        return null;
    }

    public FeatureInterface getFeatureWithName(String s) {
        return null;
    }

    @KeepMethod
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @KeepMethod
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection parentSection = this.getParent().getConfigurationSection();
        if (parentSection.isConfigurationSection(this.getId())) {
            return parentSection.getConfigurationSection(this.getId());
        }
        return parentSection.createSection(this.getId());
    }

    @KeepMethod
    public File getFile() {
        return this.getParent().getFile();
    }

    @KeepMethod
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            BoundingBoxZoneFeature eF;
            if (!(feature instanceof BoundingBoxZoneFeature) || !(eF = (BoundingBoxZoneFeature)feature).getId().equals(this.id)) continue;
            eF.setFrom(this.from);
            eF.setTo(this.to);
            break;
        }
    }

    @KeepMethod
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @KeepMethod
    public void openEditor(@NotNull Player player) {
    }

    public ArrayFeature<Double> getFrom() {
        return this.from;
    }

    public ArrayFeature<Double> getTo() {
        return this.to;
    }

    public String getId() {
        return this.id;
    }

    public void setFrom(ArrayFeature<Double> from) {
        this.from = from;
    }

    public void setTo(ArrayFeature<Double> to) {
        this.to = to;
    }

    public void setId(String id) {
        this.id = id;
    }
}

