/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.furniture.placedfurniture;

import com.ssomar.myfurniture.MyFurniture;
import com.ssomar.myfurniture.furniture.Furniture;
import com.ssomar.myfurniture.furniture.creations.AnimatedDisplay;
import com.ssomar.myfurniture.furniture.creations.CreationAbstract;
import com.ssomar.myfurniture.furniture.creations.Display;
import com.ssomar.myfurniture.furniture.placedfurniture.FurniturePlaced;
import com.ssomar.myfurniture.furniture.placedfurniture.LocationConverter;
import com.ssomar.myfurniture.furniture.placedfurniture.TargetResult;
import com.ssomar.myfurniture.utils.NotCartesianParralelBoundingBox;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.sobject.SObjectManager;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.usedapi.AllWorldManager;
import com.ssomar.score.utils.obfuscation.KeepMethod;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.joml.Vector3f;

public class FurniturePlacedManager
extends SObjectManager<FurniturePlaced> {
    private Map<Entity, FurniturePlaced> furniturePlaced = new HashMap<Entity, FurniturePlaced>();
    private static FurniturePlacedManager instance;

    public FurniturePlacedManager() {
        super((SPlugin)MyFurniture.plugin, "FurniturePlaced");
    }

    public void addFurniturePlaced(FurniturePlaced furniturePlaced) {
        this.furniturePlaced.put(furniturePlaced.getMainEntity(), furniturePlaced);
        this.getLoadedObjects().add(furniturePlaced);
    }

    public void removeFurniturePlaced(FurniturePlaced furniturePlaced) {
        this.getLoadedObjects().remove((Object)furniturePlaced);
        this.furniturePlaced.remove(furniturePlaced.getMainEntity());
    }

    public Optional<String> onRequestPlaceholder(OfflinePlayer player, String params) {
        if (params.contains("{") && params.contains("}")) {
            params = params.replace("{", "%").replace("}", "%");
            params = StringPlaceholder.replacePlaceholderOfPAPI((String)params, (UUID)player.getUniqueId());
        }
        if (params.startsWith("variables_furniture:")) {
            String config = params.substring(16);
            String[] split = config.split("_variable:");
            String[] location = split[0].split(",");
            Optional world = AllWorldManager.getWorld((String)location[3]);
            if (!world.isPresent()) {
                return Optional.of("Invalid world");
            }
            double x = Double.parseDouble(location[0]);
            double y = Double.parseDouble(location[1]);
            double z = Double.parseDouble(location[2]);
            x = Math.floor(x) + 0.5;
            y = Math.floor(y) + 0.5;
            z = Math.floor(z) + 0.5;
            SsomarDev.testMsg((String)("onRequestPlaceholder >>" + ((World)world.get()).getName() + " " + x + " " + y + " " + z), (boolean)true);
            Location loc = new Location((World)world.get(), x, y, z);
            Optional<FurniturePlaced> eBPO = this.getFurniturePlaced(loc);
            if (!eBPO.isPresent()) {
                return Optional.of("No Furniture found");
            }
            FurniturePlaced eBP = eBPO.get();
            Map variables = eBP.getInternalData().getVariables();
            for (Map.Entry entry : variables.entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase(split[1])) continue;
                return Optional.of((String)entry.getValue());
            }
            return Optional.of("No variable found");
        }
        return Optional.empty();
    }

    public Optional<FurniturePlaced> getFurniturePlaced(Location location) {
        if (this.furniturePlaced.containsKey(location)) {
            return Optional.ofNullable(this.furniturePlaced.get(location));
        }
        return Optional.empty();
    }

    public Optional<FurniturePlaced> getFurniturePlaced(String id) {
        for (FurniturePlaced furniturePlaced : this.furniturePlaced.values()) {
            if (!furniturePlaced.getId().equals(id)) continue;
            return Optional.of(furniturePlaced);
        }
        return Optional.empty();
    }

    public Optional<FurniturePlaced> getFurniturePlaced(Entity byDisplay) {
        if (this.furniturePlaced.containsKey(byDisplay)) {
            return Optional.ofNullable(this.furniturePlaced.get(byDisplay));
        }
        return Optional.empty();
    }

    public Optional<TargetResult> getFurniturePlacedDisplayRaytracePlayerLocation(Player player, Location location, Vector direction, double editY, double maxSearchDistance, Vector hitPosition) {
        return this.getFurniturePlacedDisplayTargetByLocation(location.add(0.0, editY, 0.0), direction, this.getFurniturePlacedNear(player.getLocation(), maxSearchDistance), hitPosition);
    }

    public Optional<TargetResult> getFurniturePlacedDisplayTargetByPlayer(Player player, double maxSearchDistance, Vector hitPosition) {
        Location loc = player.getEyeLocation();
        return this.getFurniturePlacedDisplayTargetByLocation(loc, loc.getDirection().clone().multiply(5), this.getFurniturePlacedNear(player.getLocation(), maxSearchDistance), hitPosition);
    }

    public Optional<TargetResult> getFurniturePlacedDisplayTargetByPlayer(Player player) {
        Location loc = player.getEyeLocation();
        return this.getFurniturePlacedDisplayTargetByLocation(loc, loc.getDirection().clone().multiply(5), this.getFurniturePlacedNear(player.getLocation(), 25.0), new Vector());
    }

    public Optional<TargetResult> getFurniturePlacedDisplayTargetByLocation(Location location, Vector dir, Collection<FurniturePlaced> whitelist, Vector hitPosition) {
        Vector baseVec = location.toVector();
        Vector3f baseVec3f = baseVec.toVector3f();
        Vector3f direction = dir.toVector3f();
        HashMap<FurniturePlaced, Double> possibleElements = new HashMap<FurniturePlaced, Double>();
        HashMap<FurniturePlaced, String> boundingBoxesId = new HashMap<FurniturePlaced, String>();
        HashMap<FurniturePlaced, Vector> hitPositions = new HashMap<FurniturePlaced, Vector>();
        Iterator<FurniturePlaced> iterator = whitelist.iterator();
        while (iterator.hasNext()) {
            FurniturePlaced executableBlockPlaced;
            FurniturePlaced eBP = executableBlockPlaced = iterator.next();
            Furniture furniture = eBP.getFurniture();
            CreationAbstract creation = eBP.getCreation();
            List<Object> boundingBoxes = new ArrayList();
            if (!(creation instanceof Display) && !(creation instanceof AnimatedDisplay)) continue;
            boundingBoxes = creation.getBoundingBoxes();
            for (NotCartesianParralelBoundingBox notCartesianParralelBoundingBox : boundingBoxes) {
                double distance;
                RayTraceResult rayTraceResult = null;
                try {
                    rayTraceResult = notCartesianParralelBoundingBox.rayTrace(baseVec3f, direction);
                }
                catch (CloneNotSupportedException e) {
                    throw new RuntimeException(e);
                }
                if (rayTraceResult == null || (distance = rayTraceResult.getHitPosition().distance(baseVec)) > (Double)furniture.getInteractionRange().getValue().get()) continue;
                if (possibleElements.containsKey((Object)eBP)) {
                    if (!((Double)possibleElements.get((Object)eBP) > distance)) continue;
                    possibleElements.put(eBP, distance);
                    hitPositions.put(eBP, rayTraceResult.getHitPosition());
                    boundingBoxesId.put(eBP, notCartesianParralelBoundingBox.getId());
                    continue;
                }
                possibleElements.put(eBP, distance);
                hitPositions.put(eBP, rayTraceResult.getHitPosition());
                boundingBoxesId.put(eBP, notCartesianParralelBoundingBox.getId());
            }
        }
        if (!possibleElements.isEmpty()) {
            double min = (Double)possibleElements.values().stream().min(Double::compare).get();
            for (Map.Entry entry : possibleElements.entrySet()) {
                if (!((Double)entry.getValue()).equals(min)) continue;
                Vector result = (Vector)hitPositions.get(entry.getKey());
                hitPosition.setX(result.getX());
                hitPosition.setY(result.getY());
                hitPosition.setZ(result.getZ());
                TargetResult targetResult = new TargetResult((FurniturePlaced)((Object)entry.getKey()), new Location(location.getWorld(), hitPosition.getX(), hitPosition.getY(), hitPosition.getZ()), (String)boundingBoxesId.get(entry.getKey()));
                return Optional.of(targetResult);
            }
        }
        return Optional.empty();
    }

    public Optional<FurniturePlaced> getFurniturePlaced(Block block) {
        return this.getFurniturePlaced(LocationConverter.convert(block.getLocation(), false, false));
    }

    public List<FurniturePlaced> getFurniturePlacedNear(Location location, double distanceMax) {
        ArrayList<FurniturePlaced> list = new ArrayList<FurniturePlaced>();
        for (FurniturePlaced eBP : this.furniturePlaced.values()) {
            if (!eBP.getLocation().getWorld().equals((Object)location.getWorld()) || !(eBP.getLocation().distance(location) <= distanceMax)) continue;
            list.add(eBP);
        }
        return list;
    }

    public void cacheFurniturePlaced(Entity entity) {
        FurniturePlaced furniturePlaced = new FurniturePlaced(entity);
        if (furniturePlaced.isMyFurniture()) {
            this.furniturePlaced.put(entity, furniturePlaced);
        }
    }

    public void cacheFurniturePlaced(Collection<Entity> entities) {
        entities.forEach(this::cacheFurniturePlaced);
    }

    public void cacheAllEntities() {
        for (String worldStr : AllWorldManager.getWorlds()) {
            Optional worldOpt = AllWorldManager.getWorld((String)worldStr);
            if (!worldOpt.isPresent()) continue;
            World world = (World)worldOpt.get();
            world.getEntities().forEach(this::cacheFurniturePlaced);
        }
    }

    public void unCacheFurniturePlaced(Entity entity) {
        FurniturePlaced furniturePlaced1 = this.furniturePlaced.remove(entity);
    }

    public void unCacheFurniturePlaced(Collection<Entity> entities) {
        entities.forEach(this::unCacheFurniturePlaced);
    }

    public void unCacheAllFurniturePlaced() {
        this.furniturePlaced.clear();
    }

    public Map<Entity, FurniturePlaced> getAllFurniturePlaced() {
        return new HashMap<Entity, FurniturePlaced>(this.furniturePlaced);
    }

    public Map<Location, FurniturePlaced> getAllFurniturePlacedBy(UUID playerUUID) {
        HashMap<Location, FurniturePlaced> map = new HashMap<Location, FurniturePlaced>();
        for (FurniturePlaced eBP : this.furniturePlaced.values()) {
            if (eBP.getInternalData().getOwnerUUID() == null || eBP.getInternalData().getOwnerUUID() != playerUUID) continue;
            map.put(eBP.getLocation(), eBP);
        }
        return map;
    }

    public int getAmountOfFurniturePlacedBy(UUID playerUUID) {
        int i = 0;
        for (FurniturePlaced eBP : this.furniturePlaced.values()) {
            if (eBP.getInternalData().getOwnerUUID() == null || !eBP.getInternalData().getOwnerUUID().equals(playerUUID)) continue;
            ++i;
        }
        return i;
    }

    public int getAmountOfFurniturePlacedBy(UUID playerUUID, String id) {
        int i = 0;
        for (FurniturePlaced eBP : this.furniturePlaced.values()) {
            if (!eBP.getFurnitureID().equalsIgnoreCase(id) || eBP.getInternalData().getOwnerUUID() == null || !eBP.getInternalData().getOwnerUUID().equals(playerUUID)) continue;
            ++i;
        }
        return i;
    }

    public static FurniturePlacedManager getInstance() {
        if (instance == null) {
            instance = new FurniturePlacedManager();
        }
        return instance;
    }

    public void removeAllBoundingBoxes(Player player) {
        for (FurniturePlaced eBP : this.furniturePlaced.values()) {
            eBP.removeBoundingBoxes(player);
        }
    }

    @KeepMethod
    public void actionOnObjectWhenLoading(FurniturePlaced executableBlockPlaced) {
    }

    @KeepMethod
    public void actionOnObjectWhenReloading(FurniturePlaced executableBlockPlaced) {
    }

    @KeepMethod
    public Optional<FurniturePlaced> methodObjectLoading(String s) {
        return Optional.empty();
    }

    @KeepMethod
    public List<FurniturePlaced> getObjects() {
        ArrayList<FurniturePlaced> list = new ArrayList<FurniturePlaced>();
        list.addAll(this.furniturePlaced.values());
        return list;
    }

    @KeepMethod
    public Optional<FurniturePlaced> getObject(String id) {
        for (FurniturePlaced eBP : this.furniturePlaced.values()) {
            if (!eBP.getId().equals(id)) continue;
            return Optional.of(eBP);
        }
        return Optional.empty();
    }
}

