/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.furniture.creations;

import com.ssomar.myfurniture.MyFurniture;
import com.ssomar.myfurniture.configs.GeneralConfig;
import com.ssomar.myfurniture.features.display.DisplayFeatures;
import com.ssomar.myfurniture.features.display.boundingboxzones.boundingboxzone.BoundingBoxZoneFeature;
import com.ssomar.myfurniture.furniture.Furniture;
import com.ssomar.myfurniture.furniture.creations.CreationAbstract;
import com.ssomar.myfurniture.furniture.placedfurniture.FurniturePlacedManager;
import com.ssomar.myfurniture.furniture.placedfurniture.LocationConverter;
import com.ssomar.myfurniture.furniture.placedfurniture.TargetResult;
import com.ssomar.myfurniture.utils.NotCartesianParralelBoundingBox;
import com.ssomar.myfurniture.utils.ShulkerPacketUtilPacketEvent;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.features.types.ArrayFeature;
import com.ssomar.score.utils.obfuscation.KeepMethod;
import com.ssomar.score.utils.writer.NameSpaceKeyWriterReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Vector3f;

public class Display
extends CreationAbstract {
    private List<Long> breakTentatives = new ArrayList<Long>();
    private List<NotCartesianParralelBoundingBox> boundingBoxes = new ArrayList<NotCartesianParralelBoundingBox>();
    private UUID displayUUID;

    public Display(Furniture config) {
        super(config);
    }

    public boolean isWallBlockFace(BlockFace blockFace) {
        return blockFace == BlockFace.NORTH || blockFace == BlockFace.SOUTH || blockFace == BlockFace.EAST || blockFace == BlockFace.WEST;
    }

    @Override
    @KeepMethod
    @Nullable
    public Location getTheCorrectedPlacementLocation(@Nullable Location base, @Nullable Entity placer, @Nullable BlockFace blockface) {
        boolean placerSneak = false;
        try {
            placerSneak = placer != null && ((Player)placer).isSneaking();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean needToBeAligned = this.getConfig().getDisplayFeatures().getAligned().getValue() != false || placerSneak;
        boolean useSpecialFeature = false;
        if (!needToBeAligned) {
            Player player = (Player)placer;
            Vector hitPos = new Vector();
            Optional<TargetResult> eBPOpt = FurniturePlacedManager.getInstance().getFurniturePlacedDisplayTargetByPlayer(player, 10.0, hitPos);
            if (eBPOpt.isPresent()) {
                base = new Location(player.getWorld(), hitPos.getX(), hitPos.getY(), hitPos.getZ()).add(0.0, 0.5, 0.0);
                SsomarDev.testMsg((String)("Hit pos at: " + base), (boolean)true);
                useSpecialFeature = true;
            } else {
                RayTraceResult rayTraceResult = ((Player)placer).rayTraceBlocks(5.0);
                if (rayTraceResult != null) {
                    base = rayTraceResult.getHitPosition().toLocation(placer.getWorld());
                    SsomarDev.testMsg((String)("Blockface: " + blockface), (boolean)true);
                    if (blockface == BlockFace.UP) {
                        base = base.add(0.0, 0.5, 0.0);
                    } else {
                        Map<String, BoundingBoxZoneFeature> mp = this.getConfig().getDisplayFeatures().getBoundingBoxZoneGroupFeature().getBoundingBoxZones();
                        double zMin = Double.MAX_VALUE;
                        double zMax = Double.MIN_VALUE;
                        for (String key : mp.keySet()) {
                            BoundingBoxZoneFeature bbzf = mp.get(key);
                            double check = (Double)bbzf.getFrom().getArrayValueAtIndex(2);
                            if (check < zMin) {
                                zMin = check;
                            }
                            if (!((check = ((Double)bbzf.getTo().getArrayValueAtIndex(2)).doubleValue()) > zMax)) continue;
                            zMax = check;
                        }
                        SsomarDev.testMsg((String)("Z min: " + zMin + " Z max: " + zMax), (boolean)true);
                        double size = zMax - zMin;
                        SsomarDev.testMsg((String)("Size: " + size), (boolean)true);
                        if (blockface != null) {
                            switch (blockface) {
                                case NORTH: {
                                    base = base.add(0.0, 0.0, -size / 16.0 + (-zMin + 8.0) / 16.0);
                                    break;
                                }
                                case SOUTH: {
                                    base = base.add(0.0, 0.0, size / 16.0 - (-zMin + 8.0) / 16.0);
                                    break;
                                }
                                case EAST: {
                                    base = base.add(size / 16.0 - (-zMin + 8.0) / 16.0, 0.0, 0.0);
                                    break;
                                }
                                case WEST: {
                                    base = base.add(-size / 16.0 + (-zMin + 8.0) / 16.0, 0.0, 0.0);
                                    break;
                                }
                            }
                        }
                    }
                    useSpecialFeature = true;
                }
            }
        }
        if (base == null) {
            return null;
        }
        if (!useSpecialFeature) {
            base = LocationConverter.convert(base, false, true);
        }
        float yaw = 0.0f;
        if (placer != null) {
            base.setYaw(placer.getLocation().getYaw());
        }
        if (SCore.is1v20v1Plus()) {
            base.setPitch(-90.0f);
            base.setYaw(base.getYaw() + 180.0f);
        }
        base.setPitch(base.getPitch() + this.getConfig().getDisplayFeatures().getCustomPitch().getValue().orElse(0).floatValue());
        if (needToBeAligned || blockface != BlockFace.UP) {
            base.setYaw((float)(Math.round(base.getYaw() / 90.0f) * 90));
        }
        base.setY(base.getY() + this.getConfig().getDisplayFeatures().getCustomY().getValue().orElse(0.0));
        return base;
    }

    @Override
    @KeepMethod
    public boolean canPlace(@NotNull Location location) {
        return true;
    }

    @Override
    @KeepMethod
    public boolean place(@NotNull Location location) {
        Optional intOpt;
        DisplayFeatures displayFeatures = this.getConfig().getDisplayFeatures();
        ItemDisplay display = (ItemDisplay)location.getWorld().spawnEntity(location, EntityType.ITEM_DISPLAY);
        ItemStack visualItem = new ItemStack(MyFurniture.BASE_MATERIAL);
        if (!SCore.is1v21v4Plus()) {
            visualItem = new ItemStack(displayFeatures.getMaterial().getValue().orElse(MyFurniture.BASE_MATERIAL));
        }
        ItemMeta meta = visualItem.getItemMeta();
        if (SCore.is1v21v4Plus()) {
            intOpt = displayFeatures.getItemModel().getValue();
            intOpt.ifPresent(s -> meta.setItemModel(NamespacedKey.fromString((String)s)));
        } else {
            intOpt = displayFeatures.getCustomModelData().getValue();
            intOpt.ifPresent(arg_0 -> ((ItemMeta)meta).setCustomModelData(arg_0));
        }
        visualItem.setItemMeta(meta);
        display.setItemStack(visualItem);
        display.setItemDisplayTransform(GeneralConfig.getInstance().getDisplayDefaultTransform());
        this.loadBoundingBoxes(displayFeatures, location);
        if (displayFeatures.getGlow().getValue().booleanValue()) {
            display.setGlowing(true);
            if (displayFeatures.getGlowColor().getValue().isPresent()) {
                display.setGlowColorOverride(Color.fromRGB((int)((Integer)displayFeatures.getGlowColor().getValue().get())));
            }
        }
        Transformation transformation = display.getTransformation();
        transformation.getScale().mul(displayFeatures.getScale().getValue().orElse(1.0).floatValue());
        display.setTransformation(transformation);
        if (displayFeatures.getSkyLight().getValue().isPresent() || displayFeatures.getBlockLight().getValue().isPresent()) {
            int skyLight;
            int blockLight = displayFeatures.getBlockLight().getValue().orElse(7);
            if (blockLight > 15) {
                blockLight = 15;
            }
            if ((skyLight = displayFeatures.getSkyLight().getValue().orElse(7).intValue()) > 15) {
                skyLight = 15;
            }
            Display.Brightness brightness = new Display.Brightness(blockLight, skyLight);
            display.setBrightness(brightness);
        }
        display.setViewRange(displayFeatures.getViewRange().getValue().orElse(20.0).floatValue());
        if (SCore.isFolia()) {
            display.teleportAsync(location);
        } else {
            display.teleport(location);
        }
        this.displayUUID = display.getUniqueId();
        this.setMainEntity((Entity)display);
        return true;
    }

    public List<Integer> spawnBoundingBoxFor(Player player) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        Location location = player.getLocation();
        ArrayList<Location> borderPoints = new ArrayList<Location>();
        AtomicInteger i = new AtomicInteger();
        for (NotCartesianParralelBoundingBox notCartesianParralelBoundingBox : this.boundingBoxes) {
            List<Vector3f> allBorderPoints = notCartesianParralelBoundingBox.getAllBorderPoints();
            for (Vector3f point : allBorderPoints) {
                Location pointLoc = new Location(location.getWorld(), (double)point.x(), (double)point.y(), (double)point.z());
                boolean canSummon = true;
                for (Location borderPoint : borderPoints) {
                    if (!(borderPoint.distance(pointLoc) < 0.35)) continue;
                    canSummon = false;
                    break;
                }
                if (!canSummon) continue;
                ShulkerPacketUtilPacketEvent shulkerPacketUtils = new ShulkerPacketUtilPacketEvent();
                int text = shulkerPacketUtils.sendClientTextDisplay(player, pointLoc);
                ids.add(text);
                int shulker = shulkerPacketUtils.sendClientShulker(player, pointLoc);
                ids.add(shulker);
                shulkerPacketUtils.mountShulker(player, shulker, text);
                borderPoints.add(new Location(location.getWorld(), (double)point.x(), (double)point.y(), (double)point.z()));
                i.getAndIncrement();
            }
        }
        SsomarDev.testMsg((String)("Amount of border points: " + i.get()), (boolean)true);
        return ids;
    }

    @Override
    @KeepMethod
    public void afterPlacingModification(@NotNull Location location) {
    }

    @Override
    @KeepMethod
    public void remove(Location location) {
        if (this.displayUUID != null) {
            Entity entity = Bukkit.getEntity((UUID)this.displayUUID);
            if (entity != null) {
                entity.remove();
            }
            for (Entity ent : location.getWorld().getEntities()) {
                PersistentDataContainer persistentDataContainer = ent.getPersistentDataContainer();
                Optional stringOpt = NameSpaceKeyWriterReader.readString((Plugin)SCore.plugin, (PersistentDataContainer)persistentDataContainer, (String)"MF-BOUNDING");
                if (!stringOpt.isPresent() || !((String)stringOpt.get()).equals(this.displayUUID.toString())) continue;
                ent.getPassengers().forEach(Entity::remove);
                ent.remove();
            }
        }
    }

    public void shake() {
        Entity entity;
        if (this.displayUUID != null && (entity = Bukkit.getEntity((UUID)this.displayUUID)) != null) {
            final org.bukkit.entity.Display display = (org.bukkit.entity.Display)entity;
            this.transformationLeft(display, new Vector(0, 0, 1), 0.136332f, 2, -1);
            BukkitRunnable runnable = new BukkitRunnable(){

                public void run() {
                    Display.this.transformationLeft(display, new Vector(0, 0, 1), -0.136332f, 3, -1);
                }
            };
            SCore.schedulerHook.runEntityTask((Runnable)runnable, null, (Entity)display, 2L);
            BukkitRunnable runnable2 = new BukkitRunnable(){

                public void run() {
                    Display.this.transformationLeft(display, new Vector(0, 0, 1), 0.136332f, 3, -1);
                }
            };
            SCore.schedulerHook.runEntityTask((Runnable)runnable2, null, (Entity)display, 5L);
            BukkitRunnable runnable3 = new BukkitRunnable(){

                public void run() {
                    Display.this.transformationLeft(display, new Vector(0, 0, 1), 0.0f, 2, -1);
                }
            };
            SCore.schedulerHook.runEntityTask((Runnable)runnable3, null, (Entity)display, 8L);
        }
    }

    public void transformationLeft(org.bukkit.entity.Display entity, Vector axis, float angle, int duration, int delay) {
        entity.setInterpolationDuration(duration);
        entity.setInterpolationDelay(delay);
        Transformation transformation = entity.getTransformation();
        transformation.getLeftRotation().set(new AxisAngle4f(angle, (float)axis.getX(), (float)axis.getY(), (float)axis.getZ()));
        entity.setTransformation(transformation);
    }

    @Override
    @KeepMethod
    public boolean load(Entity entity) {
        this.displayUUID = entity.getUniqueId();
        DisplayFeatures displayFeatures = this.getConfig().getDisplayFeatures();
        this.loadBoundingBoxes(displayFeatures, entity.getLocation());
        return true;
    }

    public void loadBoundingBoxes(DisplayFeatures displayFeatures, Location location) {
        this.boundingBoxes.clear();
        displayFeatures.getBoundingBoxZoneGroupFeature().getBoundingBoxZones().forEach((key, value) -> {
            double yaw = -location.getYaw() + 180.0f;
            ArrayFeature<Double> from = value.getFrom();
            ArrayFeature<Double> to = value.getTo();
            Vector3f fromLoc = new Vector3f((float)((Double)from.getArrayValueAtIndex(0) / 16.0), (float)((Double)from.getArrayValueAtIndex(1) / 16.0), (float)((Double)from.getArrayValueAtIndex(2) / 16.0));
            Vector3f toLoc = new Vector3f((float)((Double)to.getArrayValueAtIndex(0) / 16.0), (float)((Double)to.getArrayValueAtIndex(1) / 16.0), (float)((Double)to.getArrayValueAtIndex(2) / 16.0));
            NotCartesianParralelBoundingBox notCartesianParralelBoundingBox = new NotCartesianParralelBoundingBox(fromLoc, toLoc, value.getId());
            double correctionX = location.getX() - (double)location.getBlockX();
            double correctionZ = location.getZ() - (double)location.getBlockZ();
            double correctionY = location.getY() - (double)location.getBlockY();
            notCartesianParralelBoundingBox.translate(-0.5f, -0.5f, -0.5f);
            notCartesianParralelBoundingBox.rotateY((float)Math.toRadians(yaw));
            notCartesianParralelBoundingBox.translate((double)location.getBlockX() + correctionX, (double)location.getBlockY() + correctionY, (double)location.getBlockZ() + correctionZ);
            this.boundingBoxes.add(notCartesianParralelBoundingBox);
        });
    }

    @Override
    @KeepMethod
    public void save(ConfigurationSection config) {
        if (this.displayUUID == null) {
            config.set("blockEntityUUID", (Object)"no");
        } else {
            config.set("blockEntityUUID", (Object)this.displayUUID.toString());
        }
    }

    @Override
    @KeepMethod
    public String getDisplayName() {
        return "";
    }

    @Override
    public boolean tryBreak() {
        this.shake();
        int clickToBreak = (Integer)this.getConfig().getDisplayFeatures().getClickToBreak().getValue().get();
        if (clickToBreak < 1) {
            clickToBreak = 1;
        }
        if (clickToBreak == 1) {
            return true;
        }
        long time = System.currentTimeMillis();
        int click = 0;
        ArrayList<Long> toRemove = new ArrayList<Long>();
        for (int i = this.breakTentatives.size() - 1; i >= 0; --i) {
            if (time - this.breakTentatives.get(i) < 2000L) {
                ++click;
                continue;
            }
            toRemove.add(this.breakTentatives.get(i));
        }
        this.breakTentatives.removeAll(toRemove);
        if (click + 1 >= clickToBreak) {
            return true;
        }
        this.breakTentatives.add(time);
        return false;
    }

    public ItemDisplay getDisplay() {
        Entity entity;
        if (this.displayUUID != null && (entity = Bukkit.getEntity((UUID)this.displayUUID)) != null) {
            return (ItemDisplay)entity;
        }
        return null;
    }

    public List<Long> getBreakTentatives() {
        return this.breakTentatives;
    }

    @Override
    public List<NotCartesianParralelBoundingBox> getBoundingBoxes() {
        return this.boundingBoxes;
    }

    public UUID getDisplayUUID() {
        return this.displayUUID;
    }
}

