/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.utils;

import com.ssomar.myfurniture.utils.MollerTrumbore;
import com.ssomar.myfurniture.utils.Triangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TextDisplay;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.joml.Vector3f;

@SerializableAs(value="CustomBoundingBox")
public class NotCartesianParralelBoundingBox {
    String id;
    Vector3f p0;
    Vector3f p1;
    Vector3f p2;
    Vector3f p3;
    Vector3f p4;
    Vector3f p5;
    Vector3f p6;
    Vector3f p7;
    List<Vector3f> points;
    List<Triangle> trianglesNormal;
    private static double EPSILON = 1.0E-7;

    public NotCartesianParralelBoundingBox(Vector3f from, Vector3f to, String id) {
        this.id = id;
        double xLow = Math.min(from.x, to.x);
        double xHigh = Math.max(from.x, to.x);
        double yLow = Math.min(from.y, to.y);
        double yHigh = Math.max(from.y, to.y);
        double zLow = Math.min(from.z, to.z);
        double zHigh = Math.max(from.z, to.z);
        this.p0 = new Vector3f((float)xLow, (float)yLow, (float)zLow);
        this.p1 = new Vector3f((float)xHigh, (float)yLow, (float)zLow);
        this.p2 = new Vector3f((float)xHigh, (float)yLow, (float)zHigh);
        this.p3 = new Vector3f((float)xLow, (float)yLow, (float)zHigh);
        this.p4 = new Vector3f((float)xLow, (float)yHigh, (float)zLow);
        this.p5 = new Vector3f((float)xHigh, (float)yHigh, (float)zLow);
        this.p6 = new Vector3f((float)xHigh, (float)yHigh, (float)zHigh);
        this.p7 = new Vector3f((float)xLow, (float)yHigh, (float)zHigh);
        this.points = Arrays.asList(this.p0, this.p1, this.p2, this.p3, this.p4, this.p5, this.p6, this.p7);
        this.trianglesNormal = Arrays.asList(new Triangle(this.p1, this.p5, this.p4), new Triangle(this.p0, this.p4, this.p1), new Triangle(this.p0, this.p4, this.p7), new Triangle(this.p0, this.p3, this.p7), new Triangle(this.p7, this.p6, this.p2), new Triangle(this.p7, this.p3, this.p2), new Triangle(this.p2, this.p6, this.p5), new Triangle(this.p2, this.p5, this.p1), new Triangle(this.p0, this.p2, this.p1), new Triangle(this.p0, this.p3, this.p2), new Triangle(this.p4, this.p5, this.p6), new Triangle(this.p4, this.p6, this.p7));
    }

    public NotCartesianParralelBoundingBox(Vector3f p0, Vector3f p1, Vector3f p2, Vector3f p3, Vector3f p4, Vector3f p5, Vector3f p6, Vector3f p7) {
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
        this.p3 = p3;
        this.p4 = p4;
        this.p5 = p5;
        this.p6 = p6;
        this.p7 = p7;
        this.points = Arrays.asList(p0, p1, p2, p3, p4, p5, p6, p7);
        this.trianglesNormal = Arrays.asList(new Triangle(p1, p5, p4), new Triangle(p0, p4, p1), new Triangle(p0, p4, p7), new Triangle(p0, p3, p7), new Triangle(p7, p6, p2), new Triangle(p7, p3, p2), new Triangle(p2, p6, p5), new Triangle(p2, p5, p1), new Triangle(p0, p2, p1), new Triangle(p0, p3, p2), new Triangle(p4, p5, p6), new Triangle(p4, p6, p7));
    }

    public void translate(float x, float y, float z) {
        for (Vector3f point : this.points) {
            point.add(x, y, z);
        }
    }

    public void translate(double x, double y, double z) {
        for (Vector3f point : this.points) {
            point.add((float)x, (float)y, (float)z);
        }
    }

    public void rotateY(float angleRadian) {
        for (Vector3f point : this.points) {
            point.rotateY(angleRadian);
        }
    }

    public void debugAllPoints(World world) {
        int i = 0;
        for (Vector3f point : this.points) {
            Location loc = new Location(world, (double)point.x, (double)point.y, (double)point.z);
            TextDisplay display = (TextDisplay)world.spawnEntity(loc, EntityType.TEXT_DISPLAY);
            display.setText(i + "");
            display.setBackgroundColor(Color.GREEN);
            ++i;
        }
    }

    public RayTraceResult rayTrace(Vector3f start, Vector3f max) throws CloneNotSupportedException {
        HashMap<Point3d, Double> validTriangles = new HashMap<Point3d, Double>();
        Point3d startP = new Point3d((double)start.x, (double)start.y, (double)start.z);
        Vector3d maxP = new Vector3d((double)max.x, (double)max.y, (double)max.z);
        for (Triangle triangle : this.trianglesNormal) {
            Point3d result;
            boolean check = MollerTrumbore.rayIntersectsTriangle(startP, maxP, triangle, result = new Point3d(0.0, 0.0, 0.0));
            if (!check) continue;
            validTriangles.put(result, result.distance(startP));
        }
        if (!validTriangles.isEmpty()) {
            Point3d min = (Point3d)((Map.Entry)validTriangles.entrySet().stream().min((entry1, entry2) -> (Double)entry1.getValue() > (Double)entry2.getValue() ? 1 : -1).get()).getKey();
            RayTraceResult result = new RayTraceResult(new Vector(min.x, min.y, min.z));
            return result;
        }
        return null;
    }

    public boolean isInside(double x, double y, double z) {
        if (x < (double)this.p0.x || x > (double)this.p6.x) {
            return false;
        }
        if (y < (double)this.p0.y || y > (double)this.p6.y) {
            return false;
        }
        return !(z < (double)this.p0.z) && !(z > (double)this.p6.z);
    }

    public boolean isNear(double x, double y, double z, double distance) {
        if (x < (double)this.p0.x - distance || x > (double)this.p6.x + distance) {
            return false;
        }
        if (y < (double)this.p0.y - distance || y > (double)this.p6.y + distance) {
            return false;
        }
        return !(z < (double)this.p0.z - distance) && !(z > (double)this.p6.z + distance);
    }

    public List<Vector3f> getAllBorderPoints() {
        ArrayList<Vector3f> borderPoints = new ArrayList<Vector3f>(this.points);
        float step = 0.1f;
        Consumer<int[]> interpolatePoints = pair -> {
            Vector3f p1 = this.points.get(pair[0]);
            Vector3f p2 = this.points.get(pair[1]);
            Vector3f direction = new Vector3f(p2.x - p1.x, p2.y - p1.y, p2.z - p1.z);
            float length = direction.length();
            if (length > 0.0f) {
                direction.normalize();
                for (float dist = step; dist < length; dist += step) {
                    borderPoints.add(new Vector3f(p1.x + direction.x * dist, p1.y + direction.y * dist, p1.z + direction.z * dist));
                }
            }
        };
        int[][] bottomPairs = new int[][]{{0, 1}, {0, 2}, {0, 3}, {1, 2}, {1, 3}, {2, 3}};
        int[][] topPairs = new int[][]{{4, 5}, {4, 6}, {4, 7}, {5, 6}, {5, 7}, {6, 7}};
        int[][] verticalPairs = new int[][]{{0, 4}, {1, 5}, {2, 6}, {3, 7}};
        Arrays.stream(bottomPairs).forEach(interpolatePoints);
        Arrays.stream(topPairs).forEach(interpolatePoints);
        Arrays.stream(verticalPairs).forEach(interpolatePoints);
        for (int i = 0; i < 4; ++i) {
            for (int j = 4; j < 8; ++j) {
                if (j - i == 4) continue;
                interpolatePoints.accept(new int[]{i, j});
            }
        }
        return borderPoints;
    }

    public String getId() {
        return this.id;
    }

    public Vector3f getP0() {
        return this.p0;
    }

    public Vector3f getP1() {
        return this.p1;
    }

    public Vector3f getP2() {
        return this.p2;
    }

    public Vector3f getP3() {
        return this.p3;
    }

    public Vector3f getP4() {
        return this.p4;
    }

    public Vector3f getP5() {
        return this.p5;
    }

    public Vector3f getP6() {
        return this.p6;
    }

    public Vector3f getP7() {
        return this.p7;
    }

    public List<Vector3f> getPoints() {
        return this.points;
    }

    public List<Triangle> getTrianglesNormal() {
        return this.trianglesNormal;
    }
}

