/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.PacketEventsAPI;
import com.ssomar.libs.com.alessiodp.libby.BukkitLibraryManager;
import com.ssomar.libs.com.alessiodp.libby.Library;
import com.ssomar.myfurniture.api.load.MyFurniturePostLoadEvent;
import com.ssomar.myfurniture.bukkit.Metrics;
import com.ssomar.myfurniture.charts.SimplePie;
import com.ssomar.myfurniture.commands.CommandsClass;
import com.ssomar.myfurniture.configs.GeneralConfig;
import com.ssomar.myfurniture.configs.api.PlaceholderAPI;
import com.ssomar.myfurniture.configs.messages.Message;
import com.ssomar.myfurniture.furniture.Furniture;
import com.ssomar.myfurniture.furniture.FurnitureLoader;
import com.ssomar.myfurniture.furniture.placedfurniture.FurniturePlaced;
import com.ssomar.myfurniture.furniture.placedfurniture.FurniturePlacedManager;
import com.ssomar.myfurniture.furniture.placedfurniture.storage.StorageEntityManager;
import com.ssomar.myfurniture.listeners.EventsHandler;
import com.ssomar.myfurniture.listeners.TESTEVENT;
import com.ssomar.myfurniture.listeners.optimize.OptimizedEventsHandler;
import com.ssomar.myfurniture.pack.MyFurniturePack;
import com.ssomar.myfurniture.playersettings.PlayerSettings;
import com.ssomar.myfurniture.playersettings.PlayerSettingsLoader;
import com.ssomar.myfurniture.texturesloader.TexturesPackLoader;
import com.ssomar.myfurniture.usedapi.PlaceholderAPISCoreExpansion;
import com.ssomar.score.SCore;
import com.ssomar.score.config.Config;
import com.ssomar.score.configs.messages.MessageInterface;
import com.ssomar.score.configs.messages.MessageMain;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.usedapi.Dependency;
import com.ssomar.score.utils.logging.Utils;
import com.ssomar.score.utils.obfuscation.KeepClass;
import com.ssomar.score.utils.obfuscation.KeepMethod;
import io.github.retrooper.packetevents.factory.spigot.SpigotPacketEventsBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

@KeepClass
public class MyFurniture
extends JavaPlugin
implements SPlugin {
    public static MyFurniture plugin;
    private CommandsClass commandClass;
    public static final String NAME = "MyFurniture";
    public static final String NAME_COLOR = "&5MyFurniture";
    public static final String NAME_COLOR_WITH_BRACKETS = "&a5[MyFurniture]";
    public static final Material BASE_MATERIAL;

    @KeepMethod
    public void onLoad() {
        boolean packetEventsPresent;
        plugin = this;
        try {
            Class.forName("com.github.retrooper.packetevents.PacketEventsAPI");
            packetEventsPresent = true;
        }
        catch (ClassNotFoundException e) {
            packetEventsPresent = false;
        }
        if (!packetEventsPresent) {
            this.getLogger().info("PacketEvents not found; loading it dynamically...");
            BukkitLibraryManager bukkitLibraryManager = new BukkitLibraryManager((Plugin)plugin);
            bukkitLibraryManager.addRepository("https://repo.codemc.io/repository/maven-snapshots/");
            bukkitLibraryManager.addMavenCentral();
            Library lib = Library.builder().groupId("com{}github{}retrooper").artifactId("packetevents-spigot").version("2.10.0-SNAPSHOT").resolveTransitiveDependencies(true).build();
            bukkitLibraryManager.loadLibrary(lib);
            try {
                PacketEvents.setAPI((PacketEventsAPI)SpigotPacketEventsBuilder.build((Plugin)this));
                PacketEvents.getAPI().load();
            }
            catch (IllegalArgumentException | LinkageError ignored) {
                ignored.printStackTrace();
            }
        } else {
            this.getLogger().info("PacketEvents found in classpath; skipping dynamic load.");
        }
    }

    @KeepMethod
    public void onEnable() {
        if (!Dependency.PACKET_EVENTS.isInstalled()) {
            PacketEvents.getAPI().init();
        }
        int pluginId = 24621;
        Metrics metrics = new Metrics(this, pluginId);
        SimplePie customChart = new SimplePie("premium", () -> !this.isLotOfWork() + "");
        metrics.addCustomChart(customChart);
        if (this.isLotOfWork()) {
            Utils.sendConsoleMsg((String)"&7================ &5MyFurniture &7================");
        } else {
            Utils.sendConsoleMsg((String)"&7========&e*&7======== &5MyFurniture &7========&e*&7========");
        }
        this.commandClass = new CommandsClass(this);
        plugin.saveDefaultConfig();
        MessageMain.getInstance().loadMessagesOf((Plugin)plugin, MessageInterface.getMessagesEnum((MessageInterface[])Message.values()));
        TESTEVENT.startUpdate();
        PlayerSettingsLoader.getInstance().load();
        EventsHandler.getInstance().setup(this);
        GeneralConfig.getInstance();
        if (!TexturesPackLoader.isPackFolderExists() || GeneralConfig.getInstance().getBooleanSetting(GeneralConfig.Setting.downloadAndExtractAtNextRestart.name())) {
            TexturesPackLoader.downloadPack((CommandSender)Bukkit.getConsoleSender(), true);
            TexturesPackLoader.unzipPack();
            new TexturesPackLoader().runPackCommand(new String[0]);
            GeneralConfig.getInstance().setBooleanSetting(GeneralConfig.Setting.downloadAndExtractAtNextRestart.name(), false);
        }
        if (GeneralConfig.getInstance().getBooleanSetting(GeneralConfig.Setting.selfHostPack.name())) {
            MyFurniturePack.registerPack();
        }
        FurnitureLoader.getInstance().load();
        this.getCommand("mf").setExecutor((CommandExecutor)this.commandClass);
        if (SCore.hasPlaceholderAPI) {
            new PlaceholderAPISCoreExpansion(this).register();
        }
        FurniturePlacedManager.getInstance().cacheAllEntities();
        StorageEntityManager.getInstance().addAllEntities();
        if (this.isLotOfWork()) {
            Utils.sendConsoleMsg((String)"&7================ &5MyFurniture &7================");
        } else {
            Utils.sendConsoleMsg((String)"&7========&e*&7======== &5MyFurniture &7========&e*&7========");
        }
        Bukkit.getPluginManager().callEvent((Event)new MyFurniturePostLoadEvent());
    }

    public void onReload(boolean PluginCommand2) {
        if (this.isLotOfWork()) {
            Utils.sendConsoleMsg((String)"&7================ &5MyFurniture &7================");
        } else {
            Utils.sendConsoleMsg((String)"&7========&e*&7======== &5MyFurniture &7========&e*&7========");
        }
        plugin.saveDefaultConfig();
        GeneralConfig.getInstance().reload();
        OptimizedEventsHandler.getInstance().reload();
        MessageMain.getInstance().loadMessagesOf((Plugin)plugin, MessageInterface.getMessagesEnum((MessageInterface[])Message.values()));
        FurnitureLoader.getInstance().reload();
        for (FurniturePlaced eBP : FurniturePlacedManager.getInstance().getAllFurniturePlaced().values()) {
            Location holoLoc;
            Furniture nEB = eBP.getFurniture();
            if (nEB == null || (holoLoc = nEB.getTitle().update(eBP.getHoloLocation(), eBP.getLocation(), eBP.getPlaceholders())) == null) continue;
            eBP.setHoloLocation(holoLoc);
        }
        if (this.isLotOfWork()) {
            Utils.sendConsoleMsg((String)"&7================ &5MyFurniture &7================");
        } else {
            Utils.sendConsoleMsg((String)"&7========&e*&7======== &5MyFurniture &7========&e*&7========");
        }
    }

    @KeepMethod
    public void onDisable() {
        PacketEvents.getAPI().terminate();
        MyFurniturePack.unregisterPack();
    }

    public static MyFurniture getPluginSt() {
        return plugin;
    }

    @KeepMethod
    public String getNameDesign() {
        return NAME_COLOR;
    }

    @KeepMethod
    public String getNameDesignWithBrackets() {
        return NAME_COLOR_WITH_BRACKETS;
    }

    @KeepMethod
    public String getObjectName() {
        return "furniture";
    }

    public String getObjectNameForPermission(SObject sObject) {
        if (sObject instanceof Furniture) {
            return "furniture";
        }
        if (sObject instanceof FurniturePlaced) {
            return "";
        }
        if (sObject instanceof PlayerSettings) {
            return "";
        }
        return "furniture";
    }

    @KeepMethod
    public Plugin getPlugin() {
        return MyFurniture.getPluginSt();
    }

    @KeepMethod
    public String getShortName() {
        return "MF";
    }

    @KeepMethod
    public String getNameWithBrackets() {
        return "[MyFurniture]";
    }

    @KeepMethod
    public boolean isLotOfWork() {
        return PlaceholderAPI.isLotOfWork();
    }

    @KeepMethod
    public int getMaxSObjectsLimit() {
        return 300;
    }

    @KeepMethod
    public Config getPluginConfig() {
        return GeneralConfig.getInstance();
    }

    static {
        BASE_MATERIAL = Material.BLUE_CANDLE;
    }
}

