/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.configs;

import com.ssomar.myfurniture.MyFurniture;
import com.ssomar.score.SCore;
import com.ssomar.score.config.Config;
import com.ssomar.score.usedapi.AllWorldManager;
import com.ssomar.score.utils.obfuscation.KeepMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.plugin.Plugin;

public class GeneralConfig
extends Config {
    private static GeneralConfig instance;
    private List<String> whitelistedWorlds;
    private ItemDisplay.ItemDisplayTransform displayDefaultTransform;
    private String texturesPackUrl;

    public GeneralConfig() {
        super("config.yml");
        super.setup((Plugin)MyFurniture.plugin);
    }

    @KeepMethod
    public boolean converter(FileConfiguration fileConfiguration) {
        if (!fileConfiguration.contains("config_12_04_2024")) {
            fileConfiguration.set("config_12_04_2024", (Object)true);
            fileConfiguration.set("premiumEnableCooldownForOp", fileConfiguration.get("premium-enable-cooldown-for-op", (Object)true));
            fileConfiguration.set("premium-enable-cooldown-for-op", null);
            fileConfiguration.set("silentGive", fileConfiguration.get("silentEBGive", (Object)true));
            fileConfiguration.set("silentEBGive", null);
            return true;
        }
        return false;
    }

    @KeepMethod
    public void load() {
        this.loadBooleanSetting(Setting.premiumEnableCooldownForOp.name(), true);
        this.loadBooleanSetting(Setting.checkVersionMsg.name(), true);
        this.loadIntSetting(Setting.giveLimit.name(), 100);
        this.loadBooleanSetting(Setting.silentGive.name(), false);
        this.loadIntSetting(Setting.displayDefaultPitch.name(), 90);
        this.loadDoubleSetting(Setting.displayDefaultScale.name(), 1.0);
        this.loadIntSetting(Setting.maxFurniturePlacedUsingCommand.name(), 500);
        this.loadBooleanSetting(Setting.downloadAndExtractAtNextRestart.name(), true);
        this.loadBooleanSetting(Setting.selfHostPack.name(), true);
        if (SCore.is1v19v4Plus()) {
            this.displayDefaultTransform = ItemDisplay.ItemDisplayTransform.valueOf((String)this.config.getString("displayDefaultTransform", "NONE").toUpperCase());
        }
        this.whitelistedWorlds = new ArrayList<String>();
        for (String str : this.config.getStringList("whitelistedWorlds")) {
            Optional worldOptional = AllWorldManager.getWorld((String)str);
            if (worldOptional.isPresent()) {
                this.whitelistedWorlds.add(str);
                continue;
            }
            MyFurniture.plugin.getServer().getLogger().severe("[MyFurniture] Invalid world: " + str + " in the option whitelistedWorlds");
        }
        if (!this.whitelistedWorlds.isEmpty()) {
            MyFurniture.plugin.getServer().getLogger().info("[MyFurniture] MyFurniture is enabled only in the worlds: ");
            for (String str : this.whitelistedWorlds) {
                MyFurniture.plugin.getServer().getLogger().info("[MyFurniture] " + str);
            }
        }
        this.texturesPackUrl = this.getBooleanSetting(Setting.selfHostPack.name()) ? "" : this.config.getString("texturesPackUrl", "");
    }

    public static GeneralConfig getInstance() {
        if (instance == null) {
            instance = new GeneralConfig();
        }
        return instance;
    }

    public void reload() {
        instance = new GeneralConfig();
    }

    public List<String> getWhitelistedWorlds() {
        return this.whitelistedWorlds;
    }

    public ItemDisplay.ItemDisplayTransform getDisplayDefaultTransform() {
        return this.displayDefaultTransform;
    }

    public String getTexturesPackUrl() {
        return this.texturesPackUrl;
    }

    public void setWhitelistedWorlds(List<String> whitelistedWorlds) {
        this.whitelistedWorlds = whitelistedWorlds;
    }

    public void setDisplayDefaultTransform(ItemDisplay.ItemDisplayTransform displayDefaultTransform) {
        this.displayDefaultTransform = displayDefaultTransform;
    }

    public void setTexturesPackUrl(String texturesPackUrl) {
        this.texturesPackUrl = texturesPackUrl;
    }

    public static enum Setting {
        premiumEnableCooldownForOp,
        checkVersionMsg,
        giveLimit,
        silentGive,
        displayDefaultPitch,
        displayDefaultScale,
        downloadAndExtractAtNextRestart,
        maxFurniturePlacedUsingCommand,
        selfHostPack;

    }
}

