/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.commands;

import com.ssomar.myfurniture.MyFurniture;
import com.ssomar.myfurniture.commands.PlaceCommand;
import com.ssomar.myfurniture.commands.RemoveCommand;
import com.ssomar.myfurniture.commands.VariableModificationCommand;
import com.ssomar.myfurniture.configs.GeneralConfig;
import com.ssomar.myfurniture.editor.FurnituresEditor;
import com.ssomar.myfurniture.editor.FurnituresPlacedEditor;
import com.ssomar.myfurniture.furniture.Furniture;
import com.ssomar.myfurniture.furniture.FurnitureLoader;
import com.ssomar.myfurniture.furniture.FurnitureManager;
import com.ssomar.myfurniture.furniture.FurnitureObject;
import com.ssomar.myfurniture.furniture.placedfurniture.FilterFurniturePlaced;
import com.ssomar.myfurniture.furniture.placedfurniture.FurniturePlaced;
import com.ssomar.myfurniture.furniture.placedfurniture.FurniturePlacedManager;
import com.ssomar.myfurniture.furniture.placedfurniture.SortFurniturePlaced;
import com.ssomar.myfurniture.listeners.EventsManager;
import com.ssomar.myfurniture.listeners.optimize.OptimizedEventsHandler;
import com.ssomar.myfurniture.pack.MyFurniturePack;
import com.ssomar.myfurniture.playersettings.PlayerSettings;
import com.ssomar.myfurniture.playersettings.PlayerSettingsManager;
import com.ssomar.myfurniture.texturesloader.TexturesPackLoader;
import com.ssomar.score.actionbar.ActionbarCommands;
import com.ssomar.score.api.executableitems.events.RemoveItemInPlayerInventoryEvent;
import com.ssomar.score.commands.score.CommandsClassAbstract;
import com.ssomar.score.commands.score.DropCommand;
import com.ssomar.score.commands.score.GiveCommand;
import com.ssomar.score.commands.score.GiveFolderCommand;
import com.ssomar.score.commands.score.clear.ClearCommand;
import com.ssomar.score.commands.score.clear.ClearType;
import com.ssomar.score.editor.SaveSessionPathManager;
import com.ssomar.score.features.custom.variables.real.VariableReal;
import com.ssomar.score.sobject.SObjectManager;
import com.ssomar.score.sobject.SObjectWithFileManager;
import com.ssomar.score.sobject.menu.NewSObjectsManagerEditor;
import com.ssomar.score.sobject.menu.SObjectsEditorAbstract;
import com.ssomar.score.sobject.sactivator.EventInfo;
import com.ssomar.score.sobject.sactivator.OptionGlobal;
import com.ssomar.score.sobject.sactivator.SOption;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.usedapi.AllWorldManager;
import com.ssomar.score.utils.logging.Utils;
import com.ssomar.score.utils.numbers.NTools;
import com.ssomar.score.utils.obfuscation.KeepMethod;
import com.ssomar.score.utils.place.OverrideMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class CommandsClass
extends CommandsClassAbstract<MyFurniture> {
    private final GiveCommand<MyFurniture, FurnitureManager, Furniture> giveCommand;
    private final GiveFolderCommand<MyFurniture, FurnitureManager, Furniture> giveFolderCommand;
    private final DropCommand<MyFurniture, FurnitureManager, Furniture> dropCommand;

    public CommandsClass(MyFurniture main) {
        super((SPlugin)main);
        this.addCommand("reload");
        this.addCommand("show");
        this.addCommand("show-placed");
        this.addCommand("editor");
        this.addCommand("edit");
        this.addCommand("take");
        this.addCommand("drop");
        this.addCommand("place");
        this.addCommand("replace");
        this.addCommand("remove");
        this.addCommand("we-place");
        this.addCommand("we-replace");
        this.addCommand("we-remove");
        this.addCommand("wg-fill-region");
        this.addCommand("inspect");
        this.addCommand("clear");
        this.addCommand("actionbar");
        this.addCommand("delete");
        this.addCommand("delete-placed");
        this.addCommand("checkevents");
        this.addCommand("modification");
        this.addCommand("pack");
        this.addCommand("download-default-pack");
        this.addCommand("run-custom-trigger");
        this.addCommand("remove-all-furniture-placed");
        this.addCommand("settings");
        this.giveCommand = new GiveCommand((SPlugin)MyFurniture.plugin, (SObjectManager)FurnitureManager.getInstance());
        this.addCommands(this.giveCommand.getCommands());
        this.giveFolderCommand = new GiveFolderCommand((SPlugin)MyFurniture.plugin, (SObjectWithFileManager)FurnitureManager.getInstance());
        this.addCommands(this.giveFolderCommand.getCommands());
        this.dropCommand = new DropCommand((SPlugin)MyFurniture.plugin, (SObjectManager)FurnitureManager.getInstance());
        this.addCommands(this.dropCommand.getCommands());
    }

    public void runCommand(CommandSender sender, Player player, String command, String[] args, String typedCommand) {
        block30 : switch (command) {
            case "pack": {
                this.getSm().sendMessage(sender, ((MyFurniture)this.getSPlugin()).getNameDesign() + " &7Command executed, loading in progress, check the console for more information !");
                new TexturesPackLoader().runPackCommand(args);
                this.getSm().sendMessage(sender, ((MyFurniture)this.getSPlugin()).getNameDesign() + " &7Command executed, process finished, check the console for more information ! (You can do /mf show)");
                if (!GeneralConfig.getInstance().getBooleanSetting(GeneralConfig.Setting.selfHostPack.name())) break;
                MyFurniturePack.unregisterPack();
                MyFurniturePack.registerPack();
                break;
            }
            case "download-default-pack": {
                TexturesPackLoader.downloadPack(sender, true);
                TexturesPackLoader.unzipPack();
                this.getSm().sendMessage(sender, ((MyFurniture)this.getSPlugin()).getNameDesign() + " &7Default pack downloaded and unzipped !");
                break;
            }
            case "reload": {
                if (args.length < 1) {
                    ((MyFurniture)this.getSPlugin()).onReload(true);
                    this.getSm().sendMessage(sender, ((MyFurniture)this.getSPlugin()).getNameDesign() + " &7has been reloaded !");
                    Utils.sendConsoleMsg((String)(((MyFurniture)this.getSPlugin()).getNameDesign() + " &7Successfully reloaded !"));
                    break;
                }
                String idToReload = args[0];
                if (idToReload.contains("folder:")) {
                    String folderName = idToReload.replace("folder:", "");
                    if (FurnitureLoader.getInstance().reloadFolder(folderName)) {
                        this.getSm().sendMessage(sender, ((MyFurniture)this.getSPlugin()).getNameDesign() + " &7The folder &e" + folderName + " &7has been reloaded !");
                        break;
                    }
                    this.getSm().sendMessage(sender, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cThe folder &6" + folderName + " &cdoes not exist !");
                    break;
                }
                if (FurnitureManager.getInstance().isValidID(idToReload)) {
                    FurnitureManager.getInstance().reloadObject(idToReload);
                    this.getSm().sendMessage(sender, ((MyFurniture)this.getSPlugin()).getNameDesign() + " &7Furniture &e" + idToReload + " &7has been reloaded !");
                    break;
                }
                this.getSm().sendMessage(sender, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cThe ID " + idToReload + " specified is not valid !");
                break;
            }
            case "inspect": {
                if (player == null) break;
                ItemStack item = player.getInventory().getItemInMainHand();
                FurnitureObject eb = new FurnitureObject(item);
                if (eb.isValid()) {
                    eb.loadFurnitureInfos();
                    this.getSm().sendMessage(sender, ((MyFurniture)this.getSPlugin()).getNameDesign() + " &aItem information :");
                    this.getSm().sendMessage(sender, "&6>> &eFurniture usage: &6" + eb.getUsage());
                    UUID ownerUUID = eb.getInternalData().getOwnerUUID();
                    if (ownerUUID != null) {
                        this.getSm().sendMessage(sender, "&6>> &eFurniture owner (UUID): &6" + ownerUUID);
                        try {
                            this.getSm().sendMessage(sender, "&6>> &eFurniture owner (name): &6" + Bukkit.getOfflinePlayer((UUID)ownerUUID).getName());
                        }
                        catch (Exception exception) {}
                    } else {
                        this.getSm().sendMessage(sender, "&6>> &eFurniture owner (UUID): &cNo owner");
                        this.getSm().sendMessage(sender, "&6>> &eFurniture owner (name): &cNo owner");
                    }
                    this.getSm().sendMessage(sender, "&6>> &eFurniture id: &6" + eb.getConfig().getId());
                    for (VariableReal vR : eb.getInternalData().getVariableRealsList()) {
                        this.getSm().sendMessage(sender, "&6>> &eVar &aSCORE-" + ((String)vR.getConfig().getVariableName().getValue().get()).toUpperCase() + ": &6" + vR.getValue());
                    }
                    break;
                }
                this.getSm().sendMessage(sender, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cError no info for this item, it's not an Furniture");
                break;
            }
            case "checkevents": {
                OptimizedEventsHandler.getInstance().displayOptimisation();
                this.getSm().sendMessage(sender, ((MyFurniture)this.getSPlugin()).getNameDesign() + " &7Check events sent in your console !");
                break;
            }
            case "edit": {
                if (player == null) break;
                if (args.length > 0) {
                    try {
                        Optional eb = FurnitureManager.getInstance().getLoadedObjectWithID(args[0]);
                        if (eb.isPresent()) {
                            ((Furniture)((Object)eb.get())).openEditor(player);
                            break;
                        }
                        this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cThis Furniture &6" + args[0] + " &cdoesn't exist");
                    }
                    catch (NullPointerException e) {
                        this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cError > Invalid FurnitureID &6/eb edit {FurnitureID}");
                    }
                    break;
                }
                this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cError > Invalid BlockID &6/eb edit {BlockID}");
                break;
            }
            case "we-place": {
                if (player != null) {
                    PlaceCommand.sendPlace(player, args);
                    break;
                }
                this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cERROR this command must be executed by a player");
                break;
            }
            case "we-replace": {
                if (player != null) {
                    PlaceCommand.sendReplace(player, args);
                    break;
                }
                this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cERROR this command must be executed by a player");
                break;
            }
            case "we-remove": {
                if (player != null) {
                    RemoveCommand.sendRemove(player, args);
                    break;
                }
                this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cERROR this command must be executed by a player");
                break;
            }
            case "wg-fill-region": {
                PlaceCommand.fillRegion(player, args);
                break;
            }
            case "show": 
            case "editor": {
                if (player == null) break;
                NewSObjectsManagerEditor.getInstance().startEditing(player, (SObjectsEditorAbstract)new FurnituresEditor());
                break;
            }
            case "show-placed": {
                if (player == null) break;
                Comparator<FurniturePlaced> sortEBP = null;
                ArrayList<Predicate<FurniturePlaced>> filters = new ArrayList<Predicate<FurniturePlaced>>();
                if (args.length >= 1) {
                    for (String arg : args) {
                        String[] split;
                        if (arg.contains("sort:")) {
                            split = arg.split(":");
                            if (split.length < 2) continue;
                            sortEBP = SortFurniturePlaced.valueOf(split[1].toUpperCase()).getComparator();
                            continue;
                        }
                        if (!arg.contains("filter") || (split = arg.split(":")).length < 3) continue;
                        filters.add(FilterFurniturePlaced.valueOf(split[1].toUpperCase()).getPredicate(split[2]));
                    }
                }
                FurnituresPlacedEditor editor = new FurnituresPlacedEditor();
                boolean reload = false;
                if (filters.size() > 0) {
                    editor.setPredicates(filters);
                    reload = true;
                }
                if (sortEBP != null) {
                    editor.setComparator(sortEBP);
                    reload = true;
                }
                if (reload) {
                    editor.load();
                }
                NewSObjectsManagerEditor.getInstance().startEditing(player, (SObjectsEditorAbstract)editor);
                break;
            }
            case "take": {
                if (args.length >= 2) {
                    Player target = sender.getServer().getPlayerExact(args[0]);
                    if (target == null) {
                        this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cInvalid player for &6" + args[0] + "&c, verify that the player exist !");
                        return;
                    }
                    if (!FurnitureLoader.getInstance().getAllObjects().contains(args[1])) {
                        this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cThis furniture doesn't exist pls enter a good ID &6/eb take {playerName} {furnitureID} {quantity}");
                        return;
                    }
                    int quantity = 1;
                    if (args.length == 3) {
                        try {
                            quantity = Integer.valueOf(args[2]);
                        }
                        catch (Exception editor) {
                            // empty catch block
                        }
                    }
                    PlayerInventory inv = target.getInventory();
                    int slot = 0;
                    for (ItemStack is : inv.getContents()) {
                        Furniture i;
                        Optional<Furniture> ebOpt;
                        if (quantity == 0) break block30;
                        if (is != null && (ebOpt = FurnitureManager.getInstance().getFurniture(is)).isPresent() && (i = ebOpt.get()).getId().equals(args[1])) {
                            RemoveItemInPlayerInventoryEvent eventToCall = new RemoveItemInPlayerInventoryEvent(target, is, slot);
                            Bukkit.getPluginManager().callEvent((Event)eventToCall);
                            if (is.getAmount() <= quantity) {
                                quantity -= is.getAmount();
                                is.setAmount(0);
                            } else {
                                is.setAmount(is.getAmount() - quantity);
                                quantity = 0;
                            }
                        }
                        ++slot;
                    }
                    break;
                }
                this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cInvalid command, look the example: &6/eb take {playerName} {itemID} {quantity}");
                break;
            }
            case "clear": {
                ClearCommand.clearCmd((SPlugin)MyFurniture.plugin, (CommandSender)sender, (String[])args);
                break;
            }
            case "actionbar": {
                if (sender instanceof Player) {
                    if (args.length == 1) {
                        ActionbarCommands.manageCommand((Player)((Player)sender), (String)args[0]);
                        break;
                    }
                    this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &6/eb actionbar on &cor &6/eb actionbar off");
                    break;
                }
                this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cThis is only an In-game command !");
                break;
            }
            case "settings": {
                if (sender instanceof Player) {
                    SaveSessionPathManager.getInstance().clearPlayerSessionPath(player);
                    PlayerSettings playerSettings = PlayerSettingsManager.getInstance().getLoadedObjectWithID(((Player)sender).getUniqueId().toString()).orElse(null);
                    playerSettings.openEditor((Player)sender);
                    break;
                }
                this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cThis is only an In-game command !");
                break;
            }
            case "delete": {
                if (args.length == 2) {
                    if (!args[1].equalsIgnoreCase("confirm")) {
                        this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cTo confirm the delete type &6/mf delete {furnitureID} confirm");
                        return;
                    }
                    Optional eiOpt = FurnitureManager.getInstance().getLoadedObjectWithID(args[0]);
                    if (eiOpt.isPresent()) {
                        for (FurniturePlaced ebp : FurniturePlacedManager.getInstance().getAllFurniturePlaced().values()) {
                            if (!ebp.getMF_ID().equals(args[0])) continue;
                            ebp.remove();
                        }
                        FurnitureManager.getInstance().deleteObject(args[0]);
                        this.getSm().sendMessage(sender, ((MyFurniture)this.getSPlugin()).getNameDesign() + " &7Furniture &e" + args[0] + " &7deleted");
                        if (player == null) break;
                        NewSObjectsManagerEditor.getInstance().startEditing(player, (SObjectsEditorAbstract)new FurnituresEditor());
                        break;
                    }
                    this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cFurniture &6" + args[0] + " &cnot found");
                    break;
                }
                this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cTo confirm the delete type &6/mf delete {furnitureID} confirm &7&o&lIt will also delete the furniture placed");
                break;
            }
            case "delete-placed": {
                if (args.length == 2) {
                    if (!args[1].equalsIgnoreCase("confirm")) {
                        this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cTo confirm the delete type &6/mf delete-placed {mfUUID} confirm");
                        return;
                    }
                    Optional<FurniturePlaced> mfPlacedOpt = FurniturePlacedManager.getInstance().getFurniturePlaced(args[0]);
                    if (mfPlacedOpt.isPresent()) {
                        FurniturePlaced furniturePlaced = mfPlacedOpt.get();
                        furniturePlaced.remove();
                        this.getSm().sendMessage(sender, ((MyFurniture)this.getSPlugin()).getNameDesign() + " &7Furniture placed &e" + args[0] + " &7deleted");
                        break;
                    }
                    this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cFurniture placed &6" + args[0] + " &cnot found");
                    break;
                }
                this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cTo confirm the delete type &6/mf delete-placed {mfUUID} confirm");
                break;
            }
            case "place": {
                if (args.length == 5) {
                    Optional oOpt = FurnitureManager.getInstance().getLoadedObjectWithID(args[0]);
                    if (!oOpt.isPresent()) {
                        this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cInvalid furniture id: &6" + args[0] + " &7&o/mf place {MF_ID} {x} {y} {z} {world}");
                        return;
                    }
                    Furniture executableBlock = (Furniture)((Object)oOpt.get());
                    if (!NTools.isNumber((String)args[1])) {
                        this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cInvalid X position: &6" + args[1] + " &7&o/mf place {MF_ID} {x} {y} {z} {world}");
                        return;
                    }
                    double x = Double.valueOf(args[1]);
                    if (!NTools.isNumber((String)args[2])) {
                        this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cInvalid Y position: &6" + args[2] + " &7&o/mf place {MF_ID} {x} {y} {z} {world}");
                        return;
                    }
                    double y = Double.valueOf(args[2]);
                    if (!NTools.isNumber((String)args[3])) {
                        this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cInvalid Z position: &6" + args[3] + " &7&o/mf place {MF_ID} {x} {y} {z} {world}");
                        return;
                    }
                    double z = Double.valueOf(args[3]);
                    if (Bukkit.getServer().getWorld(args[4]) == null) {
                        this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cInvalid world: &6" + args[4] + " &7&o/mf place {MF_ID} {x} {y} {z} {world}");
                        return;
                    }
                    World world = Bukkit.getServer().getWorld(args[4]);
                    Location loc = new Location(world, x, y, z).getBlock().getLocation();
                    executableBlock.place(loc, OverrideMode.KEEP_EXISTING, (Entity)player, null);
                    break;
                }
                this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cError not enough arguments : &6/mf place {MF_ID} {x} {y} {z} {world} ");
                break;
            }
            case "replace": {
                if (args.length == 2) {
                    Optional<FurniturePlaced> furniturePlacedOpt = FurniturePlacedManager.getInstance().getFurniturePlaced(args[0]);
                    if (!furniturePlacedOpt.isPresent()) {
                        this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cInvalid furniture id: &6" + args[0] + " &7&o/mf replace {MF_PLACED_UUID} {MF_ID}");
                        return;
                    }
                    FurniturePlaced furniturePlaced = furniturePlacedOpt.get();
                    Optional furnitureConfigOpt = FurnitureManager.getInstance().getLoadedObjectWithID(args[1]);
                    if (!furnitureConfigOpt.isPresent()) {
                        this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cInvalid furniture id: &6" + args[1] + " &7&o/mf replace {MF_PLACED_UUID} {MF_ID}");
                        return;
                    }
                    Furniture furnitureConfig = (Furniture)((Object)furnitureConfigOpt.get());
                    furniturePlaced.replaceFurnitureConfig(furnitureConfig);
                    break;
                }
                this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cError not enough arguments : &6/mf replace {MF_PLACED_UUID} {MF_ID}");
                break;
            }
            case "remove": {
                if (args.length >= 4) {
                    boolean replaceair = true;
                    if (!NTools.isNumber((String)args[0])) {
                        this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cInvalid X position: &6" + args[0] + " &7&o/mf remove {x} {y} {z} {world}");
                        return;
                    }
                    double x = Double.valueOf(args[0]);
                    if (!NTools.isNumber((String)args[1])) {
                        this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cInvalid Y position: &6" + args[1] + " &7&o/mf remove {x} {y} {z} {world}");
                        return;
                    }
                    double y = Double.valueOf(args[1]);
                    if (!NTools.isNumber((String)args[2])) {
                        this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cInvalid Z position: &6" + args[2] + " &7&o/mf remove {x} {y} {z} {world}");
                        return;
                    }
                    double z = Double.valueOf(args[2]);
                    if (Bukkit.getServer().getWorld(args[3]) == null) {
                        this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cInvalid world: &6" + args[3] + " &7&o/mf remove {x} {y} {z} {world}");
                        return;
                    }
                    World world = Bukkit.getServer().getWorld(args[3]);
                    if (args.length == 5) {
                        replaceair = Boolean.parseBoolean(args[4]);
                    }
                    Block block = new Location(world, x, y, z).getBlock();
                    Optional<FurniturePlaced> eBPOpt = FurniturePlacedManager.getInstance().getFurniturePlaced(block);
                    if (!eBPOpt.isPresent()) break;
                    FurniturePlaced eBP = eBPOpt.get();
                    FurniturePlacedManager.getInstance().removeFurniturePlaced(eBP);
                    if (!replaceair) break;
                    block.setType(Material.AIR);
                    break;
                }
                this.getSm().sendMessage(player, "&c" + MyFurniture.plugin.getNameWithBrackets() + " &cError not enough arguments : &6/mf remove {x} {y} {z} {world} ");
                break;
            }
            case "modification": {
                VariableModificationCommand varModif = new VariableModificationCommand("modification", args, player);
                varModif.run();
                break;
            }
            case "run-custom-trigger": {
                ArrayList<String> trigger = new ArrayList<String>();
                Optional<Object> loc = Optional.empty();
                HashMap<String, String> otherArgs = new HashMap<String, String>();
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].startsWith("trigger:")) {
                        String triggerStr = args[i].replace("trigger:", "");
                        if (triggerStr.startsWith("[") && triggerStr.endsWith("]")) {
                            String[] triggers;
                            triggerStr = triggerStr.replace("[", "");
                            triggerStr = triggerStr.replace("]", "");
                            for (String t : triggers = triggerStr.split(",")) {
                                trigger.add(t);
                            }
                            continue;
                        }
                        trigger.add(triggerStr);
                        continue;
                    }
                    if (args[i].startsWith("block:")) {
                        World world;
                        String blockStr = args[i].replace("block:", "");
                        String[] block = blockStr.split(":");
                        if (block.length != 4 || (world = AllWorldManager.getWorld((String)block[0]).orElseGet(() -> Bukkit.getWorld((String)block[0]))) == null) continue;
                        double x = Double.parseDouble(block[1]);
                        double y = Double.parseDouble(block[2]);
                        double z = Double.parseDouble(block[3]);
                        loc = Optional.of(new Location(world, x, y, z));
                        continue;
                    }
                    otherArgs.put("%arg" + otherArgs.size() + "%", args[i]);
                }
                String allArgs = "";
                for (String arg : args) {
                    allArgs = allArgs + arg + " ";
                }
                if (!allArgs.isEmpty()) {
                    allArgs = allArgs.substring(0, allArgs.length() - 1);
                }
                otherArgs.put("%all_args%", allArgs);
                EventInfo eInfo = new EventInfo(null);
                eInfo.setOption((SOption)OptionGlobal.CUSTOM_TRIGGER);
                eInfo.setWhitelistActivatorsId(trigger);
                eInfo.setPlaceholders(otherArgs);
                if (loc.isPresent()) {
                    Optional<FurniturePlaced> eBPOpt = FurniturePlacedManager.getInstance().getFurniturePlaced((Location)loc.get());
                    if (!eBPOpt.isPresent()) {
                        return;
                    }
                    FurniturePlaced eBP = eBPOpt.get();
                    EventsManager.getInstance().activeOption(eBP, eInfo);
                    break;
                }
                EventsManager.getInstance().activeOptionAllFP(eInfo);
                break;
            }
            case "remove-all-furniture-placed": {
                FurniturePlacedManager.getInstance().getAllFurniturePlaced().values().forEach(FurniturePlaced::remove);
                this.getSm().sendMessage(sender, ((MyFurniture)this.getSPlugin()).getNameDesign() + " &7All furniture placed removed !");
                break;
            }
            default: {
                this.giveCommand.run(sender, command, args, typedCommand);
                this.giveFolderCommand.run(sender, command, args, typedCommand);
                this.dropCommand.run(sender, command, args, typedCommand);
            }
        }
    }

    @KeepMethod
    public List<String> getOnTabCompleteArguments(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (args.length >= 2) {
            switch (args[0]) {
                case "show-placed": {
                    for (SortFurniturePlaced sortFurniturePlaced : SortFurniturePlaced.values()) {
                        arguments.add("sort:" + sortFurniturePlaced.toString());
                    }
                    for (Enum enum_ : FilterFurniturePlaced.values()) {
                        arguments.add("filter:" + enum_.toString() + ":????");
                    }
                    return arguments;
                }
                case "clear": {
                    if (args.length != 3) break;
                    for (ClearType clearType : ClearType.values()) {
                        arguments.add(clearType.name());
                    }
                    return arguments;
                }
                case "take": {
                    if (args.length == 3) {
                        return FurnitureManager.getInstance().getLoadedObjectsWith(args[2]);
                    }
                    if (args.length == 4) {
                        arguments.addAll(CommandsClass.getArgumentsQuantity());
                        return arguments;
                    }
                }
                case "edit": {
                    if (args.length != 2) break;
                    return FurnitureManager.getInstance().getLoadedObjectsWith(args[1]);
                }
                case "actionbar": {
                    if (args.length != 2) break;
                    arguments.add("on");
                    arguments.add("off");
                    return arguments;
                }
                case "test": {
                    if (args.length != 2) break;
                    arguments.add("idle");
                    arguments.add("open");
                    arguments.add("noanim");
                    return arguments;
                }
                case "place": {
                    if (args.length == 2) {
                        return FurnitureManager.getInstance().getLoadedObjectsWith(args[1]);
                    }
                    if (args.length != 6) break;
                    for (World world : Bukkit.getServer().getWorlds()) {
                        arguments.add(world.getName());
                    }
                    return arguments;
                }
                case "replace": {
                    if (args.length == 2) {
                        return FurniturePlacedManager.getInstance().getLoadedObjectsWith(args[1]);
                    }
                    if (args.length != 3) break;
                    return FurnitureManager.getInstance().getLoadedObjectsWith(args[2]);
                }
                case "reload": {
                    if (args.length != 2) break;
                    arguments.addAll(FurnitureManager.getInstance().getLoadedObjectsWith(args[1]));
                    for (String str : FurnitureLoader.getInstance().getAllFoldersName()) {
                        arguments.add("folder:" + str);
                    }
                    return arguments;
                }
                case "remove": {
                    if (args.length == 2) {
                        return FurnitureManager.getInstance().getLoadedObjectsWith(args[1]);
                    }
                    if (args.length != 6) break;
                    for (World world : Bukkit.getServer().getWorlds()) {
                        arguments.add(world.getName());
                    }
                    return arguments;
                }
                case "we-place": {
                    if (args.length != 2) break;
                    return FurnitureManager.getInstance().getLoadedObjectsWith(args[1]);
                }
                case "we-remove": {
                    if (args.length != 2) break;
                    arguments.add("true");
                    arguments.add("false");
                    return arguments;
                }
                case "delete": {
                    if (args.length == 2) {
                        return FurnitureManager.getInstance().getLoadedObjectsWith(args[1]);
                    }
                    if (args.length == 3) {
                        arguments.add("confirm");
                        return arguments;
                    }
                }
                case "modification": {
                    if (args.length == 2) {
                        arguments.add("set");
                        arguments.add("modification");
                        return arguments;
                    }
                    if (args.length != 3) break;
                    arguments.add("usage");
                    arguments.add("variable");
                    return arguments;
                }
                default: {
                    arguments.addAll(this.giveCommand.getArguments(args[0], args));
                    arguments.addAll(this.giveFolderCommand.getArguments(args[0], args));
                    arguments.addAll(this.dropCommand.getArguments(args[0], args));
                    if (arguments.size() <= 0) break;
                    return arguments;
                }
            }
        }
        return new ArrayList<String>();
    }
}

