/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.listeners.mechanics;

import com.ssomar.myfurniture.api.events.FurniturePlaceEvent;
import com.ssomar.myfurniture.furniture.Furniture;
import com.ssomar.myfurniture.furniture.FurnitureObject;
import com.ssomar.myfurniture.furniture.creations.CreationAbstract;
import com.ssomar.myfurniture.furniture.creations.Creations;
import com.ssomar.myfurniture.furniture.placedfurniture.FurniturePlaced;
import com.ssomar.myfurniture.listeners.fixes.PlacementsNoClickManager;
import com.ssomar.myfurniture.listeners.mechanics.BreakFurnitureListener;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.sobject.InternalData;
import com.ssomar.score.utils.place.OverrideMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class PlaceFurnitureListener
implements Listener {
    private List<Location> firstPlace = new ArrayList<Location>();
    private static boolean DEBUG = true;

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockPlaceEvent(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        Action action = e.getAction();
        if (!action.equals((Object)Action.RIGHT_CLICK_BLOCK) && !action.equals((Object)Action.RIGHT_CLICK_AIR)) {
            SsomarDev.testMsg((String)"PlayerInteractListener >> 0.5 ", (boolean)DEBUG);
            return;
        }
        ItemStack is = e.getItem();
        EquipmentSlot hand = e.getHand();
        if (is == null) {
            return;
        }
        SsomarDev.testMsg((String)"PlayerInteractListener >> 3 ", (boolean)DEBUG);
        FurnitureObject nEBO = new FurnitureObject(is.clone());
        if (!nEBO.isValid()) {
            return;
        }
        SsomarDev.testMsg((String)"PlayerInteractListener >> 4 ", (boolean)DEBUG);
        e.setCancelled(true);
        if (PlacementsNoClickManager.getInstance().isPlacementsNoClick(e.getPlayer().getUniqueId())) {
            SsomarDev.testMsg((String)"PlayerInteractListener >> 0.6 ", (boolean)DEBUG);
            return;
        }
        SsomarDev.testMsg((String)"PlayerInteractListener >> 1 ", (boolean)DEBUG);
        Furniture furniture = nEBO.getConfig();
        CreationAbstract creation = Creations.getCreation(furniture);
        Block clicked = e.getClickedBlock();
        Location loc = null;
        if (clicked != null) {
            Block against = clicked.getRelative(e.getBlockFace());
            loc = against.getLocation();
        }
        SsomarDev.testMsg((String)"PlayerInteractListener >> 4.5 ", (boolean)DEBUG);
        Location locationForCheck = creation.getTheCorrectedPlacementLocation(loc != null ? loc.clone() : null, (Entity)p, e.getBlockFace());
        if (locationForCheck == null || !furniture.checkIfPlayerCanPlaceAt(p, locationForCheck, true)) {
            return;
        }
        SsomarDev.testMsg((String)"PlayerInteractListener >> 4.6 ", (boolean)DEBUG);
        Optional<FurniturePlaced> eBP = nEBO.createFurniturePlaced(loc, OverrideMode.KEEP_EXISTING, (Entity)p, null, new InternalData().setOwnerUUID(p.getUniqueId()), e.getBlockFace());
        if (!eBP.isPresent()) {
            return;
        }
        SsomarDev.testMsg((String)"PlayerInteractListener >> 5 ", (boolean)DEBUG);
        FurniturePlaceEvent eBPEvent = new FurniturePlaceEvent(p, eBP.get(), (Event)e);
        Bukkit.getPluginManager().callEvent((Event)eBPEvent);
        if (eBPEvent.isCancelled()) {
            eBP.get().remove();
            return;
        }
        SsomarDev.testMsg((String)"PlayerInteractListener >> 6 ", (boolean)DEBUG);
        is.setAmount(is.getAmount() - 1);
        BreakFurnitureListener.addCooldown(p, 300L);
        switch (hand) {
            case HAND: {
                p.swingMainHand();
                break;
            }
            case OFF_HAND: {
                p.swingOffHand();
            }
        }
        PlacementsNoClickManager.getInstance().addPlayer(p.getUniqueId());
    }
}

