/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.client;

import com.eerussianguy.firmalife.client.FLClientHelpers;
import com.eerussianguy.firmalife.client.model.BonsaiPlanterBlockModel;
import com.eerussianguy.firmalife.client.model.DynamicBlockModel;
import com.eerussianguy.firmalife.client.model.FoodShelfBlockModel;
import com.eerussianguy.firmalife.client.model.HangerBlockModel;
import com.eerussianguy.firmalife.client.model.HangingPlanterBlockModel;
import com.eerussianguy.firmalife.client.model.HydroponicPlanterBlockModel;
import com.eerussianguy.firmalife.client.model.JarbnetBlockModel;
import com.eerussianguy.firmalife.client.model.JarringStationBlockModel;
import com.eerussianguy.firmalife.client.model.LargePlanterBakedModel;
import com.eerussianguy.firmalife.client.model.PeelModel;
import com.eerussianguy.firmalife.client.model.QuadPlanterBlockModel;
import com.eerussianguy.firmalife.client.model.TrellisPlanterBlockModel;
import com.eerussianguy.firmalife.client.model.WineShelfBlockModel;
import com.eerussianguy.firmalife.client.render.BarrelPressBlockEntityRenderer;
import com.eerussianguy.firmalife.client.render.CompostTumblerBlockEntityRenderer;
import com.eerussianguy.firmalife.client.render.DryingMatBlockEntityRenderer;
import com.eerussianguy.firmalife.client.render.FLBeeRenderer;
import com.eerussianguy.firmalife.client.render.HydroponicPlanterBlockEntityRenderer;
import com.eerussianguy.firmalife.client.render.MixingBowlBlockEntityRenderer;
import com.eerussianguy.firmalife.client.render.OvenBlockEntityRenderer;
import com.eerussianguy.firmalife.client.render.PickerBlockEntityRenderer;
import com.eerussianguy.firmalife.client.render.PlateBlockEntityRenderer;
import com.eerussianguy.firmalife.client.render.PumpingStationBlockEntityRenderer;
import com.eerussianguy.firmalife.client.render.StompingBarrelBlockEntityRenderer;
import com.eerussianguy.firmalife.client.render.StovetopGrillBlockEntityRenderer;
import com.eerussianguy.firmalife.client.render.StovetopPotBlockEntityRenderer;
import com.eerussianguy.firmalife.client.render.StringBlockEntityRenderer;
import com.eerussianguy.firmalife.client.render.SweeperBlockEntityRenderer;
import com.eerussianguy.firmalife.client.render.VatBlockEntityRenderer;
import com.eerussianguy.firmalife.client.screen.BarrelPressScreen;
import com.eerussianguy.firmalife.client.screen.BeehiveScreen;
import com.eerussianguy.firmalife.client.screen.BigBarrelScreen;
import com.eerussianguy.firmalife.client.screen.StovetopGrillScreen;
import com.eerussianguy.firmalife.client.screen.StovetopPotScreen;
import com.eerussianguy.firmalife.common.FLCreativeTabs;
import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.eerussianguy.firmalife.common.capabilities.bee.BeeCapability;
import com.eerussianguy.firmalife.common.capabilities.bee.IBee;
import com.eerussianguy.firmalife.common.container.FLContainerTypes;
import com.eerussianguy.firmalife.common.entities.FLEntities;
import com.eerussianguy.firmalife.common.items.FLFoodTraits;
import com.eerussianguy.firmalife.common.items.FLItems;
import com.eerussianguy.firmalife.common.items.WineBottleItem;
import com.eerussianguy.firmalife.common.misc.FLParticles;
import com.eerussianguy.firmalife.common.misc.SprinklerParticle;
import com.eerussianguy.firmalife.common.util.FLFruit;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.dries007.tfc.client.TFCColors;
import net.dries007.tfc.client.particle.GlintParticleProvider;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.items.TFCItems;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.model.DynamicFluidContainerModel;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

public class FLClientEvents {
    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(FLClientEvents::clientSetup);
        bus.addListener(FLClientEvents::registerEntityRenderers);
        bus.addListener(FLClientEvents::onLayers);
        bus.addListener(FLClientEvents::onModelRegister);
        bus.addListener(FLClientEvents::onBlockColors);
        bus.addListener(FLClientEvents::onItemColors);
        bus.addListener(FLClientEvents::registerParticleFactories);
        bus.addListener(FLClientEvents::registerModels);
        bus.addListener(FLClientEvents::registerLoaders);
        bus.addListener(FLCreativeTabs::onBuildCreativeTab);
    }

    public static void clientSetup(FMLClientSetupEvent event) {
        RenderType solid = RenderType.m_110451_();
        RenderType cutout = RenderType.m_110463_();
        RenderType cutoutMipped = RenderType.m_110457_();
        RenderType translucent = RenderType.m_110466_();
        Stream.of(FLBlocks.OVEN_BOTTOM, FLBlocks.OVEN_TOP, FLBlocks.OVEN_CHIMNEY, FLBlocks.OVEN_HOPPER, FLBlocks.QUAD_PLANTER, FLBlocks.LARGE_PLANTER, FLBlocks.HANGING_PLANTER, FLBlocks.BONSAI_PLANTER, FLBlocks.TRELLIS_PLANTER, FLBlocks.COMPOST_TUMBLER, FLBlocks.CHEDDAR_WHEEL, FLBlocks.RAJYA_METOK_WHEEL, FLBlocks.CHEVRE_WHEEL, FLBlocks.SHOSHA_WHEEL, FLBlocks.FETA_WHEEL, FLBlocks.GOUDA_WHEEL, FLBlocks.SMALL_CHROMITE, FLBlocks.MIXING_BOWL, FLBlocks.BUTTERFLY_GRASS, FLBlocks.VAT, FLBlocks.HYDROPONIC_PLANTER, FLBlocks.STOVETOP_GRILL, FLBlocks.STOVETOP_POT, FLBlocks.DARK_LADDER, FLBlocks.JARRING_STATION, FLBlocks.GRAPE_TRELLIS_POST_RED, FLBlocks.GRAPE_TRELLIS_POST_WHITE, FLBlocks.GRAPE_TRELLIS_POST, FLBlocks.GRAPE_STRING, FLBlocks.GRAPE_STRING_RED, FLBlocks.GRAPE_STRING_WHITE, FLBlocks.GRAPE_STRING_PLANT_RED, FLBlocks.GRAPE_STRING_PLANT_WHITE, FLBlocks.GRAPE_FLUFF_RED, FLBlocks.GRAPE_FLUFF_WHITE, FLBlocks.WILD_WHITE_GRAPES, FLBlocks.WILD_RED_GRAPES, FLBlocks.PUMPING_STATION, FLBlocks.IRRIGATION_TANK).forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)FLBlocks.SOLAR_DRIER.get()), (RenderType)translucent);
        FLBlocks.CHROMITE_ORES.values().forEach(map -> map.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout)));
        FLBlocks.GREENHOUSE_BLOCKS.values().forEach(map -> map.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout)));
        FLBlocks.FRUIT_TREE_LEAVES.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), layer -> Minecraft.m_91405_() ? layer == cutoutMipped : layer == solid));
        FLBlocks.FRUIT_TREE_SAPLINGS.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        FLBlocks.FRUIT_TREE_POTTED_SAPLINGS.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        FLBlocks.STATIONARY_BUSHES.values().forEach(bush -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)bush.get()), (RenderType)cutoutMipped));
        FLBlocks.HERBS.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        FLBlocks.POTTED_HERBS.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        FLBlocks.FOOD_SHELVES.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        FLBlocks.HANGERS.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        FLBlocks.JARBNETS.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        FLBlocks.STOMPING_BARRELS.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        FLBlocks.BARREL_PRESSES.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        FLBlocks.WINE_SHELVES.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        FLBlocks.CURED_OVEN_BOTTOM.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        FLBlocks.CURED_OVEN_TOP.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        FLBlocks.CURED_OVEN_HOPPER.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        FLBlocks.CURED_OVEN_CHIMNEY.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        FLBlocks.INSULATED_OVEN_BOTTOM.values().forEach(reg -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)reg.get()), (RenderType)cutout));
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)FLBlocks.REINFORCED_POURED_GLASS.get()), (RenderType)translucent);
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)FLContainerTypes.BEEHIVE.get()), BeehiveScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)FLContainerTypes.BARREL_PRESS.get()), BarrelPressScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)FLContainerTypes.STOVETOP_GRILL.get()), StovetopGrillScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)FLContainerTypes.STOVETOP_POT.get()), StovetopPotScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)FLContainerTypes.BIG_BARREL.get()), BigBarrelScreen::new);
            TFCItems.FOOD.forEach((food, item) -> {
                if (FLItems.TFC_FRUITS.contains(food)) {
                    FLClientEvents.registerDryProperty((Supplier<Item>)item);
                }
            });
            FLItems.FRUITS.forEach((food, item) -> FLClientEvents.registerDryProperty((Supplier<Item>)item));
            ItemProperties.register((Item)((Item)FLItems.BEEHIVE_FRAME.get()), (ResourceLocation)FLHelpers.identifier("queen"), (stack, a, b, c) -> stack.getCapability(BeeCapability.CAPABILITY).map(IBee::hasQueen).orElse(false) != false ? 1.0f : 0.0f);
        });
    }

    public static void onBlockColors(RegisterColorHandlersEvent.Block event) {
        BlockColor tallGrassColor = (state, level, pos, tintIndex) -> TFCColors.getTallGrassColor((BlockPos)pos, (int)tintIndex);
        event.register(tallGrassColor, new Block[]{(Block)FLBlocks.BUTTERFLY_GRASS.get()});
        event.register(tallGrassColor, new Block[]{(Block)FLBlocks.POTTED_BUTTERFLY_GRASS.get()});
    }

    public static void onItemColors(RegisterColorHandlersEvent.Item event) {
        ItemColor grassColor = (stack, tintIndex) -> TFCColors.getGrassColor(null, (int)tintIndex);
        Stream.of(FLBlocks.BUTTERFLY_GRASS).forEach(reg -> event.register(grassColor, new ItemLike[]{(ItemLike)reg.get()}));
        for (Fluid fluid : ForgeRegistries.FLUIDS.getValues()) {
            if (!Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)fluid)).m_135827_().equals("firmalife")) continue;
            event.register((ItemColor)new DynamicFluidContainerModel.Colors(), new ItemLike[]{fluid.m_6859_()});
        }
        event.register((ItemColor)new DynamicFluidContainerModel.Colors(), new ItemLike[]{(ItemLike)FLItems.HOLLOW_SHELL.get()});
        event.register((ItemColor)new DynamicFluidContainerModel.Colors(), new ItemLike[]{(ItemLike)FLItems.WINE_GLASS.get()});
    }

    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)FLParticles.GROWTH.get(), set -> new GlintParticleProvider(set, ChatFormatting.GREEN));
        event.registerSpriteSet((ParticleType)FLParticles.SPRINKLER.get(), set -> SprinklerParticle.provider(set, SprinklerParticle::new));
    }

    public static void registerModels(ModelEvent.RegisterAdditional event) {
        for (FLFruit fruit : FLFruit.values()) {
            event.register(FLHelpers.identifier("block/jar/" + fruit.getSerializedName()));
            event.register(FLHelpers.identifier("block/jar/" + fruit.getSerializedName() + "_unsealed"));
        }
        event.register(FLHelpers.identifier("block/jar/compost"));
        event.register(FLHelpers.identifier("block/jar/rotten_compost"));
        event.register(FLHelpers.identifier("block/jar/guano"));
        event.register(FLHelpers.identifier("block/jar/honey"));
        event.register(FLHelpers.identifier("block/barrel_press_piston"));
        event.register(FLHelpers.identifier("block/picker_arms"));
        event.register(FLHelpers.identifier("block/sweeper_arm"));
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            if (!(item instanceof WineBottleItem)) continue;
            WineBottleItem wine = (WineBottleItem)item;
            event.register(wine.getModelLocation());
        }
    }

    public static void registerLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("large_planter", (IGeometryLoader)new DynamicBlockModel.Loader(LargePlanterBakedModel::new));
        event.register("hanging_planter", (IGeometryLoader)new DynamicBlockModel.Loader(HangingPlanterBlockModel::new));
        event.register("bonsai_planter", (IGeometryLoader)new DynamicBlockModel.Loader(BonsaiPlanterBlockModel::new));
        event.register("quad_planter", (IGeometryLoader)new DynamicBlockModel.Loader(QuadPlanterBlockModel::new));
        event.register("hydroponic_planter", (IGeometryLoader)new DynamicBlockModel.Loader(HydroponicPlanterBlockModel::new));
        event.register("trellis_planter", (IGeometryLoader)new DynamicBlockModel.Loader(TrellisPlanterBlockModel::new));
        event.register("jarbnet", (IGeometryLoader)new DynamicBlockModel.Loader(JarbnetBlockModel::new));
        event.register("jarring_station", (IGeometryLoader)new DynamicBlockModel.Loader(JarringStationBlockModel::new));
        event.register("food_shelf", (IGeometryLoader)new DynamicBlockModel.Loader(FoodShelfBlockModel::new));
        event.register("hanger", (IGeometryLoader)new DynamicBlockModel.Loader(HangerBlockModel::new));
        event.register("wine_shelf", (IGeometryLoader)new DynamicBlockModel.Loader(WineShelfBlockModel::new));
    }

    private static void registerDryProperty(Supplier<Item> item) {
        ItemProperties.register((Item)item.get(), (ResourceLocation)FLHelpers.identifier("dry"), (stack, a, b, c) -> stack.getCapability(FoodCapability.CAPABILITY).map(cap -> cap.getTraits().contains(FLFoodTraits.DRIED)).orElse(false) != false ? 1.0f : 0.0f);
    }

    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.OVEN_TOP.get(), ctx -> new OvenBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.DRYING_MAT.get(), ctx -> new DryingMatBlockEntityRenderer(0.125f));
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.SOLAR_DRIER.get(), ctx -> new DryingMatBlockEntityRenderer(0.0625f));
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.STRING.get(), ctx -> new StringBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.VAT.get(), ctx -> new VatBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.MIXING_BOWL.get(), ctx -> new MixingBowlBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.STOVETOP_GRILL.get(), ctx -> new StovetopGrillBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.STOVETOP_POT.get(), ctx -> new StovetopPotBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.PLATE.get(), ctx -> new PlateBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.HYDROPONIC_PLANTER.get(), ctx -> new HydroponicPlanterBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.COMPOST_TUMBLER.get(), ctx -> new CompostTumblerBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.STOMPING_BARREL.get(), ctx -> new StompingBarrelBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.BARREL_PRESS.get(), ctx -> new BarrelPressBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.PUMPING_STATION.get(), ctx -> new PumpingStationBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.PICKER.get(), ctx -> new PickerBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)FLBlockEntities.SWEEPER.get(), ctx -> new SweeperBlockEntityRenderer());
        event.registerEntityRenderer((EntityType)FLEntities.SEED_BALL.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)FLEntities.FLBEE.get(), FLBeeRenderer::new);
    }

    public static void onLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(FLClientHelpers.modelIdentifier("peel"), PeelModel::createBodyLayer);
    }

    public static void onModelRegister(ModelEvent.RegisterAdditional event) {
        event.register(MixingBowlBlockEntityRenderer.SPOON_LOCATION);
        event.register(JarbnetBlockModel.JUG_LOCATION);
        event.register(CompostTumblerBlockEntityRenderer.OPEN_MODEL);
        event.register(CompostTumblerBlockEntityRenderer.CLOSED_MODEL);
    }
}

