/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.client.model;

import com.eerussianguy.firmalife.client.model.SimpleDynamicBlockModel;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blockentities.TrellisPlanterBlockEntity;
import com.eerussianguy.firmalife.common.util.Plantable;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.dries007.tfc.client.RenderHelpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class TrellisPlanterBlockModel
extends SimpleDynamicBlockModel<TrellisPlanterBlockEntity> {
    private static final int GROWING_ID = 0;
    private static final int DRY_ID = 1;
    private static final int FLOWERING_ID = 2;
    private static final int FRUITING_ID = 3;

    public TrellisPlanterBlockModel(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, ItemOverrides overrides, BakedModel baseModel) {
        super(isAmbientOcclusion, isGui3d, isSideLit, overrides, baseModel);
    }

    @Override
    public void render(TrellisPlanterBlockEntity planter, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        Plantable plant = planter.getPlantable(0);
        if (plant == null) {
            return;
        }
        boolean water = planter.getWater() > 0.0f;
        float growth = planter.getGrowth(0);
        Function atlas = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
        int id = 0;
        if (growth >= 1.0f) {
            id = 3;
        } else if (!water) {
            id = 1;
        } else if (growth > 0.66f) {
            id = 2;
        }
        poseStack.m_85836_();
        TextureAtlasSprite sprite = (TextureAtlasSprite)atlas.apply(plant.getTexture(id));
        boolean odd = planter.m_58899_().m_123342_() % 2 == 0;
        poseStack.m_85841_(odd ? 1.01f : 1.0f, 1.01f, odd ? 1.01f : 1.0f);
        RenderHelpers.renderTexturedCuboid((PoseStack)poseStack, (VertexConsumer)buffer, (TextureAtlasSprite)sprite, (int)packedLight, (int)packedOverlay, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    @Override
    public BlockEntityType<TrellisPlanterBlockEntity> type() {
        return (BlockEntityType)FLBlockEntities.TRELLIS_PLANTER.get();
    }
}

