/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.client.screen;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.StovetopPotBlockEntity;
import com.eerussianguy.firmalife.common.container.StovetopPotContainer;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.screen.BlockEntityScreen;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.heat.Heat;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.config.TemperatureDisplayStyle;
import net.dries007.tfc.util.Tooltips;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.fluids.FluidStack;

public class StovetopPotScreen
extends BlockEntityScreen<StovetopPotBlockEntity, StovetopPotContainer> {
    private static final ResourceLocation BACKGROUND = FLHelpers.identifier("textures/gui/stovetop_pot.png");

    public StovetopPotScreen(StovetopPotContainer container, Inventory playerInventory, Component name) {
        super((BlockEntityContainer)container, playerInventory, name, BACKGROUND);
        this.f_97731_ += 20;
        this.f_97727_ += 20;
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280003_(graphics, mouseX, mouseY);
        if (((StovetopPotBlockEntity)this.blockEntity).isBoiling()) {
            this.drawDisabled(graphics, 0, 4);
        }
        String text = ((StovetopPotBlockEntity)this.blockEntity).isBoiling() ? I18n.m_118938_((String)"tfc.tooltip.pot_boiling", (Object[])new Object[0]) : I18n.m_118938_((String)"tfc.tooltip.pot_ready", (Object[])new Object[0]);
        int x = 118 - this.f_96547_.m_92895_(text) / 2;
        graphics.m_280056_(this.f_96547_, text, x, 56, 0x404040, false);
    }

    protected void m_280072_(GuiGraphics graphics, int mouseX, int mouseY) {
        MutableComponent text;
        FluidStack fluid;
        super.m_280072_(graphics, mouseX, mouseY);
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        if (mouseX >= left + 54 && mouseY >= top + 48 && mouseX < left + 86 && mouseY < top + 74 && !(fluid = ((StovetopPotBlockEntity)this.blockEntity).getCapability(Capabilities.FLUID).map(c -> c.getFluidInTank(0)).orElse(FluidStack.EMPTY)).isEmpty()) {
            graphics.m_280557_(this.f_96547_, (Component)Tooltips.fluidUnitsAndCapacityOf((FluidStack)fluid, (int)1000), mouseX, mouseY);
        }
        if (RenderHelpers.isInside((int)mouseX, (int)mouseY, (int)(this.f_97735_ + 30), (int)(this.f_97736_ + 76 - 51), (int)15, (int)51) && (text = ((TemperatureDisplayStyle)TFCConfig.CLIENT.heatTooltipStyle.get()).formatColored(((StovetopPotBlockEntity)this.blockEntity).getTemperature())) != null) {
            graphics.m_280557_(this.f_96547_, (Component)text, mouseX, mouseY);
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(graphics, partialTicks, mouseX, mouseY);
        int temp = (int)(51.0f * ((StovetopPotBlockEntity)this.blockEntity).getTemperature() / Heat.maxVisibleTemperature());
        if (temp > 0) {
            graphics.m_280218_(this.texture, this.f_97735_ + 30, this.f_97736_ + 76 - Math.min(51, temp), 176, 0, 15, 5);
        }
    }
}

