/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.blockentities.CrucibleLikeHeatBlock;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.capabilities.DelegateItemHandler;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.SidedHandler;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.IHeatBlock;
import net.dries007.tfc.common.recipes.inventory.EmptyInventory;
import net.dries007.tfc.util.IntArrayBuilder;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ApplianceBlockEntity<C extends IItemHandlerModifiable & INBTSerializable<CompoundTag>>
extends TickableInventoryBlockEntity<C>
implements ICalendarTickable {
    private long lastUpdateTick = Calendars.SERVER.getTicks();
    protected float temperature = 0.0f;
    protected float targetTemperature = 0.0f;
    protected int targetTemperatureStabilityTicks = 0;
    protected final ContainerData syncableData;
    private final SidedHandler.Noop<IHeatBlock> sidedHeat = new SidedHandler.Noop((Object)((IHeatBlock)this.inventory));

    public ApplianceBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, InventoryBlockEntity.InventoryFactory<C> inventoryFactory, Component name) {
        super(type, pos, state, inventoryFactory, name);
        this.syncableData = new IntArrayBuilder().add(() -> (int)this.temperature, value -> {
            this.temperature = value;
        });
    }

    public ContainerData getSyncableData() {
        return this.syncableData;
    }

    public void tickTemperature() {
        if (this.temperature != this.targetTemperature) {
            this.temperature = HeatCapability.adjustTempTowards((float)this.temperature, (float)this.targetTemperature);
            this.onTemperatureAdjusted();
        }
        if (this.targetTemperatureStabilityTicks > 0) {
            --this.targetTemperatureStabilityTicks;
        }
        if (this.targetTemperature > 0.0f && this.targetTemperatureStabilityTicks == 0) {
            this.targetTemperature = HeatCapability.adjustTempTowards((float)this.targetTemperature, (float)0.0f);
        }
    }

    public void onTemperatureAdjusted() {
        this.markForSync();
    }

    public void onCalendarUpdate(long ticks) {
        assert (this.f_58857_ != null);
        boolean wasHot = this.temperature > 0.0f;
        this.targetTemperature = HeatCapability.adjustTempTowards((float)this.targetTemperature, (float)0.0f, (float)ticks);
        this.temperature = HeatCapability.adjustTempTowards((float)this.temperature, (float)this.targetTemperature, (float)ticks);
        if (wasHot && this.temperature == 0.0f) {
            this.ranOutDueToCalendar();
            this.markForSync();
        }
    }

    public void ranOutDueToCalendar() {
    }

    public long getLastCalendarUpdateTick() {
        return this.lastUpdateTick;
    }

    public void setLastCalendarUpdateTick(long tick) {
        this.lastUpdateTick = tick;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public void loadAdditional(CompoundTag nbt) {
        this.lastUpdateTick = nbt.m_128454_("lastTick");
        this.temperature = nbt.m_128457_("temperature");
        this.targetTemperature = nbt.m_128457_("targetTemperature");
        this.targetTemperatureStabilityTicks = nbt.m_128451_("targetTemperatureStabilityTicks");
        super.loadAdditional(nbt);
    }

    public void m_183515_(CompoundTag nbt) {
        nbt.m_128356_("lastTick", this.lastUpdateTick);
        nbt.m_128350_("temperature", this.temperature);
        nbt.m_128350_("targetTemperature", this.targetTemperature);
        nbt.m_128405_("targetTemperatureStabilityTicks", this.targetTemperatureStabilityTicks);
        super.m_183515_(nbt);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == HeatCapability.BLOCK_CAPABILITY) {
            return this.sidedHeat.getSidedHandler(side).cast();
        }
        return super.getCapability(cap, side);
    }

    public static class ApplianceInventory
    implements EmptyInventory,
    DelegateItemHandler,
    INBTSerializable<CompoundTag>,
    CrucibleLikeHeatBlock {
        private final ApplianceBlockEntity<?> appliance;
        protected final ItemStackHandler inventory;

        public ApplianceInventory(InventoryBlockEntity<?> entity, int slots) {
            this.appliance = (ApplianceBlockEntity)entity;
            this.inventory = new InventoryItemHandler(entity, slots);
        }

        public IItemHandlerModifiable getItemHandler() {
            return this.inventory;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        }

        public float getTemperature() {
            return this.appliance.temperature;
        }

        @Override
        public void setTargetTemperature(float temp) {
            this.appliance.targetTemperature = temp;
        }

        @Override
        public float getTargetTemperature() {
            return this.appliance.targetTemperature;
        }

        @Override
        public void resetStability() {
            this.appliance.targetTemperatureStabilityTicks = 400;
            this.appliance.markForSync();
        }

        @Override
        public void setTemperature(float temperature) {
            CrucibleLikeHeatBlock.super.setTemperature(temperature);
            this.appliance.temperature = temperature;
        }
    }
}

