/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.FLTags;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blocks.FLFluids;
import com.eerussianguy.firmalife.common.capabilities.wine.WineCapability;
import com.eerussianguy.firmalife.common.capabilities.wine.WineType;
import com.eerussianguy.firmalife.common.container.BarrelPressContainer;
import com.eerussianguy.firmalife.common.items.FLFood;
import com.eerussianguy.firmalife.common.items.FLFoodTraits;
import com.eerussianguy.firmalife.common.items.FLItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.KoppenClimateClassification;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class BarrelPressBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler> {
    public static final int SLOTS = 9;
    public static final int SLOT_GRAPES = 0;
    public static final int SLOT_WINE_IN = 5;
    public static final int SLOT_WINE_OUT = 6;
    public static final int SLOT_CORK = 7;
    public static final int SLOT_LABEL = 8;
    public static final long TIME = 40L;
    private boolean didAction = false;
    private boolean needsSlotUpdate = false;
    private long lastPushed = 0L;
    @Nullable
    private WineOutput output = null;

    public static void tick(Level level, BlockPos pos, BlockState state, BarrelPressBlockEntity press) {
        ItemStack current;
        ItemStack newStack;
        RandomSource rand;
        ItemStack item;
        boolean doneWorking;
        press.checkForLastTickSync();
        boolean bl = doneWorking = level.m_46467_() - press.lastPushed > 40L;
        if (!press.didAction && doneWorking) {
            press.didAction = true;
            press.squish();
        }
        if (!doneWorking && level.f_46443_ && level.m_46467_() % 2L == 0L && !(item = ((ItemStackHandler)press.inventory).getStackInSlot((rand = level.f_46441_).m_188503_(9))).m_41619_()) {
            level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, item), (double)((float)pos.m_123341_() + rand.m_188501_()), (double)((float)pos.m_123342_() + 0.2f), (double)((float)pos.m_123343_() + rand.m_188501_()), (double)rand.m_188501_(), (double)(0.125f + 0.5f * rand.m_188501_()), (double)rand.m_188501_());
        }
        if (press.needsSlotUpdate && press.hasOutput() && press.output != null && ((ItemStackHandler)press.inventory).getStackInSlot(6).m_41619_() && !(newStack = press.tryFillWine(level, pos, current = ((ItemStackHandler)press.inventory).getStackInSlot(5))).m_41619_()) {
            ((ItemStackHandler)press.inventory).setStackInSlot(6, newStack);
        }
    }

    @Nullable
    private static Item getFilledWine(Item item) {
        if (item == FLItems.EMPTY_HEMATITIC_WINE_BOTTLE.get()) {
            return (Item)FLItems.HEMATITIC_WINE_BOTTLE.get();
        }
        if (item == FLItems.EMPTY_OLIVINE_WINE_BOTTLE.get()) {
            return (Item)FLItems.OLIVINE_WINE_BOTTLE.get();
        }
        if (item == FLItems.EMPTY_VOLCANIC_WINE_BOTTLE.get()) {
            return (Item)FLItems.VOLCANIC_WINE_BOTTLE.get();
        }
        return null;
    }

    public BarrelPressBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.BARREL_PRESS.get(), pos, state, BarrelPressBlockEntity.defaultInventory((int)9), FLHelpers.blockEntityName("barrel_press"));
    }

    public InteractionResult push() {
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_46467_() - this.lastPushed > 40L) {
            this.didAction = false;
            this.lastPushed = this.f_58857_.m_46467_();
            this.markForSync();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void squish() {
        ItemStack grapes = ((ItemStackHandler)this.inventory).getStackInSlot(0);
        int servings = grapes.m_41613_() / 4;
        if (servings == 0 || this.f_58857_ == null) {
            return;
        }
        WineType wine = this.getWineType();
        if (wine == null) {
            return;
        }
        KoppenClimateClassification climate = KoppenClimateClassification.classify((float)Climate.getAverageTemperature((Level)this.f_58857_, (BlockPos)this.f_58858_), (float)Climate.getRainfall((Level)this.f_58857_, (BlockPos)this.f_58858_));
        ArrayList<FoodTrait> traits = new ArrayList<FoodTrait>();
        grapes.getCapability(FoodCapability.CAPABILITY).ifPresent(cap -> {
            for (FoodTrait trait : cap.getTraits()) {
                if (!FLFoodTraits.WINE_TRAITS.contains(trait)) continue;
                traits.add(trait);
            }
        });
        this.output = new WineOutput(wine, climate, servings, traits);
        for (int i = 0; i < 5; ++i) {
            ((ItemStackHandler)this.inventory).setStackInSlot(i, ItemStack.f_41583_);
        }
        this.markForSync();
    }

    @Nullable
    public WineType getWineType() {
        ItemStack grapes = ((ItemStackHandler)this.inventory).getStackInSlot(0);
        if (FoodCapability.isRotten((ItemStack)grapes)) {
            return null;
        }
        Item redGrapes = (Item)FLItems.FOODS.get((Object)FLFood.SMASHED_RED_GRAPES).get();
        if (Helpers.isItem((ItemStack)grapes, (Item)redGrapes)) {
            return WineType.RED;
        }
        if (Helpers.isItem((ItemStack)grapes, (Item)((Item)FLItems.FOODS.get((Object)FLFood.SMASHED_WHITE_GRAPES).get()))) {
            if (this.hasAtLeastThisMuchOfThisInOtherSlots(s -> s.m_41720_() == redGrapes && FoodCapability.hasTrait((ItemStack)s, (FoodTrait)FLFoodTraits.FERMENTED) && !FoodCapability.isRotten((ItemStack)s), 1)) {
                return WineType.ROSE;
            }
            if (this.hasAtLeastThisMuchOfThisInOtherSlots(s -> Helpers.isItem((ItemStack)s, FLTags.Items.SWEETENER), 2)) {
                return WineType.DESSERT;
            }
            if (this.hasAtLeastThisMuchOfThisInOtherSlots(s -> s.m_41720_() == FLItems.TIRAGE_MIXTURE.get(), 1)) {
                return WineType.SPARKLING;
            }
            return WineType.WHITE;
        }
        return null;
    }

    public ItemStack tryFillWine(Level level, BlockPos pos, ItemStack current) {
        if (this.output == null || !this.hasOutput()) {
            return ItemStack.f_41583_;
        }
        Item newWine = BarrelPressBlockEntity.getFilledWine(current.m_41720_());
        if (Helpers.isItem((ItemStack)current, FLTags.Items.EMPTY_WINE_BOTTLES) && newWine != null) {
            if (((ItemStackHandler)this.inventory).extractItem(7, 1, false).m_41619_()) {
                return ItemStack.f_41583_;
            }
            ItemStack label = ((ItemStackHandler)this.inventory).extractItem(8, 1, false);
            ItemStack bottle = newWine.m_7968_();
            bottle.getCapability(WineCapability.CAPABILITY).ifPresent(cap -> {
                cap.setCreationDate(Calendars.get((LevelReader)level).getTicks());
                cap.setWineType(this.output.wine);
                cap.setClimate(this.output.koppen);
                cap.setTraits(this.output.traits);
                cap.getFluidHandler().fill(new FluidStack((Fluid)FLFluids.WINE_FLUIDS.get((Object)this.output.wine).getSource(), 2000), IFluidHandler.FluidAction.EXECUTE);
                if (!label.m_41619_() && label.m_41788_()) {
                    cap.setLabelText(label.m_41786_().getString());
                }
            });
            current.m_41774_(1);
            --this.output.servings;
            ((ItemStackHandler)this.inventory).setStackInSlot(5, ItemStack.f_41583_);
            if (this.output.servings <= 0) {
                this.output = null;
            }
            Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_11770_);
            return bottle;
        }
        return ItemStack.f_41583_;
    }

    private boolean hasAtLeastThisMuchOfThisInOtherSlots(Predicate<ItemStack> test, int count) {
        int found = 0;
        for (int i = 1; i <= 4; ++i) {
            if (!test.test(((ItemStackHandler)this.inventory).getStackInSlot(i)) || ++found < count) continue;
            return true;
        }
        return found >= count;
    }

    @Nullable
    public WineOutput getOutput() {
        return this.output;
    }

    public int getSlotStackLimit(int slot) {
        return slot == 0 ? 16 : (slot == 7 || slot == 8 ? 64 : 1);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot == 0 && Helpers.isItem((ItemStack)stack, FLTags.Items.CAN_BE_PRESSED_LIKE_GRAPES)) {
            return stack.getCapability(FoodCapability.CAPABILITY).map(cap -> cap.hasTrait(FLFoodTraits.FERMENTED)).orElse(false);
        }
        if (slot == 6) {
            return false;
        }
        if (slot == 5) {
            return Helpers.isItem((ItemStack)stack, FLTags.Items.EMPTY_WINE_BOTTLES);
        }
        if (slot == 7) {
            return Helpers.isItem((ItemStack)stack, (Item)((Item)FLItems.CORK.get()));
        }
        if (slot == 8) {
            return Helpers.isItem((ItemStack)stack, (Item)((Item)FLItems.BOTTLE_LABEL.get()));
        }
        return !Helpers.isItem((ItemStack)stack, (Item)((Item)FLItems.CORK.get())) && !Helpers.isItem((ItemStack)stack, (Item)((Item)FLItems.BOTTLE_LABEL.get())) && !Helpers.isItem((ItemStack)stack, FLTags.Items.EMPTY_WINE_BOTTLES);
    }

    public boolean hasOutput() {
        if (this.output != null && this.output.servings <= 0) {
            this.output = null;
            return false;
        }
        return this.output != null;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128356_("pushed", this.lastPushed);
        tag.m_128379_("didAction", this.didAction);
        if (this.output != null) {
            this.output.save(tag);
        }
    }

    public void loadAdditional(CompoundTag tag) {
        super.loadAdditional(tag);
        this.lastPushed = tag.m_128454_("pushed");
        this.didAction = tag.m_128471_("didAction");
        if (tag.m_128425_("output", 10)) {
            this.output = new WineOutput(tag);
        }
        this.needsSlotUpdate = true;
    }

    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.needsSlotUpdate = true;
    }

    public float sinceWeLastTouched(float partialTick) {
        assert (this.f_58857_ != null);
        return (float)(this.f_58857_.m_46467_() - this.lastPushed) + partialTick;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, Inventory inv, Player player) {
        return BarrelPressContainer.create(this, inv, windowID);
    }

    public static class WineOutput {
        private WineType wine = WineType.RED;
        private KoppenClimateClassification koppen = KoppenClimateClassification.TEMPERATE;
        private int servings = 0;
        private List<FoodTrait> traits;

        public WineOutput(WineType type, KoppenClimateClassification koppen, int servings, List<FoodTrait> traits) {
            this.wine = type;
            this.koppen = koppen;
            this.servings = servings;
            this.traits = traits;
        }

        public WineOutput(CompoundTag tag) {
            if (tag.m_128425_("output", 10)) {
                CompoundTag outputTag = tag.m_128469_("output");
                this.wine = WineType.VALUES[outputTag.m_128451_("wineType")];
                this.koppen = WineType.KOPPEN_VALUES[outputTag.m_128451_("climate")];
                this.servings = outputTag.m_128451_("servings");
                this.traits = new ArrayList<FoodTrait>();
                FLHelpers.readTraitList(this.traits, outputTag, "traits");
            }
        }

        public void save(CompoundTag tag) {
            CompoundTag outputTag = new CompoundTag();
            outputTag.m_128405_("wineType", this.wine.ordinal());
            outputTag.m_128405_("climate", this.koppen.ordinal());
            outputTag.m_128405_("servings", this.servings);
            FLHelpers.writeTraitList(this.traits, outputTag, "traits");
            tag.m_128365_("output", (Tag)outputTag);
        }

        public int getServings() {
            return this.servings;
        }

        public WineType getType() {
            return this.wine;
        }

        public KoppenClimateClassification getClimate() {
            return this.koppen;
        }
    }
}

