/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.ClimateReceiver;
import com.eerussianguy.firmalife.common.blockentities.ClimateType;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.util.GreenhouseType;
import com.eerussianguy.firmalife.common.util.Mechanics;
import java.util.HashSet;
import java.util.Set;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ClimateStationBlockEntity
extends TFCBlockEntity {
    private Set<BlockPos> positions;
    private ClimateType type = ClimateType.GREENHOUSE;
    @Nullable
    private ResourceLocation favoriteGreenhouseType = null;
    private boolean favoriteIsCellar = false;

    public ClimateStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.CLIMATE_STATION.get(), pos, state);
        this.positions = new HashSet<BlockPos>();
    }

    public void loadAdditional(CompoundTag nbt) {
        super.loadAdditional(nbt);
        this.type = ClimateType.byId(nbt.m_128451_("climateType"));
        long[] array = nbt.m_128467_("positions");
        this.positions.clear();
        this.positions = new HashSet<BlockPos>(array.length);
        for (long pos : array) {
            this.positions.add(BlockPos.m_122022_((long)pos));
        }
        if (nbt.m_128441_("favoriteType")) {
            this.favoriteGreenhouseType = FLHelpers.res(nbt.m_128461_("favoriteType"));
        }
        this.favoriteIsCellar = nbt.m_128471_("favoriteIsCellar");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("climateType", this.type.ordinal());
        long[] array = new long[this.positions.size()];
        int i = 0;
        for (BlockPos pos : this.positions) {
            array[i] = pos.m_121878_();
            ++i;
        }
        nbt.m_128388_("positions", array);
        if (this.favoriteGreenhouseType != null) {
            nbt.m_128359_("favoriteType", this.favoriteGreenhouseType.toString());
        }
        nbt.m_128379_("favoriteIsCellar", this.favoriteIsCellar);
    }

    public void updateValidity(boolean valid, int tier) {
        assert (this.f_58857_ != null);
        this.positions.forEach(pos -> {
            ClimateReceiver receiver = ClimateReceiver.get(this.f_58857_, pos);
            if (receiver != null) {
                receiver.setValid(this.f_58857_, (BlockPos)pos, valid, tier, this.type);
            }
        });
    }

    public void setType(ClimateType cellar) {
        this.type = cellar;
    }

    public void setPositions(Set<BlockPos> positions) {
        this.positions = positions;
    }

    public boolean setFavorite(ItemStack held) {
        Item item = held.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            BlockState state = bi.m_40614_().m_49966_();
            if (Mechanics.CELLAR.test(state)) {
                this.setFavoriteIsCellar();
                return true;
            }
            GreenhouseType type = GreenhouseType.get(state);
            if (type != null) {
                this.setFavorite(type);
                return true;
            }
        }
        return false;
    }

    public void setFavorite(GreenhouseType type) {
        this.favoriteGreenhouseType = type.id;
        this.favoriteIsCellar = false;
    }

    public void setFavoriteIsCellar() {
        this.favoriteGreenhouseType = null;
        this.favoriteIsCellar = true;
    }

    @Nullable
    public GreenhouseType getFavoriteType() {
        if (this.favoriteGreenhouseType != null) {
            return GreenhouseType.get(this.favoriteGreenhouseType);
        }
        return null;
    }

    public boolean favoriteIsCellar() {
        return this.favoriteIsCellar;
    }
}

