/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blocks.CompostTumblerBlock;
import com.eerussianguy.firmalife.common.items.FLItems;
import com.eerussianguy.firmalife.config.FLConfig;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.RotationSinkBlockEntity;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.rotation.NetworkAction;
import net.dries007.tfc.util.rotation.Node;
import net.dries007.tfc.util.rotation.SinkNode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class CompostTumblerBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler>
implements RotationSinkBlockEntity {
    public static final int MAX_COMPOST = 32;
    public static final int MIN_COMPOST = 16;
    public static final int SLOT_COMPOST = 0;
    protected long lastUpdateTick = Integer.MIN_VALUE;
    private int green;
    private int brown;
    private int fish;
    private int bones;
    private int pottery;
    private int charcoal;
    private boolean rotten = false;
    private final Node node;

    public static void serverTick(Level level, BlockPos pos, BlockState state, CompostTumblerBlockEntity tumbler) {
        tumbler.checkForLastTickSync();
        if (level.m_46467_() % 20L == 0L) {
            tumbler.checkReady();
        }
    }

    public CompostTumblerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.COMPOST_TUMBLER.get(), pos, state, CompostTumblerBlockEntity.defaultInventory((int)1), FLHelpers.blockEntityName("compost_tumbler"));
        Direction connection = ((Direction)state.m_61143_((Property)CompostTumblerBlock.FACING)).m_122424_();
        this.node = new SinkNode(pos, connection){

            public String toString() {
                return "Tumbler[pos=%s]".formatted(this.pos());
            }
        };
    }

    public InteractionResult use(ItemStack stack, Player player, boolean client) {
        assert (this.f_58857_ != null);
        if (this.isReady() && !this.isRotating()) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)((ItemStackHandler)this.inventory).extractItem(0, 64, false));
            this.reset();
            return InteractionResult.m_19078_((boolean)this.f_58857_.f_46443_);
        }
        if (!((ItemStackHandler)this.inventory).getStackInSlot(0).m_41619_()) {
            return InteractionResult.PASS;
        }
        int total = this.getTotal();
        if (total >= 32 || this.rotten) {
            return InteractionResult.PASS;
        }
        Compost compost = this.getCompost(stack);
        if (compost.isEmpty()) {
            return InteractionResult.PASS;
        }
        int toAdd = Math.min(32 - compost.amount, compost.amount);
        switch (compost.type) {
            case BROWN: {
                this.brown += toAdd;
                break;
            }
            case GREEN: {
                this.green += toAdd;
                break;
            }
            case BONE: {
                this.bones += toAdd;
                break;
            }
            case CHARCOAL: {
                this.charcoal += toAdd;
                break;
            }
            case FISH: {
                this.fish += toAdd;
                break;
            }
            case POTTERY: {
                this.pottery += toAdd;
                break;
            }
            case POISON: {
                this.rotten = true;
            }
        }
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
        this.markForSync();
        this.resetCounter();
        return InteractionResult.m_19078_((boolean)client);
    }

    public void checkReady() {
        if (!this.canWork()) {
            return;
        }
        int total = this.getTotal();
        if (this.isReady()) {
            this.calculateRotten();
            this.getTotal();
            int count = total == 32 ? 3 : (total >= 24 ? 2 : 1);
            ItemStack result = this.rotten ? new ItemStack((ItemLike)TFCItems.ROTTEN_COMPOST.get(), count) : new ItemStack((ItemLike)TFCItems.COMPOST.get(), count);
            ((ItemStackHandler)this.inventory).setStackInSlot(0, result);
            this.reset();
            this.markForSync();
        }
    }

    public boolean canWork() {
        if (!this.isRotating() || !((ItemStackHandler)this.inventory).getStackInSlot(0).m_41619_()) {
            this.resetCounter();
            return false;
        }
        int total = this.getTotal();
        if (total < 16) {
            this.resetCounter();
            return false;
        }
        return true;
    }

    public boolean isRotating() {
        assert (this.f_58857_ != null);
        return this.node.rotation() != null || (Boolean)FLConfig.SERVER.mechanicalPowerCheatMode.get() != false && this.f_58857_.m_277173_(this.f_58858_) > 0;
    }

    public void loadAdditional(CompoundTag nbt) {
        this.green = nbt.m_128451_("green");
        this.brown = nbt.m_128451_("brown");
        this.fish = nbt.m_128451_("fish");
        this.bones = nbt.m_128451_("bones");
        this.pottery = nbt.m_128451_("pottery");
        this.charcoal = nbt.m_128451_("charcoal");
        this.rotten = nbt.m_128471_("rotten");
        this.lastUpdateTick = nbt.m_128454_("tick");
        super.loadAdditional(nbt);
    }

    public void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("green", this.green);
        nbt.m_128405_("brown", this.brown);
        nbt.m_128405_("fish", this.fish);
        nbt.m_128405_("bones", this.bones);
        nbt.m_128405_("pottery", this.pottery);
        nbt.m_128405_("charcoal", this.charcoal);
        nbt.m_128379_("rotten", this.rotten);
        nbt.m_128356_("tick", this.lastUpdateTick);
        super.m_183515_(nbt);
    }

    public int getTotal() {
        return this.green + this.brown + this.fish + this.bones + this.pottery + this.charcoal;
    }

    public boolean isRotten() {
        return this.rotten || ((ItemStackHandler)this.inventory).getStackInSlot(0).m_41720_() == TFCItems.ROTTEN_COMPOST.get();
    }

    public boolean isReady() {
        return this.getTicksSinceUpdate() > this.getReadyTicks() && this.getTotal() >= 16 || !((ItemStackHandler)this.inventory).getStackInSlot(0).m_41619_();
    }

    public void reset() {
        this.charcoal = 0;
        this.pottery = 0;
        this.bones = 0;
        this.fish = 0;
        this.brown = 0;
        this.green = 0;
        this.rotten = false;
        this.resetCounter();
    }

    public void calculateRotten() {
        float bonePct = (float)this.bones / 32.0f;
        float fishPct = (float)this.fish / 32.0f;
        float charcoalPct = (float)this.charcoal / 32.0f;
        float potterPct = (float)this.pottery / 32.0f;
        int greenBrownDiff = Mth.m_14040_((int)(this.green - this.brown));
        if (bonePct > 0.15f || fishPct > 0.15f || charcoalPct > 0.2f || potterPct > 0.15f || greenBrownDiff > 9) {
            this.rotten = true;
        }
    }

    public long getReadyTicks() {
        assert (this.f_58857_ != null);
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        cursor.m_122190_((Vec3i)this.m_58899_());
        float rainfall = Climate.getRainfall((Level)this.f_58857_, (BlockPos)cursor);
        long readyTicks = ((Integer)FLConfig.SERVER.compostTumblerTicks.get()).intValue();
        if (rainfall < 150.0f) {
            readyTicks *= (long)((150.0f - rainfall) / 50.0f + 1.0f);
        } else if (rainfall > 350.0f) {
            readyTicks *= (long)((rainfall - 350.0f) / 50.0f + 1.0f);
        }
        long originalReadyTicks = readyTicks;
        int greenBrownDifference = Mth.m_14040_((int)(this.green - this.brown));
        readyTicks = (long)((float)readyTicks * Mth.m_184631_((float)greenBrownDifference, (float)0.0f, (float)5.0f, (float)0.8f, (float)1.2f));
        readyTicks = (long)((float)readyTicks * (0.1f * (float)this.fish + 1.0f));
        readyTicks = (long)((float)readyTicks * (0.1f * (float)this.bones + 1.0f));
        readyTicks = (long)((float)readyTicks * (0.1f * (float)this.pottery + 0.7f));
        readyTicks = (long)((float)readyTicks * (0.1f * (float)this.charcoal + 0.7f));
        if (readyTicks > originalReadyTicks * 3L) {
            readyTicks = originalReadyTicks;
        }
        return readyTicks;
    }

    public Compost getCompost(ItemStack stack) {
        if (Helpers.isItem((ItemStack)stack, (Item)Items.f_42500_)) {
            return new Compost(AdditionType.BONE, 1);
        }
        if (Helpers.isItem((ItemStack)stack, (TagKey)ItemTags.f_13156_)) {
            return new Compost(AdditionType.FISH, 1);
        }
        if (Helpers.isItem((ItemStack)stack, (TagKey)TFCTags.Items.COMPOST_POISONS)) {
            return new Compost(AdditionType.POISON, 0);
        }
        if (Helpers.isItem((ItemStack)stack, (TagKey)TFCTags.Items.COMPOST_BROWNS_LOW)) {
            return new Compost(AdditionType.BROWN, 1);
        }
        if (Helpers.isItem((ItemStack)stack, (TagKey)TFCTags.Items.COMPOST_BROWNS)) {
            return new Compost(AdditionType.BROWN, 2);
        }
        if (Helpers.isItem((ItemStack)stack, (TagKey)TFCTags.Items.COMPOST_BROWNS_HIGH)) {
            return new Compost(AdditionType.BROWN, 4);
        }
        if (Helpers.isItem((ItemStack)stack, (TagKey)TFCTags.Items.COMPOST_GREENS_LOW)) {
            return new Compost(AdditionType.GREEN, 1);
        }
        if (Helpers.isItem((ItemStack)stack, (TagKey)TFCTags.Items.COMPOST_GREENS)) {
            return new Compost(AdditionType.GREEN, 2);
        }
        if (Helpers.isItem((ItemStack)stack, (TagKey)TFCTags.Items.COMPOST_GREENS_HIGH)) {
            return new Compost(AdditionType.GREEN, 4);
        }
        if (Helpers.isItem((ItemStack)stack, (Item)((Item)FLItems.POTTERY_SHERD.get())) || Helpers.isItem((ItemStack)stack, (TagKey)ItemTags.f_271220_)) {
            return new Compost(AdditionType.POTTERY, 1);
        }
        if (Helpers.isItem((ItemStack)stack, (Item)Items.f_42414_)) {
            return new Compost(AdditionType.CHARCOAL, 1);
        }
        return new Compost(AdditionType.NONE, 0);
    }

    public void resetCounter() {
        this.lastUpdateTick = Calendars.SERVER.getTicks();
        this.m_6596_();
    }

    public long getTicksSinceUpdate() {
        assert (this.f_58857_ != null);
        return Calendars.get((LevelReader)this.f_58857_).getTicks() - this.lastUpdateTick;
    }

    public Node getRotationNode() {
        return this.node;
    }

    protected void onLoadAdditional() {
        this.performNetworkAction(NetworkAction.ADD);
    }

    protected void onUnloadAdditional() {
        this.performNetworkAction(NetworkAction.REMOVE);
    }

    public float getPercentage(AdditionType type) {
        int total = this.getTotal();
        if (total < 1) {
            return 0.0f;
        }
        return (switch (type) {
            case AdditionType.GREEN -> this.green;
            case AdditionType.BROWN -> this.brown;
            case AdditionType.FISH -> this.fish;
            case AdditionType.BONE -> this.bones;
            case AdditionType.POTTERY -> this.pottery;
            case AdditionType.CHARCOAL -> this.charcoal;
            default -> 0.0f;
        }) / (float)total;
    }

    public record Compost(AdditionType type, int amount) {
        public boolean isEmpty() {
            return this.type == AdditionType.NONE || this.amount < 1;
        }
    }

    public static enum AdditionType {
        NONE,
        POISON,
        GREEN,
        BROWN,
        FISH,
        BONE,
        POTTERY,
        CHARCOAL;

        public static final AdditionType[] VALUES;

        static {
            VALUES = AdditionType.values();
        }
    }
}

