/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.FLTags;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blocks.FLBeehiveBlock;
import com.eerussianguy.firmalife.common.blocks.greenhouse.LargePlanterBlock;
import com.eerussianguy.firmalife.common.capabilities.bee.BeeAbility;
import com.eerussianguy.firmalife.common.capabilities.bee.BeeCapability;
import com.eerussianguy.firmalife.common.capabilities.bee.IBee;
import com.eerussianguy.firmalife.common.container.BeehiveContainer;
import com.eerussianguy.firmalife.common.entities.FLBee;
import com.eerussianguy.firmalife.common.entities.FLEntities;
import com.eerussianguy.firmalife.common.items.FLItems;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.dries007.tfc.common.blockentities.FarmlandBlockEntity;
import net.dries007.tfc.common.blockentities.IFarmland;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blocks.plant.PlantBlock;
import net.dries007.tfc.common.blocks.plant.ShortGrassBlock;
import net.dries007.tfc.common.blocks.soil.ConnectedGrassBlock;
import net.dries007.tfc.common.blocks.soil.DirtBlock;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FLBeehiveBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler>
implements ICalendarTickable {
    public static final int MIN_FLOWERS = 10;
    public static final int UPDATE_INTERVAL = 24000;
    public static final int ENTITY_HANDLING_INTERVAL = 1000;
    public static final int FRAME_SLOTS = 4;
    public static final int TOTAL_SLOTS = 6;
    public static final int SLOT_JAR_IN = 4;
    public static final int SLOT_JAR_OUT = 5;
    private static final Component NAME = FLHelpers.blockEntityName("beehive");
    private static final FarmlandBlockEntity.NutrientType N = FarmlandBlockEntity.NutrientType.NITROGEN;
    private static final FarmlandBlockEntity.NutrientType P = FarmlandBlockEntity.NutrientType.PHOSPHOROUS;
    private static final FarmlandBlockEntity.NutrientType K = FarmlandBlockEntity.NutrientType.POTASSIUM;
    private final IBee[] cachedBees;
    private int beesInWorld = 0;
    private long lastPlayerTick = Integer.MIN_VALUE;
    private long lastAreaTick = Calendars.SERVER.getTicks();
    private int honey = 0;
    private boolean needsSlotUpdate = false;

    public static void serverTick(Level level, BlockPos pos, BlockState state, FLBeehiveBlockEntity hive) {
        ItemStack current;
        hive.checkForLastTickSync();
        hive.checkForCalendarUpdate();
        if (level.m_46467_() % 60L == 0L) {
            hive.updateState();
        }
        if ((level.m_46467_() + pos.m_121878_()) % 1000L == 0L) {
            hive.controlEntitiesTick();
        }
        if (hive.needsSlotUpdate && ((ItemStackHandler)hive.inventory).getStackInSlot(5).m_41619_() && Helpers.isItem((ItemStack)(current = ((ItemStackHandler)hive.inventory).getStackInSlot(4)), (Item)((Item)TFCItems.EMPTY_JAR.get())) && hive.takeHoney(1) > 0) {
            ((ItemStackHandler)hive.inventory).setStackInSlot(4, ItemStack.f_41583_);
            ((ItemStackHandler)hive.inventory).setStackInSlot(5, ((Item)FLItems.HONEY_JAR.get()).m_7968_());
            Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_11770_);
        }
    }

    public FLBeehiveBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.BEEHIVE.get(), pos, state, be -> new FixedISH((InventoryBlockEntity<ItemStackHandler>)be, 6), NAME);
        this.cachedBees = new IBee[]{null, null, null, null};
        this.sidedInventory.on((Object)new PartialItemHandler(this.inventory).insert(new int[]{4}), (Predicate)Direction.Plane.HORIZONTAL).on((Object)new PartialItemHandler(this.inventory).extract(new int[]{5}), new Direction[]{Direction.DOWN});
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128356_("lastTick", this.lastPlayerTick);
        nbt.m_128356_("lastAreaTick", this.lastAreaTick);
        nbt.m_128405_("honey", this.honey);
        nbt.m_128405_("beesInWorld", this.beesInWorld);
        nbt.m_128379_("updatedSize", true);
    }

    public void loadAdditional(CompoundTag nbt) {
        super.loadAdditional(nbt);
        this.updateCache();
        this.lastPlayerTick = nbt.m_128454_("lastTick");
        this.lastAreaTick = nbt.m_128454_("lastAreaTick");
        this.honey = Math.min(nbt.m_128451_("honey"), this.getMaxHoney());
        this.beesInWorld = nbt.m_128451_("beesInWorld");
        this.needsSlotUpdate = true;
    }

    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, Inventory inv, Player player) {
        return BeehiveContainer.create(this, inv, windowID);
    }

    public void onCalendarUpdate(long ticks) {
        this.tryPeriodicUpdate();
    }

    public void tryPeriodicUpdate() {
        long now = Calendars.SERVER.getTicks();
        if (now > this.lastAreaTick + 24000L) {
            while (this.lastAreaTick < now) {
                this.updateTick();
                this.lastAreaTick += 24000L;
            }
            this.markForSync();
        }
    }

    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.updateCache();
        this.needsSlotUpdate = true;
    }

    private void updateCache() {
        for (int i = 0; i < 4; ++i) {
            this.cachedBees[i] = this.getBee(i);
        }
    }

    public IBee[] getCachedBees() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.updateCache();
        }
        return this.cachedBees;
    }

    private void updateTick() {
        assert (this.f_58857_ != null);
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        BlockPos posInFront = this.f_58858_.m_121945_(direction);
        if (!this.f_58857_.m_8055_(posInFront).m_60812_((BlockGetter)this.f_58857_, posInFront).m_83281_()) {
            return;
        }
        float temp = Climate.getTemperature((Level)this.f_58857_, (BlockPos)this.f_58858_);
        List<IBee> usableBees = this.getUsableBees(temp);
        int flowers = this.getFlowers(usableBees, true);
        int breedTickChanceInverted = this.getBreedTickChanceInverted(usableBees, flowers);
        if (flowers > 10 && (breedTickChanceInverted == 0 || this.f_58857_.f_46441_.m_188503_(breedTickChanceInverted) == 0)) {
            IBee parent1 = null;
            IBee parent2 = null;
            IBee uninitializedBee = null;
            for (int i = 0; i < 4; ++i) {
                IBee bee = ((ItemStackHandler)this.inventory).getStackInSlot(i).getCapability(BeeCapability.CAPABILITY).resolve().orElse(null);
                if (bee == null) continue;
                if (bee.hasQueen()) {
                    if (parent1 == null) {
                        parent1 = bee;
                        continue;
                    }
                    if (parent2 != null) continue;
                    parent2 = bee;
                    continue;
                }
                if (uninitializedBee != null) continue;
                uninitializedBee = bee;
            }
            if (uninitializedBee != null) {
                if (parent2 == null) {
                    uninitializedBee.initFreshAbilities(this.f_58857_.f_46441_);
                } else if (parent1.hasQueen() && parent2.hasQueen()) {
                    uninitializedBee.setAbilitiesFromParents(parent1, parent2, this.f_58857_.f_46441_);
                }
            }
        }
        int honeyChanceInverted = this.getHoneyTickChanceInverted(usableBees, flowers);
        if (flowers > 10 && (honeyChanceInverted == 0 || this.f_58857_.f_46441_.m_188503_(honeyChanceInverted) == 0)) {
            usableBees.removeIf(IBee::hasGeneticDisease);
            this.addHoney(usableBees.size());
        }
    }

    private void controlEntitiesTick() {
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_46462_() && this.beesInWorld > 0) {
            this.beesInWorld = 0;
        } else if (this.f_58857_.m_46461_() && this.beesInWorld <= 0) {
            float temp = Climate.getTemperature((Level)this.f_58857_, (BlockPos)this.f_58858_);
            List<IBee> usableBees = this.getUsableBees(temp);
            Direction direction = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
            BlockPos posInFront = this.f_58858_.m_121945_(direction);
            if (this.f_58857_.m_8055_(posInFront).m_60812_((BlockGetter)this.f_58857_, posInFront).m_83281_() && !usableBees.isEmpty() && this.beesInWorld == 0) {
                FLBee beeEntity = (FLBee)((EntityType)FLEntities.FLBEE.get()).m_20615_(this.f_58857_);
                assert (beeEntity != null);
                beeEntity.m_20219_(this.f_58858_.m_121945_(direction).m_252807_());
                beeEntity.m_146922_(direction.m_122435_());
                beeEntity.setSpawnPos(posInFront);
                this.f_58857_.m_7967_((Entity)beeEntity);
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11696_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ++this.beesInWorld;
            }
        }
    }

    @NotNull
    public List<IBee> getUsableBees(float temp) {
        return Arrays.stream(this.cachedBees).filter(bee -> bee != null && bee.hasQueen() && temp > BeeAbility.getMinTemperature(bee.getAbility(BeeAbility.HARDINESS))).collect(Collectors.toList());
    }

    public int getFlowers(List<IBee> bees, boolean tick) {
        assert (this.f_58857_ != null);
        int flowers = 0;
        BlockPos min = this.f_58858_.m_7918_(-5, -5, -5);
        BlockPos max = this.f_58858_.m_7918_(5, 5, 5);
        boolean empty = bees.isEmpty();
        if (this.f_58857_.m_46832_(min, max)) {
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
                BlockState state = this.f_58857_.m_8055_(pos);
                if (this.isFlower(state)) {
                    ++flowers;
                }
                if (!tick) continue;
                if (empty) {
                    this.tickPosition(pos, state, null);
                    continue;
                }
                for (IBee bee : bees) {
                    this.tickPosition(pos, state, bee);
                }
            }
        }
        return flowers;
    }

    private boolean isFlower(BlockState state) {
        return Helpers.isBlock((BlockState)state, (TagKey)BlockTags.f_13041_) || state.m_60734_() instanceof PlantBlock && !(state.m_60734_() instanceof ShortGrassBlock) || state.m_60734_() instanceof LargePlanterBlock && (Boolean)state.m_61143_((Property)LargePlanterBlock.WATERED) != false;
    }

    public int getHoneyTickChanceInverted(List<IBee> bees, int flowers) {
        int chance = 30;
        for (IBee bee : bees) {
            if (!bee.hasQueen()) continue;
            chance += 10 - bee.getAbility(BeeAbility.PRODUCTION);
        }
        if (!bees.isEmpty()) {
            chance /= bees.size();
        }
        return Math.max(0, chance - Mth.m_14165_((double)(0.2 * (double)Math.min(flowers, 60))));
    }

    public int getBreedTickChanceInverted(List<IBee> bees, int flowers) {
        int chance = 0;
        for (IBee bee : bees) {
            if (!bee.hasQueen()) continue;
            chance += 10 - bee.getAbility(BeeAbility.FERTILITY);
        }
        if (bees.isEmpty()) {
            chance = 80;
        }
        return Math.max(0, chance - Math.min(flowers, 60));
    }

    public void addHoney(int amount) {
        this.honey = Math.min(this.getMaxHoney(), amount + this.honey);
        this.markForSync();
    }

    public int takeHoney(int amount) {
        int take = Math.min(amount, this.honey);
        this.honey -= take;
        this.updateState();
        this.markForSync();
        return take;
    }

    public int getMaxHoney() {
        return 12;
    }

    public int getHoney() {
        return this.honey;
    }

    private void tickPosition(BlockPos pos, BlockState state, @Nullable IBee bee) {
        assert (this.f_58857_ != null);
        if (bee != null) {
            int restore;
            Block block = state.m_60734_();
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (blockEntity instanceof IFarmland) {
                IFarmland farmland = (IFarmland)blockEntity;
                float cropAffinity = bee.getAbility(BeeAbility.CROP_AFFINITY);
                if (cropAffinity >= 1.0f && this.f_58857_.f_46441_.m_188503_(50) == 0) {
                    int which = this.f_58857_.f_46441_.m_188503_(3);
                    float nut = this.f_58857_.f_46441_.m_188501_() * cropAffinity * 0.01f;
                    float cap = cropAffinity / 10.0f * 0.5f;
                    this.receiveNutrients(farmland, cap, which == 0 ? nut : 0.0f, which == 1 ? nut : 0.0f, which == 2 ? nut : 0.0f);
                }
            }
            if ((restore = bee.getAbility(BeeAbility.NATURE_RESTORATION)) > 1 && this.f_58857_.f_46441_.m_188503_(50 + 50 * (10 - restore)) == 0) {
                BlockPos above = pos.m_7494_();
                boolean airAbove = this.f_58857_.m_8055_(above).m_60795_();
                if (airAbove && state.m_60734_() == Blocks.f_49990_ && state.m_60819_().m_76170_()) {
                    Helpers.getRandomElement((IForgeRegistry)ForgeRegistries.BLOCKS, FLTags.Blocks.BEE_RESTORATION_WATER_PLANTS, (RandomSource)this.f_58857_.f_46441_).ifPresent(plant -> {
                        if (plant.m_49966_().m_60710_((LevelReader)this.f_58857_, pos)) {
                            this.f_58857_.m_46597_(pos, plant.m_49966_());
                        }
                    });
                } else if (airAbove && block instanceof DirtBlock) {
                    DirtBlock dirt = (DirtBlock)block;
                    this.f_58857_.m_46597_(pos, dirt.getGrass());
                } else if (state.m_60795_() && this.f_58857_.m_8055_(pos.m_7495_()).m_60734_() instanceof ConnectedGrassBlock) {
                    Helpers.getRandomElement((IForgeRegistry)ForgeRegistries.BLOCKS, FLTags.Blocks.BEE_RESTORATION_PLANTS, (RandomSource)this.f_58857_.f_46441_).ifPresent(plant -> this.f_58857_.m_46597_(pos, plant.m_49966_()));
                }
            }
        }
    }

    private void receiveNutrients(IFarmland farmland, float cap, float nitrogen, float phosphorous, float potassium) {
        float k;
        float p;
        float n = farmland.getNutrient(N);
        if (n < cap) {
            farmland.setNutrient(N, Math.min(n + nitrogen, cap));
        }
        if ((p = farmland.getNutrient(P)) < cap) {
            farmland.setNutrient(P, Math.min(p + phosphorous, cap));
        }
        if ((k = farmland.getNutrient(K)) < cap) {
            farmland.setNutrient(K, Math.min(k + potassium, cap));
        }
    }

    public void updateState() {
        boolean hasHoney;
        BlockState state;
        assert (this.f_58857_ != null);
        boolean bees = this.hasBees();
        if (bees != (Boolean)(state = this.f_58857_.m_8055_(this.f_58858_)).m_61143_((Property)FLBeehiveBlock.BEES)) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)FLBeehiveBlock.BEES, (Comparable)Boolean.valueOf(bees)));
            this.markForSync();
        }
        boolean bl = hasHoney = this.honey > 0;
        if (hasHoney != (Boolean)state.m_61143_((Property)FLBeehiveBlock.HONEY)) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)FLBeehiveBlock.HONEY, (Comparable)Boolean.valueOf(hasHoney)));
            this.markForSync();
        }
    }

    private boolean hasBees() {
        for (int i = 0; i < 4; ++i) {
            if (this.cachedBees[i] == null || !this.cachedBees[i].hasQueen()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private IBee getBee(int slot) {
        Optional opt;
        ItemStack stack = ((ItemStackHandler)this.inventory).getStackInSlot(slot);
        if (!stack.m_41619_() && (opt = stack.getCapability(BeeCapability.CAPABILITY).resolve()).isPresent()) {
            return (IBee)opt.get();
        }
        return null;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot < 4) {
            return stack.getCapability(BeeCapability.CAPABILITY).isPresent();
        }
        if (slot == 4) {
            return Helpers.isItem((ItemStack)stack, (Item)((Item)TFCItems.EMPTY_JAR.get()));
        }
        return false;
    }

    public void onSlotTake(Player player, int slot, ItemStack stack) {
        assert (this.f_58857_ != null);
        if (FLBeehiveBlock.shouldAnger(this.f_58857_, this.f_58858_)) {
            FLBeehiveBlock.attack(player);
        }
    }

    public long getLastCalendarUpdateTick() {
        return this.lastPlayerTick;
    }

    public void setLastCalendarUpdateTick(long tick) {
        this.lastPlayerTick = tick;
    }

    public static class FixedISH
    extends InventoryItemHandler {
        public FixedISH(InventoryBlockEntity<ItemStackHandler> be, int slots) {
            super(be, slots);
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.setSize(this.stacks.size());
            ListTag tagList = nbt.m_128437_("Items", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag itemTags = tagList.m_128728_(i);
                int slot = itemTags.m_128451_("Slot");
                if (slot < 0 || slot >= this.stacks.size()) continue;
                this.stacks.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags));
            }
            this.onLoad();
        }
    }
}

