/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blocks.JarbnetBlock;
import java.util.function.Predicate;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.items.CandleBlockItem;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class JarbnetBlockEntity
extends InventoryBlockEntity<ItemStackHandler> {
    public static final int SLOTS = 6;
    private long lastUpdateTick = Long.MIN_VALUE;

    public JarbnetBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.JARBNET.get(), pos, state, JarbnetBlockEntity.defaultInventory((int)6), FLHelpers.blockEntityName("jarbnet"));
        this.sidedInventory.on((Object)new PartialItemHandler(this.inventory).insert(new int[]{0, 1, 2, 3, 4, 5}), (Predicate)Direction.Plane.HORIZONTAL).on((Object)new PartialItemHandler(this.inventory).extract(new int[]{0, 1, 2, 3, 4, 5}), new Direction[]{Direction.DOWN});
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return JarbnetBlock.isItemAllowed(stack);
    }

    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.updateState();
    }

    public void onLoadAdditional() {
        this.updateState();
    }

    private void updateState() {
        boolean isLit;
        boolean bl = isLit = this.m_58900_().m_61138_((Property)JarbnetBlock.LIT) && (Boolean)this.m_58900_().m_61143_((Property)JarbnetBlock.LIT) != false;
        if (isLit && this.f_58857_ != null) {
            for (ItemStack stack : Helpers.iterate((IItemHandler)this.inventory)) {
                if (!(stack.m_41720_() instanceof CandleBlockItem)) continue;
                return;
            }
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)JarbnetBlock.LIT, (Comparable)Boolean.valueOf(false)));
        }
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public int getSlotStackLimit(int slot) {
        return 1;
    }

    public long getTicksSinceUpdate() {
        assert (this.f_58857_ != null);
        return Calendars.get((LevelReader)this.f_58857_).getTicks() - this.lastUpdateTick;
    }

    public void setLastUpdateTick(long tick) {
        this.lastUpdateTick = tick;
        this.m_6596_();
    }

    public long getLastUpdateTick() {
        return this.lastUpdateTick;
    }

    public void resetCounter() {
        this.lastUpdateTick = Calendars.SERVER.getTicks();
        this.m_6596_();
    }

    public void loadAdditional(CompoundTag nbt) {
        this.lastUpdateTick = nbt.m_128454_("tick");
        super.loadAdditional(nbt);
    }

    public void m_183515_(CompoundTag nbt) {
        nbt.m_128356_("tick", this.lastUpdateTick);
        super.m_183515_(nbt);
    }
}

