/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.FLTags;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blockentities.SimpleItemRecipeBlockEntity;
import com.eerussianguy.firmalife.common.blocks.StringBlock;
import com.eerussianguy.firmalife.common.items.FLFoodTraits;
import com.eerussianguy.firmalife.common.recipes.SmokingRecipe;
import com.eerussianguy.firmalife.config.FLConfig;
import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.FirepitBlockEntity;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;

public class StringBlockEntity
extends SimpleItemRecipeBlockEntity<SmokingRecipe> {
    public static void serverTick(Level level, BlockPos pos, BlockState state, StringBlockEntity string) {
        if (string.needsRecipeUpdate) {
            string.updateCache();
        }
        if (level.m_46467_() % 40L == 0L && !string.readStack().m_41619_()) {
            if (string.cachedRecipe == null) {
                string.resetCounter();
                return;
            }
            FirepitBlockEntity firepit = StringBlock.findFirepit(level, pos);
            if (firepit == null || firepit.getTemperature() <= 0.0f) {
                string.resetCounter();
            } else {
                firepit.getCapability(Capabilities.ITEM).ifPresent(inv -> {
                    for (int i = 0; i < 3; ++i) {
                        ItemStack item = inv.getStackInSlot(i);
                        if (item.m_41619_() || Helpers.isItem((ItemStack)item, FLTags.Items.SMOKING_FUEL)) continue;
                        FoodCapability.applyTrait((ItemStack)item, (FoodTrait)FLFoodTraits.RANCID_SMOKED);
                        string.resetCounter();
                    }
                });
            }
            if (string.getTicksLeft() <= 0L) {
                string.finish();
            }
        }
    }

    public StringBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.STRING.get(), pos, state, FLHelpers.blockEntityName("string"), (Supplier<Integer>)FLConfig.SERVER.smokingTicks);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        assert (this.f_58857_ != null);
        ItemStack current = ((ItemStackHandler)this.inventory).getStackInSlot(slot);
        if (!current.m_41619_()) {
            return FoodCapability.areStacksStackableExceptCreationDate((ItemStack)stack, (ItemStack)current);
        }
        return SmokingRecipe.getRecipe(this.f_58857_, new ItemStackInventory(stack)) != null;
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.markForSync();
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 8;
    }

    @Override
    public void updateCache() {
        assert (this.f_58857_ != null);
        this.cachedRecipe = SmokingRecipe.getRecipe(this.f_58857_, new ItemStackInventory(this.readStack()));
        this.needsRecipeUpdate = false;
    }
}

