/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks.greenhouse;

import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.eerussianguy.firmalife.common.blocks.greenhouse.AbstractSprinklerBlock;
import com.eerussianguy.firmalife.common.blocks.greenhouse.GreenhousePortBlock;
import com.eerussianguy.firmalife.common.blocks.greenhouse.HydroponicPlanterBlock;
import com.eerussianguy.firmalife.common.blocks.greenhouse.PumpingStationBlock;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SprinklerPipeBlock
extends ExtendedBlock
implements DirectionPropertyBlock {
    private static final VoxelShape[] SHAPES = new VoxelShape[64];

    public SprinklerPipeBlock(ExtendedProperties properties) {
        super(properties);
        this.m_49959_(DirectionPropertyBlock.setAllDirections((BlockState)((BlockState)this.m_49965_().m_61090_()), (boolean)false));
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        FluidHelpers.tickFluid((LevelAccessor)level, (BlockPos)currentPos, (BlockState)state);
        return this.updateConnectedSides(level, currentPos, state, null);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.updateConnectedSides((LevelAccessor)context.m_43725_(), context.m_8083_(), this.m_49966_(), context.m_7820_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int index = 0;
        for (Direction side : Helpers.DIRECTIONS) {
            if (!((Boolean)state.m_61143_((Property)DirectionPropertyBlock.getProperty((Direction)side))).booleanValue()) continue;
            index |= 1 << side.ordinal();
        }
        return SHAPES[index];
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return DirectionPropertyBlock.rotate((BlockState)state, (Rotation)rotation);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return DirectionPropertyBlock.mirror((BlockState)state, (Mirror)mirror);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_((Property[])PROPERTIES);
    }

    private BlockState updateConnectedSides(LevelAccessor level, BlockPos pos, BlockState state, @Nullable Direction defaultDirection) {
        int openSides = 0;
        Direction openDirection = null;
        for (Direction direction : Helpers.DIRECTIONS) {
            BlockPos adjacentPos;
            BlockState adjacentState;
            boolean adjacentConnection;
            BooleanProperty property = DirectionPropertyBlock.getProperty((Direction)direction);
            if (defaultDirection == null && ((Boolean)state.m_61143_((Property)property)).booleanValue()) {
                defaultDirection = direction;
            }
            if (adjacentConnection = this.connectsToPipeInDirection(adjacentState = level.m_8055_(adjacentPos = pos.m_121945_(direction)), direction)) {
                ++openSides;
                openDirection = direction;
            }
            state = (BlockState)state.m_61124_((Property)property, (Comparable)Boolean.valueOf(adjacentConnection));
        }
        if (openSides == 0) {
            assert (defaultDirection != null);
            return (BlockState)((BlockState)state.m_61124_((Property)DirectionPropertyBlock.getProperty((Direction)defaultDirection), (Comparable)Boolean.valueOf(true))).m_61124_((Property)DirectionPropertyBlock.getProperty((Direction)defaultDirection.m_122424_()), (Comparable)Boolean.valueOf(true));
        }
        if (openSides == 1) {
            return (BlockState)state.m_61124_((Property)DirectionPropertyBlock.getProperty((Direction)openDirection.m_122424_()), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    private boolean connectsToPipeInDirection(BlockState state, Direction direction) {
        AbstractSprinklerBlock sprinkler;
        Block block = state.m_60734_();
        return block == this || block instanceof AbstractSprinklerBlock && (sprinkler = (AbstractSprinklerBlock)block).getPipeConnection().test(direction) || direction == Direction.UP && block instanceof HydroponicPlanterBlock || block instanceof GreenhousePortBlock && state.m_61143_(GreenhousePortBlock.AXIS) == direction.m_122434_() || block == FLBlocks.IRRIGATION_TANK.get() && direction.m_122434_().m_122479_() || block == FLBlocks.PUMPING_STATION.get() && direction.m_122434_().m_122479_() && state.m_61143_((Property)PumpingStationBlock.FACING) != direction.m_122424_();
    }

    static {
        VoxelShape north = SprinklerPipeBlock.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0);
        VoxelShape south = SprinklerPipeBlock.m_49796_((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0);
        VoxelShape west = SprinklerPipeBlock.m_49796_((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
        VoxelShape east = SprinklerPipeBlock.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
        VoxelShape up = SprinklerPipeBlock.m_49796_((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        VoxelShape down = SprinklerPipeBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
        VoxelShape[] directions = new VoxelShape[]{down, up, north, south, east, west};
        VoxelShape center = SprinklerPipeBlock.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
        for (int i = 0; i < SHAPES.length; ++i) {
            VoxelShape shape = center;
            for (Direction direction : Helpers.DIRECTIONS) {
                if ((i >> direction.ordinal() & 1) != 1) continue;
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)directions[direction.ordinal()]);
            }
            SprinklerPipeBlock.SHAPES[i] = shape;
        }
    }
}

