/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.capabilities.wine;

import com.eerussianguy.firmalife.common.capabilities.wine.WineType;
import java.util.List;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Tooltips;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.climate.KoppenClimateClassification;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public interface IWine
extends INBTSerializable<CompoundTag> {
    public long getCreationDate();

    public void setCreationDate(long var1);

    public long getOpenDate();

    public void setOpenDate(long var1);

    @Nullable
    public String getLabelText();

    public void setLabelText(String var1);

    default public boolean isSealed() {
        return this.getOpenDate() == -1L;
    }

    public WineType getWineType();

    public void setWineType(WineType var1);

    @Nullable
    public KoppenClimateClassification getClimate();

    public void setClimate(KoppenClimateClassification var1);

    public List<FoodTrait> getTraits();

    public void setTraits(List<FoodTrait> var1);

    public IFluidHandler getFluidHandler();

    default public void addTooltipInfo(List<Component> tooltip) {
        FluidStack contained = this.getFluidHandler().getFluidInTank(0);
        if (contained.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"firmalife.wine.empty"));
            if (this.getLabelText() != null) {
                tooltip.add((Component)Component.m_237113_((String)this.getLabelText()));
            }
            return;
        }
        if (this.isSealed()) {
            if (this.getLabelText() != null) {
                tooltip.add((Component)Component.m_237113_((String)this.getLabelText()));
            }
            tooltip.add((Component)Component.m_237110_((String)"firmalife.wine.age_time", (Object[])new Object[]{Calendars.CLIENT.getTimeDelta(Calendars.CLIENT.getTicks() - this.getCreationDate())}));
        } else {
            if (this.getLabelText() != null) {
                tooltip.add((Component)Component.m_237113_((String)this.getLabelText()));
            }
            tooltip.add((Component)Component.m_237110_((String)"firmalife.wine.age_time_opened", (Object[])new Object[]{Calendars.CLIENT.getTimeDelta(this.getOpenDate() - this.getCreationDate())}));
            tooltip.add((Component)Tooltips.fluidUnits((int)contained.getAmount()).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
        }
        if (this.getClimate() != null) {
            tooltip.add((Component)Helpers.translateEnum((Enum)this.getClimate()).m_130940_(ChatFormatting.DARK_GREEN).m_130940_(ChatFormatting.ITALIC));
        }
        for (FoodTrait trait : this.getTraits()) {
            trait.addTooltipInfo(ItemStack.f_41583_, tooltip);
        }
    }
}

