/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.capabilities.wine;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.FLTags;
import com.eerussianguy.firmalife.common.capabilities.wine.IWine;
import com.eerussianguy.firmalife.common.capabilities.wine.WineCapability;
import com.eerussianguy.firmalife.common.capabilities.wine.WineType;
import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.ItemStackFluidHandler;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.util.climate.KoppenClimateClassification;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WineHandler
implements IWine,
ICapabilitySerializable<CompoundTag> {
    private final ItemStack stack;
    private long creationDate = -1L;
    private long openDate = -1L;
    private final LazyOptional<IWine> capability = LazyOptional.of(() -> this);
    private boolean initialized = false;
    @Nullable
    private String labelText = null;
    private WineType wineType = WineType.RED;
    @Nullable
    private KoppenClimateClassification climate = null;
    private List<FoodTrait> traits = new ArrayList<FoodTrait>();
    private final ItemStackFluidHandler fluidHandler;

    public WineHandler(ItemStack stack) {
        this.stack = stack;
        this.fluidHandler = new ItemStackFluidHandler(stack, FLTags.Fluids.WINE, () -> 2000);
    }

    @Override
    @Nullable
    public String getLabelText() {
        return this.labelText;
    }

    @Override
    public void setLabelText(String labelText) {
        this.labelText = labelText;
        this.save();
    }

    @Override
    public WineType getWineType() {
        return this.wineType;
    }

    @Override
    public void setWineType(WineType type) {
        this.wineType = type;
        this.save();
    }

    @Override
    @Nullable
    public KoppenClimateClassification getClimate() {
        return this.climate;
    }

    @Override
    public void setClimate(@Nullable KoppenClimateClassification koppen) {
        this.climate = koppen;
        this.save();
    }

    @Override
    public long getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(long ticks) {
        this.creationDate = ticks;
        this.save();
    }

    @Override
    public long getOpenDate() {
        return this.openDate;
    }

    @Override
    public void setOpenDate(long ticks) {
        this.openDate = ticks;
        this.save();
    }

    @Override
    public List<FoodTrait> getTraits() {
        return this.traits;
    }

    @Override
    public void setTraits(List<FoodTrait> traits) {
        this.traits = traits;
        this.save();
    }

    @Override
    public IFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    public CompoundTag serializeNBT() {
        return new CompoundTag();
    }

    public void deserializeNBT(CompoundTag nbt) {
    }

    private void load() {
        if (!this.initialized) {
            this.initialized = true;
            CompoundTag tag = this.stack.m_41784_();
            if (tag.m_128425_("wine", 10)) {
                CompoundTag wineTag = tag.m_128469_("wine");
                this.creationDate = wineTag.m_128454_("creationDate");
                this.openDate = wineTag.m_128454_("openDate");
                this.wineType = WineType.VALUES[wineTag.m_128451_("wineType")];
                if (wineTag.m_128425_("label", 8)) {
                    this.labelText = wineTag.m_128461_("label");
                }
                if (wineTag.m_128425_("climate", 3)) {
                    this.climate = WineType.KOPPEN_VALUES[wineTag.m_128451_("climate")];
                }
                FLHelpers.readTraitList(this.traits, wineTag, "traits");
            }
        }
    }

    private void save() {
        CompoundTag tag = this.stack.m_41784_();
        CompoundTag wineTag = new CompoundTag();
        wineTag.m_128356_("creationDate", this.creationDate);
        wineTag.m_128356_("openDate", this.openDate);
        wineTag.m_128405_("wineType", this.wineType.ordinal());
        if (this.labelText != null) {
            wineTag.m_128359_("label", this.labelText);
        }
        if (this.climate != null) {
            wineTag.m_128405_("climate", this.climate.ordinal());
        }
        FLHelpers.writeTraitList(this.traits, wineTag, "traits");
        tag.m_128365_("wine", (Tag)wineTag);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.FLUID_ITEM) {
            this.load();
            return this.fluidHandler.getCapability(cap, side).cast();
        }
        if (cap == WineCapability.CAPABILITY) {
            this.load();
            return this.capability.cast();
        }
        return LazyOptional.empty();
    }
}

