/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.items;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.capabilities.wine.IWine;
import com.eerussianguy.firmalife.common.capabilities.wine.WineCapability;
import com.eerussianguy.firmalife.common.capabilities.wine.WineHandler;
import com.eerussianguy.firmalife.common.items.WineBottleItem;
import java.util.List;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;

public class FilledWineBottleItem
extends WineBottleItem {
    public FilledWineBottleItem(Item.Properties properties, ResourceLocation modelLocation) {
        super(properties, modelLocation);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        BlockHitResult hit;
        ItemStack stack = player.m_21120_(hand);
        if (FluidHelpers.transferBetweenWorldAndItem((ItemStack)stack, (Level)level, (BlockHitResult)(hit = Helpers.rayTracePlayer((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY)), (Player)player, (InteractionHand)hand, (boolean)false, (boolean)false, (boolean)false)) {
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess carried) {
        if (action == ClickAction.SECONDARY && Helpers.isItem((ItemStack)other, (TagKey)TFCTags.Items.KNIVES)) {
            return stack.getCapability(WineCapability.CAPABILITY).map(wine -> {
                if (wine.isSealed()) {
                    player.m_216990_(SoundEvents.f_11716_);
                    wine.setOpenDate(Calendars.get((LevelReader)player.m_9236_()).getTicks());
                    other.m_41622_(1, (LivingEntity)player, p -> {});
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    public Component m_7626_(ItemStack stack) {
        IWine wine = (IWine)Helpers.getCapability((ICapabilityProvider)stack, WineCapability.CAPABILITY);
        return wine != null && wine.getCreationDate() > 0L ? Component.m_237110_((String)("firmalife.wine." + (wine.isSealed() ? "sealed" : "unsealed")), (Object[])new Object[]{FLHelpers.translateEnum(wine.getWineType())}) : super.m_7626_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag debug) {
        stack.getCapability(WineCapability.CAPABILITY).ifPresent(wine -> {
            if (wine.isSealed()) {
                tooltip.add((Component)Component.m_237115_((String)"firmalife.wine.how_to_open").m_130940_(ChatFormatting.GRAY));
            }
        });
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return new ItemStack((ItemLike)this);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return stack.getCapability(Capabilities.FLUID_ITEM).map(cap -> !cap.getFluidInTank(0).isEmpty()).orElse(false);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new WineHandler(stack);
    }
}

