/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.util;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.PouredGlassBlock;
import net.dries007.tfc.common.blocks.plant.BodyPlantBlock;
import net.dries007.tfc.common.blocks.plant.BranchingCactusBlock;
import net.dries007.tfc.common.blocks.plant.GrowingBranchingCactusBlock;
import net.dries007.tfc.common.blocks.plant.fruit.GrowingFruitTreeBranchBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.SelfTests;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.slf4j.Logger;

public class FLSelfTests {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static boolean EXTERNAL_ERROR = false;

    public static void reportExternalError() {
        EXTERNAL_ERROR = true;
    }

    public static void runServerSelfTests() {
        if (FLHelpers.ASSERTIONS_ENABLED) {
            Stopwatch tick = Stopwatch.createStarted();
            SelfTests.throwIfAny((boolean[])new boolean[]{FLSelfTests.validateOwnBlockLootTables(), FLSelfTests.validateOwnBlockMineableTags(), FLSelfTests.validateOwnBlockTags(), EXTERNAL_ERROR});
            LOGGER.info("Server self tests passed in {}", (Object)tick.stop());
        }
    }

    private static boolean validateOwnBlockLootTables() {
        Set expectedNoLootTableBlocks = Stream.of(FLBlocks.GRAPE_FLUFF_RED, FLBlocks.GRAPE_FLUFF_WHITE).map(Supplier::get).collect(Collectors.toSet());
        ImmutableSet expectedNoLootTableClasses = ImmutableSet.of(BodyPlantBlock.class, GrowingFruitTreeBranchBlock.class, LiquidBlock.class, BranchingCactusBlock.class, GrowingBranchingCactusBlock.class, PouredGlassBlock.class, (Object[])new Class[0]);
        return SelfTests.validateBlockLootTables(SelfTests.stream((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"firmalife").filter(b -> !expectedNoLootTableBlocks.contains(b)).filter(arg_0 -> FLSelfTests.lambda$validateOwnBlockLootTables$1((Set)expectedNoLootTableClasses, arg_0)), (Logger)LOGGER);
    }

    private static boolean validateOwnBlockMineableTags() {
        Set expectedNotMineableBlocks = Stream.of(FLBlocks.SMALL_CHROMITE, FLBlocks.HOLLOW_SHELL).map(Supplier::get).collect(Collectors.toSet());
        Set<TagKey> mineableTags = Set.of(BlockTags.f_144280_, BlockTags.f_144281_, BlockTags.f_144282_, BlockTags.f_144283_, TFCTags.Blocks.MINEABLE_WITH_PROPICK, TFCTags.Blocks.MINEABLE_WITH_HAMMER, TFCTags.Blocks.MINEABLE_WITH_KNIFE, TFCTags.Blocks.MINEABLE_WITH_SCYTHE, TFCTags.Blocks.MINEABLE_WITH_CHISEL, TFCTags.Blocks.MINEABLE_WITH_GLASS_SAW);
        List<Block> missingTag = SelfTests.stream((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"firmalife").filter(b -> !(b instanceof LiquidBlock) && b.m_155943_() > 0.0f && !expectedNotMineableBlocks.contains(b) && mineableTags.stream().noneMatch(t -> Helpers.isBlock((Block)b, (TagKey)t))).toList();
        return SelfTests.logRegistryErrors((String)"{} non-fluid blocks have no mineable_with_<tool> tag.", missingTag, (Logger)LOGGER);
    }

    private static boolean validateOwnBlockTags() {
        return SelfTests.validateBlocksHaveTag(SelfTests.stream((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"firmalife").filter(b -> b instanceof WallBlock), (TagKey)BlockTags.f_13032_, (Logger)LOGGER) | SelfTests.validateBlocksHaveTag(SelfTests.stream((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"firmalife").filter(b -> b instanceof StairBlock), (TagKey)BlockTags.f_13030_, (Logger)LOGGER) | SelfTests.validateBlocksHaveTag(SelfTests.stream((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"firmalife").filter(b -> b instanceof SlabBlock), (TagKey)BlockTags.f_13031_, (Logger)LOGGER);
    }

    private static /* synthetic */ boolean lambda$validateOwnBlockLootTables$1(Set expectedNoLootTableClasses, Block b) {
        return !expectedNoLootTableClasses.contains(b.getClass());
    }
}

