/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.compat.jei;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.eerussianguy.firmalife.common.items.FLItems;
import com.eerussianguy.firmalife.common.recipes.DryingRecipe;
import com.eerussianguy.firmalife.common.recipes.FLRecipeSerializers;
import com.eerussianguy.firmalife.common.recipes.FLRecipeTypes;
import com.eerussianguy.firmalife.common.recipes.MixingBowlRecipe;
import com.eerussianguy.firmalife.common.recipes.OvenRecipe;
import com.eerussianguy.firmalife.common.recipes.PressRecipe;
import com.eerussianguy.firmalife.common.recipes.SmokingRecipe;
import com.eerussianguy.firmalife.common.recipes.StompingRecipe;
import com.eerussianguy.firmalife.common.recipes.VatRecipe;
import com.eerussianguy.firmalife.compat.jei.BowlPotCategory;
import com.eerussianguy.firmalife.compat.jei.DryingCategory;
import com.eerussianguy.firmalife.compat.jei.MixingCategory;
import com.eerussianguy.firmalife.compat.jei.OvenCategory;
import com.eerussianguy.firmalife.compat.jei.PressCategory;
import com.eerussianguy.firmalife.compat.jei.SmokingCategory;
import com.eerussianguy.firmalife.compat.jei.StinkySoupCategory;
import com.eerussianguy.firmalife.compat.jei.StompingCategory;
import com.eerussianguy.firmalife.compat.jei.VatCategory;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.recipes.KnappingRecipe;
import net.dries007.tfc.common.recipes.PotRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

@JeiPlugin
public class FLJEIPlugin
implements IModPlugin {
    public static final RecipeType<DryingRecipe> DRYING = FLJEIPlugin.type("drying", DryingRecipe.class);
    public static final RecipeType<SmokingRecipe> SMOKING = FLJEIPlugin.type("smoking", SmokingRecipe.class);
    public static final RecipeType<StompingRecipe> STOMPING = FLJEIPlugin.type("stomping", StompingRecipe.class);
    public static final RecipeType<PressRecipe> PRESS = FLJEIPlugin.type("press", PressRecipe.class);
    public static final RecipeType<MixingBowlRecipe> MIXING_BOWL = FLJEIPlugin.type("mixing_bowl", MixingBowlRecipe.class);
    public static final RecipeType<KnappingRecipe> PUMPKIN_KNAPPING = FLJEIPlugin.type("pumpkin_knapping", KnappingRecipe.class);
    public static final RecipeType<OvenRecipe> OVEN = FLJEIPlugin.type("oven", OvenRecipe.class);
    public static final RecipeType<VatRecipe> VAT = FLJEIPlugin.type("vat", VatRecipe.class);
    public static final RecipeType<PotRecipe> BOWL_POT = FLJEIPlugin.type("bowl_pot", PotRecipe.class);
    public static final RecipeType<PotRecipe> STINKY_SOUP = FLJEIPlugin.type("stinky_soup", PotRecipe.class);

    private static <T> RecipeType<T> type(String name, Class<T> tClass) {
        return RecipeType.create((String)"firmalife", (String)name, tClass);
    }

    public ResourceLocation getPluginUid() {
        return FLHelpers.identifier("jei");
    }

    public void registerCategories(IRecipeCategoryRegistration r) {
        IGuiHelper gui = r.getJeiHelpers().getGuiHelper();
        r.addRecipeCategories(new IRecipeCategory[]{new DryingCategory(DRYING, gui)});
        r.addRecipeCategories(new IRecipeCategory[]{new SmokingCategory(SMOKING, gui)});
        r.addRecipeCategories(new IRecipeCategory[]{new StompingCategory(STOMPING, gui)});
        r.addRecipeCategories(new IRecipeCategory[]{new PressCategory(PRESS, gui)});
        r.addRecipeCategories(new IRecipeCategory[]{new MixingCategory(MIXING_BOWL, gui)});
        r.addRecipeCategories(new IRecipeCategory[]{new OvenCategory(OVEN, gui)});
        r.addRecipeCategories(new IRecipeCategory[]{new VatCategory(VAT, gui)});
        r.addRecipeCategories(new IRecipeCategory[]{new StinkySoupCategory(STINKY_SOUP, gui)});
        r.addRecipeCategories(new IRecipeCategory[]{new BowlPotCategory(BOWL_POT, gui)});
    }

    public void registerRecipes(IRecipeRegistration r) {
        r.addRecipes(DRYING, FLJEIPlugin.recipes((net.minecraft.world.item.crafting.RecipeType)FLRecipeTypes.DRYING.get()));
        r.addRecipes(SMOKING, FLJEIPlugin.recipes((net.minecraft.world.item.crafting.RecipeType)FLRecipeTypes.SMOKING.get()));
        r.addRecipes(STOMPING, FLJEIPlugin.recipes((net.minecraft.world.item.crafting.RecipeType)FLRecipeTypes.STOMPING.get()));
        r.addRecipes(PRESS, FLJEIPlugin.recipes((net.minecraft.world.item.crafting.RecipeType)FLRecipeTypes.PRESS.get()));
        r.addRecipes(MIXING_BOWL, FLJEIPlugin.recipes((net.minecraft.world.item.crafting.RecipeType)FLRecipeTypes.MIXING_BOWL.get()));
        r.addRecipes(OVEN, FLJEIPlugin.recipes((net.minecraft.world.item.crafting.RecipeType)FLRecipeTypes.OVEN.get()));
        r.addRecipes(VAT, FLJEIPlugin.recipes((net.minecraft.world.item.crafting.RecipeType)FLRecipeTypes.VAT.get()));
        r.addRecipes(BOWL_POT, FLJEIPlugin.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.POT.get(), recipe -> recipe.m_7707_() == FLRecipeSerializers.BOWL_POT.get()));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration r) {
        FLJEIPlugin.cat(r, FLBlocks.DRYING_MAT, DRYING);
        FLJEIPlugin.cat(r, FLBlocks.SOLAR_DRIER, DRYING);
        FLJEIPlugin.cat(r, (Item)TFCItems.WOOL_YARN.get(), SMOKING);
        FLJEIPlugin.cat(r, FLBlocks.MIXING_BOWL, MIXING_BOWL);
        FLJEIPlugin.cat(r, (Item)FLItems.SPOON.get(), MIXING_BOWL);
        FLJEIPlugin.cat(r, (Supplier<? extends Block>)TFCBlocks.PUMPKIN, PUMPKIN_KNAPPING);
        FLBlocks.CURED_OVEN_TOP.values().forEach(oven -> FLJEIPlugin.cat(r, (Supplier<? extends Block>)oven, OVEN));
        FLJEIPlugin.cat(r, FLBlocks.VAT, VAT);
        FLJEIPlugin.cat(r, (Item)TFCItems.POT.get(), BOWL_POT);
        FLJEIPlugin.cat(r, (Item)TFCItems.POT.get(), STINKY_SOUP);
        FLBlocks.STOMPING_BARRELS.values().forEach(barrel -> FLJEIPlugin.cat(r, (Supplier<? extends Block>)barrel, STOMPING));
        FLBlocks.BARREL_PRESSES.values().forEach(barrel -> FLJEIPlugin.cat(r, (Supplier<? extends Block>)barrel, PRESS));
    }

    private static void cat(IRecipeCatalystRegistration r, Supplier<? extends Block> supplier, RecipeType<?> type) {
        r.addRecipeCatalyst(new ItemStack((ItemLike)supplier.get()), new RecipeType[]{type});
    }

    private static void cat(IRecipeCatalystRegistration r, Item item, RecipeType<?> type) {
        r.addRecipeCatalyst(new ItemStack((ItemLike)item), new RecipeType[]{type});
    }

    private static <C extends Container, T extends Recipe<C>> List<T> recipes(net.minecraft.world.item.crafting.RecipeType<T> type, Predicate<T> filter) {
        return FLJEIPlugin.recipes(type).stream().filter(filter).collect(Collectors.toList());
    }

    private static <C extends Container, T extends Recipe<C>> List<T> recipes(net.minecraft.world.item.crafting.RecipeType<T> type) {
        return ClientHelpers.getLevelOrThrow().m_7465_().m_44013_(type);
    }
}

