/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.compat.tooltip;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.BarrelPressBlockEntity;
import com.eerussianguy.firmalife.common.blockentities.CompostTumblerBlockEntity;
import com.eerussianguy.firmalife.common.blockentities.DryingMatBlockEntity;
import com.eerussianguy.firmalife.common.blockentities.FoodShelfBlockEntity;
import com.eerussianguy.firmalife.common.blockentities.JarbnetBlockEntity;
import com.eerussianguy.firmalife.common.blockentities.OvenLike;
import com.eerussianguy.firmalife.common.blockentities.OvenTopBlockEntity;
import com.eerussianguy.firmalife.common.blockentities.StringBlockEntity;
import com.eerussianguy.firmalife.common.blockentities.VatBlockEntity;
import com.eerussianguy.firmalife.common.blocks.AbstractOvenBlock;
import com.eerussianguy.firmalife.common.blocks.CheeseWheelBlock;
import com.eerussianguy.firmalife.common.blocks.CompostTumblerBlock;
import com.eerussianguy.firmalife.common.blocks.DryingMatBlock;
import com.eerussianguy.firmalife.common.blocks.FoodShelfBlock;
import com.eerussianguy.firmalife.common.blocks.HangerBlock;
import com.eerussianguy.firmalife.common.blocks.ICure;
import com.eerussianguy.firmalife.common.blocks.JarbnetBlock;
import com.eerussianguy.firmalife.common.blocks.OvenBottomBlock;
import com.eerussianguy.firmalife.common.blocks.OvenTopBlock;
import com.eerussianguy.firmalife.common.blocks.SolarDrierBlock;
import com.eerussianguy.firmalife.common.blocks.StringBlock;
import com.eerussianguy.firmalife.common.blocks.VatBlock;
import com.eerussianguy.firmalife.common.blocks.greenhouse.PumpingStationBlock;
import com.eerussianguy.firmalife.common.blocks.plant.FLFruitTreeSaplingBlock;
import com.eerussianguy.firmalife.common.capabilities.wine.WineType;
import com.eerussianguy.firmalife.common.items.FLFoodTraits;
import com.eerussianguy.firmalife.config.FLConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeSaplingBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.compat.jade.common.BlockEntityTooltip;
import net.dries007.tfc.compat.jade.common.BlockEntityTooltips;
import net.dries007.tfc.compat.jade.common.EntityTooltip;
import net.dries007.tfc.compat.jade.common.RegisterCallback;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.config.TemperatureDisplayStyle;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;

public final class FLTooltips {
    private static MutableComponent delta(Level level, long ticks) {
        return Calendars.get((LevelReader)level).getTimeDelta(ticks);
    }

    public static final class Entities {
        public static void register(RegisterCallback<EntityTooltip, Entity> r) {
        }
    }

    public static final class BlockEntities {
        public static final BlockEntityTooltip VAT = (level, state, pos, entity, tooltip) -> {
            if (entity instanceof VatBlockEntity) {
                VatBlockEntity vat = (VatBlockEntity)entity;
                if (vat.isBoiling()) {
                    tooltip.accept(Component.m_237115_((String)"firmalife.jade.boiling"));
                } else if (!vat.hasOutput() && !((Boolean)state.m_61143_((Property)VatBlock.SEALED)).booleanValue()) {
                    tooltip.accept(Component.m_237115_((String)"firmalife.jade.close_lid"));
                }
                if (vat.hasOutput()) {
                    tooltip.accept(vat.getOutput().m_41786_());
                }
                BlockEntityTooltips.heat((Consumer)tooltip, (float)vat.getTemperature());
            }
        };
        public static final BlockEntityTooltip TUMBLER = (level, state, pos, entity, tooltip) -> {
            if (entity instanceof CompostTumblerBlockEntity) {
                CompostTumblerBlockEntity tumbler = (CompostTumblerBlockEntity)entity;
                if (tumbler.canWork()) {
                    BlockEntityTooltips.timeLeft((Level)level, (Consumer)tooltip, (long)(tumbler.getReadyTicks() - tumbler.getTicksSinceUpdate()), (Component)Component.m_237115_((String)"firmalife.tumbler.almost_ready"));
                }
                for (CompostTumblerBlockEntity.AdditionType type : CompostTumblerBlockEntity.AdditionType.VALUES) {
                    float pct;
                    if (type == CompostTumblerBlockEntity.AdditionType.NONE || type == CompostTumblerBlockEntity.AdditionType.POISON || !((pct = tumbler.getPercentage(type)) > 0.0f)) continue;
                    tooltip.accept(Component.m_237110_((String)"firmalife.tumbler.component_pct", (Object[])new Object[]{FLHelpers.translateEnum(type), String.format("%.2f", Float.valueOf(pct))}));
                }
                if (tumbler.isReady()) {
                    if (tumbler.isRotten()) {
                        tooltip.accept(Component.m_237115_((String)"firmalife.tumbler.rotten"));
                    } else {
                        tooltip.accept(Component.m_237115_((String)"firmalife.tumbler.ready"));
                    }
                }
                tooltip.accept(Component.m_237110_((String)"firmalife.tumbler.total", (Object[])new Object[]{tumbler.getTotal()}));
            }
        };
        public static final BlockEntityTooltip DRYING_MAT = (level, state, pos, entity, tooltip) -> {
            Block patt5724$temp = state.m_60734_();
            if (patt5724$temp instanceof DryingMatBlock) {
                DryingMatBlockEntity mat;
                DryingMatBlock block = (DryingMatBlock)patt5724$temp;
                if (entity instanceof DryingMatBlockEntity && !(mat = (DryingMatBlockEntity)entity).viewStack().m_41619_() && mat.getCachedRecipe() != null && mat.getTicksLeft() > 0L) {
                    tooltip.accept(Component.m_237110_((String)"tfc.jade.time_left", (Object[])new Object[]{FLTooltips.delta(level, mat.getTicksLeft())}));
                }
            }
        };
        public static final BlockEntityTooltip STRING = (level, state, pos, entity, tooltip) -> {
            Block patt6233$temp = state.m_60734_();
            if (patt6233$temp instanceof StringBlock) {
                StringBlock block = (StringBlock)patt6233$temp;
                if (entity instanceof StringBlockEntity) {
                    StringBlockEntity mat = (StringBlockEntity)entity;
                    tooltip.accept(Component.m_237115_((String)("firmalife.jade." + (StringBlock.findFirepit(level, pos) != null ? "has_firepit" : "no_firepit"))));
                    ItemStack item = mat.viewStack();
                    if (!item.m_41619_()) {
                        List traits;
                        IFood food = item.getCapability(FoodCapability.CAPABILITY).resolve().orElse(null);
                        List list = traits = food == null ? null : food.getTraits();
                        if (mat.getCachedRecipe() != null) {
                            tooltip.accept(Component.m_237110_((String)"tfc.jade.time_left", (Object[])new Object[]{FLTooltips.delta(level, mat.getTicksLeft())}));
                        } else if (traits != null) {
                            ArrayList text = new ArrayList();
                            if (traits.contains(FLFoodTraits.SMOKED)) {
                                FLFoodTraits.SMOKED.addTooltipInfo(item, text);
                            }
                            if (traits.contains(FLFoodTraits.RANCID_SMOKED)) {
                                FLFoodTraits.RANCID_SMOKED.addTooltipInfo(item, text);
                            }
                            if (!text.isEmpty()) {
                                text.forEach(tooltip);
                            }
                        }
                    }
                }
            }
        };
        public static final BlockEntityTooltip CHEESE = (level, state, pos, entity, tooltip) -> {
            Block patt7891$temp = state.m_60734_();
            if (patt7891$temp instanceof CheeseWheelBlock) {
                CheeseWheelBlock block = (CheeseWheelBlock)patt7891$temp;
                if (((Boolean)state.m_61143_((Property)CheeseWheelBlock.AGING)).booleanValue()) {
                    tooltip.accept(Component.m_237115_((String)"firmalife.jade.aging"));
                } else {
                    tooltip.accept(Component.m_237115_((String)"firmalife.jade.not_aging"));
                }
                tooltip.accept(Component.m_237110_((String)"firmalife.jade.slices", (Object[])new Object[]{state.m_61143_((Property)CheeseWheelBlock.COUNT)}));
                tooltip.accept(Component.m_237110_((String)"firmalife.jade.food_age", (Object[])new Object[]{FLHelpers.translateEnum((Enum)((Object)state.m_61143_(CheeseWheelBlock.AGE)))}));
            }
        };
        public static final BlockEntityTooltip SHELF_OR_HANGER = (level, state, pos, entity, tooltip) -> {
            BlockEntity patt8707$temp = level.m_7702_(pos);
            if (patt8707$temp instanceof FoodShelfBlockEntity) {
                FoodShelfBlockEntity shelf = (FoodShelfBlockEntity)patt8707$temp;
                if (shelf.isClimateValid()) {
                    tooltip.accept(Component.m_237115_((String)"firmalife.cellar.valid_block"));
                } else {
                    tooltip.accept(Component.m_237115_((String)"firmalife.cellar.invalid_block"));
                }
                shelf.getCapability(Capabilities.ITEM).ifPresent(inv -> {
                    ItemStack stack = inv.getStackInSlot(0);
                    stack.getCapability(FoodCapability.CAPABILITY).ifPresent(food -> {
                        ArrayList foodTooltip = new ArrayList();
                        food.addTooltipInfo(stack, foodTooltip);
                        foodTooltip.forEach(tooltip);
                    });
                });
            }
        };
        public static final BlockEntityTooltip OVEN = (level, state, pos, entity, tooltip) -> {
            AbstractOvenBlock block;
            Block patt12161$temp;
            if (entity instanceof OvenLike) {
                ICure cure;
                Block patt10049$temp;
                OvenLike oven = (OvenLike)entity;
                BlockEntityTooltips.heat((Consumer)tooltip, (float)oven.getTemperature());
                if (oven.getTemperature() > 100.0f && oven instanceof OvenTopBlockEntity) {
                    tooltip.accept(Component.m_237115_((String)"firmalife.jade.needs_peel"));
                }
                if ((patt10049$temp = state.m_60734_()) instanceof ICure && !(cure = (ICure)patt10049$temp).isCured()) {
                    if (oven.getTemperature() < (float)((Integer)FLConfig.SERVER.ovenCureTemperature.get()).intValue()) {
                        tooltip.accept(Component.m_237115_((String)"firmalife.jade.cannot_cure"));
                    } else {
                        tooltip.accept(Component.m_237110_((String)"firmalife.jade.cure_time_left", (Object[])new Object[]{FLTooltips.delta(level, (Integer)FLConfig.SERVER.ovenCureTicks.get() - oven.getCureTicks())}));
                    }
                }
                if (entity instanceof OvenTopBlockEntity) {
                    OvenTopBlockEntity top = (OvenTopBlockEntity)entity;
                    entity.getCapability(Capabilities.ITEM).ifPresent(inv -> {
                        for (int i = 0; i < inv.getSlots(); ++i) {
                            ItemStack stack;
                            int ticksLeft = top.getTicksLeft(i);
                            if (ticksLeft <= 0 || (stack = inv.getStackInSlot(i)).m_41619_()) continue;
                            float temp = HeatCapability.getTemperature((ItemStack)stack);
                            MutableComponent tempComponent = ((TemperatureDisplayStyle)TFCConfig.CLIENT.heatTooltipStyle.get()).formatColored(temp);
                            if (temp > 0.0f && tempComponent != null) {
                                tooltip.accept(Component.m_237110_((String)"firmalife.jade.cook_left_temp", (Object[])new Object[]{stack.m_41786_(), FLTooltips.delta(level, ticksLeft), tempComponent}));
                                continue;
                            }
                            tooltip.accept(Component.m_237110_((String)"firmalife.jade.cook_left", (Object[])new Object[]{stack.m_41786_(), FLTooltips.delta(level, ticksLeft)}));
                        }
                    });
                }
            }
            if ((patt12161$temp = state.m_60734_()) instanceof AbstractOvenBlock && !(block = (AbstractOvenBlock)patt12161$temp).isInsulated((LevelAccessor)level, pos, state)) {
                tooltip.accept(Component.m_237115_((String)"firmalife.jade.not_insulated"));
            }
            if (!((Boolean)state.m_61143_((Property)AbstractOvenBlock.HAS_CHIMNEY)).booleanValue()) {
                tooltip.accept(Component.m_237115_((String)"firmalife.jade.no_chimney"));
            }
        };
        public static final BlockEntityTooltip FRUIT_TREE_SAPLING = (level, state, pos, entity, tooltip) -> {
            if (entity instanceof TickCounterBlockEntity) {
                TickCounterBlockEntity counter = (TickCounterBlockEntity)entity;
                Block patt12738$temp = state.m_60734_();
                if (patt12738$temp instanceof FruitTreeSaplingBlock) {
                    FruitTreeSaplingBlock sapling = (FruitTreeSaplingBlock)patt12738$temp;
                    BlockEntityTooltips.timeLeft((Level)level, (Consumer)tooltip, (long)((long)((double)(sapling.getTreeGrowthDays() * 24000) * (Double)TFCConfig.SERVER.globalFruitSaplingGrowthModifier.get()) - counter.getTicksSinceUpdate()), (Component)Component.m_237115_((String)"tfc.jade.ready_to_grow"));
                }
            }
        };
        public static final BlockEntityTooltip JARBNET = (level, state, pos, entity, tooltip) -> {
            if (entity instanceof JarbnetBlockEntity) {
                JarbnetBlockEntity counter = (JarbnetBlockEntity)entity;
                if (((Boolean)state.m_61143_((Property)JarbnetBlock.LIT)).booleanValue()) {
                    BlockEntityTooltips.timeLeft((Level)level, (Consumer)tooltip, (long)((long)((Integer)TFCConfig.SERVER.candleTicks.get()).intValue() - counter.getTicksSinceUpdate()));
                }
            }
        };
        public static final BlockEntityTooltip BARREL_PRESS = (level, state, pos, entity, tooltip) -> {
            if (entity instanceof BarrelPressBlockEntity) {
                WineType type;
                BarrelPressBlockEntity press = (BarrelPressBlockEntity)entity;
                if (press.getOutput() != null) {
                    tooltip.accept(Component.m_237110_((String)"firmalife.wine.has_output", (Object[])new Object[]{press.getOutput().getServings(), FLHelpers.translateEnum(press.getOutput().getType())}));
                }
                if ((type = press.getWineType()) != null) {
                    tooltip.accept(Component.m_237110_((String)"firmalife.wine.making", (Object[])new Object[]{FLHelpers.translateEnum(type)}));
                }
            }
        };

        public static void register(RegisterCallback<BlockEntityTooltip, Block> r) {
            BlockEntities.register(r, "drying_mat", DRYING_MAT, DryingMatBlock.class);
            BlockEntities.register(r, "solar_drier", DRYING_MAT, SolarDrierBlock.class);
            BlockEntities.register(r, "string", STRING, StringBlock.class);
            BlockEntities.register(r, "cheese", CHEESE, CheeseWheelBlock.class);
            BlockEntities.register(r, "oven_bottom", OVEN, OvenBottomBlock.class);
            BlockEntities.register(r, "oven_top", OVEN, OvenTopBlock.class);
            BlockEntities.register(r, "shelf", SHELF_OR_HANGER, FoodShelfBlock.class);
            BlockEntities.register(r, "hanger", SHELF_OR_HANGER, HangerBlock.class);
            BlockEntities.register(r, "vat", VAT, VatBlock.class);
            BlockEntities.register(r, "tumbler", TUMBLER, CompostTumblerBlock.class);
            BlockEntities.register(r, "fruit_tree_sapling", FRUIT_TREE_SAPLING, FLFruitTreeSaplingBlock.class);
            BlockEntities.register(r, "jarbnet", JARBNET, JarbnetBlock.class);
            BlockEntities.register(r, "barrel_press", BARREL_PRESS, JarbnetBlock.class);
            BlockEntities.register(r, "pumping_station", BlockEntityTooltips.ROTATING, PumpingStationBlock.class);
        }

        private static void register(RegisterCallback<BlockEntityTooltip, Block> r, String name, BlockEntityTooltip tooltip, Class<? extends Block> aClass) {
            r.register(FLHelpers.identifier(name), (Object)tooltip, aClass);
        }
    }
}

