/*
 * Decompiled with CFR 0.152.
 */
package com.cobblehunts.utils;

import com.everlastingutils.utils.LogDebugKt;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001*B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u001d\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ/\u0010\u0010\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000f0\u000e2\u0006\u0010\r\u001a\u00020\t\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00162\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00162\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bR \u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001d0\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR \u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00190 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u001c\u0010%\u001a\n $*\u0004\u0018\u00010#0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u001c\u0010(\u001a\n $*\u0004\u0018\u00010'0'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)\u00a8\u0006+"}, d2={"Lcom/cobblehunts/utils/LeaderboardManager;", "", "<init>", "()V", "", "loadData", "saveData", "", "playerName", "", "points", "addPoints", "(Ljava/lang/String;I)V", "limit", "", "Lkotlin/Triple;", "getTopPlayers", "(I)Ljava/util/List;", "getAllPlayerNames", "()Ljava/util/List;", "Lnet/minecraft/server/MinecraftServer;", "server", "Ljava/util/concurrent/CompletableFuture;", "updatePlayerTexture", "(Ljava/lang/String;Lnet/minecraft/server/MinecraftServer;)Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/authlib/GameProfile;", "fetchMojangProfile", "(Ljava/lang/String;)Ljava/util/concurrent/CompletableFuture;", "", "Lcom/cobblehunts/utils/LeaderboardManager$PlayerData;", "data", "Ljava/util/Map;", "Ljava/util/concurrent/ConcurrentHashMap;", "mojangProfileCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "mojangProfileExecutor", "Ljava/util/concurrent/ExecutorService;", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "PlayerData", "cobblehunts"})
@SourceDebugExtension(value={"SMAP\nLeaderboardManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LeaderboardManager.kt\ncom/cobblehunts/utils/LeaderboardManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,197:1\n1068#2:198\n1563#2:199\n1634#2,3:200\n1#3:203\n*S KotlinDebug\n*F\n+ 1 LeaderboardManager.kt\ncom/cobblehunts/utils/LeaderboardManager\n*L\n92#1:198\n94#1:199\n94#1:200,3\n*E\n"})
public final class LeaderboardManager {
    @NotNull
    public static final LeaderboardManager INSTANCE = new LeaderboardManager();
    @NotNull
    private static final Map<String, PlayerData> data = new LinkedHashMap();
    @NotNull
    private static final ConcurrentHashMap<String, GameProfile> mojangProfileCache = new ConcurrentHashMap();
    private static final ExecutorService mojangProfileExecutor = Executors.newSingleThreadExecutor();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    private LeaderboardManager() {
    }

    private final void loadData() {
        File file = new File("config/cobblehunts/leaderboard.json");
        if (file.exists()) {
            String json = FilesKt.readText$default((File)file, null, (int)1, null);
            try {
                Type newType2 = new TypeToken<Map<String, ? extends PlayerData>>(){}.getType();
                Object object = gson.fromJson(json, newType2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                Map map = (Map)object;
                data.putAll(map);
            }
            catch (Exception e) {
                try {
                    Type rawType2 = new TypeToken<Map<String, ? extends Object>>(){}.getType();
                    Object object = gson.fromJson(json, rawType2);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                    Map rawMap = (Map)object;
                    boolean migrated = false;
                    for (Map.Entry entry : rawMap.entrySet()) {
                        String playerName = (String)entry.getKey();
                        Object value = entry.getValue();
                        Object v = value;
                        if (v instanceof Number) {
                            data.put(playerName, new PlayerData(((Number)value).intValue(), null));
                            migrated = true;
                            continue;
                        }
                        if (v instanceof Map) {
                            Object v2 = ((Map)value).get("points");
                            Number number = v2 instanceof Number ? (Number)((Number)v2) : (Number)null;
                            int points = number != null ? number.intValue() : 0;
                            v2 = ((Map)value).get("texture");
                            String texture = v2 instanceof String ? (String)v2 : null;
                            data.put(playerName, new PlayerData(points, texture));
                            continue;
                        }
                        LogDebugKt.logDebug((String)("DEBUG: Invalid data for player '" + playerName + "'"), (String)"cobblehunts");
                    }
                    if (migrated) {
                        this.saveData();
                        LogDebugKt.logDebug((String)"DEBUG: Migrated old leaderboard data to new format", (String)"cobblehunts");
                    }
                }
                catch (Exception e2) {
                    LogDebugKt.logDebug((String)("DEBUG: Failed to load leaderboard data: " + e2.getMessage()), (String)"cobblehunts");
                }
            }
        }
    }

    private final void saveData() {
        File file = new File("config/cobblehunts/leaderboard.json");
        file.getParentFile().mkdirs();
        String json = gson.toJson(data);
        Intrinsics.checkNotNull((Object)json);
        FilesKt.writeText$default((File)file, (String)json, null, (int)2, null);
    }

    public final void addPoints(@NotNull String playerName, int points) {
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        PlayerData playerData = data.getOrDefault(playerName, new PlayerData(0, null));
        data.put(playerName, PlayerData.copy$default(playerData, playerData.getPoints() + points, null, 2, null));
        this.saveData();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Triple<String, Integer, String>> getTopPlayers(int limit) {
        void $this$mapTo$iv$iv;
        Iterable $this$sortedByDescending$iv = data.entrySet();
        boolean $i$f$sortedByDescending = false;
        Iterable $this$map$iv = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((PlayerData)it.getValue()).getPoints());
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((PlayerData)it.getValue()).getPoints()));
            }
        }), (int)limit);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Triple(it.getKey(), (Object)((PlayerData)it.getValue()).getPoints(), (Object)((PlayerData)it.getValue()).getTexture()));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<String> getAllPlayerNames() {
        return CollectionsKt.toList((Iterable)data.keySet());
    }

    @NotNull
    public final CompletableFuture<String> updatePlayerTexture(@NotNull String playerName, @NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        CompletableFuture<String> completableFuture = CompletableFuture.supplyAsync(() -> LeaderboardManager.updatePlayerTexture$lambda$6(playerName, server));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    @NotNull
    public final CompletableFuture<GameProfile> fetchMojangProfile(@NotNull String playerName) {
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        GameProfile gameProfile = mojangProfileCache.get(playerName);
        if (gameProfile != null) {
            GameProfile it = gameProfile;
            boolean bl = false;
            LogDebugKt.logDebug((String)("DEBUG: Returning cached Mojang profile for '" + playerName + "'"), (String)"cobblehunts");
            CompletableFuture<GameProfile> completableFuture = CompletableFuture.completedFuture(it);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        CompletableFuture<GameProfile> completableFuture = CompletableFuture.supplyAsync(() -> LeaderboardManager.fetchMojangProfile$lambda$10(playerName), mojangProfileExecutor);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    private static final String updatePlayerTexture$lambda$6(String $playerName, MinecraftServer $server) {
        Object object;
        block8: {
            PlayerData updatedData;
            String texture;
            String string;
            PlayerData playerData;
            block9: {
                block7: {
                    PlayerData playerData2 = playerData = data.get($playerName);
                    if ((playerData2 != null ? playerData2.getTexture() : null) == null) break block7;
                    LogDebugKt.logDebug((String)("DEBUG: Using stored texture for '" + $playerName + "' from JSON"), (String)"cobblehunts");
                    object = playerData.getTexture();
                    break block8;
                }
                object = $server.method_3760().method_14566($playerName);
                if (object == null) break block9;
                Object onlinePlayer = object;
                boolean bl = false;
                Collection collection = onlinePlayer.method_7334().getProperties().get((Object)"textures");
                texture = string = collection != null && (collection = (Property)CollectionsKt.firstOrNull((Iterable)collection)) != null ? collection.value() : null;
                boolean bl2 = false;
                if (texture != null) {
                    PlayerData playerData3 = playerData;
                    if (playerData3 == null) {
                        playerData3 = new PlayerData(0, null);
                    }
                    updatedData = PlayerData.copy$default(playerData3, 0, texture, 1, null);
                    data.put($playerName, updatedData);
                    INSTANCE.saveData();
                    LogDebugKt.logDebug((String)("DEBUG: Fetched and stored texture for online player '" + $playerName + "'"), (String)"cobblehunts");
                }
                String string2 = string;
                object = string2;
                if (string2 != null) break block8;
            }
            LeaderboardManager $this$updatePlayerTexture_u24lambda_u246_u24lambda_u245 = INSTANCE;
            boolean bl = false;
            Object object2 = $this$updatePlayerTexture_u24lambda_u246_u24lambda_u245.fetchMojangProfile($playerName).join();
            texture = string = object2 != null && (object2 = object2.getProperties()) != null && (object2 = object2.get((Object)"textures")) != null && (object2 = (Property)CollectionsKt.firstOrNull((Iterable)((Iterable)object2))) != null ? object2.value() : null;
            boolean bl3 = false;
            if (texture != null) {
                PlayerData playerData4 = playerData;
                if (playerData4 == null) {
                    playerData4 = new PlayerData(0, null);
                }
                updatedData = PlayerData.copy$default(playerData4, 0, texture, 1, null);
                data.put($playerName, updatedData);
                $this$updatePlayerTexture_u24lambda_u246_u24lambda_u245.saveData();
                LogDebugKt.logDebug((String)("DEBUG: Fetched and stored texture for '" + $playerName + "' from Mojang API"), (String)"cobblehunts");
            }
            object = string;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final GameProfile fetchMojangProfile$lambda$10(String $playerName) {
        block20: {
            try {
                URL profileUrl = new URL("https://api.mojang.com/users/profiles/minecraft/" + $playerName);
                URLConnection uRLConnection = profileUrl.openConnection();
                Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                HttpURLConnection connection = (HttpURLConnection)uRLConnection;
                connection.setRequestMethod("GET");
                connection.connect();
                if (connection.getResponseCode() == 200) {
                    Object it;
                    InputStream inputStream = connection.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                    Closeable closeable = inputStream;
                    Object object = Charsets.UTF_8;
                    Reader reader = new InputStreamReader((InputStream)closeable, (Charset)object);
                    int n = 8192;
                    closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
                    object = null;
                    try {
                        it = (BufferedReader)closeable;
                        boolean bl = false;
                        it = TextStreamsKt.readText((Reader)((Reader)it));
                    }
                    catch (Throwable bl) {
                        object = bl;
                        throw bl;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                    }
                    Object response = it;
                    JsonElement jsonElement2 = Json.Default.parseToJsonElement((String)response);
                    JsonObject jsonObject = JsonElementKt.getJsonObject((JsonElement)jsonElement2);
                    if (!jsonObject.containsKey((Object)"id")) {
                        LogDebugKt.logDebug((String)("DEBUG: Mojang API did not return an id for '" + $playerName + "'"), (String)"cobblehunts");
                        return null;
                    }
                    Object object2 = (JsonElement)jsonObject.get((Object)"id");
                    if (object2 == null || (object2 = JsonElementKt.getJsonPrimitive((JsonElement)object2)) == null || (object2 = object2.getContent()) == null) {
                        return null;
                    }
                    Object id = object2;
                    URL sessionUrl = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + (String)id + "?unsigned=false");
                    URLConnection uRLConnection2 = sessionUrl.openConnection();
                    Intrinsics.checkNotNull((Object)uRLConnection2, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                    HttpURLConnection sessionConn = (HttpURLConnection)uRLConnection2;
                    sessionConn.setRequestMethod("GET");
                    sessionConn.connect();
                    if (sessionConn.getResponseCode() == 200) {
                        JsonArray properties;
                        Object it2;
                        InputStream inputStream2 = sessionConn.getInputStream();
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getInputStream(...)");
                        Closeable closeable2 = inputStream2;
                        Object object3 = Charsets.UTF_8;
                        Reader reader2 = new InputStreamReader((InputStream)closeable2, (Charset)object3);
                        int n2 = 8192;
                        closeable2 = reader2 instanceof BufferedReader ? (BufferedReader)reader2 : new BufferedReader(reader2, n2);
                        object3 = null;
                        try {
                            it2 = (BufferedReader)closeable2;
                            boolean bl = false;
                            it2 = TextStreamsKt.readText((Reader)((Reader)it2));
                        }
                        catch (Throwable bl) {
                            object3 = bl;
                            throw bl;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object3);
                        }
                        Object sessionResponse = it2;
                        JsonElement sessionJsonElement = Json.Default.parseToJsonElement((String)sessionResponse);
                        JsonObject sessionJsonObject = JsonElementKt.getJsonObject((JsonElement)sessionJsonElement);
                        JsonElement jsonElement3 = (JsonElement)sessionJsonObject.get((Object)"properties");
                        Object object4 = properties = jsonElement3 != null ? JsonElementKt.getJsonArray((JsonElement)jsonElement3) : null;
                        if (properties != null && properties.size() > 0) {
                            String signature;
                            JsonObject textureProperty = JsonElementKt.getJsonObject((JsonElement)properties.get(0));
                            JsonElement jsonElement4 = (JsonElement)textureProperty.get((Object)"value");
                            String textureValue = jsonElement4 != null && (jsonElement4 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement4)) != null ? jsonElement4.getContent() : null;
                            JsonElement jsonElement5 = (JsonElement)textureProperty.get((Object)"signature");
                            String string = jsonElement5 != null && (jsonElement5 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement5)) != null ? jsonElement5.getContent() : (signature = null);
                            if (textureValue == null || signature == null) {
                                LogDebugKt.logDebug((String)("DEBUG: Texture or signature missing for '" + $playerName + "'"), (String)"cobblehunts");
                                return null;
                            }
                            CharSequence charSequence = (CharSequence)id;
                            Regex regex = new Regex("([0-9a-fA-F]{8})([0-9a-fA-F]{4})([0-9a-fA-F]{4})([0-9a-fA-F]{4})([0-9a-fA-F]{12})");
                            String string2 = "$1-$2-$3-$4-$5";
                            String uuidString = regex.replaceFirst(charSequence, string2);
                            UUID uuid = UUID.fromString(uuidString);
                            GameProfile profile = new GameProfile(uuid, $playerName);
                            profile.getProperties().put((Object)"textures", (Object)new Property("textures", textureValue, signature));
                            ((Map)mojangProfileCache).put($playerName, profile);
                            LogDebugKt.logDebug((String)("DEBUG: Fetched and cached Mojang profile for '" + $playerName + "': " + profile), (String)"cobblehunts");
                            return profile;
                        }
                        break block20;
                    }
                    LogDebugKt.logDebug((String)("DEBUG: Session server returned code " + sessionConn.getResponseCode() + " for '" + $playerName + "'"), (String)"cobblehunts");
                    break block20;
                }
                LogDebugKt.logDebug((String)("DEBUG: Mojang API returned code " + connection.getResponseCode() + " for '" + $playerName + "'"), (String)"cobblehunts");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static {
        INSTANCE.loadData();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ&\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\tJ\u0010\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u000bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\tR\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0016\u001a\u0004\b\u0017\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/cobblehunts/utils/LeaderboardManager$PlayerData;", "", "", "points", "", "texture", "<init>", "(ILjava/lang/String;)V", "component1", "()I", "component2", "()Ljava/lang/String;", "copy", "(ILjava/lang/String;)Lcom/cobblehunts/utils/LeaderboardManager$PlayerData;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "I", "getPoints", "Ljava/lang/String;", "getTexture", "cobblehunts"})
    public static final class PlayerData {
        private final int points;
        @Nullable
        private final String texture;

        public PlayerData(int points, @Nullable String texture) {
            this.points = points;
            this.texture = texture;
        }

        public final int getPoints() {
            return this.points;
        }

        @Nullable
        public final String getTexture() {
            return this.texture;
        }

        public final int component1() {
            return this.points;
        }

        @Nullable
        public final String component2() {
            return this.texture;
        }

        @NotNull
        public final PlayerData copy(int points, @Nullable String texture) {
            return new PlayerData(points, texture);
        }

        public static /* synthetic */ PlayerData copy$default(PlayerData playerData, int n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = playerData.points;
            }
            if ((n2 & 2) != 0) {
                string = playerData.texture;
            }
            return playerData.copy(n, string);
        }

        @NotNull
        public String toString() {
            return "PlayerData(points=" + this.points + ", texture=" + this.texture + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.points);
            result = result * 31 + (this.texture == null ? 0 : this.texture.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PlayerData)) {
                return false;
            }
            PlayerData playerData = (PlayerData)other;
            if (this.points != playerData.points) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.texture, (Object)playerData.texture);
        }
    }
}

