/*
 * Decompiled with CFR 0.152.
 */
package megabytesme.minelights.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_6379;

public class LiveLogEntry
extends AbstractConfigListEntry<String> {
    private final List<String> logLines;
    private int scrollY = 0;
    private int lastEntryWidth = 0;
    private List<String> wrappedLinesCache = new ArrayList<String>();

    public LiveLogEntry(String fieldName, List<String> logLines) {
        super((class_2561)class_2561.method_43470((String)fieldName), false);
        this.logLines = logLines;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int maxScroll = Math.max(0, this.wrappedLinesCache.size() * 10 - this.getItemHeight());
        this.scrollY -= (int)(verticalAmount * 10.0);
        this.scrollY = class_3532.method_15340((int)this.scrollY, (int)0, (int)maxScroll);
        return true;
    }

    public String getValue() {
        return "";
    }

    public Optional<String> getDefaultValue() {
        return Optional.empty();
    }

    public void save() {
    }

    public boolean isRequiresRestart() {
        return false;
    }

    public void setRequiresRestart(boolean requiresRestart) {
    }

    public int getItemHeight() {
        return 120;
    }

    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }

    public List<? extends class_6379> narratables() {
        return Collections.emptyList();
    }

    public void render(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        this.renderLog(context, x, y, entryWidth, entryHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderLog(Object contextOrMatrices, int x, int y, int entryWidth, int entryHeight) {
        if (entryWidth != this.lastEntryWidth) {
            this.lastEntryWidth = entryWidth;
            this.wrappedLinesCache.clear();
            List<String> list = this.logLines;
            synchronized (list) {
                for (String raw : this.logLines) {
                    this.wrappedLinesCache.addAll(this.wrapString(raw, entryWidth - 15));
                }
            }
        }
        class_327 textRenderer = class_310.method_1551().field_1772;
        int maxScroll = Math.max(0, this.wrappedLinesCache.size() * 10 - entryHeight);
        this.scrollY = class_3532.method_15340((int)this.scrollY, (int)0, (int)maxScroll);
        int startX = x + 2;
        for (int i = 0; i < this.wrappedLinesCache.size(); ++i) {
            int lineY = y + 2 + i * 10 - this.scrollY;
            if (lineY < y || lineY >= y + entryHeight - 5) continue;
            String part = this.wrappedLinesCache.get(i);
            ((class_332)contextOrMatrices).method_51433(textRenderer, part, startX, lineY, 0xFFFFFF, false);
        }
        if (maxScroll > 0) {
            int scrollbarX = x + entryWidth - 6;
            int scrollbarHeight = entryHeight;
            int thumbHeight = Math.max(10, (int)((float)scrollbarHeight / (float)(this.wrappedLinesCache.size() * 10) * (float)scrollbarHeight));
            int thumbY = y + (int)((float)this.scrollY / (float)maxScroll * (float)(scrollbarHeight - thumbHeight));
            class_332 context = (class_332)contextOrMatrices;
            context.method_25294(scrollbarX, y, scrollbarX + 5, y + scrollbarHeight, -16777216);
            context.method_25294(scrollbarX, thumbY, scrollbarX + 5, thumbY + thumbHeight, -7829368);
        }
    }

    private List<String> wrapString(String text, int maxWidth) {
        String[] words;
        class_327 tr = class_310.method_1551().field_1772;
        ArrayList<String> lines = new ArrayList<String>();
        if (maxWidth <= 10 || text.isEmpty()) {
            lines.add(text);
            return lines;
        }
        StringBuilder currentLine = new StringBuilder();
        for (String word : words = text.split(" ")) {
            Object potentialLine = currentLine.length() == 0 ? word : String.valueOf(currentLine) + " " + word;
            int width = tr.method_1727((String)potentialLine);
            if (width > maxWidth && currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            currentLine = new StringBuilder((String)potentialLine);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }
}

