/*
 * Decompiled with CFR 0.152.
 */
package megabytesme.minelights.config;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import java.util.Comparator;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import megabytesme.minelights.CommandClient;
import megabytesme.minelights.MineLightsClient;
import megabytesme.minelights.config.CompassPriority;
import megabytesme.minelights.config.DimmingMode;
import megabytesme.minelights.config.LiveLogEntry;
import megabytesme.minelights.config.LiveStatusEntry;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class ModMenuIntegration
implements ModMenuApi {
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return this::buildConfigScreen;
    }

    private class_437 buildConfigScreen(class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)class_2561.method_43471((String)"title.mine-lights.config"));
        builder.setSavingRunnable(() -> {
            MineLightsClient.saveConfig();
            boolean needsRefresh = false;
            if (MineLightsClient.CONFIG.forceServerUpdate) {
                new Thread(MineLightsClient::checkForServerUpdate, "MineLights-Manual-Update-Check").start();
                MineLightsClient.CONFIG.forceServerUpdate = false;
            }
            if (MineLightsClient.CONFIG.refreshDevices) {
                MineLightsClient.CONFIG.refreshDevices = false;
                needsRefresh = true;
            }
            if (MineLightsClient.CONFIG.restartProxy) {
                MineLightsClient.isManualRestart = true;
                CommandClient.sendCommand("restart");
                MineLightsClient.CONFIG.restartProxy = false;
                needsRefresh = false;
            }
            if (MineLightsClient.CONFIG.restartProxyAsAdmin) {
                MineLightsClient.isManualRestart = true;
                CommandClient.sendCommand("restart_admin");
                MineLightsClient.CONFIG.restartProxyAsAdmin = false;
                needsRefresh = false;
            }
            if (MineLightsClient.CONFIG.clearDisabledDevices) {
                MineLightsClient.CONFIG.disabledDevices.clear();
                MineLightsClient.saveConfig();
                MineLightsClient.CONFIG.clearDisabledDevices = false;
                needsRefresh = true;
            }
            if (needsRefresh) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                MineLightsClient.refreshLightingManager();
                new Thread(() -> {
                    try {
                        Thread.sleep(1000L);
                        class_310.method_1551().execute(() -> class_310.method_1551().method_1507(this.buildConfigScreen(parent)));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }).start();
            }
        });
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        if (MineLightsClient.IS_WINDOWS) {
            ConfigCategory serverManagement = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"category.mine-lights.server_management"));
            Supplier<class_2561> statusTextSupplier = () -> {
                MineLightsClient.DownloadStatus status = MineLightsClient.downloadStatus.get();
                switch (status) {
                    case DOWNLOADING: {
                        long soFarMB = MineLightsClient.downloadBytesSoFar.get() / 0x100000L;
                        long totalMB = MineLightsClient.downloadTotalBytes.get() / 0x100000L;
                        String eta = MineLightsClient.downloadEta.get();
                        String speed = MineLightsClient.downloadSpeedMBps.get();
                        return class_2561.method_43469((String)"minelights.status.downloading", (Object[])new Object[]{soFarMB, totalMB, MineLightsClient.downloadProgress.get(), eta, speed});
                    }
                    case VERIFYING: {
                        return class_2561.method_43471((String)"minelights.status.verifying");
                    }
                    case SUCCESS: {
                        return class_2561.method_43471((String)"minelights.status.success");
                    }
                    case FAILED: {
                        return class_2561.method_43469((String)"minelights.status.failed", (Object[])new Object[]{MineLightsClient.downloadError.get()});
                    }
                }
                return MineLightsClient.isServerRunning() ? class_2561.method_43471((String)"minelights.status.running") : class_2561.method_43471((String)"minelights.status.not_running");
            };
            serverManagement.addEntry((AbstractConfigListEntry)new LiveStatusEntry("minelights.status", statusTextSupplier));
            serverManagement.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.mine-lights.force_update.label"), MineLightsClient.CONFIG.forceServerUpdate).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.mine-lights.force_update.tooltip")}).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.forceServerUpdate = newValue;
            }).build());
            if (MineLightsClient.IS_WINDOWS) {
                serverManagement.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.mine-lights.autoStartServer"), MineLightsClient.CONFIG.autoStartServer).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.mine-lights.autoStartServer.tooltip")}).setSaveConsumer(newValue -> {
                    MineLightsClient.CONFIG.autoStartServer = newValue;
                }).build());
            }
            serverManagement.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43470((String)"")).build());
            serverManagement.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.mine-lights.restart.label"), MineLightsClient.CONFIG.restartProxy).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.mine-lights.restart.tooltip")}).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.restartProxy = newValue;
            }).build());
            serverManagement.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.mine-lights.restart_admin.label"), MineLightsClient.CONFIG.restartProxyAsAdmin).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.mine-lights.restart_admin.tooltip")}).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.restartProxyAsAdmin = newValue;
            }).build());
            serverManagement.addEntry((AbstractConfigListEntry)new LiveLogEntry("Server Log", MineLightsClient.serverLogLines));
        }
        ConfigCategory general = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"category.mine-lights.general"));
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.mine-lights.enableMod"), MineLightsClient.CONFIG.enableMod).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.mine-lights.enableMod.tooltip")}).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.enableMod = newValue;
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.mine-lights.refresh_devices.label"), MineLightsClient.CONFIG.refreshDevices).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.mine-lights.refresh_devices.tooltip")}).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.refreshDevices = newValue;
        }).build());
        ConfigCategory integrations = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"category.mine-lights.integrations"));
        integrations.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"integration.mine-lights.corsair"), MineLightsClient.CONFIG.enableCorsair).setDefaultValue(true).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.enableCorsair = newValue;
        }).build());
        integrations.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"integration.mine-lights.asus"), MineLightsClient.CONFIG.enableAsus).setDefaultValue(true).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.enableAsus = newValue;
        }).build());
        integrations.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"integration.mine-lights.logitech"), MineLightsClient.CONFIG.enableLogitech).setDefaultValue(true).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.enableLogitech = newValue;
        }).build());
        integrations.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"integration.mine-lights.razer"), MineLightsClient.CONFIG.enableRazer).setDefaultValue(true).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.enableRazer = newValue;
        }).build());
        integrations.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"integration.mine-lights.wooting"), MineLightsClient.CONFIG.enableWooting).setDefaultValue(true).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.enableWooting = newValue;
        }).build());
        integrations.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"integration.mine-lights.steelseries"), MineLightsClient.CONFIG.enableSteelSeries).setDefaultValue(true).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.enableSteelSeries = newValue;
        }).build());
        integrations.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"integration.mine-lights.msi"), MineLightsClient.CONFIG.enableMsi).setDefaultValue(true).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.enableMsi = newValue;
        }).build());
        integrations.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"integration.mine-lights.novation"), MineLightsClient.CONFIG.enableNovation).setDefaultValue(true).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.enableNovation = newValue;
        }).build());
        integrations.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"integration.mine-lights.picopi"), MineLightsClient.CONFIG.enablePicoPi).setDefaultValue(true).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.enablePicoPi = newValue;
        }).build());
        integrations.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"integration.mine-lights.openrgb"), MineLightsClient.CONFIG.enableOpenRgb).setDefaultValue(true).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.enableOpenRgb = newValue;
        }).build());
        integrations.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"integration.mine-lights.yeelight"), MineLightsClient.CONFIG.enableYeelight).setDefaultValue(true).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.enableYeelight = newValue;
        }).build());
        ConfigCategory devices = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"category.mine-lights.devices"));
        devices.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43471((String)"option.mine-lights.device.header")).build());
        MineLightsClient.discoveredDevices.stream().sorted(Comparator.naturalOrder()).forEach(uniqueId -> {
            boolean isEnabled = !MineLightsClient.CONFIG.disabledDevices.contains(uniqueId);
            String[] parts = uniqueId.split("\\|", 2);
            String deviceSdk = parts.length > 1 ? parts[0] : "Unknown";
            String deviceName = parts.length > 1 ? parts[1] : uniqueId;
            class_5250 label = class_2561.method_43470((String)deviceName).method_10852((class_2561)class_2561.method_43470((String)(" (" + deviceSdk + ")")).method_27692(class_124.field_1080));
            devices.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)label, isEnabled).setDefaultValue(true).setSaveConsumer(newValue -> {
                if (newValue.booleanValue()) {
                    MineLightsClient.CONFIG.disabledDevices.remove(uniqueId);
                } else if (!MineLightsClient.CONFIG.disabledDevices.contains(uniqueId)) {
                    MineLightsClient.CONFIG.disabledDevices.add((String)uniqueId);
                }
            }).build());
        });
        if (!MineLightsClient.CONFIG.disabledDevices.isEmpty()) {
            devices.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43470((String)"")).build());
            devices.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.mine-lights.clear_disabled.label"), MineLightsClient.CONFIG.clearDisabledDevices).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.mine-lights.clear_disabled.tooltip")}).setSaveConsumer(newValue -> {
                MineLightsClient.CONFIG.clearDisabledDevices = newValue;
            }).build());
        }
        ConfigCategory playerStatus = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"category.mine-lights.player_status"));
        playerStatus.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.mine-lights.enableHealthBar"), MineLightsClient.CONFIG.enableHealthBar).setDefaultValue(true).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.enableHealthBar = newValue;
        }).build());
        playerStatus.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.mine-lights.enableHungerBar"), MineLightsClient.CONFIG.enableHungerBar).setDefaultValue(true).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.enableHungerBar = newValue;
        }).build());
        playerStatus.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.mine-lights.enableSaturationBar"), MineLightsClient.CONFIG.enableSaturationBar).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.mine-lights.enableSaturationBar.tooltip")}).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.enableSaturationBar = newValue;
        }).build());
        playerStatus.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.mine-lights.enableExperienceBar"), MineLightsClient.CONFIG.enableExperienceBar).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.mine-lights.enableExperienceBar.tooltip")}).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.enableExperienceBar = newValue;
        }).build());
        playerStatus.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.mine-lights.enableLocatorBar"), MineLightsClient.CONFIG.enableLocatorBar).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.mine-lights.enableLocatorBar.tooltip")}).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.enableLocatorBar = newValue;
        }).build());
        playerStatus.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.mine-lights.enableCompassEffect"), MineLightsClient.CONFIG.enableCompassEffect).setDefaultValue(true).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.enableCompassEffect = newValue;
        }).build());
        playerStatus.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.mine-lights.alwaysShowCompass"), MineLightsClient.CONFIG.alwaysShowCompass).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.mine-lights.alwaysShowCompass.tooltip")}).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.alwaysShowCompass = newValue;
        }).build());
        CompassPriority initial = MineLightsClient.CONFIG.compassPriority != null ? MineLightsClient.CONFIG.compassPriority : CompassPriority.PRIORITY;
        playerStatus.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector((class_2561)class_2561.method_43471((String)"option.mine-lights.compassPriority"), CompassPriority.class, (Enum)initial).setDefaultValue((Enum)CompassPriority.PRIORITY).setEnumNameProvider(value -> class_2561.method_43471((String)("enum.mine-lights.compassPriority." + value.toString().toLowerCase()))).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.mine-lights.compassPriority.tooltip")}).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.compassPriority = newValue;
        }).build());
        playerStatus.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.mine-lights.enableLowHealthWarning"), MineLightsClient.CONFIG.enableLowHealthWarning).setDefaultValue(true).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.enableLowHealthWarning = newValue;
        }).build());
        playerStatus.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.mine-lights.highlightMovementKeys"), MineLightsClient.CONFIG.highlightMovementKeys).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.mine-lights.highlightMovementKeys.tooltip")}).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.highlightMovementKeys = newValue;
        }).build());
        playerStatus.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.mine-lights.pulseChatKey"), MineLightsClient.CONFIG.pulseChatKey).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.mine-lights.pulseChatKey.tooltip")}).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.pulseChatKey = newValue;
        }).build());
        ConfigCategory environment = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"category.mine-lights.environment"));
        environment.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.mine-lights.enableBiomeEffects"), MineLightsClient.CONFIG.enableBiomeEffects).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.mine-lights.enableBiomeEffects.tooltip")}).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.enableBiomeEffects = newValue;
        }).build());
        DimmingMode initialDimming = MineLightsClient.CONFIG.dimmingMode != null ? MineLightsClient.CONFIG.dimmingMode : DimmingMode.LOCAL_LIGHT;
        environment.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector((class_2561)class_2561.method_43471((String)"option.mine-lights.dimmingMode"), DimmingMode.class, (Enum)initialDimming).setDefaultValue((Enum)DimmingMode.NONE).setEnumNameProvider(value -> class_2561.method_43471((String)("enum.mine-lights.dimmingMode." + value.toString().toLowerCase()))).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.mine-lights.dimmingMode.tooltip")}).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.dimmingMode = newValue;
        }).build());
        environment.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.mine-lights.enableWeatherEffects"), MineLightsClient.CONFIG.enableWeatherEffects).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.mine-lights.enableWeatherEffects.tooltip")}).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.enableWeatherEffects = newValue;
        }).build());
        environment.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.mine-lights.enableOnFireEffect"), MineLightsClient.CONFIG.enableOnFireEffect).setDefaultValue(true).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.enableOnFireEffect = newValue;
        }).build());
        environment.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.mine-lights.enableInWaterEffect"), MineLightsClient.CONFIG.enableInWaterEffect).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.mine-lights.enableInWaterEffect.tooltip")}).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.enableInWaterEffect = newValue;
        }).build());
        environment.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.mine-lights.enablePortalEffects"), MineLightsClient.CONFIG.enablePortalEffects).setDefaultValue(true).setSaveConsumer(newValue -> {
            MineLightsClient.CONFIG.enablePortalEffects = newValue;
        }).build());
        ConfigCategory aboutCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"category.mine-lights.about"));
        aboutCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43471((String)"text.mine-lights.about.title")).build());
        aboutCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43469((String)"text.mine-lights.about.version", (Object[])new Object[]{"2.2.1"})).build());
        aboutCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43471((String)"text.mine-lights.about.copyright")).build());
        aboutCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43470((String)"")).build());
        aboutCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextField((class_2561)class_2561.method_43471((String)"text.mine-lights.about.source_code"), "https://github.com/megabytesme/MineLights").build());
        aboutCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextField((class_2561)class_2561.method_43471((String)"text.mine-lights.about.issues"), "https://github.com/megabytesme/MineLights/issues").build());
        aboutCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43470((String)"")).build());
        aboutCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43471((String)"text.mine-lights.about.support_intro")).build());
        aboutCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextField((class_2561)class_2561.method_43471((String)"text.mine-lights.about.kofi"), "https://ko-fi.com/megabytesme").build());
        aboutCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43470((String)"")).build());
        aboutCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43471((String)"text.mine-lights.about.description")).build());
        return builder.build();
    }
}

