package megabytesme.minelights;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import megabytesme.minelights.mixin.LightningAccessor;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_4208;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_746;
import megabytesme.minelights.accessor.ChatReceivedAccessor;
import megabytesme.minelights.accessor.PlayerVisualBrightnessAccessor;

import java.util.ArrayList;
import java.util.List;
//? if >=1.19 {
import java.util.Optional;

public class PlayerDataCollector {
    public static final Logger LOGGER = LogManager.getLogger("MineLights-PlayerDataCollector");

    public static PlayerDto getCurrentState(class_310 client) {
        PlayerDto playerDto = new PlayerDto();

        if (client == null || client.field_1687 == null || client.field_1724 == null) {
            playerDto.setInGame(false);
            return playerDto;
        }

        class_746 player = client.field_1724;
        class_638 world = client.field_1687;

        playerDto.setInGame(true);
        playerDto.setHealth(player.method_6032());
        playerDto.setHunger(player.method_7344().method_7586());
        playerDto.setSaturation(player.method_7344().method_7589());
        //? if <=1.14.3 {
        /* playerDto.setAir(player.getBreath());
        *///?} else {
        playerDto.setAir(player.method_5669());
        //?}
        playerDto.setExperience(player.field_7510);

        playerDto.setBlockAtFeet(world.method_8320(player.method_24515()).method_26204().method_9539());
        playerDto.setBlockOn(world.method_8320(player.method_24515().method_10074()).method_26204().method_9539());
        //? if >=1.20 {
        class_243 eyePos = player.method_33571();
        class_2338 headPos = class_2338.method_49637(eyePos.field_1352, eyePos.field_1351, eyePos.field_1350);
        playerDto.setBlockAtHead(world.method_8320(headPos).method_26204().method_9539());
        //?} else if >=1.17 {
        /* Vec3d eyePos = player.getEyePos();
        BlockPos headPos = new BlockPos(eyePos.x, eyePos.y, eyePos.z);
        playerDto.setBlockAtHead(world.getBlockState(headPos).getBlock().getTranslationKey());
        *///?} else if >=1.15 {
        /* float eyeHeight = player.getStandingEyeHeight();
        Vec3d eyePos = player.getPos().add(0.0D, (double)eyeHeight, 0.0D);
        BlockPos headPos = new BlockPos(eyePos.x, eyePos.y, eyePos.z);
        playerDto.setBlockAtHead(world.getBlockState(headPos).getBlock().getTranslationKey());
        *///?} else {
        /* net.minecraft.entity.EntityPose pose = player.getPose();
        float eyeHeight = player.getEyeHeight(pose);
        Vec3d eyePos = player.getPos().add(0.0D, (double)eyeHeight, 0.0D);
        BlockPos headPos = new BlockPos(eyePos.x, eyePos.y, eyePos.z);
        playerDto.setBlockAtHead(world.getBlockState(headPos).getBlock().getTranslationKey());
        *///?}

        //? if >=1.19 {
        world.method_23753(player.method_24515()).method_40230().ifPresent(key -> playerDto.setCurrentBiome(key.method_29177().toString()));
        //?} else if >= 1.16.2 {
        /*
        playerDto.setCurrentBiome(world.getRegistryManager().get(Registry.BIOME_KEY).getId(world.getBiome(player.getBlockPos())).toString());
        *///?} else if >= 1.16 {
        /*
        playerDto.setCurrentWorld(world.getRegistryKey().getValue().toString());
        *///?} else {
        /*
        playerDto.setCurrentBiome(Registry.BIOME.getId(world.getBiome(player.getBlockPos())).toString());
        */
        //?}

        //? if <=1.14.3 {
        /* playerDto.setCurrentWorld(Registry.DIMENSION_TYPE.getId(world.getDimension().getType()).toString());
        *///?} else if <1.16 {
        /* playerDto.setCurrentWorld(Registry.DIMENSION.getId(world.getDimension().getType()).toString());
        *///?} else {
        playerDto.setCurrentWorld(world.method_27983().method_29177().toString());
        //?}
        playerDto.setIsOnFire(player.method_5809());
        playerDto.setIsPoisoned(player.method_6059(class_1294.field_5899));
        playerDto.setIsWithering(player.method_6059(class_1294.field_5920));
        playerDto.setIsTakingDamage(player.field_6235 > 0);
        updateCompassData(playerDto, player, world);

        if (world.method_8546()) {
            playerDto.setWeather("Thunderstorm");
        } else if (world.method_8419()) {
            playerDto.setWeather("Rain");
        } else {
            playerDto.setWeather("Clear");
        }

        //? if >=1.21.8 {
        /*List<WaypointDto> waypoints = new ArrayList<>();
        client.player.networkHandler.getWaypointHandler().forEachWaypoint(client.cameraEntity, (waypoint) -> {
            if (waypoint.getSource().left().map(uuid -> uuid.equals(client.cameraEntity.getUuid())).orElse(false)) {
                return;
            }

            WaypointDto waypointDto = new WaypointDto();
            waypointDto.setRelativeYaw(waypoint.getRelativeYaw(world, client.gameRenderer.getCamera()));
            waypointDto.setPitch(waypoint.getPitch(world, client.gameRenderer));
            waypointDto.setDistance((float) Math.sqrt(waypoint.squaredDistanceTo(client.cameraEntity)));

            int color = waypoint.getConfig().color.orElseGet(() -> waypoint.getSource().map(
                    uuid -> ColorHelper.withBrightness(ColorHelper.withAlpha(255, uuid.hashCode()), 0.9F),
                    name -> ColorHelper.withBrightness(ColorHelper.withAlpha(255, name.hashCode()), 0.9F)));
            waypointDto.setColor(color);

            waypoints.add(waypointDto);
        });
        playerDto.setWaypoints(waypoints);
        *///?}

        for (class_1297 entity : world.method_18112()) {
            if (entity instanceof class_1538) {
                class_1538 lightning = (class_1538) entity;
                LightningAccessor acc = (LightningAccessor) lightning;

                int ambientTick = acc.getAmbientTick();
                int remainingActions = acc.getRemainingActions();

                playerDto.setIsLightningFlashing((ambientTick % 3) < 2 && remainingActions > 0);
            }
        }

        playerDto.setSkyLightLevel(((PlayerVisualBrightnessAccessor) player).getSkyLightLevel());
        playerDto.setRenderedBrightnessLevel(((PlayerVisualBrightnessAccessor) player).getRenderedBrightness());

        class_634 handler = class_310.method_1551().method_1562();
        if (handler instanceof ChatReceivedAccessor) {
            ChatReceivedAccessor accessor = (ChatReceivedAccessor) handler;
            if (accessor.wasChatReceivedThisTick()) {
                playerDto.setIsChatReceived(true);
                accessor.resetChatReceivedFlag();
            } else {
                playerDto.setIsChatReceived(false);
            }
        }

        return playerDto;
    }

    private static void updateCompassData(PlayerDto dto, class_746 player, class_638 world) {
        CompassFindResult result = findCompass(player);

        if (result == null) {
            //? if >=1.16 && <1.20.5 {
             if (MineLightsClient.CONFIG.alwaysShowCompass &&
             world.method_27983().equals(class_1937.field_25179)) {
             dto.setCompassType(CompassType.STANDARD);
             class_4208 spawnPos = class_4208.method_19443(world.method_27983(),
             world.method_43126());
             setCompassTarget(dto, player, spawnPos.method_19446());
             } else {
             dto.setCompassState(megabytesme.minelights.CompassState.NONE);
             dto.setCompassType(CompassType.NONE);
             }
            //?} else if >=1.20.5 {
            /*if (MineLightsClient.CONFIG.alwaysShowCompass &&
                world.getRegistryKey().equals(World.OVERWORLD)) {
                dto.setCompassType(CompassType.STANDARD);
                GlobalPos spawnPos = GlobalPos.create(world.getRegistryKey(),
                world.getSpawnPos());
                setCompassTarget(dto, player, spawnPos.pos());
            } else {
                dto.setCompassState(megabytesme.minelights.CompassState.NONE);
                dto.setCompassType(CompassType.NONE);
            }
            *///?} else {
            /* if (MineLightsClient.CONFIG.alwaysShowCompass && world.dimension.getType() ==
             DimensionType.OVERWORLD) {
             dto.setCompassType(CompassType.STANDARD);
             setCompassTarget(dto, player, world.getSpawnPos());
             } else {
             dto.setCompassState(CompassState.NONE);
             dto.setCompassType(CompassType.NONE);
             }
            *///?}
            return;
        }

        dto.setCompassType(result.type);

        class_2338 targetPos = getCompassTargetPos(result.stack, player, world);

        if (targetPos != null && !(targetPos.method_10262(player.method_24515()) < 1.0E-5)) {
            setCompassTarget(dto, player, targetPos);
        } else {
            dto.setCompassState(CompassState.SPINNING);
        }
    }

    private static class CompassFindResult {
        final class_1799 stack;
        final CompassType type;

        CompassFindResult(class_1799 stack, CompassType type) {
            this.stack = stack;
            this.type = type;
        }
    }

    private static CompassFindResult findCompass(class_1657 player) {
        //? if >=1.16 {
        List<CompassFindResult> foundCompasses = new ArrayList<>();
        List<class_1799> inventory = new ArrayList<>();
        inventory.add(player.method_6047());
        inventory.add(player.method_6079());
        for (int i = 0; i < 36; i++) {
            //? if >=1.17 {
            inventory.add(player.method_31548().method_5438(i));
            //?} else {
            /* inventory.add(player.inventory.getStack(i));
            *///?}
        }

        for (class_1799 stack : inventory) {
            if (stack.method_7960()) continue;

            //? if >=1.19 {
            if (stack.method_7909() == class_1802.field_38747) {
                foundCompasses.add(new CompassFindResult(stack, CompassType.RECOVERY));
                continue;
            }
            //?}

            if (stack.method_7909() == class_1802.field_8251) {
                boolean isLodestone = false;
                //? if >=1.20.5 {
                /*LodestoneTrackerComponent lodestoneData = stack.get(DataComponentTypes.LODESTONE_TRACKER);
                if (lodestoneData != null && lodestoneData.target().isPresent()) {
                    isLodestone = true;
                }
                *///?} else if >= 1.18 {
                 if (stack.method_7985()) {
                    class_2487 tag = stack.method_7969();
                    if (tag != null && tag.method_10545("LodestonePos")) isLodestone = true;
                }
                //?} else if >= 1.17 {
                /* if (stack.hasTag()) {
                    NbtCompound tag = stack.getTag();
                    if (tag != null && tag.contains("LodestonePos")) isLodestone = true;
                }
                *///?} else {
                /* if (stack.hasTag()) {
                    CompoundTag tag = stack.getTag();
                    if (tag != null && tag.contains("LodestonePos")) isLodestone = true;
                }
                *///?}
                
                if (isLodestone) {
                    foundCompasses.add(new CompassFindResult(stack, CompassType.LODESTONE));
                } else {
                    foundCompasses.add(new CompassFindResult(stack, CompassType.STANDARD));
                }
            }
        }

        if (foundCompasses.isEmpty()) {
            return null;
        }
        if (foundCompasses.size() == 1) {
            return foundCompasses.get(0);
        }

        switch (MineLightsClient.CONFIG.compassPriority) {
            case STANDARD_FIRST:
                return foundCompasses.stream().filter(r -> r.type == CompassType.STANDARD).findFirst().orElse(foundCompasses.get(0));
            case LODESTONE_FIRST:
                return foundCompasses.stream().filter(r -> r.type == CompassType.LODESTONE).findFirst().orElse(foundCompasses.get(0));
            //? if >=1.19 {
            case RECOVERY_FIRST:
                return foundCompasses.stream().filter(r -> r.type == CompassType.RECOVERY).findFirst().orElse(foundCompasses.get(0));
            //?}
            case PRIORITY:
            default:
                return foundCompasses.get(0);
        }
        //?} else {
        /*
        List<ItemStack> stacksToCheck = new ArrayList<>();
        stacksToCheck.add(player.getMainHandStack());
        stacksToCheck.add(player.getOffHandStack());
        for (int i = 0; i < 36; i++) {
            stacksToCheck.add(player.inventory.getInvStack(i));
        }
        for (ItemStack stack : stacksToCheck) {
            if (stack.getItem() == Items.COMPASS) {
                return new CompassFindResult(stack, CompassType.STANDARD);
            }
        }
        return null;
        *///?}
    }

    private static class_2338 getCompassTargetPos(class_1799 stack, class_1657 holder, class_638 world) {
        //? if >= 1.19 {
        if (stack.method_7909() == class_1802.field_38747) {
            Optional<class_4208> lastDeathPos = holder.method_43122();
            if (lastDeathPos.isPresent()) {
                class_4208 pos = lastDeathPos.get();
                //? if >=1.20.5 {
                /*if (pos.dimension().equals(world.getRegistryKey())) {
                    return pos.pos();
                }
                *///?} else {
                 if (pos.method_19442().equals(world.method_27983())) {
                    return pos.method_19446();
                }
                //?}
            }
            return null;
        }
        //? if >=1.20.5 {
        /*LodestoneTrackerComponent lodestoneData = stack.get(DataComponentTypes.LODESTONE_TRACKER);
        if (lodestoneData != null) {
            return lodestoneData.target()
                    .filter(pos -> pos.dimension().equals(world.getRegistryKey()))
                    .map(GlobalPos::pos)
                    .orElse(null);
        }
        *///?} else if >= 1.19 {
         if (stack.method_7985()) {
            class_2487 tag = stack.method_7969();
            if (tag != null && tag.method_10545("LodestonePos") && tag.method_10545("LodestoneDimension")) {
                String lodestoneDim = tag.method_10558("LodestoneDimension");
                if (world.method_27983().method_29177().toString().equals(lodestoneDim)) {
                    class_2487 posTag = tag.method_10562("LodestonePos");
                    return new class_2338(posTag.method_10550("X"), posTag.method_10550("Y"), posTag.method_10550("Z"));
                }
                return null;
            }
        }
        //?}
        if (world.method_27983().equals(class_1937.field_25179)) {
            return world.method_43126();
        }
        //?} else if >= 1.18 {
        /* if (stack.hasNbt()) {
            NbtCompound tag = stack.getNbt();
            if (tag != null && tag.contains("LodestonePos") && tag.contains("LodestoneDimension")) {
                String lodestoneDim = tag.getString("LodestoneDimension");
                if (world.getRegistryKey().getValue().toString().equals(lodestoneDim)) {
                    NbtCompound posTag = tag.getCompound("LodestonePos");
                    return new BlockPos(posTag.getInt("X"), posTag.getInt("Y"), posTag.getInt("Z"));
                }
                return null;
            }
        }
        if (world.getRegistryKey().equals(World.OVERWORLD)) {
            return world.getSpawnPos();
        }
        *///?} else if >= 1.17 {
        /* if (stack.hasTag()) {
            NbtCompound tag = stack.getTag();
            if (tag != null && tag.contains("LodestonePos") && tag.contains("LodestoneDimension")) {
                String lodestoneDim = tag.getString("LodestoneDimension");
                if (world.getRegistryKey().getValue().toString().equals(lodestoneDim)) {
                    NbtCompound posTag = tag.getCompound("LodestonePos");
                    return new BlockPos(posTag.getInt("X"), posTag.getInt("Y"), posTag.getInt("Z"));
                }
                return null;
            }
        }
        if (world.getRegistryKey().equals(World.OVERWORLD)) {
            return world.getSpawnPos();
        }
        *///?} else if >= 1.16 {
        /* if (stack.hasTag()) {
            CompoundTag tag = stack.getTag();
            if (tag != null && tag.contains("LodestonePos") && tag.contains("LodestoneDimension")) {
                String lodestoneDim = tag.getString("LodestoneDimension");
                if (world.getRegistryKey().getValue().toString().equals(lodestoneDim)) {
                    CompoundTag posTag = tag.getCompound("LodestonePos");
                    return new BlockPos(posTag.getInt("X"), posTag.getInt("Y"), posTag.getInt("Z"));
                }
                return null;
            }
        }
        if (world.getRegistryKey().equals(World.OVERWORLD)) {
            return world.getSpawnPos();
        }
        *///?} else {
        /* if (world.getDimension().getType() == DimensionType.OVERWORLD) {
            return world.getSpawnPos();
        }
        *///?}
        return null;
    }

    private static void setCompassTarget(PlayerDto dto, class_746 player, class_2338 target) {
        class_243 playerPos = player.method_19538();
        class_243 targetPos = new class_243(target.method_10263() + 0.5, target.method_10264() + 0.5, target.method_10260() + 0.5);

        double deltaX = targetPos.field_1352 - playerPos.field_1352;
        double deltaZ = targetPos.field_1350 - playerPos.field_1350;

        double targetYaw = Math.toDegrees(Math.atan2(-deltaX, deltaZ));

        double playerYaw;
        //? if <=1.16.5 {
        /* playerYaw = player.yaw;
        *///?} else {
        playerYaw = player.method_36454();
        //?}

        double relativeYaw = targetYaw - playerYaw;
        while (relativeYaw <= -180.0D)
            relativeYaw += 360.0D;
        while (relativeYaw > 180.0D)
            relativeYaw -= 360.0D;

        dto.setCompassState(CompassState.POINTING);
        dto.setCompassRelativeYaw(relativeYaw);
        dto.setCompassDistance(Math.sqrt(deltaX * deltaX + deltaZ * deltaZ));
    }
}