/*
 * Decompiled with CFR 0.152.
 */
package megabytesme.minelights;

import java.util.ArrayList;
import megabytesme.minelights.CompassState;
import megabytesme.minelights.CompassType;
import megabytesme.minelights.MineLightsClient;
import megabytesme.minelights.PlayerDto;
import megabytesme.minelights.accessor.ChatReceivedAccessor;
import megabytesme.minelights.accessor.PlayerVisualBrightnessAccessor;
import megabytesme.minelights.mixin.LightningAccessor;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerDataCollector {
    public static final Logger LOGGER = LogManager.getLogger((String)"MineLights-PlayerDataCollector");

    public static PlayerDto getCurrentState(class_310 client) {
        PlayerDto playerDto = new PlayerDto();
        if (client == null || client.field_1687 == null || client.field_1724 == null) {
            playerDto.setInGame(false);
            return playerDto;
        }
        class_746 player = client.field_1724;
        class_638 world = client.field_1687;
        playerDto.setInGame(true);
        playerDto.setHealth(player.method_6032());
        playerDto.setHunger(player.method_7344().method_7586());
        playerDto.setSaturation(player.method_7344().method_7589());
        playerDto.setAir(player.method_5669());
        playerDto.setExperience(player.field_7510);
        playerDto.setBlockAtFeet(world.method_8320(player.method_24515()).method_26204().method_9539());
        playerDto.setBlockOn(world.method_8320(player.method_24515().method_10074()).method_26204().method_9539());
        float eyeHeight = player.method_5751();
        class_243 eyePos = player.method_19538().method_1031(0.0, (double)eyeHeight, 0.0);
        class_2338 headPos = new class_2338(eyePos.field_1352, eyePos.field_1351, eyePos.field_1350);
        playerDto.setBlockAtHead(world.method_8320(headPos).method_26204().method_9539());
        playerDto.setCurrentWorld(world.method_27983().method_29177().toString());
        playerDto.setCurrentWorld(world.method_27983().method_29177().toString());
        playerDto.setIsOnFire(player.method_5809());
        playerDto.setIsPoisoned(player.method_6059(class_1294.field_5899));
        playerDto.setIsWithering(player.method_6059(class_1294.field_5920));
        playerDto.setIsTakingDamage(player.field_6235 > 0);
        PlayerDataCollector.updateCompassData(playerDto, player, world);
        if (world.method_8546()) {
            playerDto.setWeather("Thunderstorm");
        } else if (world.method_8419()) {
            playerDto.setWeather("Rain");
        } else {
            playerDto.setWeather("Clear");
        }
        for (class_1297 entity : world.method_18112()) {
            if (!(entity instanceof class_1538)) continue;
            class_1538 lightning = (class_1538)entity;
            LightningAccessor acc = (LightningAccessor)lightning;
            int ambientTick = acc.getAmbientTick();
            int remainingActions = acc.getRemainingActions();
            playerDto.setIsLightningFlashing(ambientTick % 3 < 2 && remainingActions > 0);
        }
        playerDto.setSkyLightLevel(((PlayerVisualBrightnessAccessor)player).getSkyLightLevel());
        playerDto.setRenderedBrightnessLevel(((PlayerVisualBrightnessAccessor)player).getRenderedBrightness());
        class_634 handler = class_310.method_1551().method_1562();
        if (handler instanceof ChatReceivedAccessor) {
            ChatReceivedAccessor accessor = (ChatReceivedAccessor)handler;
            if (accessor.wasChatReceivedThisTick()) {
                playerDto.setIsChatReceived(true);
                accessor.resetChatReceivedFlag();
            } else {
                playerDto.setIsChatReceived(false);
            }
        }
        return playerDto;
    }

    private static void updateCompassData(PlayerDto dto, class_746 player, class_638 world) {
        CompassFindResult result = PlayerDataCollector.findCompass((class_1657)player);
        if (result == null) {
            if (MineLightsClient.CONFIG.alwaysShowCompass && world.method_27983().equals(class_1937.field_25179)) {
                dto.setCompassType(CompassType.STANDARD);
                class_4208 spawnPos = class_4208.method_19443((class_5321)world.method_27983(), (class_2338)world.method_27874());
                PlayerDataCollector.setCompassTarget(dto, player, spawnPos.method_19446());
            } else {
                dto.setCompassState(CompassState.NONE);
                dto.setCompassType(CompassType.NONE);
            }
            return;
        }
        dto.setCompassType(result.type);
        class_2338 targetPos = PlayerDataCollector.getCompassTargetPos(result.stack, (class_1657)player, world);
        if (targetPos != null && !(targetPos.method_10262((class_2382)player.method_24515()) < 1.0E-5)) {
            PlayerDataCollector.setCompassTarget(dto, player, targetPos);
        } else {
            dto.setCompassState(CompassState.SPINNING);
        }
    }

    private static CompassFindResult findCompass(class_1657 player) {
        ArrayList<CompassFindResult> foundCompasses = new ArrayList<CompassFindResult>();
        ArrayList<class_1799> inventory = new ArrayList<class_1799>();
        inventory.add(player.method_6047());
        inventory.add(player.method_6079());
        for (int i = 0; i < 36; ++i) {
            inventory.add(player.field_7514.method_5438(i));
        }
        for (class_1799 stack : inventory) {
            class_2487 tag;
            if (stack.method_7960() || stack.method_7909() != class_1802.field_8251) continue;
            boolean isLodestone = false;
            if (stack.method_7985() && (tag = stack.method_7969()) != null && tag.method_10545("LodestonePos")) {
                isLodestone = true;
            }
            if (isLodestone) {
                foundCompasses.add(new CompassFindResult(stack, CompassType.LODESTONE));
                continue;
            }
            foundCompasses.add(new CompassFindResult(stack, CompassType.STANDARD));
        }
        if (foundCompasses.isEmpty()) {
            return null;
        }
        if (foundCompasses.size() == 1) {
            return (CompassFindResult)foundCompasses.get(0);
        }
        switch (MineLightsClient.CONFIG.compassPriority) {
            case STANDARD_FIRST: {
                return foundCompasses.stream().filter(r -> r.type == CompassType.STANDARD).findFirst().orElse((CompassFindResult)foundCompasses.get(0));
            }
            case LODESTONE_FIRST: {
                return foundCompasses.stream().filter(r -> r.type == CompassType.LODESTONE).findFirst().orElse((CompassFindResult)foundCompasses.get(0));
            }
        }
        return (CompassFindResult)foundCompasses.get(0);
    }

    private static class_2338 getCompassTargetPos(class_1799 stack, class_1657 holder, class_638 world) {
        class_2487 tag;
        if (stack.method_7985() && (tag = stack.method_7969()) != null && tag.method_10545("LodestonePos") && tag.method_10545("LodestoneDimension")) {
            String lodestoneDim = tag.method_10558("LodestoneDimension");
            if (world.method_27983().method_29177().toString().equals(lodestoneDim)) {
                class_2487 posTag = tag.method_10562("LodestonePos");
                return new class_2338(posTag.method_10550("X"), posTag.method_10550("Y"), posTag.method_10550("Z"));
            }
            return null;
        }
        if (world.method_27983().equals(class_1937.field_25179)) {
            return world.method_27874();
        }
        return null;
    }

    private static void setCompassTarget(PlayerDto dto, class_746 player, class_2338 target) {
        double relativeYaw;
        class_243 playerPos = player.method_19538();
        class_243 targetPos = new class_243((double)target.method_10263() + 0.5, (double)target.method_10264() + 0.5, (double)target.method_10260() + 0.5);
        double deltaX = targetPos.field_1352 - playerPos.field_1352;
        double deltaZ = targetPos.field_1350 - playerPos.field_1350;
        double targetYaw = Math.toDegrees(Math.atan2(-deltaX, deltaZ));
        double playerYaw = player.field_6031;
        for (relativeYaw = targetYaw - playerYaw; relativeYaw <= -180.0; relativeYaw += 360.0) {
        }
        while (relativeYaw > 180.0) {
            relativeYaw -= 360.0;
        }
        dto.setCompassState(CompassState.POINTING);
        dto.setCompassRelativeYaw(relativeYaw);
        dto.setCompassDistance(Math.sqrt(deltaX * deltaX + deltaZ * deltaZ));
    }

    private static class CompassFindResult {
        final class_1799 stack;
        final CompassType type;

        CompassFindResult(class_1799 stack, CompassType type) {
            this.stack = stack;
            this.type = type;
        }
    }
}

