/*
 * Decompiled with CFR 0.152.
 */
package megabytesme.minelights;

import com.google.gson.Gson;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import megabytesme.minelights.PlayerDto;

public class UDPClient {
    private static DatagramSocket socket;
    private static InetAddress address;
    private static final int PORT = 63212;

    public static void sendFrameData(String frameJson) {
        if (socket == null || socket.isClosed()) {
            return;
        }
        try {
            byte[] buffer = frameJson.getBytes();
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length, address, 63212);
            socket.send(packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sendDisconnectSignal() {
        PlayerDto dto = new PlayerDto();
        dto.setInGame(false);
        String disconnectJson = new Gson().toJson((Object)dto);
        UDPClient.sendFrameData(disconnectJson);
    }

    public static void close() {
        if (socket != null) {
            socket.close();
        }
    }

    static {
        try {
            socket = new DatagramSocket();
            address = InetAddress.getByName("localhost");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

