/*
 * Decompiled with CFR 0.152.
 */
package megabytesme.minelights;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import megabytesme.minelights.MineLightsClient;
import megabytesme.minelights.PlayerDataCollector;
import megabytesme.minelights.PlayerDto;
import megabytesme.minelights.UDPClient;
import megabytesme.minelights.effects.DeviceLayout;
import megabytesme.minelights.effects.EffectPainter;
import megabytesme.minelights.effects.FrameStateDto;
import megabytesme.minelights.effects.KeyColorDto;
import megabytesme.minelights.effects.KeyNameStandardizer;
import megabytesme.minelights.effects.RGBColorDto;
import megabytesme.minelights.rgb.OpenRGBController;
import megabytesme.minelights.rgb.YeelightController;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LightingManager
implements Runnable {
    public static final Logger LOGGER = LogManager.getLogger((String)"MineLights-LightingManager");
    private EffectPainter effectPainter;
    private final Gson gson = new Gson();
    private static final int FRAME_DURATION_MS = 33;
    private volatile boolean isInitialized = false;
    private FrameStateDto lastSentFrame = null;
    private final OpenRGBController openRgbController = new OpenRGBController();
    private final Map<Integer, Integer> openRgbLedToDeviceMap = new HashMap<Integer, Integer>();
    private final YeelightController yeelightController = new YeelightController();
    private final Map<Integer, Integer> yeelightLedToDeviceMap = new HashMap<Integer, Integer>();
    private final List<DeviceLayout> deviceLayouts = Collections.synchronizedList(new ArrayList());

    private void performHandshakes() {
        JsonObject[] serverDataContainer = new JsonObject[1];
        Thread serverHandshakeThread = new Thread(() -> {
            try (Socket clientSocket = new Socket();){
                clientSocket.connect(new InetSocketAddress("127.0.0.1", 63211), 2000);
                MineLightsClient.isProxyConnected = true;
                DataOutputStream dos = new DataOutputStream(clientSocket.getOutputStream());
                DataInputStream dis = new DataInputStream(clientSocket.getInputStream());
                JsonObject configPayload = new JsonObject();
                JsonArray enabledIntegrations = new JsonArray();
                if (MineLightsClient.CONFIG.enableCorsair) {
                    enabledIntegrations.add("Corsair");
                }
                if (MineLightsClient.CONFIG.enableAsus) {
                    enabledIntegrations.add("Asus");
                }
                if (MineLightsClient.CONFIG.enableLogitech) {
                    enabledIntegrations.add("Logitech");
                }
                if (MineLightsClient.CONFIG.enableRazer) {
                    enabledIntegrations.add("Razer");
                }
                if (MineLightsClient.CONFIG.enableWooting) {
                    enabledIntegrations.add("Wooting");
                }
                if (MineLightsClient.CONFIG.enableSteelSeries) {
                    enabledIntegrations.add("SteelSeries");
                }
                if (MineLightsClient.CONFIG.enableMsi) {
                    enabledIntegrations.add("Msi");
                }
                if (MineLightsClient.CONFIG.enableNovation) {
                    enabledIntegrations.add("Novation");
                }
                if (MineLightsClient.CONFIG.enablePicoPi) {
                    enabledIntegrations.add("PicoPi");
                }
                configPayload.add("enabled_integrations", (JsonElement)enabledIntegrations);
                configPayload.add("disabled_devices", new Gson().toJsonTree(MineLightsClient.CONFIG.disabledDevices));
                byte[] configBytes = configPayload.toString().getBytes(StandardCharsets.UTF_8);
                dos.writeInt(configBytes.length);
                dos.write(configBytes);
                dos.flush();
                int length = dis.readInt();
                if (length > 0) {
                    byte[] jsonBytes = new byte[length];
                    dis.readFully(jsonBytes);
                    String jsonString = new String(jsonBytes, StandardCharsets.UTF_8);
                    serverDataContainer[0] = new JsonParser().parse(jsonString).getAsJsonObject();
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed during handshake with MineLights Server. Is it running? Details: {}", (Object)e.getMessage());
                MineLightsClient.isProxyConnected = false;
            }
        });
        serverHandshakeThread.setName("MineLights-Server-Handshake");
        Thread openRgbThread = new Thread(() -> {
            if (!MineLightsClient.CONFIG.enableOpenRgb) {
                return;
            }
            this.openRgbController.connect();
        });
        openRgbThread.setName("MineLights-OpenRGB-Handshake");
        Thread yeelightThread = new Thread(() -> {
            if (!MineLightsClient.CONFIG.enableYeelight) {
                return;
            }
            if (this.yeelightController.discover()) {
                List<YeelightController.YeelightDevice> devices = this.yeelightController.getDevices();
                int yeelightLedOffset = 3000;
                for (int i = 0; i < devices.size(); ++i) {
                    YeelightController.YeelightDevice device = devices.get(i);
                    String uniqueId = "Yeelight|" + (device.name != null && !device.name.isEmpty() ? device.name : device.id);
                    if (MineLightsClient.CONFIG.disabledDevices.contains(uniqueId)) continue;
                    MineLightsClient.discoveredDevices.add(uniqueId);
                    int globalLedId = yeelightLedOffset + i;
                    DeviceLayout layout = new DeviceLayout("Yeelight " + i, "YEELIGHT");
                    layout.addMapping("YEELIGHT_" + i, globalLedId);
                    this.deviceLayouts.add(layout);
                    this.yeelightLedToDeviceMap.put(globalLedId, i);
                }
            }
        });
        yeelightThread.setName("MineLights-Yeelight-Discovery");
        try {
            serverHandshakeThread.start();
            openRgbThread.start();
            yeelightThread.start();
            serverHandshakeThread.join(5000L);
            openRgbThread.join(5000L);
            yeelightThread.join(5000L);
            if (serverDataContainer[0] != null) {
                this.parseServerHandshakeData(serverDataContainer[0]);
            }
            this.parseOpenRGBData();
            this.effectPainter = new EffectPainter(this.deviceLayouts);
            this.isInitialized = true;
            long totalLeds = this.deviceLayouts.stream().mapToLong(d -> d.getAllLeds().size()).sum();
            LOGGER.info("Initialization complete. Found {} devices with a total of {} LEDs.", (Object)this.deviceLayouts.size(), (Object)totalLeds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void parseServerHandshakeData(JsonObject handshakeData) {
        LOGGER.info("--- Parsing Handshake Data from MineLights Server ---");
        if (handshakeData.has("devices")) {
            for (JsonElement deviceElement : handshakeData.getAsJsonArray("devices")) {
                JsonObject deviceObject = deviceElement.getAsJsonObject();
                String name = deviceObject.get("name").getAsString();
                String sdk = deviceObject.get("sdk").getAsString();
                String uniqueId = sdk + "|" + name;
                MineLightsClient.discoveredDevices.add(uniqueId);
                DeviceLayout layout = new DeviceLayout(name, "SERVER");
                if (deviceObject.has("key_map")) {
                    JsonObject mapObject = deviceObject.getAsJsonObject("key_map");
                    for (Map.Entry entry : mapObject.entrySet()) {
                        String standardizedName = KeyNameStandardizer.standardize((String)entry.getKey());
                        int ledId = ((JsonElement)entry.getValue()).getAsInt();
                        layout.addMapping(standardizedName, ledId);
                    }
                }
                this.deviceLayouts.add(layout);
                LOGGER.info("> Mapped device [{}]: {} ({} LEDs)", (Object)sdk, (Object)name, (Object)layout.getAllLeds().size());
            }
        }
    }

    private void parseOpenRGBData() {
        LOGGER.info("[OpenRGB] Parsing data from OpenRGB...");
        int openRgbDeviceIndex = 0;
        for (OpenRGBController.OpenRGBDevice device : this.openRgbController.getDevices()) {
            String uniqueId = "OpenRGB|" + device.name;
            MineLightsClient.discoveredDevices.add(uniqueId);
            DeviceLayout layout = new DeviceLayout(device.name, "OPENRGB");
            Map<String, Integer> openRgbMap = device.keyMap;
            int openRgbLedOffset = 2000 + openRgbDeviceIndex * 1000;
            for (Map.Entry<String, Integer> entry : openRgbMap.entrySet()) {
                String standardizedName = KeyNameStandardizer.standardize(entry.getKey());
                int globalLedId = openRgbLedOffset + entry.getValue();
                layout.addMapping(standardizedName, globalLedId);
                this.openRgbLedToDeviceMap.put(globalLedId, openRgbDeviceIndex);
            }
            this.deviceLayouts.add(layout);
            LOGGER.info("> Mapped device [OpenRGB]: {} ({} LEDs)", (Object)device.name, (Object)layout.getAllLeds().size());
            ++openRgbDeviceIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.performHandshakes();
        while (!this.isInitialized) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        try {
            while (!Thread.currentThread().isInterrupted()) {
                long frameEnd;
                long sleepTime;
                PlayerDto playerState;
                long frameStart = System.currentTimeMillis();
                class_310 client = class_310.method_1551();
                if (client.field_1724 == null || !MineLightsClient.CONFIG.enableMod) {
                    playerState = new PlayerDto();
                    playerState.setInGame(false);
                } else {
                    playerState = PlayerDataCollector.getCurrentState(client);
                }
                FrameStateDto frameState = this.effectPainter.paint(playerState);
                if (frameState.equals(this.lastSentFrame)) {
                    long frameEnd2 = System.currentTimeMillis();
                    long sleepTime2 = 33L - (frameEnd2 - frameStart);
                    if (sleepTime2 <= 0L) continue;
                    Thread.sleep(sleepTime2);
                    continue;
                }
                this.lastSentFrame = frameState;
                ArrayList<KeyColorDto> proxyUpdateList = new ArrayList<KeyColorDto>();
                HashMap<Integer, List> openRgbUpdates = new HashMap<Integer, List>();
                for (Map.Entry<Integer, RGBColorDto> entry : frameState.keys.entrySet()) {
                    int deviceIndex;
                    int globalLedId = entry.getKey();
                    RGBColorDto color = entry.getValue();
                    if (this.openRgbLedToDeviceMap.containsKey(globalLedId)) {
                        deviceIndex = this.openRgbLedToDeviceMap.get(globalLedId);
                        openRgbUpdates.computeIfAbsent(deviceIndex, k -> new ArrayList()).add(new KeyColorDto(globalLedId, color));
                        continue;
                    }
                    if (this.yeelightLedToDeviceMap.containsKey(globalLedId)) {
                        deviceIndex = this.yeelightLedToDeviceMap.get(globalLedId);
                        this.yeelightController.updateLed(deviceIndex, color);
                        continue;
                    }
                    proxyUpdateList.add(new KeyColorDto(globalLedId, color));
                }
                if (!proxyUpdateList.isEmpty()) {
                    JsonObject proxyPayload = new JsonObject();
                    proxyPayload.add("led_colors", this.gson.toJsonTree(proxyUpdateList));
                    UDPClient.sendFrameData(this.gson.toJson((JsonElement)proxyPayload));
                }
                if (!openRgbUpdates.isEmpty()) {
                    for (Map.Entry entry : openRgbUpdates.entrySet()) {
                        this.openRgbController.updateLeds((Integer)entry.getKey(), (List)entry.getValue());
                    }
                }
                if ((sleepTime = 33L - ((frameEnd = System.currentTimeMillis()) - frameStart)) <= 0L) continue;
                Thread.sleep(sleepTime);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.error("Error in lighting loop", (Throwable)e);
        }
        finally {
            this.openRgbController.disconnect();
            this.yeelightController.disconnect();
        }
    }
}

