/*
 * Decompiled with CFR 0.152.
 */
package megabytesme.minelights;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import megabytesme.minelights.CommandClient;
import megabytesme.minelights.DiscoveryListener;
import megabytesme.minelights.LightingManager;
import megabytesme.minelights.UDPClient;
import megabytesme.minelights.config.MineLightsConfig;
import megabytesme.minelights.config.SimpleJsonConfig;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_442;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MineLightsClient
implements ClientModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"MineLights");
    public static final String MOD_ID = "mine-lights";
    public static final List<String> serverLogLines = Collections.synchronizedList(new ArrayList());
    public static MineLightsConfig CONFIG;
    private static SimpleJsonConfig CONFIG_MANAGER;
    private static LightingManager lightingManager;
    private static Thread lightingManagerThread;
    private static Thread discoveryThread;
    public static Thread serverMonitorThread;
    public static volatile boolean isManualRestart;
    public static final List<String> discoveredDevices;
    public static final boolean IS_WINDOWS;
    public static volatile boolean isProxyConnected;
    public static CountDownLatch proxyDiscoveredLatch;
    private static final AtomicBoolean hasPerformedServerCheck;
    private static final String GITHUB_API_URL = "https://api.github.com/repos/megabytesme/MineLights-Server/releases/latest";
    private boolean titleScreenHooked = false;
    private static final AtomicBoolean lightingInitialized;
    private static final String MODRINTH_PROJECT_ID = "minelights";
    private static final AtomicBoolean hasCheckedForUpdate;
    public static final AtomicReference<DownloadStatus> downloadStatus;
    public static final AtomicInteger downloadProgress;
    public static final AtomicReference<String> downloadError;
    public static final AtomicLong downloadBytesSoFar;
    public static final AtomicLong downloadTotalBytes;
    public static final AtomicReference<String> downloadEta;
    public static final AtomicReference<String> downloadSpeedMBps;
    private static Process serverProcess;
    private static final char[] HEX_ARRAY;

    public void onInitializeClient() {
        CONFIG_MANAGER = new SimpleJsonConfig(MOD_ID);
        CONFIG = CONFIG_MANAGER.load(MineLightsConfig.class, new MineLightsConfig());
        if (IS_WINDOWS) {
            this.initializeServerConnection();
            ClientTickEvents.END_CLIENT_TICK.register(client -> {
                if (client.field_1755 instanceof class_442 && !this.titleScreenHooked) {
                    this.titleScreenHooked = true;
                    if (!hasPerformedServerCheck.getAndSet(true)) {
                        new Thread(MineLightsClient::checkForServerUpdate, "MineLights-Update-Check").start();
                    }
                }
            });
        }
        ClientTickEvents.START_WORLD_TICK.register(client -> {
            if (hasCheckedForUpdate.compareAndSet(false, true)) {
                new Thread(MineLightsClient::checkForUpdate, "MineLights-Modrinth-Update-Check").start();
            }
        });
        new Thread(() -> {
            try {
                if (proxyDiscoveredLatch.await(3L, TimeUnit.SECONDS)) {
                    LOGGER.info("MineLights Server discovered via broadcast! Initializing connection.");
                } else if (!IS_WINDOWS) {
                    LOGGER.warn("MineLights Server not discovered via broadcast on non-Windows OS.");
                }
                MineLightsClient.triggerLightingInitialization();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }, "MineLights-Initializer-Waiter").start();
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> {
            if (lightingManagerThread != null) {
                lightingManagerThread.interrupt();
            }
            if (discoveryThread != null) {
                discoveryThread.interrupt();
            }
            if (serverMonitorThread != null) {
                serverMonitorThread.interrupt();
            }
            UDPClient.close();
            if (IS_WINDOWS) {
                CommandClient.sendCommand("shutdown");
            }
        });
    }

    private static void checkForUpdate() {
        LOGGER.info("Checking for MineLights updates on Modrinth...");
        try {
            String latestVersionNumber;
            String json;
            Optional modContainer = FabricLoader.getInstance().getModContainer(MOD_ID);
            if (!modContainer.isPresent()) {
                return;
            }
            String currentVersion = ((ModContainer)modContainer.get()).getMetadata().getVersion().getFriendlyString();
            String gameVersion = class_155.method_16673().getName();
            String urlString = String.format("https://api.modrinth.com/v2/project/%s/version?game_versions=%s&loaders=%s", MODRINTH_PROJECT_ID, URLEncoder.encode("[\"" + gameVersion + "\"]", StandardCharsets.UTF_8.toString()), URLEncoder.encode("[\"fabric\"]", StandardCharsets.UTF_8.toString()));
            HttpURLConnection conn = (HttpURLConnection)URI.create(urlString).toURL().openConnection();
            conn.setRequestMethod("GET");
            if (conn.getResponseCode() != 200) {
                return;
            }
            try (InputStream in = conn.getInputStream();){
                json = MineLightsClient.readAllBytes(in);
            }
            JsonArray versions = new JsonParser().parse(json).getAsJsonArray();
            if (versions.size() > 0 && !currentVersion.equals(latestVersionNumber = versions.get(0).getAsJsonObject().get("version_number").getAsString())) {
                class_310.method_1551().execute(() -> {
                    if (class_310.method_1551().field_1724 != null) {
                        String modrinthUrl = "https://modrinth.com/mod/minelights/versions?version=" + gameVersion + "#download";
                        class_5250 message = new class_2585("[MineLights] ").method_27692(class_124.field_1065).method_10852((class_2561)new class_2585("A new version is available: ").method_27692(class_124.field_1054)).method_10852((class_2561)new class_2585(latestVersionNumber).method_27692(class_124.field_1075));
                        class_5250 link = new class_2585("[Click here to download]").method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, modrinthUrl)).method_10977(class_124.field_1060));
                        class_310.method_1551().field_1724.method_7353((class_2561)message, false);
                        class_310.method_1551().field_1724.method_7353((class_2561)link, false);
                    }
                });
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to check for mod updates", (Throwable)e);
        }
    }

    private static String readAllBytes(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return new String(buffer.toByteArray());
    }

    public static void checkForServerUpdate() {
        if (downloadStatus.get() == DownloadStatus.DOWNLOADING) {
            return;
        }
        try {
            String json;
            Path serverExePath = class_310.method_1551().field_1697.toPath().resolve("mods").resolve("MineLights").resolve("MineLights.exe");
            URI apiUri = URI.create(GITHUB_API_URL);
            HttpURLConnection conn = (HttpURLConnection)apiUri.toURL().openConnection();
            conn.setRequestProperty("Accept", "application/vnd.github+json");
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            try (InputStream in = conn.getInputStream();){
                json = MineLightsClient.readAllBytes(in);
            }
            JsonObject root = new JsonParser().parse(json).getAsJsonObject();
            JsonArray assets = root.getAsJsonArray("assets");
            if (assets.size() == 0) {
                return;
            }
            JsonObject asset = assets.get(0).getAsJsonObject();
            String expectedHash = asset.has("digest") ? asset.get("digest").getAsString().replace("sha256:", "") : "";
            boolean needsDownload = false;
            if (!Files.exists(serverExePath, new LinkOption[0])) {
                needsDownload = true;
            } else {
                String localHash = MineLightsClient.sha256(serverExePath);
                if (!expectedHash.isEmpty() && !localHash.equalsIgnoreCase(expectedHash)) {
                    LOGGER.info("MineLights.exe is outdated or corrupted. An update is required.");
                    needsDownload = true;
                } else if (expectedHash.isEmpty()) {
                    LOGGER.warn("Could not verify server hash from GitHub API, assuming it's up to date.");
                } else {
                    LOGGER.info("MineLights.exe is up to date.");
                }
            }
            if (needsDownload) {
                Path tempExePath = serverExePath.getParent().resolve("MineLights.exe.new");
                new Thread(() -> {
                    if (MineLightsClient.performServerDownload(tempExePath)) {
                        LOGGER.info("Shutting down MineLights server for update...");
                        CommandClient.sendCommand("shutdown");
                        if (serverProcess != null) {
                            try {
                                serverProcess.waitFor(5L, TimeUnit.SECONDS);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        try {
                            Files.deleteIfExists(serverExePath);
                            Files.move(tempExePath, serverExePath, new CopyOption[0]);
                            LOGGER.info("MineLights.exe updated successfully.");
                            lightingInitialized.set(false);
                            isManualRestart = true;
                            MineLightsClient.startServerProcess();
                        }
                        catch (IOException e) {
                            LOGGER.error("Failed to replace MineLights.exe", (Throwable)e);
                        }
                    }
                }, "MineLights-Background-Downloader").start();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to check for server update", (Throwable)e);
            downloadError.set(e.getMessage());
            downloadStatus.set(DownloadStatus.FAILED);
        }
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    private static String sha256(Path file) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        try (InputStream fis = Files.newInputStream(file, new OpenOption[0]);){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = fis.read(buffer)) != -1) {
                digest.update(buffer, 0, bytesRead);
            }
        }
        return MineLightsClient.bytesToHex(digest.digest());
    }

    private static boolean performServerDownload(Path destination) {
        if (!(downloadStatus.compareAndSet(DownloadStatus.IDLE, DownloadStatus.DOWNLOADING) || downloadStatus.compareAndSet(DownloadStatus.FAILED, DownloadStatus.DOWNLOADING) || downloadStatus.compareAndSet(DownloadStatus.SUCCESS, DownloadStatus.DOWNLOADING))) {
            return false;
        }
        downloadProgress.set(0);
        downloadError.set("");
        try {
            String json;
            URL apiUrl = URI.create(GITHUB_API_URL).toURL();
            HttpURLConnection conn = (HttpURLConnection)apiUrl.openConnection();
            conn.setRequestProperty("Accept", "application/vnd.github+json");
            try (InputStream in = conn.getInputStream();){
                json = MineLightsClient.readAllBytes(in);
            }
            JsonObject root = new JsonParser().parse(json).getAsJsonObject();
            JsonArray assets = root.getAsJsonArray("assets");
            if (assets.size() == 0) {
                throw new IOException("No assets found in release");
            }
            JsonObject asset = assets.get(0).getAsJsonObject();
            String downloadUrl = asset.get("browser_download_url").getAsString();
            String expectedHash = asset.has("digest") ? asset.get("digest").getAsString().replace("sha256:", "") : "";
            Files.createDirectories(destination.getParent(), new FileAttribute[0]);
            URL url = URI.create(downloadUrl).toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", "MineLights-Mod-Downloader/1.0");
            long totalFileSize = connection.getContentLengthLong();
            long totalBytesRead = 0L;
            downloadTotalBytes.set(totalFileSize);
            downloadBytesSoFar.set(0L);
            long startTime = System.nanoTime();
            try (InputStream inputStream = connection.getInputStream();
                 FileOutputStream outputStream = new FileOutputStream(destination.toFile());){
                int bytesRead;
                byte[] buffer = new byte[8192];
                long lastBytesRead = 0L;
                long lastTimeCheck = startTime;
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    long now;
                    double intervalSeconds;
                    double secondsElapsed;
                    outputStream.write(buffer, 0, bytesRead);
                    downloadBytesSoFar.set(totalBytesRead += (long)bytesRead);
                    if (totalFileSize > 0L) {
                        downloadProgress.set((int)(totalBytesRead * 100L / totalFileSize));
                    }
                    if ((secondsElapsed = (double)(System.nanoTime() - startTime) / 1.0E9) > 0.0 && totalFileSize > 0L) {
                        double bytesPerSecond = (double)totalBytesRead / secondsElapsed;
                        long secondsRemaining = (long)((double)(totalFileSize - totalBytesRead) / bytesPerSecond);
                        downloadEta.set(MineLightsClient.formatEta(secondsRemaining));
                    }
                    if (!((intervalSeconds = (double)((now = System.nanoTime()) - lastTimeCheck) / 1.0E9) >= 1.0)) continue;
                    long bytesInInterval = totalBytesRead - lastBytesRead;
                    double mbps = (double)bytesInInterval / 1048576.0 / intervalSeconds;
                    downloadSpeedMBps.set(String.format("%.2f", mbps));
                    lastBytesRead = totalBytesRead;
                    lastTimeCheck = now;
                }
            }
            downloadStatus.set(DownloadStatus.VERIFYING);
            String actualHash = MineLightsClient.sha256(destination);
            if (!expectedHash.isEmpty() && !actualHash.equalsIgnoreCase(expectedHash)) {
                throw new IOException("Hash mismatch! Expected " + expectedHash + " but got " + actualHash);
            }
            LOGGER.info("Server executable downloaded successfully.");
            downloadStatus.set(DownloadStatus.SUCCESS);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed during background download or verification", (Throwable)e);
            downloadError.set(e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName());
            downloadStatus.set(DownloadStatus.FAILED);
            return false;
        }
    }

    private static String formatEta(long seconds) {
        long mins = seconds / 60L;
        long secs = seconds % 60L;
        return String.format("%dm %ds", mins, secs);
    }

    private void initializeServerConnection() {
        discoveryThread = new Thread((Runnable)new DiscoveryListener(), "MineLights-Discovery");
        discoveryThread.setDaemon(true);
        discoveryThread.start();
        if (MineLightsClient.CONFIG.autoStartServer) {
            serverMonitorThread = new Thread(MineLightsClient::serverMonitorLoop, "MineLights-Server-Monitor");
            serverMonitorThread.setDaemon(true);
            serverMonitorThread.start();
        } else {
            new Thread(MineLightsClient::checkForServerUpdate, "MineLights-Initial-Check").start();
        }
    }

    private static void serverMonitorLoop() {
        LOGGER.info("Starting MineLights Server monitor.");
        boolean hasConnected = false;
        long lastLaunchAttemptTime = 0L;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                if (MineLightsClient.isServerRunning()) {
                    if (isManualRestart) {
                        LOGGER.info("New server process detected after manual restart. Forcing re-initialization...");
                        lightingInitialized.set(false);
                        isManualRestart = false;
                        hasConnected = false;
                    }
                    if (!hasConnected) {
                        MineLightsClient.triggerLightingInitialization();
                        hasConnected = true;
                    }
                    Thread.sleep(10000L);
                    continue;
                }
                lightingInitialized.set(false);
                hasConnected = false;
                if (isManualRestart) {
                    LOGGER.info("Manual restart initiated. Waiting for new server process to start...");
                    Thread.sleep(8000L);
                    continue;
                }
                Path serverExePath = class_310.method_1551().field_1697.toPath().resolve("mods").resolve("MineLights").resolve("MineLights.exe");
                if (!Files.exists(serverExePath, new LinkOption[0])) {
                    if (downloadStatus.get() != DownloadStatus.DOWNLOADING) {
                        LOGGER.warn("MineLights.exe not found. Performing synchronous download.");
                        if (MineLightsClient.performServerDownload(serverExePath)) continue;
                        LOGGER.error("Download failed. Will retry after 30 seconds.");
                        Thread.sleep(30000L);
                        continue;
                    }
                    Thread.sleep(1000L);
                    continue;
                }
                if (serverProcess == null || !serverProcess.isAlive()) {
                    if (System.currentTimeMillis() - lastLaunchAttemptTime > 10000L) {
                        LOGGER.info("Server process is not active. Attempting to launch MineLights.exe...");
                        MineLightsClient.startServerProcess();
                        lastLaunchAttemptTime = System.currentTimeMillis();
                    }
                } else {
                    LOGGER.info("Waiting for running server process to become responsive...");
                }
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOGGER.info("Server monitor shutting down.");
                break;
            }
        }
    }

    public static boolean isServerRunning() {
        boolean bl;
        Socket ignored = new Socket("127.0.0.1", 63213);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        ignored.close();
        return bl;
    }

    private static void startServerProcess() {
        Path serverExePath = class_310.method_1551().field_1697.toPath().resolve("mods").resolve("MineLights").resolve("MineLights.exe");
        if (!Files.exists(serverExePath, new LinkOption[0])) {
            return;
        }
        try {
            LOGGER.info("Launching server from: {}", (Object)serverExePath.toAbsolutePath());
            serverLogLines.clear();
            ProcessBuilder pb = new ProcessBuilder(serverExePath.toAbsolutePath().toString());
            pb.directory(serverExePath.getParent().toFile());
            pb.redirectErrorStream(true);
            serverProcess = pb.start();
            DateTimeFormatter tsFormat = DateTimeFormatter.ofPattern("HH:mm:ss");
            new Thread(() -> {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(serverProcess.getInputStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        String ts = LocalTime.now().format(tsFormat);
                        String stamped = "[" + ts + "] " + line;
                        LOGGER.info("[MineLights.exe] {}", (Object)stamped);
                        List<String> list = serverLogLines;
                        synchronized (list) {
                            serverLogLines.add(0, stamped);
                        }
                    }
                    return;
                }
                catch (IOException e) {
                    LOGGER.error("Error reading server log", (Throwable)e);
                }
            }, "MineLights-Server-Log-Reader").start();
        }
        catch (IOException e) {
            LOGGER.warn("Failed to start MineLights.exe process: {}", (Object)e.getMessage());
            serverProcess = null;
        }
    }

    public static synchronized void triggerLightingInitialization() {
        if (lightingInitialized.compareAndSet(false, true)) {
            LOGGER.info("Primary initialization trigger. Starting lighting systems...");
            MineLightsClient.refreshLightingManager();
        } else {
            LOGGER.info("Initialization already in progress or complete. Skipping redundant start.");
        }
    }

    public static synchronized void refreshLightingManager() {
        LOGGER.info("Refreshing lighting manager...");
        if (lightingManagerThread != null && lightingManagerThread.isAlive()) {
            lightingManagerThread.interrupt();
            try {
                lightingManagerThread.join(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        discoveredDevices.clear();
        proxyDiscoveredLatch = new CountDownLatch(1);
        lightingManager = new LightingManager();
        lightingManagerThread = new Thread((Runnable)lightingManager, "MineLights-MainLoop");
        lightingManagerThread.start();
        lightingInitialized.set(true);
    }

    public static void saveConfig() {
        CONFIG_MANAGER.save(CONFIG);
    }

    static {
        isManualRestart = false;
        discoveredDevices = Collections.synchronizedList(new ArrayList());
        IS_WINDOWS = System.getProperty("os.name").toLowerCase().contains("win");
        isProxyConnected = false;
        proxyDiscoveredLatch = new CountDownLatch(1);
        hasPerformedServerCheck = new AtomicBoolean(false);
        lightingInitialized = new AtomicBoolean(false);
        hasCheckedForUpdate = new AtomicBoolean(false);
        downloadStatus = new AtomicReference<DownloadStatus>(DownloadStatus.IDLE);
        downloadProgress = new AtomicInteger(0);
        downloadError = new AtomicReference<String>("");
        downloadBytesSoFar = new AtomicLong(0L);
        downloadTotalBytes = new AtomicLong(0L);
        downloadEta = new AtomicReference<String>("");
        downloadSpeedMBps = new AtomicReference<String>("");
        serverProcess = null;
        HEX_ARRAY = "0123456789abcdef".toCharArray();
    }

    public static enum DownloadStatus {
        IDLE,
        DOWNLOADING,
        VERIFYING,
        SUCCESS,
        FAILED;

    }
}

