/*
 * Decompiled with CFR 0.152.
 */
package megabytesme.minelights.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class SimpleJsonConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final String modId;

    public SimpleJsonConfig(String modId) {
        this.modId = modId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T load(Class<T> configClass, T defaultConfig) {
        File configFile = this.getConfigFile();
        if (!configFile.exists()) {
            this.save(defaultConfig);
            return defaultConfig;
        }
        try (FileReader reader = new FileReader(configFile);){
            Object object = GSON.fromJson((Reader)reader, configClass);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read config file!", e);
        }
    }

    public <T> void save(T config) {
        File configFile = this.getConfigFile();
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson(config, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save config file!", e);
        }
    }

    private File getConfigFile() {
        return new File(FabricLoader.getInstance().getConfigDir().toFile(), this.modId + ".json");
    }
}

