/*
 * Decompiled with CFR 0.152.
 */
package megabytesme.minelights.rgb;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import megabytesme.minelights.effects.RGBColorDto;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class YeelightController {
    public static final Logger LOGGER = LogManager.getLogger((String)"Minelights-Yeelight");
    private static final String DISCOVERY_MSG = "M-SEARCH * HTTP/1.1\r\nHOST: 239.255.255.250:1982\r\nMAN: \"ssdp:discover\"\r\nST: wifi_bulb\r\n";
    private static final String MULTICAST_ADDRESS = "239.255.255.250";
    private static final int MULTICAST_PORT = 1982;
    private static final int DISCOVERY_TIMEOUT_MS = 3000;
    private static final int YEELIGHT_SMOOTH_DURATION = 400;
    private final List<YeelightDevice> devices = Collections.synchronizedList(new ArrayList());

    public boolean discover() {
        LOGGER.info("Starting Yeelight discovery...");
        HashMap<String, YeelightDevice> foundDevices = new HashMap<String, YeelightDevice>();
        try (DatagramSocket socket = new DatagramSocket();){
            socket.setSoTimeout(3000);
            byte[] discoveryMsgBytes = DISCOVERY_MSG.getBytes(StandardCharsets.UTF_8);
            InetAddress multicastAddress = InetAddress.getByName(MULTICAST_ADDRESS);
            DatagramPacket sendPacket = new DatagramPacket(discoveryMsgBytes, discoveryMsgBytes.length, multicastAddress, 1982);
            LOGGER.debug("[UDP-SEND] Broadcasting discovery message from local port: {}", (Object)socket.getLocalPort());
            socket.send(sendPacket);
            LOGGER.debug("[UDP-SEND] Broadcast sent successfully.");
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < 3000L) {
                try {
                    byte[] receiveBuffer = new byte[1500];
                    DatagramPacket receivePacket = new DatagramPacket(receiveBuffer, receiveBuffer.length);
                    socket.receive(receivePacket);
                    String response = new String(receivePacket.getData(), 0, receivePacket.getLength(), StandardCharsets.UTF_8);
                    LOGGER.info("[UDP-RECV] Received response from {}:{}", (Object)receivePacket.getAddress().getHostAddress(), (Object)receivePacket.getPort());
                    LOGGER.trace("[UDP-RECV] Raw data:\n{}", (Object)response);
                    Map<String, String> headers = this.parseDiscoveryResponse(response);
                    String id = headers.get("id");
                    String location = headers.get("Location");
                    if (id == null || location == null || foundDevices.containsKey(id)) continue;
                    String model = headers.getOrDefault("model", "unknown");
                    String name = headers.getOrDefault("name", "");
                    LOGGER.info("SUCCESS: Discovered and parsed Yeelight device: id={}, name='{}', location={}", (Object)id, (Object)name, (Object)location);
                    foundDevices.put(id, new YeelightDevice(id, location, model, name));
                }
                catch (SocketTimeoutException e) {
                    LOGGER.debug("[UDP-RECV] Discovery listener timed out. Assuming all devices have responded.");
                    break;
                }
                catch (IOException e) {
                    LOGGER.error("Error during Yeelight discovery receive loop", (Throwable)e);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Fatal error during Yeelight discovery setup or broadcast", (Throwable)e);
            return false;
        }
        this.devices.clear();
        this.devices.addAll(foundDevices.values());
        LOGGER.info("Yeelight discovery process finished. Found {} total devices.", (Object)this.devices.size());
        if (!this.devices.isEmpty()) {
            this.devices.parallelStream().forEach(YeelightDevice::connect);
        }
        return true;
    }

    private Map<String, String> parseDiscoveryResponse(String response) {
        String[] lines;
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String line : lines = response.split("\r\n")) {
            String[] parts;
            if (!line.contains(":") || (parts = line.split(":", 2)).length != 2) continue;
            headers.put(parts[0].trim(), parts[1].trim());
        }
        return headers;
    }

    public List<YeelightDevice> getDevices() {
        return this.devices;
    }

    public void updateLed(int deviceId, RGBColorDto color) {
        if (deviceId >= 0 && deviceId < this.devices.size()) {
            this.devices.get(deviceId).setColor(color.r, color.g, color.b);
        }
    }

    public void disconnect() {
        this.devices.forEach(YeelightDevice::disconnect);
    }

    public static class YeelightDevice {
        public String id;
        public String location;
        public String ip;
        public int port;
        public String model;
        public String name;
        Socket socket;
        DataOutputStream out;
        BufferedReader in;
        final AtomicInteger commandId = new AtomicInteger(1);
        final RGBColorDto lastColor = new RGBColorDto(-1, -1, -1);
        private final Object socketLock = new Object();

        public YeelightDevice(String id, String location, String model, String name) {
            this.id = id;
            this.location = location;
            this.model = model;
            this.name = name;
            String[] parts = location.replace("yeelight://", "").split(":");
            this.ip = parts[0];
            this.port = Integer.parseInt(parts[1]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean connect() {
            Object object = this.socketLock;
            synchronized (object) {
                if (this.socket != null && this.socket.isConnected() && !this.socket.isClosed()) {
                    return true;
                }
                try {
                    this.disconnect();
                    this.socket = new Socket();
                    this.socket.connect(new InetSocketAddress(this.ip, this.port), 1000);
                    this.out = new DataOutputStream(this.socket.getOutputStream());
                    this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                    LOGGER.info("Connected to Yeelight device: {}", (Object)this.id);
                    Thread readerThread = new Thread(() -> {
                        try {
                            while (this.socket != null && !this.socket.isClosed() && this.in != null) {
                                String line = this.in.readLine();
                                if (line == null) {
                                    break;
                                }
                                LOGGER.trace("[TCP-RECV {}] {}", (Object)this.id, (Object)line);
                            }
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            LOGGER.info("Reader thread for Yeelight {} stopping.", (Object)this.id);
                        }
                    });
                    readerThread.setDaemon(true);
                    readerThread.setName("Yeelight-Reader-" + this.id);
                    readerThread.start();
                    return true;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to connect to Yeelight device {}: {}", (Object)this.id, (Object)e.getMessage());
                    this.disconnect();
                    return false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnect() {
            Object object = this.socketLock;
            synchronized (object) {
                try {
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.socket = null;
                this.out = null;
                this.in = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setColor(int r, int g, int b) {
            if (r == this.lastColor.r && g == this.lastColor.g && b == this.lastColor.b) {
                return;
            }
            Object object = this.socketLock;
            synchronized (object) {
                if (!(this.socket != null && this.socket.isConnected() && !this.socket.isClosed() || this.connect())) {
                    return;
                }
                try {
                    int rgbVal = r << 16 | g << 8 | b;
                    HashMap<String, Object> command = new HashMap<String, Object>();
                    command.put("id", this.commandId.getAndIncrement());
                    command.put("method", "set_rgb");
                    command.put("params", new Object[]{rgbVal, "smooth", 400});
                    String jsonCmd = new Gson().toJson(command) + "\r\n";
                    LOGGER.trace("[TCP-SEND {}] {}", (Object)this.id, (Object)jsonCmd.trim());
                    this.out.write(jsonCmd.getBytes(StandardCharsets.UTF_8));
                    this.out.flush();
                    this.lastColor.r = r;
                    this.lastColor.g = g;
                    this.lastColor.b = b;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to send command to Yeelight device {}: {}", (Object)this.id, (Object)e.getMessage());
                    this.disconnect();
                }
            }
        }
    }
}

