/*
 * Decompiled with CFR 0.152.
 */
package megabytesme.minelights;

import java.util.ArrayList;
import java.util.Optional;
import megabytesme.minelights.CompassState;
import megabytesme.minelights.CompassType;
import megabytesme.minelights.MineLightsClient;
import megabytesme.minelights.PlayerDto;
import megabytesme.minelights.accessor.ChatReceivedAccessor;
import megabytesme.minelights.accessor.PlayerVisualBrightnessAccessor;
import megabytesme.minelights.mixin.LightningAccessor;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_9291;
import net.minecraft.class_9334;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerDataCollector {
    public static final Logger LOGGER = LogManager.getLogger((String)"MineLights-PlayerDataCollector");

    public static PlayerDto getCurrentState(class_310 client) {
        PlayerDto playerDto = new PlayerDto();
        if (client == null || client.field_1687 == null || client.field_1724 == null) {
            playerDto.setInGame(false);
            return playerDto;
        }
        class_746 player = client.field_1724;
        class_638 world = client.field_1687;
        playerDto.setInGame(true);
        playerDto.setHealth(player.method_6032());
        playerDto.setHunger(player.method_7344().method_7586());
        playerDto.setSaturation(player.method_7344().method_7589());
        playerDto.setAir(player.method_5669());
        playerDto.setExperience(player.field_7510);
        playerDto.setBlockAtFeet(world.method_8320(player.method_24515()).method_26204().method_9539());
        playerDto.setBlockOn(world.method_8320(player.method_24515().method_10074()).method_26204().method_9539());
        class_243 eyePos = player.method_33571();
        class_2338 headPos = class_2338.method_49637((double)eyePos.field_1352, (double)eyePos.field_1351, (double)eyePos.field_1350);
        playerDto.setBlockAtHead(world.method_8320(headPos).method_26204().method_9539());
        world.method_23753(player.method_24515()).method_40230().ifPresent(key -> playerDto.setCurrentBiome(key.method_29177().toString()));
        playerDto.setCurrentWorld(world.method_27983().method_29177().toString());
        playerDto.setIsOnFire(player.method_5809());
        playerDto.setIsPoisoned(player.method_6059(class_1294.field_5899));
        playerDto.setIsWithering(player.method_6059(class_1294.field_5920));
        playerDto.setIsTakingDamage(player.field_6235 > 0);
        PlayerDataCollector.updateCompassData(playerDto, player, world);
        if (world.method_8546()) {
            playerDto.setWeather("Thunderstorm");
        } else if (world.method_8419()) {
            playerDto.setWeather("Rain");
        } else {
            playerDto.setWeather("Clear");
        }
        for (class_1297 entity : world.method_18112()) {
            if (!(entity instanceof class_1538)) continue;
            class_1538 lightning = (class_1538)entity;
            LightningAccessor acc = (LightningAccessor)lightning;
            int ambientTick = acc.getAmbientTick();
            int remainingActions = acc.getRemainingActions();
            playerDto.setIsLightningFlashing(ambientTick % 3 < 2 && remainingActions > 0);
        }
        playerDto.setSkyLightLevel(((PlayerVisualBrightnessAccessor)player).getSkyLightLevel());
        playerDto.setRenderedBrightnessLevel(((PlayerVisualBrightnessAccessor)player).getRenderedBrightness());
        class_634 handler = class_310.method_1551().method_1562();
        if (handler instanceof ChatReceivedAccessor) {
            ChatReceivedAccessor accessor = (ChatReceivedAccessor)handler;
            if (accessor.wasChatReceivedThisTick()) {
                playerDto.setIsChatReceived(true);
                accessor.resetChatReceivedFlag();
            } else {
                playerDto.setIsChatReceived(false);
            }
        }
        return playerDto;
    }

    private static void updateCompassData(PlayerDto dto, class_746 player, class_638 world) {
        CompassFindResult result = PlayerDataCollector.findCompass((class_1657)player);
        if (result == null) {
            if (MineLightsClient.CONFIG.alwaysShowCompass && world.method_27983().equals(class_1937.field_25179)) {
                dto.setCompassType(CompassType.STANDARD);
                class_4208 spawnPos = class_4208.method_19443((class_5321)world.method_27983(), (class_2338)world.method_43126());
                PlayerDataCollector.setCompassTarget(dto, player, spawnPos.comp_2208());
            } else {
                dto.setCompassState(CompassState.NONE);
                dto.setCompassType(CompassType.NONE);
            }
            return;
        }
        dto.setCompassType(result.type);
        class_2338 targetPos = PlayerDataCollector.getCompassTargetPos(result.stack, (class_1657)player, world);
        if (targetPos != null && !(targetPos.method_10262((class_2382)player.method_24515()) < 1.0E-5)) {
            PlayerDataCollector.setCompassTarget(dto, player, targetPos);
        } else {
            dto.setCompassState(CompassState.SPINNING);
        }
    }

    private static CompassFindResult findCompass(class_1657 player) {
        ArrayList<CompassFindResult> foundCompasses = new ArrayList<CompassFindResult>();
        ArrayList<class_1799> inventory = new ArrayList<class_1799>();
        inventory.add(player.method_6047());
        inventory.add(player.method_6079());
        for (int i = 0; i < 36; ++i) {
            inventory.add(player.method_31548().method_5438(i));
        }
        for (class_1799 stack : inventory) {
            if (stack.method_7960()) continue;
            if (stack.method_7909() == class_1802.field_38747) {
                foundCompasses.add(new CompassFindResult(stack, CompassType.RECOVERY));
                continue;
            }
            if (stack.method_7909() != class_1802.field_8251) continue;
            boolean isLodestone = false;
            class_9291 lodestoneData = (class_9291)stack.method_57824(class_9334.field_49614);
            if (lodestoneData != null && lodestoneData.comp_2402().isPresent()) {
                isLodestone = true;
            }
            if (isLodestone) {
                foundCompasses.add(new CompassFindResult(stack, CompassType.LODESTONE));
                continue;
            }
            foundCompasses.add(new CompassFindResult(stack, CompassType.STANDARD));
        }
        if (foundCompasses.isEmpty()) {
            return null;
        }
        if (foundCompasses.size() == 1) {
            return (CompassFindResult)foundCompasses.get(0);
        }
        switch (MineLightsClient.CONFIG.compassPriority) {
            case STANDARD_FIRST: {
                return foundCompasses.stream().filter(r -> r.type == CompassType.STANDARD).findFirst().orElse((CompassFindResult)foundCompasses.get(0));
            }
            case LODESTONE_FIRST: {
                return foundCompasses.stream().filter(r -> r.type == CompassType.LODESTONE).findFirst().orElse((CompassFindResult)foundCompasses.get(0));
            }
            case RECOVERY_FIRST: {
                return foundCompasses.stream().filter(r -> r.type == CompassType.RECOVERY).findFirst().orElse((CompassFindResult)foundCompasses.get(0));
            }
        }
        return (CompassFindResult)foundCompasses.get(0);
    }

    private static class_2338 getCompassTargetPos(class_1799 stack, class_1657 holder, class_638 world) {
        if (stack.method_7909() == class_1802.field_38747) {
            class_4208 pos2;
            Optional lastDeathPos = holder.method_43122();
            if (lastDeathPos.isPresent() && (pos2 = (class_4208)lastDeathPos.get()).comp_2207().equals(world.method_27983())) {
                return pos2.comp_2208();
            }
            return null;
        }
        class_9291 lodestoneData = (class_9291)stack.method_57824(class_9334.field_49614);
        if (lodestoneData != null) {
            return lodestoneData.comp_2402().filter(pos -> pos.comp_2207().equals(world.method_27983())).map(class_4208::comp_2208).orElse(null);
        }
        if (world.method_27983().equals(class_1937.field_25179)) {
            return world.method_43126();
        }
        return null;
    }

    private static void setCompassTarget(PlayerDto dto, class_746 player, class_2338 target) {
        double relativeYaw;
        class_243 playerPos = player.method_19538();
        class_243 targetPos = new class_243((double)target.method_10263() + 0.5, (double)target.method_10264() + 0.5, (double)target.method_10260() + 0.5);
        double deltaX = targetPos.field_1352 - playerPos.field_1352;
        double deltaZ = targetPos.field_1350 - playerPos.field_1350;
        double targetYaw = Math.toDegrees(Math.atan2(-deltaX, deltaZ));
        double playerYaw = player.method_36454();
        for (relativeYaw = targetYaw - playerYaw; relativeYaw <= -180.0; relativeYaw += 360.0) {
        }
        while (relativeYaw > 180.0) {
            relativeYaw -= 360.0;
        }
        dto.setCompassState(CompassState.POINTING);
        dto.setCompassRelativeYaw(relativeYaw);
        dto.setCompassDistance(Math.sqrt(deltaX * deltaX + deltaZ * deltaZ));
    }

    private static class CompassFindResult {
        final class_1799 stack;
        final CompassType type;

        CompassFindResult(class_1799 stack, CompassType type) {
            this.stack = stack;
            this.type = type;
        }
    }
}

