/*
 * Decompiled with CFR 0.152.
 */
package megabytesme.minelights.effects;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import megabytesme.minelights.effects.RGBColorDto;

public class BiomeData {
    private static final Map<String, BiomeInfo> biomes = new HashMap<String, BiomeInfo>();

    private static void addBiome(String name, boolean hasRain, boolean isSnowy, int r, int g, int b) {
        biomes.put(name, new BiomeInfo(hasRain, isSnowy, new RGBColorDto(r, g, b)));
    }

    private static String normaliseKey(String biomeName) {
        if (biomeName == null) {
            return "";
        }
        int colonIndex = biomeName.indexOf(58);
        if (colonIndex != -1) {
            biomeName = biomeName.substring(colonIndex + 1);
        }
        return biomeName.trim().toUpperCase(Locale.ROOT);
    }

    private static BiomeInfo findBiomeInfo(String biomeName) {
        String key = BiomeData.normaliseKey(biomeName);
        return biomes.get(key);
    }

    public static RGBColorDto getBiomeColor(String biomeName) {
        BiomeInfo info = BiomeData.findBiomeInfo(biomeName);
        return info != null ? info.color : new RGBColorDto(124, 252, 0);
    }

    public static boolean isBiomeRainy(String biomeName) {
        BiomeInfo info = BiomeData.findBiomeInfo(biomeName);
        return info != null && info.hasRain && !info.isSnowy;
    }

    public static RGBColorDto getBiomeRainColor(String biomeName) {
        BiomeInfo info = BiomeData.findBiomeInfo(biomeName);
        if (info != null && info.isSnowy) {
            return new RGBColorDto(200, 200, 255);
        }
        return new RGBColorDto(0, 50, 200);
    }

    static {
        BiomeData.addBiome("BADLANDS", false, false, 204, 85, 0);
        BiomeData.addBiome("BADLANDS_PLATEAU", false, false, 204, 85, 0);
        BiomeData.addBiome("BAMBOO_JUNGLE", true, false, 44, 122, 29);
        BiomeData.addBiome("BAMBOO_JUNGLE_HILLS", true, false, 44, 122, 29);
        BiomeData.addBiome("BASALT_DELTAS", false, false, 64, 54, 54);
        BiomeData.addBiome("BEACH", true, false, 200, 200, 122);
        BiomeData.addBiome("BIRCH_FOREST", true, false, 78, 170, 96);
        BiomeData.addBiome("BIRCH_FOREST_HILLS", true, false, 78, 170, 96);
        BiomeData.addBiome("CHERRY_GROVE", true, false, 255, 112, 216);
        BiomeData.addBiome("COLD_OCEAN", true, false, 48, 94, 128);
        BiomeData.addBiome("CRIMSON_FOREST", false, false, 221, 8, 8);
        BiomeData.addBiome("DARK_FOREST", true, false, 42, 67, 36);
        BiomeData.addBiome("DARK_FOREST_HILLS", true, false, 42, 67, 36);
        BiomeData.addBiome("DEEP_COLD_OCEAN", true, false, 5, 46, 73);
        BiomeData.addBiome("DEEP_DARK", false, false, 10, 10, 20);
        BiomeData.addBiome("DEEP_FROZEN_OCEAN", true, true, 116, 150, 182);
        BiomeData.addBiome("DEEP_LUKEWARM_OCEAN", true, false, 17, 32, 61);
        BiomeData.addBiome("DEEP_OCEAN", true, false, 10, 19, 36);
        BiomeData.addBiome("DEEP_WARM_OCEAN", true, false, 22, 41, 79);
        BiomeData.addBiome("DEFAULT", false, false, 255, 0, 255);
        BiomeData.addBiome("DESERT", false, false, 255, 204, 132);
        BiomeData.addBiome("DESERT_HILLS", false, false, 255, 204, 132);
        BiomeData.addBiome("DESERT_LAKES", false, false, 255, 204, 132);
        BiomeData.addBiome("DRIPSTONE_CAVES", false, false, 152, 106, 69);
        BiomeData.addBiome("END_BARRENS", false, false, 244, 244, 178);
        BiomeData.addBiome("END_HIGHLANDS", false, false, 177, 149, 200);
        BiomeData.addBiome("END_MIDLANDS", false, false, 192, 166, 211);
        BiomeData.addBiome("ERODED_BADLANDS", false, false, 204, 85, 0);
        BiomeData.addBiome("FLOWER_FOREST", true, false, 34, 139, 34);
        BiomeData.addBiome("FOREST", true, false, 34, 139, 34);
        BiomeData.addBiome("FROZEN_OCEAN", true, true, 169, 208, 245);
        BiomeData.addBiome("FROZEN_PEAKS", true, true, 213, 226, 231);
        BiomeData.addBiome("FROZEN_RIVER", true, true, 176, 224, 230);
        BiomeData.addBiome("GIANT_SPRUCE_TAIGA", true, false, 74, 68, 33);
        BiomeData.addBiome("GIANT_SPRUCE_TAIGA_HILLS", true, false, 74, 68, 33);
        BiomeData.addBiome("GIANT_TREE_TAIGA", true, false, 74, 68, 33);
        BiomeData.addBiome("GIANT_TREE_TAIGA_HILLS", true, false, 74, 68, 33);
        BiomeData.addBiome("GRAVELLY_MOUNTAINS", true, false, 134, 134, 134);
        BiomeData.addBiome("GROVE", true, true, 196, 196, 196);
        BiomeData.addBiome("ICE_SPIKES", true, true, 173, 216, 230);
        BiomeData.addBiome("JAGGED_PEAKS", true, true, 221, 221, 221);
        BiomeData.addBiome("JUNGLE", true, false, 72, 156, 44);
        BiomeData.addBiome("JUNGLE_EDGE", true, false, 86, 157, 50);
        BiomeData.addBiome("JUNGLE_HILLS", true, false, 72, 156, 44);
        BiomeData.addBiome("LUKEWARM_OCEAN", true, false, 43, 65, 109);
        BiomeData.addBiome("LUSH_CAVES", false, false, 76, 122, 62);
        BiomeData.addBiome("MANGROVE_SWAMP", true, false, 89, 103, 72);
        BiomeData.addBiome("MEADOW", true, false, 65, 134, 101);
        BiomeData.addBiome("MODIFIED_BADLANDS_PLATEAU", false, false, 204, 85, 0);
        BiomeData.addBiome("MODIFIED_GRAVELLY_MOUNTAINS", true, false, 134, 134, 134);
        BiomeData.addBiome("MODIFIED_JUNGLE", true, false, 27, 153, 27);
        BiomeData.addBiome("MODIFIED_JUNGLE_EDGE", true, false, 27, 153, 27);
        BiomeData.addBiome("MODIFIED_WOODED_BADLANDS_PLATEAU", false, false, 204, 85, 0);
        BiomeData.addBiome("MOUNTAIN_EDGE", true, false, 87, 115, 107);
        BiomeData.addBiome("MOUNTAINS", true, false, 34, 139, 34);
        BiomeData.addBiome("MUSHROOM_FIELD_SHORE", true, false, 117, 81, 128);
        BiomeData.addBiome("MUSHROOM_FIELDS", true, false, 156, 110, 170);
        BiomeData.addBiome("NETHER", false, false, 191, 59, 59);
        BiomeData.addBiome("NETHER_WASTES", false, false, 191, 59, 59);
        BiomeData.addBiome("OCEAN", true, false, 36, 53, 91);
        BiomeData.addBiome("OLD_GROWTH_BIRCH_FOREST", true, false, 136, 255, 136);
        BiomeData.addBiome("OLD_GROWTH_PINE_TAIGA", true, false, 74, 68, 33);
        BiomeData.addBiome("OLD_GROWTH_SPRUCE_TAIGA", true, false, 74, 68, 33);
        BiomeData.addBiome("PALE_GARDEN", true, false, 170, 170, 170);
        BiomeData.addBiome("PLAINS", true, false, 130, 159, 66);
        BiomeData.addBiome("RIVER", true, false, 79, 148, 205);
        BiomeData.addBiome("SAVANNA", false, false, 130, 145, 63);
        BiomeData.addBiome("SAVANNA_PLATEAU", false, false, 130, 145, 63);
        BiomeData.addBiome("SHATTERED_SAVANNA", false, false, 130, 145, 63);
        BiomeData.addBiome("SHATTERED_SAVANNA_PLATEAU", false, false, 130, 145, 63);
        BiomeData.addBiome("SMALL_END_ISLANDS", false, false, 128, 0, 128);
        BiomeData.addBiome("SNOWY_BEACH", true, true, 200, 200, 122);
        BiomeData.addBiome("SNOWY_MOUNTAINS", true, true, 224, 224, 224);
        BiomeData.addBiome("SNOWY_PLAINS", true, true, 238, 238, 238);
        BiomeData.addBiome("SNOWY_SLOPES", true, true, 238, 238, 238);
        BiomeData.addBiome("SNOWY_TAIGA", true, true, 224, 224, 224);
        BiomeData.addBiome("SNOWY_TAIGA_HILLS", true, true, 255, 255, 255);
        BiomeData.addBiome("SNOWY_TAIGA_MOUNTAINS", true, true, 255, 255, 255);
        BiomeData.addBiome("SNOWY_TUNDRA", true, true, 224, 224, 224);
        BiomeData.addBiome("SOUL_SAND_VALLEY", false, false, 77, 58, 48);
        BiomeData.addBiome("SPARSE_JUNGLE", true, false, 86, 157, 50);
        BiomeData.addBiome("STONE_SHORE", true, false, 134, 134, 134);
        BiomeData.addBiome("STONY_PEAKS", true, false, 134, 134, 134);
        BiomeData.addBiome("STONY_SHORE", true, false, 134, 134, 134);
        BiomeData.addBiome("SUNFLOWER_PLAINS", true, false, 130, 159, 66);
        BiomeData.addBiome("SWAMP", true, false, 89, 103, 72);
        BiomeData.addBiome("SWAMP_HILLS", true, false, 85, 102, 68);
        BiomeData.addBiome("TAIGA", true, true, 11, 106, 95);
        BiomeData.addBiome("TAIGA_HILLS", true, true, 11, 106, 95);
        BiomeData.addBiome("TAIGA_MOUNTAINS", true, true, 11, 106, 95);
        BiomeData.addBiome("TALL_BIRCH_FOREST", true, false, 78, 170, 96);
        BiomeData.addBiome("TALL_BIRCH_HILLS", true, false, 78, 170, 96);
        BiomeData.addBiome("THE_END", false, false, 128, 0, 128);
        BiomeData.addBiome("THE_VOID", false, false, 0, 0, 0);
        BiomeData.addBiome("WARM_OCEAN", true, false, 59, 88, 146);
        BiomeData.addBiome("WARPED_FOREST", false, false, 73, 144, 123);
        BiomeData.addBiome("WINDSWEPT_FOREST", true, false, 71, 97, 89);
        BiomeData.addBiome("WINDSWEPT_GRAVELLY_HILLS", true, false, 134, 134, 134);
        BiomeData.addBiome("WINDSWEPT_HILLS", true, false, 87, 115, 107);
        BiomeData.addBiome("WINDSWEPT_SAVANNA", false, false, 130, 145, 63);
        BiomeData.addBiome("WOODED_BADLANDS", false, false, 204, 85, 0);
        BiomeData.addBiome("WOODED_BADLANDS_PLATEAU", false, false, 204, 85, 0);
        BiomeData.addBiome("WOODED_HILLS", true, false, 34, 139, 34);
        BiomeData.addBiome("WOODED_MOUNTAINS", true, false, 34, 139, 34);
    }

    private static class BiomeInfo {
        boolean hasRain;
        boolean isSnowy;
        RGBColorDto color;

        BiomeInfo(boolean hasRain, boolean isSnowy, RGBColorDto color) {
            this.hasRain = hasRain;
            this.isSnowy = isSnowy;
            this.color = color;
        }
    }
}

