/*
 * Decompiled with CFR 0.152.
 */
package megabytesme.minelights.effects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import megabytesme.minelights.CompassState;
import megabytesme.minelights.CompassType;
import megabytesme.minelights.MineLightsClient;
import megabytesme.minelights.PlayerDto;
import megabytesme.minelights.effects.BiomeData;
import megabytesme.minelights.effects.DeviceLayout;
import megabytesme.minelights.effects.FrameStateDto;
import megabytesme.minelights.effects.KeyMap;
import megabytesme.minelights.effects.RGBColorDto;
import net.minecraft.class_310;
import net.minecraft.class_315;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EffectPainter {
    public static final Logger LOGGER = LogManager.getLogger((String)"MineLights - EffectPainter");
    private final Random random = new Random();
    private final List<DeviceLayout> deviceLayouts;
    private final Map<DeviceLayout, DeviceEffectState> deviceStates = new HashMap<DeviceLayout, DeviceEffectState>();
    private boolean rainPhase = false;
    private long lastRainPhaseStep = 0L;
    private final List<Raindrop> raindrops = new ArrayList<Raindrop>();
    private long lastRaindropSpawn = 0L;
    private static final int RAINDROP_SPAWN_RATE_MS = 120;
    private static final int RAINDROP_FALL_SPEED_MS = 90;
    private long lastFireCrackleUpdate = 0L;
    private final List<Integer> cracklingKeys = new ArrayList<Integer>();
    private long lastPortalTwinkleUpdate = 0L;
    private final List<Integer> twinklingKeys = new ArrayList<Integer>();
    private RGBColorDto currentSmoothBiomeColor = new RGBColorDto(0, 0, 0);
    private RGBColorDto transitionStartColor = new RGBColorDto(0, 0, 0);
    private RGBColorDto targetBiomeColor = new RGBColorDto(0, 0, 0);
    private String lastKnownBiome = "";
    private long transitionStartTime = 0L;
    private static final int TRANSITION_DURATION_MS = 750;
    private float lastBrightnessFactor = 1.0f;
    private long chatPulseStartTime = 0L;
    private boolean chatPulseActive = false;
    private long lastInWaterTime = 0L;
    private static final int AIR_BAR_VISIBLE_DURATION_MS = 2500;
    private boolean wasTakingDamageLastFrame = false;
    private boolean isDamageFlashActive = false;
    private long damageFlashStartTime = 0L;
    private boolean wasLowHealthLastFrame = false;
    private float heartbeatBrightness = 0.1f;
    private boolean isHeartBeatingUp = true;
    private long lastHeartbeatStep = 0L;
    private long lastCompassSpinTime = 0L;
    private int compassSpinIndex = 0;
    private static long lastSheenTime = 0L;
    private static int sheenIndex = 0;

    private static RGBColorDto blend(RGBColorDto base, RGBColorDto overlay, double overlayOpacity) {
        if (base == null) {
            return overlay;
        }
        if (overlay == null) {
            return base;
        }
        double baseOpacity = 1.0 - overlayOpacity;
        int r = (int)((double)base.r * baseOpacity + (double)overlay.r * overlayOpacity);
        int g = (int)((double)base.g * baseOpacity + (double)overlay.g * overlayOpacity);
        int b = (int)((double)base.b * baseOpacity + (double)overlay.b * overlayOpacity);
        return new RGBColorDto(r, g, b);
    }

    public EffectPainter(List<DeviceLayout> deviceLayouts) {
        this.deviceLayouts = deviceLayouts;
        for (DeviceLayout layout : deviceLayouts) {
            this.deviceStates.put(layout, new DeviceEffectState());
        }
    }

    private List<Integer> getMappedIds(String keyName) {
        ArrayList<Integer> allIds = new ArrayList<Integer>();
        for (DeviceLayout layout : this.deviceLayouts) {
            allIds.addAll(layout.getKeyMap().getOrDefault(keyName, Collections.emptyList()));
        }
        return allIds;
    }

    public FrameStateDto paint(PlayerDto player) {
        FrameStateDto state = new FrameStateDto();
        if (!MineLightsClient.CONFIG.enableMod) {
            return state;
        }
        if (!player.getInGame()) {
            for (DeviceLayout layout : this.deviceLayouts) {
                for (Integer ledId : layout.getAllLeds()) {
                    state.keys.put(ledId, new RGBColorDto(255, 0, 0));
                }
            }
            return state;
        }
        for (DeviceLayout layout : this.deviceLayouts) {
            for (Integer ledId : layout.getAllLeds()) {
                state.keys.put(ledId, new RGBColorDto(0, 0, 0));
            }
        }
        long now = System.currentTimeMillis();
        this.paintEnvironmentalBase(state, player, now);
        if (MineLightsClient.CONFIG.enableExperienceBar) {
            this.paintExperienceBar(state, player);
        }
        this.paintPlayerBars(state, player);
        if (MineLightsClient.CONFIG.enableSaturationBar) {
            this.paintSaturationAndAirBar(state, player);
        }
        if (MineLightsClient.CONFIG.enableCompassEffect) {
            this.paintCompass(state, player);
        }
        if (MineLightsClient.CONFIG.enableLowHealthWarning) {
            this.paintHealthEffects(state, player);
        }
        this.paintPlayerEffects(state, player, now);
        return state;
    }

    private void paintEnvironmentalBase(FrameStateDto state, PlayerDto player, long now) {
        RGBColorDto baseColor = this.resolveEnvironmentalBaseColor(player, now);
        for (DeviceLayout layout : this.deviceLayouts) {
            for (Integer ledId : layout.getAllLeds()) {
                state.keys.put(ledId, baseColor);
            }
        }
        this.paintSpecialWorldEffects(state, player, now);
    }

    private boolean isPlayerInOrOnBlock(PlayerDto player, String ... blockIds) {
        ArrayList<String> relevantBlocks = new ArrayList<String>();
        if (player.getBlockAtFeet() != null) {
            relevantBlocks.add(player.getBlockAtFeet());
        }
        if (player.getBlockOn() != null) {
            relevantBlocks.add(player.getBlockOn());
        }
        if (player.getBlockAtHead() != null) {
            relevantBlocks.add(player.getBlockAtHead());
        }
        if (relevantBlocks.isEmpty()) {
            return false;
        }
        for (String blockId : blockIds) {
            if (!relevantBlocks.contains(blockId)) continue;
            return true;
        }
        return false;
    }

    private RGBColorDto resolveEnvironmentalBaseColor(PlayerDto player, long now) {
        RGBColorDto baseColor = new RGBColorDto(0, 0, 0);
        if (MineLightsClient.CONFIG.enableBiomeEffects) {
            if (!player.getCurrentBiome().equals(this.lastKnownBiome) && !player.getCurrentBiome().isEmpty()) {
                this.transitionStartColor = this.currentSmoothBiomeColor;
                this.targetBiomeColor = BiomeData.getBiomeColor(player.getCurrentBiome());
                this.lastKnownBiome = player.getCurrentBiome();
                this.transitionStartTime = now;
            }
            long elapsedMs = now - this.transitionStartTime;
            float t = Math.min(1.0f, (float)elapsedMs / 750.0f);
            baseColor = this.currentSmoothBiomeColor = this.lerpColor(this.transitionStartColor, this.targetBiomeColor, t);
        }
        boolean isSoulFire = false;
        if (player.getIsOnFire()) {
            isSoulFire = this.isPlayerInOrOnBlock(player, "block.minecraft.soul_fire", "block.minecraft.soul_sand");
        }
        boolean isRegularFire = this.isPlayerInOrOnBlock(player, "block.minecraft.fire", "block.minecraft.lava");
        baseColor = MineLightsClient.CONFIG.enableOnFireEffect && (player.getIsOnFire() || isRegularFire || isSoulFire) ? (isSoulFire ? new RGBColorDto(0, 100, 255) : new RGBColorDto(255, 69, 0)) : (MineLightsClient.CONFIG.enablePortalEffects && this.isPlayerInOrOnBlock(player, "block.minecraft.nether_portal") ? new RGBColorDto(128, 0, 128) : (MineLightsClient.CONFIG.enablePortalEffects && this.isPlayerInOrOnBlock(player, "block.minecraft.end_portal") ? new RGBColorDto(0, 0, 50) : this.applyLightDimming(baseColor, player)));
        return baseColor;
    }

    private RGBColorDto applyLightDimming(RGBColorDto color, PlayerDto player) {
        float smoothedFactor;
        float targetFactor = 1.0f;
        switch (MineLightsClient.CONFIG.dimmingMode) {
            case SKY_LIGHT: {
                int skyLight = player.getSkyLightLevel();
                if (this.isNetherOrEnd(player)) {
                    targetFactor = 1.0f;
                    break;
                }
                targetFactor = (float)skyLight / 15.0f;
                break;
            }
            case LOCAL_LIGHT: {
                float rendered = player.getRenderedBrightnessLevel();
                if (this.isNetherOrEnd(player)) {
                    targetFactor = 1.0f;
                    break;
                }
                targetFactor = rendered;
                break;
            }
            default: {
                return color;
            }
        }
        targetFactor = Math.max(MineLightsClient.CONFIG.minBrightness, targetFactor);
        float t = 0.1f;
        this.lastBrightnessFactor = smoothedFactor = this.lerp(this.lastBrightnessFactor, targetFactor, t);
        return new RGBColorDto((int)((float)color.r * smoothedFactor), (int)((float)color.g * smoothedFactor), (int)((float)color.b * smoothedFactor));
    }

    private boolean isNetherOrEnd(PlayerDto player) {
        String dim = player.getCurrentWorld();
        return "minecraft:the_nether".equals(dim) || "minecraft:the_end".equals(dim);
    }

    private void paintSpecialWorldEffects(FrameStateDto state, PlayerDto player, long now) {
        block9: {
            List<Integer> allDeviceLeds;
            block10: {
                block8: {
                    this.paintWeatherEffects(state, player, now);
                    if (player.getIsLightningFlashing()) {
                        return;
                    }
                    allDeviceLeds = this.deviceLayouts.stream().flatMap(d -> d.getAllLeds().stream()).collect(Collectors.toList());
                    boolean isSoulFire = false;
                    if (player.getIsOnFire()) {
                        isSoulFire = this.isPlayerInOrOnBlock(player, "block.minecraft.soul_fire", "block.minecraft.soul_sand");
                    }
                    boolean isRegularFire = this.isPlayerInOrOnBlock(player, "block.minecraft.fire", "block.minecraft.lava");
                    if (!MineLightsClient.CONFIG.enableOnFireEffect || !player.getIsOnFire() && !isRegularFire && !isSoulFire) break block8;
                    if (now - this.lastFireCrackleUpdate > 100L) {
                        this.updateRandomKeys(this.cracklingKeys, allDeviceLeds, 0.2f);
                        this.lastFireCrackleUpdate = now;
                    }
                    RGBColorDto crackleColor = isSoulFire ? new RGBColorDto(173, 216, 230) : new RGBColorDto(200, 0, 0);
                    for (Integer keyId : this.cracklingKeys) {
                        state.keys.put(keyId, crackleColor);
                    }
                    break block9;
                }
                if (!MineLightsClient.CONFIG.enablePortalEffects || !this.isPlayerInOrOnBlock(player, "block.minecraft.nether_portal")) break block10;
                if (now - this.lastPortalTwinkleUpdate > 500L) {
                    this.updateRandomKeys(this.twinklingKeys, allDeviceLeds, 0.2f);
                    this.lastPortalTwinkleUpdate = now;
                }
                for (Integer keyId : this.twinklingKeys) {
                    state.keys.put(keyId, new RGBColorDto(50, 0, 100));
                }
                break block9;
            }
            if (!MineLightsClient.CONFIG.enablePortalEffects || !this.isPlayerInOrOnBlock(player, "block.minecraft.end_portal")) break block9;
            if (now - this.lastPortalTwinkleUpdate > 500L) {
                this.updateRandomKeys(this.twinklingKeys, allDeviceLeds, 0.2f);
                this.lastPortalTwinkleUpdate = now;
            }
            for (Integer keyId : this.twinklingKeys) {
                state.keys.put(keyId, new RGBColorDto(50, 50, 50));
            }
        }
    }

    private void paintWeatherEffects(FrameStateDto state, PlayerDto player, long now) {
        boolean isRaining;
        if (player.getIsLightningFlashing()) {
            for (DeviceLayout layout : this.deviceLayouts) {
                for (Integer ledId : layout.getAllLeds()) {
                    state.keys.put(ledId, new RGBColorDto(255, 255, 255));
                }
            }
            return;
        }
        boolean bl = isRaining = MineLightsClient.CONFIG.enableWeatherEffects && (player.getWeather().equals("Rain") || player.getWeather().equals("Thunderstorm")) && BiomeData.isBiomeRainy(player.getCurrentBiome());
        if (!isRaining) {
            this.raindrops.clear();
            return;
        }
        RGBColorDto rainColor = BiomeData.getBiomeRainColor(player.getCurrentBiome());
        if (now - this.lastRainPhaseStep > 500L) {
            this.rainPhase = !this.rainPhase;
            this.lastRainPhaseStep = now;
        }
        if (now - this.lastRaindropSpawn > 120L) {
            if (this.random.nextInt(100) < 75) {
                int startRow = this.random.nextInt(2);
                List<String> rowKeys = KeyMap.KEYBOARD_ROWS.get(startRow);
                this.raindrops.add(new Raindrop(this.random.nextInt(rowKeys.size()), false, rainColor, now));
            } else {
                this.raindrops.add(new Raindrop(this.random.nextInt(KeyMap.KEYBOARD_COLUMNS.size()), true, rainColor, now));
            }
            this.lastRaindropSpawn = now;
        }
        for (DeviceLayout layout : this.deviceLayouts) {
            boolean hasKeyboardKeys = layout.getKeyMap().keySet().stream().anyMatch(k -> k.equals("Q"));
            boolean hasRamKeys = layout.getKeyMap().keySet().stream().anyMatch(k -> k.startsWith("RAM_"));
            boolean hasPlayerKeys = layout.getKeyMap().keySet().stream().anyMatch(k -> k.startsWith("PLAYER_"));
            if (hasKeyboardKeys) {
                this.applyWaveEffect(layout, state, "UNDERGLOW_", rainColor, now, 40, 8);
                continue;
            }
            if (hasRamKeys) {
                this.applyRamRainEffect(layout, state, rainColor, now);
                continue;
            }
            if (hasPlayerKeys) {
                this.applyCascadeEffect(layout, state, "PLAYER_", rainColor, now, 150);
                continue;
            }
            this.applyZonalRainEffect(layout, state, rainColor);
        }
        Iterator<Raindrop> iterator = this.raindrops.iterator();
        while (iterator.hasNext()) {
            int pathLength;
            Raindrop drop = iterator.next();
            if (now - drop.lastFallTime > 90L) {
                ++drop.row;
                drop.lastFallTime = now;
            }
            int n = pathLength = drop.isVertical ? KeyMap.KEYBOARD_COLUMNS.get(drop.column).size() : KeyMap.KEYBOARD_ROWS.size();
            if (drop.row >= pathLength + 2) {
                iterator.remove();
                continue;
            }
            if (drop.isVertical) {
                this.drawVerticalRaindropSegment(state, drop, 0, drop.color);
                this.drawVerticalRaindropSegment(state, drop, -1, drop.tailColor);
                this.drawVerticalRaindropSegment(state, drop, -2, drop.tailColor2);
                continue;
            }
            this.drawHorizontalRaindropSegment(state, drop, 0, drop.color);
            this.drawHorizontalRaindropSegment(state, drop, -1, drop.tailColor);
            this.drawHorizontalRaindropSegment(state, drop, -2, drop.tailColor2);
        }
    }

    private void applyZonalRainEffect(DeviceLayout layout, FrameStateDto state, RGBColorDto rainColor) {
        List<Integer> leds = layout.getAllLeds();
        for (int i = 0; i < leds.size(); ++i) {
            if (i % 2 != (this.rainPhase ? 0 : 1)) continue;
            Integer ledId = leds.get(i);
            RGBColorDto baseColor = state.keys.get(ledId);
            state.keys.put(ledId, EffectPainter.blend(baseColor, rainColor, 0.7));
        }
    }

    private void applyRamRainEffect(DeviceLayout layout, FrameStateDto state, RGBColorDto color, long now) {
        DeviceEffectState deviceState = this.deviceStates.get(layout);
        if (deviceState == null) {
            return;
        }
        List ramKeys = layout.getKeyMap().keySet().stream().filter(k -> k.startsWith("RAM_")).sorted(Comparator.comparingInt(k -> Integer.parseInt(k.substring(4)))).collect(Collectors.toList());
        if (ramKeys.isEmpty()) {
            return;
        }
        if (now > deviceState.lastRamRaindropSpawn + deviceState.nextRamRaindropDelay) {
            deviceState.ramRaindrops.add(new RamRaindrop(color, now));
            deviceState.lastRamRaindropSpawn = now;
            deviceState.nextRamRaindropDelay = 200 + this.random.nextInt(800);
        }
        HashMap<String, RGBColorDto> ramKeyColors = new HashMap<String, RGBColorDto>();
        Iterator<RamRaindrop> iterator = deviceState.ramRaindrops.iterator();
        while (iterator.hasNext()) {
            int tail2Pos;
            int tail1Pos;
            RamRaindrop drop = iterator.next();
            if (now - drop.lastFallTime > 90L) {
                ++drop.position;
                drop.lastFallTime = now;
            }
            if (drop.position >= ramKeys.size() + 2) {
                iterator.remove();
                continue;
            }
            if (drop.position >= 0 && drop.position < ramKeys.size()) {
                ramKeyColors.put((String)ramKeys.get(drop.position), drop.color);
            }
            if ((tail1Pos = drop.position - 1) >= 0 && tail1Pos < ramKeys.size()) {
                ramKeyColors.putIfAbsent((String)ramKeys.get(tail1Pos), drop.tailColor);
            }
            if ((tail2Pos = drop.position - 2) < 0 || tail2Pos >= ramKeys.size()) continue;
            ramKeyColors.putIfAbsent((String)ramKeys.get(tail2Pos), drop.tailColor2);
        }
        for (Map.Entry entry : ramKeyColors.entrySet()) {
            for (Integer ledId : layout.getKeyMap().get(entry.getKey())) {
                RGBColorDto baseColor = state.keys.get(ledId);
                state.keys.put(ledId, EffectPainter.blend(baseColor, (RGBColorDto)entry.getValue(), 0.9));
            }
        }
    }

    private void applyWaveEffect(DeviceLayout layout, FrameStateDto state, String prefix, RGBColorDto color, long now, int speed, int tailLength) {
        List keyNames = layout.getKeyMap().keySet().stream().filter(k -> k.startsWith(prefix)).sorted(Comparator.comparingInt(k -> Integer.parseInt(k.substring(prefix.length())))).collect(Collectors.toList());
        if (keyNames.isEmpty()) {
            return;
        }
        int headIndex = (int)(now / (long)speed % (long)keyNames.size());
        for (int i = 0; i < keyNames.size(); ++i) {
            int distance = (i - headIndex + keyNames.size()) % keyNames.size();
            if (distance >= tailLength) continue;
            float brightness = 1.0f - (float)distance / (float)tailLength;
            RGBColorDto waveColor = new RGBColorDto((int)((float)color.r * brightness), (int)((float)color.g * brightness), (int)((float)color.b * brightness));
            for (Integer ledId : layout.getKeyMap().get(keyNames.get(i))) {
                RGBColorDto baseColor = state.keys.get(ledId);
                state.keys.put(ledId, EffectPainter.blend(baseColor, waveColor, 0.8));
            }
        }
    }

    private void applyCascadeEffect(DeviceLayout layout, FrameStateDto state, String prefix, RGBColorDto color, long now, int speed) {
        List keyNames = layout.getKeyMap().keySet().stream().filter(k -> k.startsWith(prefix)).sorted(Comparator.comparingInt(k -> Integer.parseInt(k.substring(prefix.length())))).collect(Collectors.toList());
        if (keyNames.isEmpty()) {
            return;
        }
        int headIndex = (int)(now / (long)speed % (long)(keyNames.size() + 3));
        for (int i = 0; i < keyNames.size(); ++i) {
            RGBColorDto finalColor = new RGBColorDto(0, 0, 0);
            if (i == headIndex) {
                finalColor = color;
            } else if (i == headIndex - 1) {
                finalColor = new RGBColorDto((int)((double)color.r * 0.5), (int)((double)color.g * 0.5), (int)((double)color.b * 0.5));
            } else if (i == headIndex - 2) {
                finalColor = new RGBColorDto((int)((double)color.r * 0.2), (int)((double)color.g * 0.2), (int)((double)color.b * 0.2));
            }
            for (Integer ledId : layout.getKeyMap().get(keyNames.get(i))) {
                RGBColorDto baseColor = state.keys.get(ledId);
                state.keys.put(ledId, EffectPainter.blend(baseColor, finalColor, 0.9));
            }
        }
    }

    private void drawHorizontalRaindropSegment(FrameStateDto state, Raindrop drop, int rowOffset, RGBColorDto color) {
        int targetRow = drop.row + rowOffset;
        if (targetRow < 0 || targetRow >= KeyMap.KEYBOARD_ROWS.size()) {
            return;
        }
        List<String> rowKeys = KeyMap.KEYBOARD_ROWS.get(targetRow);
        if (drop.column >= rowKeys.size()) {
            return;
        }
        String keyName = rowKeys.get(drop.column);
        for (Integer ledId : this.getMappedIds(keyName)) {
            RGBColorDto baseColor = state.keys.get(ledId);
            state.keys.put(ledId, EffectPainter.blend(baseColor, color, 0.9));
        }
    }

    private void drawVerticalRaindropSegment(FrameStateDto state, Raindrop drop, int rowOffset, RGBColorDto color) {
        List<String> columnKeys = KeyMap.KEYBOARD_COLUMNS.get(drop.column);
        int targetRow = drop.row + rowOffset;
        if (targetRow < 0 || targetRow >= columnKeys.size()) {
            return;
        }
        String keyName = columnKeys.get(targetRow);
        for (Integer ledId : this.getMappedIds(keyName)) {
            RGBColorDto baseColor = state.keys.get(ledId);
            state.keys.put(ledId, EffectPainter.blend(baseColor, color, 0.9));
        }
    }

    private void paintExperienceBar(FrameStateDto state, PlayerDto player) {
        List<String> logicalKeys = KeyMap.getExperienceBar();
        int ledsToLight = (int)(player.getExperience() * (float)logicalKeys.size());
        for (int i = 0; i < logicalKeys.size(); ++i) {
            RGBColorDto color = i < ledsToLight ? new RGBColorDto(0, 255, 0) : new RGBColorDto(10, 30, 10);
            for (Integer ledId : this.getMappedIds(logicalKeys.get(i))) {
                state.keys.put(ledId, color);
            }
        }
    }

    private void paintPlayerBars(FrameStateDto state, PlayerDto player) {
        int i;
        if (player.getIsTakingDamage() && !this.wasTakingDamageLastFrame) {
            this.isDamageFlashActive = true;
            this.damageFlashStartTime = System.currentTimeMillis();
        }
        this.wasTakingDamageLastFrame = player.getIsTakingDamage();
        if (this.isDamageFlashActive && System.currentTimeMillis() - this.damageFlashStartTime >= 120L) {
            this.isDamageFlashActive = false;
        }
        if (MineLightsClient.CONFIG.enableHealthBar) {
            RGBColorDto healthDim = new RGBColorDto(30, 0, 0);
            RGBColorDto healthFull = new RGBColorDto(255, 0, 0);
            List<String> healthKeys = KeyMap.getHealthBar();
            for (i = 0; i < healthKeys.size(); ++i) {
                RGBColorDto finalColor;
                if (this.isDamageFlashActive) {
                    finalColor = new RGBColorDto(255, 255, 255);
                } else if (player.getIsWithering()) {
                    finalColor = new RGBColorDto(43, 43, 43);
                } else if (player.getIsPoisoned()) {
                    finalColor = new RGBColorDto(148, 120, 24);
                } else {
                    float t = (player.getHealth() - (float)i * 5.0f) / 5.0f;
                    finalColor = this.lerpColor(healthDim, healthFull, t);
                }
                for (Integer ledId : this.getMappedIds(healthKeys.get(i))) {
                    state.keys.put(ledId, finalColor);
                }
            }
        }
        if (MineLightsClient.CONFIG.enableHungerBar) {
            RGBColorDto hungerDim = new RGBColorDto(30, 15, 0);
            RGBColorDto hungerFull = new RGBColorDto(255, 165, 0);
            List<String> hungerKeys = KeyMap.getHungerBar();
            for (i = 0; i < hungerKeys.size(); ++i) {
                float t = ((float)player.getHunger() - (float)i * 5.0f) / 5.0f;
                RGBColorDto color = this.lerpColor(hungerDim, hungerFull, t);
                for (Integer ledId : this.getMappedIds(hungerKeys.get(i))) {
                    state.keys.put(ledId, color);
                }
            }
        }
    }

    private void paintSaturationAndAirBar(FrameStateDto state, PlayerDto player) {
        RGBColorDto dimColor;
        RGBColorDto fullColor;
        float maxValue;
        float value;
        boolean showAirBar;
        List<String> barKeys = KeyMap.getSaturationBar();
        if (this.isPlayerInOrOnBlock(player, "block.minecraft.water")) {
            this.lastInWaterTime = System.currentTimeMillis();
        }
        boolean bl = showAirBar = this.isPlayerInOrOnBlock(player, "block.minecraft.water") || System.currentTimeMillis() - this.lastInWaterTime < 2500L;
        if (showAirBar) {
            value = player.getAir();
            maxValue = 300.0f;
            fullColor = new RGBColorDto(173, 216, 230);
            dimColor = new RGBColorDto(0, 0, 50);
        } else {
            value = player.getSaturation();
            maxValue = 20.0f;
            fullColor = new RGBColorDto(200, 255, 0);
            dimColor = new RGBColorDto(40, 50, 0);
        }
        float valuePerKey = maxValue / (float)barKeys.size();
        for (int i = 0; i < barKeys.size(); ++i) {
            float t = (value - (float)i * valuePerKey) / valuePerKey;
            RGBColorDto color = this.lerpColor(dimColor, fullColor, t);
            for (Integer ledId : this.getMappedIds(barKeys.get(i))) {
                state.keys.put(ledId, color);
            }
        }
    }

    private void paintHealthEffects(FrameStateDto state, PlayerDto player) {
        boolean isLowHealthNow;
        boolean bl = isLowHealthNow = player.getHealth() < 10.0f;
        if (isLowHealthNow && !this.wasLowHealthLastFrame) {
            this.heartbeatBrightness = 0.1f;
            this.isHeartBeatingUp = true;
            this.lastHeartbeatStep = System.currentTimeMillis();
        }
        this.wasLowHealthLastFrame = isLowHealthNow;
        if (!isLowHealthNow) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastHeartbeatStep > 40L) {
            if (this.isHeartBeatingUp) {
                this.heartbeatBrightness += 0.1f;
                if (this.heartbeatBrightness >= 1.0f) {
                    this.heartbeatBrightness = 1.0f;
                    this.isHeartBeatingUp = false;
                }
            } else {
                this.heartbeatBrightness -= 0.1f;
                if (this.heartbeatBrightness <= 0.1f) {
                    this.heartbeatBrightness = 0.1f;
                    this.isHeartBeatingUp = true;
                }
            }
            this.lastHeartbeatStep = now;
        }
        int r = (int)(255.0f * this.heartbeatBrightness);
        for (String keyName : KeyMap.getHeartbeatRed()) {
            for (Integer ledId : this.getMappedIds(keyName)) {
                state.keys.put(ledId, new RGBColorDto(r, 0, 0));
            }
        }
        for (String keyName : KeyMap.getHeartbeatWhite()) {
            for (Integer ledId : this.getMappedIds(keyName)) {
                state.keys.put(ledId, new RGBColorDto(r, r, r));
            }
        }
    }

    private void paintCompass(FrameStateDto state, PlayerDto player) {
        RGBColorDto backgroundColor;
        RGBColorDto compassColor;
        if (player.getCompassType() == CompassType.NONE) {
            return;
        }
        switch (player.getCompassType()) {
            case RECOVERY: {
                compassColor = new RGBColorDto(0, 191, 255);
                backgroundColor = new RGBColorDto(0, 20, 35);
                break;
            }
            case LODESTONE: {
                compassColor = new RGBColorDto(238, 130, 238);
                backgroundColor = new RGBColorDto(25, 0, 25);
                break;
            }
            default: {
                compassColor = new RGBColorDto(255, 0, 0);
                backgroundColor = new RGBColorDto(35, 0, 0);
            }
        }
        for (String keyName : KeyMap.getNumpadDirectional()) {
            for (Integer n : this.getMappedIds(keyName)) {
                state.keys.put(n, backgroundColor);
            }
        }
        for (Integer ledId : this.getMappedIds(KeyMap.getNumpadCenter())) {
            state.keys.put(ledId, compassColor);
        }
        if (player.getCompassState() == CompassState.SPINNING) {
            long now = System.currentTimeMillis();
            if (now - this.lastCompassSpinTime > 75L) {
                this.compassSpinIndex = (this.compassSpinIndex + 1) % KeyMap.getNumpadDirectional().size();
                this.lastCompassSpinTime = now;
            }
            String keyToLight = KeyMap.getNumpadDirectional().get(this.compassSpinIndex);
            for (Integer ledId : this.getMappedIds(keyToLight)) {
                state.keys.put(ledId, compassColor);
            }
        } else if (player.getCompassState() == CompassState.POINTING) {
            if (player.getCompassDistance() != null && player.getCompassDistance() < 8.0) {
                for (Integer centerLedId : this.getMappedIds(KeyMap.getNumpadCenter())) {
                    long now = System.currentTimeMillis();
                    double pulseWave = (Math.sin((double)now / 2000.0) + 1.0) / 2.0;
                    float brightness = (float)(0.6 + pulseWave * 0.4);
                    RGBColorDto pulsedColor = new RGBColorDto((int)((float)compassColor.r * brightness), (int)((float)compassColor.g * brightness), (int)((float)compassColor.b * brightness));
                    state.keys.put(centerLedId, pulsedColor);
                }
            } else {
                Double relativeYaw = player.getCompassRelativeYaw();
                if (relativeYaw == null) {
                    return;
                }
                String keyToLight = relativeYaw >= -22.5 && relativeYaw < 22.5 ? "NUMPAD8" : (relativeYaw >= 22.5 && relativeYaw < 67.5 ? "NUMPAD9" : (relativeYaw >= 67.5 && relativeYaw < 112.5 ? "NUMPAD6" : (relativeYaw >= 112.5 && relativeYaw < 157.5 ? "NUMPAD3" : (relativeYaw >= 157.5 || relativeYaw < -157.5 ? "NUMPAD2" : (relativeYaw >= -157.5 && relativeYaw < -112.5 ? "NUMPAD1" : (relativeYaw >= -112.5 && relativeYaw < -67.5 ? "NUMPAD4" : "NUMPAD7"))))));
                for (Integer n : this.getMappedIds(keyToLight)) {
                    state.keys.put(n, compassColor);
                }
            }
        }
        if (player.getCompassType() == CompassType.LODESTONE) {
            long now = System.currentTimeMillis();
            if (now - lastSheenTime > 60L) {
                sheenIndex = (sheenIndex + 1) % KeyMap.getNumpadDirectional().size();
                lastSheenTime = now;
            }
            List<String> directionalKeys = KeyMap.getNumpadDirectional();
            RGBColorDto rGBColorDto = new RGBColorDto(120, 0, 255);
            double[] opacities = new double[]{0.6, 0.4, 0.2};
            for (int i = 0; i < opacities.length; ++i) {
                int keyIndex = (sheenIndex - i + directionalKeys.size()) % directionalKeys.size();
                String keyName = directionalKeys.get(keyIndex);
                for (Integer ledId : this.getMappedIds(keyName)) {
                    RGBColorDto baseColor = state.keys.get(ledId);
                    state.keys.put(ledId, EffectPainter.blend(baseColor, rGBColorDto, opacities[i]));
                }
            }
        }
    }

    private void paintPlayerEffects(FrameStateDto state, PlayerDto player, long now) {
        RGBColorDto keyColor = null;
        if (MineLightsClient.CONFIG.enableInWaterEffect && this.isPlayerInOrOnBlock(player, "block.minecraft.water")) {
            keyColor = new RGBColorDto(0, 100, 255);
        } else if (MineLightsClient.CONFIG.enableOnFireEffect && this.isPlayerInOrOnBlock(player, "block.minecraft.lava", "block.minecraft.fire", "block.minecraft.soul_fire", "block.minecraft.soul_sand")) {
            boolean isSoulFire = false;
            if (player.getIsOnFire()) {
                isSoulFire = this.isPlayerInOrOnBlock(player, "block.minecraft.soul_fire", "block.minecraft.soul_sand");
            }
            keyColor = isSoulFire ? new RGBColorDto(0, 100, 255) : new RGBColorDto(255, 0, 0);
        } else if (MineLightsClient.CONFIG.highlightMovementKeys) {
            keyColor = new RGBColorDto(255, 255, 255);
        }
        if (keyColor != null) {
            for (String keyName : this.getMovementKeyNames()) {
                for (Integer ledId : this.getMappedIds(keyName)) {
                    state.keys.put(ledId, keyColor);
                }
            }
        }
        if (MineLightsClient.CONFIG.pulseChatKey) {
            this.paintChatPulseEffect(state, player, now);
        }
    }

    private List<String> getMovementKeyNames() {
        ArrayList<String> friendlyNames = new ArrayList<String>();
        List<Object> keybindsToFetch = new ArrayList();
        class_315 options = class_310.method_1551().field_1690;
        keybindsToFetch = Arrays.asList(options.field_1894.method_1429().toString(), options.field_1881.method_1429().toString(), options.field_1913.method_1429().toString(), options.field_1849.method_1429().toString(), options.field_1903.method_1429().toString(), options.field_1832.method_1429().toString(), options.field_1867.method_1429().toString());
        for (String string : keybindsToFetch) {
            if (string == null || !string.startsWith("key.keyboard.")) continue;
            String[] parts = string.split("\\.");
            String friendlyName = "";
            if (parts.length == 4) {
                friendlyName = (parts[2].substring(0, 1) + parts[3]).toUpperCase();
            } else if (parts.length == 3) {
                friendlyName = parts[2].toUpperCase();
            }
            if (friendlyName.isEmpty()) continue;
            friendlyName = friendlyName.replace("CONTROL", "CTRL");
            friendlyNames.add(friendlyName);
        }
        return friendlyNames;
    }

    private void paintChatPulseEffect(FrameStateDto state, PlayerDto player, long now) {
        RGBColorDto baseColor = this.resolveEnvironmentalBaseColor(player, now);
        RGBColorDto white = new RGBColorDto(255, 255, 255);
        float pulsePeriod = 0.6f;
        int pulseCount = 3;
        float totalPulseDuration = pulsePeriod * (float)pulseCount;
        if (player.getIsChatReceived() && !this.chatPulseActive) {
            this.chatPulseActive = true;
            this.chatPulseStartTime = now;
        }
        if (!this.chatPulseActive) {
            return;
        }
        float elapsed = (float)(now - this.chatPulseStartTime) / 1000.0f;
        if (elapsed > totalPulseDuration) {
            this.chatPulseActive = false;
            return;
        }
        float t = (float)((Math.sin((double)(elapsed / pulsePeriod) * Math.PI * 2.0) + 1.0) / 2.0);
        RGBColorDto pulseColor = this.lerpColor(baseColor, white, t);
        for (String keyName : this.getChatKeyNames()) {
            for (Integer ledId : this.getMappedIds(keyName)) {
                state.keys.put(ledId, pulseColor);
            }
        }
    }

    private List<String> getChatKeyNames() {
        ArrayList<String> friendlyNames = new ArrayList<String>();
        class_315 options = class_310.method_1551().field_1690;
        String keybindToFetch = null;
        keybindToFetch = options.field_1890.method_1429().toString();
        if (keybindToFetch != null && keybindToFetch.startsWith("key.keyboard.")) {
            String[] parts = keybindToFetch.split("\\.");
            String friendlyName = "";
            if (parts.length == 4) {
                friendlyName = (parts[2].substring(0, 1) + parts[3]).toUpperCase();
            } else if (parts.length == 3) {
                friendlyName = parts[2].toUpperCase();
            }
            if (!friendlyName.isEmpty()) {
                friendlyName = friendlyName.replace("CONTROL", "CTRL");
                friendlyNames.add(friendlyName);
            }
        }
        return friendlyNames;
    }

    private void updateRandomKeys(List<Integer> keyList, List<Integer> sourceList, float density) {
        keyList.clear();
        if (sourceList.isEmpty()) {
            return;
        }
        int count = (int)((float)sourceList.size() * density);
        for (int i = 0; i < count; ++i) {
            keyList.add(sourceList.get(this.random.nextInt(sourceList.size())));
        }
    }

    private RGBColorDto lerpColor(RGBColorDto start, RGBColorDto end, float t) {
        return new RGBColorDto(this.lerp(start.r, end.r, t), this.lerp(start.g, end.g, t), this.lerp(start.b, end.b, t));
    }

    private int lerp(int start, int end, float t) {
        t = Math.max(0.0f, Math.min(1.0f, t));
        return (int)((float)start + (float)(end - start) * t);
    }

    private float lerp(float start, float end, float t) {
        t = Math.max(0.0f, Math.min(1.0f, t));
        return start + (end - start) * t;
    }

    private static class DeviceEffectState {
        final List<RamRaindrop> ramRaindrops = new ArrayList<RamRaindrop>();
        long lastRamRaindropSpawn = 0L;
        long nextRamRaindropDelay = 500L;

        private DeviceEffectState() {
        }
    }

    private static class Raindrop {
        int column;
        int row;
        long lastFallTime;
        final boolean isVertical;
        final RGBColorDto color;
        final RGBColorDto tailColor;
        final RGBColorDto tailColor2;

        Raindrop(int column, boolean isVertical, RGBColorDto color, long now) {
            this.column = column;
            this.row = 0;
            this.isVertical = isVertical;
            this.lastFallTime = now;
            this.color = color;
            this.tailColor = new RGBColorDto((int)((double)color.r * 0.5), (int)((double)color.g * 0.5), (int)((double)color.b * 0.5));
            this.tailColor2 = new RGBColorDto((int)((double)color.r * 0.2), (int)((double)color.g * 0.2), (int)((double)color.b * 0.2));
        }
    }

    private static class RamRaindrop {
        int position = -2;
        long lastFallTime;
        final RGBColorDto color;
        final RGBColorDto tailColor;
        final RGBColorDto tailColor2;

        RamRaindrop(RGBColorDto color, long now) {
            this.lastFallTime = now;
            this.color = color;
            this.tailColor = new RGBColorDto((int)((double)color.r * 0.5), (int)((double)color.g * 0.5), (int)((double)color.b * 0.5));
            this.tailColor2 = new RGBColorDto((int)((double)color.r * 0.2), (int)((double)color.g * 0.2), (int)((double)color.b * 0.2));
        }
    }
}

